/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kd.bos.olapServer2.storages.LockInstance;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00060\u0004j\u0002`\u0005H\u0016J\f\u0010\u0015\u001a\u00060\u0004j\u0002`\u0005H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/storages/CubeDataLock;", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "()V", "hasQueuedThreads", "", "Lkd/bos/olapServer2/common/bool;", "getHasQueuedThreads", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "readCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getReadLock", "Ljava/io/Closeable;", "getWriteLock", "timeout", "", "Lkd/bos/olapServer2/common/long;", "unit", "Ljava/util/concurrent/TimeUnit;", "notHasReader", "notHasWriter", "tryGetReadLock", "tryGetWriteLock", "ReadCounterInstance", "bos-olap-core2"})
public final class CubeDataLock
implements ICubeDataLock {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    @NotNull
    private final AtomicInteger readCounter = new AtomicInteger();

    @Override
    @NotNull
    public Closeable getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        CommandStatisticsItem commandStatisticsItem = CommandStatisticsItem.Companion.getDataLockTimeSpan();
        Intrinsics.checkNotNull((Object)writeLock);
        StandardCommandStatistics.INSTANCE.executeAndReportTimeSpanState(commandStatisticsItem, null, (Function0)new Function0<Unit>((Object)writeLock){

            public final void invoke() {
                ((ReentrantReadWriteLock.WriteLock)this.receiver).lock();
            }
        });
        return new LockInstance(writeLock);
    }

    @Override
    @NotNull
    public Closeable getWriteLock(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        boolean isOK2 = (Boolean)StandardCommandStatistics.INSTANCE.executeAndReportTimeSpanState(CommandStatisticsItem.Companion.getDataLockTimeSpan(), null, (Function0)new Function0<Boolean>(writeLock, timeout, unit){
            final /* synthetic */ ReentrantReadWriteLock.WriteLock $writeLock;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $unit;
            {
                this.$writeLock = $writeLock;
                this.$timeout = $timeout;
                this.$unit = $unit;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$writeLock.tryLock(this.$timeout, this.$unit);
            }
        });
        if (!isOK2) {
            String string2 = Res.INSTANCE.getCubeDataLockException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeDataLockException_1>(...)");
            Object[] objectArray = new Object[]{timeout};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        Intrinsics.checkNotNull((Object)writeLock);
        return new LockInstance(writeLock);
    }

    @Override
    @NotNull
    public Closeable getReadLock() {
        this.readCounter.incrementAndGet();
        return new ReadCounterInstance(this.readCounter);
    }

    @Override
    @NotNull
    public Closeable tryGetReadLock() {
        return this.getReadLock();
    }

    @Override
    @Nullable
    public Closeable tryGetWriteLock() {
        Closeable closeable;
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        if (writeLock.tryLock()) {
            Intrinsics.checkNotNull((Object)writeLock);
            closeable = new LockInstance(writeLock);
        } else {
            closeable = null;
        }
        return closeable;
    }

    @Override
    public boolean notHasWriter() {
        return this.lock.isWriteLocked();
    }

    @Override
    public boolean getHasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    @Override
    public boolean notHasReader() {
        return this.readCounter.get() == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/storages/CubeDataLock$ReadCounterInstance;", "Ljava/io/Closeable;", "readCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "_isClosed", "", "close", "", "bos-olap-core2"})
    private static final class ReadCounterInstance
    implements Closeable {
        @NotNull
        private final AtomicInteger readCounter;
        private boolean _isClosed;

        public ReadCounterInstance(@NotNull AtomicInteger readCounter) {
            Intrinsics.checkNotNullParameter((Object)readCounter, (String)"readCounter");
            this.readCounter = readCounter;
        }

        @Override
        public void close() {
            if (!this._isClosed) {
                this.readCounter.decrementAndGet();
                this._isClosed = true;
            }
        }
    }
}

