/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.util.UUID;
import kd.bos.olapServer2.collections.CombinedImmutableListDimensionKeys;
import kd.bos.olapServer2.collections.EmptyImmutableSparseList;
import kd.bos.olapServer2.collections.HashMapEntry;
import kd.bos.olapServer2.collections.IImmutableList;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.collections.IImmutableSparseList;
import kd.bos.olapServer2.collections.IMutableArrayLong;
import kd.bos.olapServer2.collections.IMutableCanSetList;
import kd.bos.olapServer2.collections.IMutableCanSetListLong;
import kd.bos.olapServer2.collections.IMutableIndexMap;
import kd.bos.olapServer2.collections.IMutableList;
import kd.bos.olapServer2.collections.IMutableListHashMapEntry;
import kd.bos.olapServer2.collections.IMutableSparseList;
import kd.bos.olapServer2.collections.IQueryBitmap;
import kd.bos.olapServer2.collections.ImmutableDifferenceListAny;
import kd.bos.olapServer2.collections.ImmutableListFromDense;
import kd.bos.olapServer2.collections.ImmutableListFromSparse;
import kd.bos.olapServer2.collections.ImmutableSparseListFromDense;
import kd.bos.olapServer2.collections.MeasureValuesList;
import kd.bos.olapServer2.collections.MutableDifferenceSparseList;
import kd.bos.olapServer2.collections.MutableSparseListFromDense;
import kd.bos.olapServer2.collections.NumberSetFilter;
import kd.bos.olapServer2.collections.SplitImmutableListInt;
import kd.bos.olapServer2.collections.SplitMutableList;
import kd.bos.olapServer2.collections.SplitQueryBitmap;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.DefaultEqualityComparer;
import kd.bos.olapServer2.common.IEqualityComparer;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.memoryMappedFiles.ArrayMetadata;
import kd.bos.olapServer2.memoryMappedFiles.IListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.MutableArrayLong;
import kd.bos.olapServer2.memoryMappedFiles.MutableCanSetListLong;
import kd.bos.olapServer2.memoryMappedFiles.MutableListEntry;
import kd.bos.olapServer2.memoryMappedFiles.VirtualListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ContainerByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IOffsetMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.CubeMainMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.ICubeMainMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFullSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinQueryBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.VirtualQueryBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.MutableBitmapContainer;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.ImmutableStandardListInt;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinImmutableListByteOffset;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinImmutableListLargeByteOffset;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListByteOffset;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListLargeByteOffset;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncodingV3.ImmutableRunLengthListInt;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncodingV3.MutableRunLengthListInt;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.OlapDataFormats;
import kd.bos.olapServer2.query.FixedImmutableList;
import kd.bos.olapServer2.query.OrQueryBitmap;
import kd.bos.olapServer2.storages.ChangeVersionManager;
import kd.bos.olapServer2.storages.CubeBigContainerResource;
import kd.bos.olapServer2.storages.DimensionKeysIndexMap;
import kd.bos.olapServer2.storages.InputRowList;
import kd.bos.olapServer2.storages.MeasureSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 F2\u00020\u0001:\u0002FGB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00162\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\"\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u0006\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u0018\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u001a\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\u0016\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001042\u0006\u0010 \u001a\u00020!J\u000e\u00105\u001a\u0002062\u0006\u0010/\u001a\u000200J9\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00162\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016\u00a2\u0006\u0002\u0010:J\u001c\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u0012\u0010<\u001a\u00020=2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\u0018\u0010>\u001a\b\u0012\u0004\u0012\u00020?042\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016J\u001c\u0010@\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u000e\u0010A\u001a\u00020B2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010C\u001a\u00060Dj\u0002`E2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lkd/bos/olapServer2/storages/CubeDataStorage;", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "sharedRes", "Lkd/bos/olapServer2/storages/CubeBigContainerResource;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/storages/CubeBigContainerResource;)V", "rowValidBitmaps", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableBitmapContainer;", "getRowValidBitmaps", "()Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableBitmapContainer;", "rowValidBitmaps$delegate", "Lkotlin/Lazy;", "createBuckets", "Lkd/bos/olapServer2/collections/IMutableArrayLong;", "createDimensionKeysMap", "Lkd/bos/olapServer2/collections/IMutableIndexMap;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "splitCount", "", "Lkd/bos/olapServer2/common/long;", "rowCount", "Lkd/bos/olapServer2/common/rowIdx;", "createEntries", "Lkd/bos/olapServer2/collections/IMutableListHashMapEntry;", "Lkd/bos/olapServer2/collections/HashMapEntry;", "createImmutableListInt", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "createImmutableListMeasure", "Lkd/bos/olapServer2/collections/IImmutableList;", "measure", "Lkd/bos/olapServer2/metadata/Measure;", "createImmutableSparseListMeasure", "Lkd/bos/olapServer2/collections/IImmutableSparseList;", "createImmutableStandardListMeasure", "createInputRowList", "Lkd/bos/olapServer2/storages/InputRowList;", "changeVersionManager", "Lkd/bos/olapServer2/storages/ChangeVersionManager;", "cubeMainMetadata", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ICubeMainMetadata;", "createKeys", "Lkd/bos/olapServer2/collections/IMutableList;", "createMutableBitmap", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinMutableBitmap;", "memberUUID", "Ljava/util/UUID;", "createMutableMeasureIndex", "Lkd/bos/olapServer2/collections/IMutableCanSetListLong;", "createMutableStandardListMeasure", "Lkd/bos/olapServer2/collections/IMutableCanSetList;", "createQueryBitmap", "Lkd/bos/olapServer2/collections/IQueryBitmap;", "members", "", "Lkd/bos/olapServer2/metadata/Member;", "(Lkd/bos/olapServer2/metadata/Dimension;[Lkd/bos/olapServer2/metadata/Member;JJ)Lkd/bos/olapServer2/collections/IQueryBitmap;", "createUnzipImmutableListInt", "createUnzipMutableListDimensionKeys", "Lkd/bos/olapServer2/memoryMappedFiles/minListIntV3/MinMutableListDimensionKeys;", "createValuesList", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "createZipImmutableListInt", "createZipMutableListInt", "Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt;", "existMeasureDirectory", "", "Lkd/bos/olapServer2/common/bool;", "Companion", "LazyMeasuresCreator", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeDataStorage.kt\nkd/bos/olapServer2/storages/CubeDataStorage\n+ 2 Member.kt\nkd/bos/olapServer2/metadata/Member\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,401:1\n59#2:402\n12474#3,2:403\n*S KotlinDebug\n*F\n+ 1 CubeDataStorage.kt\nkd/bos/olapServer2/storages/CubeDataStorage\n*L\n203#1:402\n210#1:403,2\n*E\n"})
public final class CubeDataStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cube cube;
    @NotNull
    private final CubeBigContainerResource sharedRes;
    @NotNull
    private final Lazy rowValidBitmaps$delegate;
    public static final long outerMeasureSegmentSize = 4096L;

    public CubeDataStorage(@NotNull Cube cube, @NotNull CubeBigContainerResource sharedRes) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)sharedRes, (String)"sharedRes");
        this.cube = cube;
        this.sharedRes = sharedRes;
        this.rowValidBitmaps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableBitmapContainer>(this){
            final /* synthetic */ CubeDataStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableBitmapContainer invoke() {
                return new MutableBitmapContainer(CubeDataStorage.access$getSharedRes$p(this.this$0).getRowValidBitmapMetadata(), CubeDataStorage.access$getSharedRes$p(this.this$0).getRowValidKeyContainer(), CubeDataStorage.access$getSharedRes$p(this.this$0).getRowValidDataContainer());
            }
        }));
    }

    @NotNull
    public final MutableBitmapContainer getRowValidBitmaps() {
        Lazy lazy = this.rowValidBitmaps$delegate;
        return (MutableBitmapContainer)lazy.getValue();
    }

    @NotNull
    public final InputRowList createInputRowList(@NotNull ChangeVersionManager changeVersionManager, @NotNull ICubeMainMetadata cubeMainMetadata) {
        Intrinsics.checkNotNullParameter((Object)changeVersionManager, (String)"changeVersionManager");
        Intrinsics.checkNotNullParameter((Object)cubeMainMetadata, (String)"cubeMainMetadata");
        long splitCount = cubeMainMetadata.getSplitCount();
        long rowCount = cubeMainMetadata.getRowCount();
        return new InputRowList(this.createDimensionKeysMap(splitCount, rowCount), this.createValuesList(rowCount), changeVersionManager, splitCount, cubeMainMetadata);
    }

    @NotNull
    public final IMutableIndexMap<IDimensionKeys> createDimensionKeysMap(long splitCount, long rowCount) {
        IEqualityComparer comparer = DefaultEqualityComparer.INSTANCE;
        IMutableArrayLong buckets = this.createBuckets();
        IMutableListHashMapEntry<HashMapEntry> entries2 = this.createEntries();
        IMutableList<IDimensionKeys> keysList = this.createKeys(splitCount, rowCount);
        return new DimensionKeysIndexMap(buckets, entries2, keysList, comparer);
    }

    private final IMutableArrayLong createBuckets() {
        ArrayMetadata metadata = new ArrayMetadata(this.sharedRes.getControlHeadBuffer(), CubeMainMetadata.Companion.getCubeControlItems().getDataBucketFields());
        return new MutableArrayLong(metadata, this.sharedRes.getBucketsContainer());
    }

    private final IMutableListHashMapEntry<HashMapEntry> createEntries() {
        ListMetadata<ListMetadata.ListHeadFieldCollection> metadata = new ListMetadata<ListMetadata.ListHeadFieldCollection>(this.sharedRes.getControlHeadBuffer(), CubeMainMetadata.Companion.getCubeControlItems().getDataEntryFields());
        return new MutableListEntry(metadata, this.sharedRes.getEntitiesContainer());
    }

    private final IMutableList<IDimensionKeys> createKeys(long splitCount, long rowCount) {
        IMutableList iMutableList;
        MinMutableListDimensionKeys unzipListIntArray = this.createUnzipMutableListDimensionKeys(rowCount);
        if (splitCount > 0L) {
            int n = 0;
            int n2 = this.cube.getDimensions().getCount();
            IImmutableListInt[] iImmutableListIntArray = new IImmutableListInt[n2];
            while (n < n2) {
                int n3 = n++;
                iImmutableListIntArray[n3] = this.createZipImmutableListInt((Dimension)this.cube.getDimensions().get(n3), splitCount);
            }
            IImmutableListInt[] columns = iImmutableListIntArray;
            CombinedImmutableListDimensionKeys zipListIntArray = new CombinedImmutableListDimensionKeys(columns);
            iMutableList = new SplitMutableList(zipListIntArray, unzipListIntArray);
        } else {
            iMutableList = unzipListIntArray;
        }
        return iMutableList;
    }

    @NotNull
    public final MinMutableListDimensionKeys createUnzipMutableListDimensionKeys(long rowCount) {
        CubeBigContainerResource sr = this.sharedRes;
        MinMutableListLargeByteOffset segmentIndex = new MinMutableListLargeByteOffset(sr.getMainUnzipKeyMetadata(), sr.getMainUnzipKeyContainer());
        int dimensionCount = this.cube.getDimensions().getCount();
        return new MinMutableListDimensionKeys(dimensionCount, segmentIndex, new VirtualListMetadata(rowCount, 0L, 2, null), sr.getMainUnzipDataContainer());
    }

    private final IImmutableListInt createUnzipImmutableListInt(Dimension dimension, long rowCount) {
        CubeBigContainerResource sr = this.sharedRes;
        MinImmutableListLargeByteOffset segmentIndex = new MinImmutableListLargeByteOffset(sr.getMainUnzipKeyMetadata(), sr.getMainUnzipKeyContainer());
        return new ImmutableStandardListInt(segmentIndex, (IImmutableSegmentContainer)sr.getMainUnzipDataContainer().getImmutableObject(), dimension.getPosition(), sr.getDimensionCount(), rowCount);
    }

    private final IImmutableListInt createZipImmutableListInt(Dimension dimension, long splitCount) {
        if (!(splitCount > 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        CubeBigContainerResource sr = this.sharedRes;
        UUID uuid = dimension.getGlobalID();
        Pair<IListMetadata, IOffsetMetadata> pair = sr.getUuidMap().tryGetMetadata(uuid);
        if (pair == null) {
            throw new RuntimeException();
        }
        Pair<IListMetadata, IOffsetMetadata> pair2 = pair;
        IListMetadata listMetadata = (IListMetadata)pair2.component1();
        IOffsetMetadata offsetMetadata = (IOffsetMetadata)pair2.component2();
        ContainerByteBufferResource res = new ContainerByteBufferResource(sr.getMainZipKeyContainer(), offsetMetadata);
        MinImmutableListByteOffset segmentIndex = new MinImmutableListByteOffset(listMetadata, res);
        return new ImmutableRunLengthListInt(segmentIndex, (IImmutableSegmentContainer)sr.getMainZipDataContainer().getImmutableObject(), splitCount);
    }

    @NotNull
    public final MutableRunLengthListInt createZipMutableListInt(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        CubeBigContainerResource sr = this.sharedRes;
        UUID uuid = dimension.getGlobalID();
        Pair<IListMetadata, IOffsetMetadata> pair = sr.getUuidMap().getOrAddMetadata(uuid);
        IListMetadata listMetadata = (IListMetadata)pair.component1();
        IOffsetMetadata offsetMetadata = (IOffsetMetadata)pair.component2();
        ContainerByteBufferResource res = new ContainerByteBufferResource(sr.getMainZipKeyContainer(), offsetMetadata);
        MinMutableListByteOffset offsetList = new MinMutableListByteOffset(listMetadata, res);
        return new MutableRunLengthListInt(offsetList, sr.getMainZipDataContainer());
    }

    @NotNull
    public final IImmutableListInt createImmutableListInt(@NotNull Dimension dimension, long splitCount, long rowCount) {
        IImmutableListInt iImmutableListInt;
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        if (splitCount > 0L) {
            IImmutableListInt firstList = this.createZipImmutableListInt(dimension, splitCount);
            IImmutableListInt secondList = this.createUnzipImmutableListInt(dimension, rowCount);
            iImmutableListInt = new SplitImmutableListInt(firstList, secondList);
        } else {
            iImmutableListInt = this.createUnzipImmutableListInt(dimension, rowCount);
        }
        return iImmutableListInt;
    }

    @NotNull
    public final IMinMutableBitmap createMutableBitmap(@NotNull UUID memberUUID) {
        Intrinsics.checkNotNullParameter((Object)memberUUID, (String)"memberUUID");
        return MinMutableBitmap.Companion.create(this.sharedRes, memberUUID);
    }

    @NotNull
    public final IQueryBitmap createQueryBitmap(@NotNull UUID memberUUID) {
        Intrinsics.checkNotNullParameter((Object)memberUUID, (String)"memberUUID");
        return MinQueryBitmap.Companion.create(this.sharedRes, memberUUID);
    }

    @NotNull
    public final IQueryBitmap createQueryBitmap(@NotNull Dimension dimension, @NotNull Member[] members2, long splitCount, long rowCount) {
        IQueryBitmap iQueryBitmap;
        boolean hasSimpleMember;
        int n;
        VirtualQueryBitmap secondBitmap;
        block7: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
            int staticCount = 64;
            NumberSetFilter matcher = new NumberSetFilter(staticCount);
            int n2 = members2.length;
            for (int i = 0; i < n2; ++i) {
                Member member;
                Member this_$iv = member = members2[i];
                boolean $i$f$getFixedNumber = false;
                matcher.add(this_$iv.getPosition());
            }
            secondBitmap = new VirtualQueryBitmap(this.createImmutableListInt(dimension, splitCount, rowCount), matcher.getWhiteListFilter());
            Member[] $this$any$iv = members2;
            boolean $i$f$any = false;
            int n3 = $this$any$iv.length;
            for (n = 0; n < n3; ++n) {
                Member element$iv;
                Member it = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                if (!it.isSimpleMember()) continue;
                bl = true;
                break block7;
            }
            bl = hasSimpleMember = false;
        }
        if (splitCount == 0L || members2.length >= 7 || hasSimpleMember) {
            iQueryBitmap = secondBitmap;
        } else {
            IQueryBitmap iQueryBitmap2;
            if (members2.length == 1) {
                iQueryBitmap2 = this.createQueryBitmap(members2[0].getGlobalID());
            } else {
                int n4 = 0;
                n = members2.length;
                IQueryBitmap[] iQueryBitmapArray = new IQueryBitmap[n];
                while (n4 < n) {
                    int n5 = n4++;
                    iQueryBitmapArray[n5] = this.createQueryBitmap(members2[n5].getGlobalID());
                }
                IQueryBitmap[] iQueryBitmapArray2 = iQueryBitmapArray;
                iQueryBitmap2 = new OrQueryBitmap(iQueryBitmapArray2);
            }
            IQueryBitmap firstBitmap = iQueryBitmap2;
            iQueryBitmap = new SplitQueryBitmap(firstBitmap, secondBitmap, splitCount);
        }
        return iQueryBitmap;
    }

    @NotNull
    public final IMutableCanSetList<IMeasureValues> createValuesList(long rowCount) {
        MeasureCollection measures2 = this.cube.getMeasures();
        int mSize = measures2.getCount();
        IMutableSparseList[] iMutableSparseListArray = new IMutableSparseList[mSize];
        for (int i = 0; i < mSize; ++i) {
            int n = i;
            Measure measure = (Measure)measures2.get(n);
            iMutableSparseListArray[n] = measure.getDataFormat().isSparse() ? null : new MutableSparseListFromDense<Object, IMutableCanSetList<Object>>(this.createMutableStandardListMeasure(measure), measure.getDataFormat().isDefaultValue());
        }
        IMutableSparseList[] existMeasures = iMutableSparseListArray;
        return new MeasureValuesList(new VirtualListMetadata(rowCount, 0L, 2, null), existMeasures, (Function1<? super Integer, ? extends IMutableSparseList<Object>>)((Function1)new Function1<Integer, IMutableSparseList<Object>>((Object)new LazyMeasuresCreator(existMeasures)){

            @NotNull
            public final IMutableSparseList<Object> invoke(int p0) {
                return ((LazyMeasuresCreator)this.receiver).create(p0);
            }
        }));
    }

    @NotNull
    public final IMutableCanSetList<Object> createMutableStandardListMeasure(@NotNull Measure measure) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        return measure.getDataFormat().createMutableStandardListMeasure(measure, this.sharedRes);
    }

    @NotNull
    public final IImmutableList<Object> createImmutableListMeasure(@NotNull Measure measure, long rowCount) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        return measure.getDataFormat().isSparse() ? (IImmutableList)new ImmutableListFromSparse(this.createImmutableSparseListMeasure(measure, rowCount), rowCount) : (this.existMeasureDirectory(measure) ? (IImmutableList)new ImmutableListFromDense<Object, IImmutableList<Object>>(this.createImmutableStandardListMeasure(measure), rowCount, measure.getDataFormat().isDefaultValue()) : (IImmutableList)new FixedImmutableList<Object>(rowCount, CommonTypesKt.getUndefined()));
    }

    private final boolean existMeasureDirectory(Measure measure) {
        IByteBufferProvider iByteBufferProvider = this.sharedRes.getBufferProvider();
        String string2 = measure.getGlobalID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return iByteBufferProvider.exist(string2);
    }

    private final IImmutableSparseList<Object> createImmutableSparseListMeasure(Measure measure, long rowCount) {
        IImmutableSparseList iImmutableSparseList;
        if (measure.getDataFormat() == OlapDataFormats.MeasureFormat_Dif) {
            Measure leftMeasure = measure.getLeftMeasure();
            Measure rightMeasure = measure.getRightMeasure();
            if (!(leftMeasure != null && rightMeasure != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            iImmutableSparseList = new ImmutableDifferenceListAny<Object>(this.createImmutableSparseListMeasure(leftMeasure, rowCount), this.createImmutableSparseListMeasure(rightMeasure, rowCount));
        } else {
            iImmutableSparseList = measure.getDataFormat().isSparse() ? (this.existMeasureDirectory(measure) ? this.createImmutableSparseListMeasure(measure) : (IImmutableSparseList)EmptyImmutableSparseList.Companion.getDefault()) : (IImmutableSparseList)(this.existMeasureDirectory(measure) ? new ImmutableSparseListFromDense<Object, IImmutableList<Object>>(this.createImmutableStandardListMeasure(measure), CommonTypesKt.getUndefined()) : new ImmutableSparseListFromDense<Object, IImmutableList>(new FixedImmutableList<Object>(rowCount, CommonTypesKt.getUndefined()), CommonTypesKt.getUndefined()));
        }
        return iImmutableSparseList;
    }

    private final IImmutableList<Object> createImmutableStandardListMeasure(Measure measure) {
        return measure.getDataFormat().createImmutableStandardListMeasure(measure, this.sharedRes);
    }

    private final IImmutableSparseList<Object> createImmutableSparseListMeasure(Measure measure) {
        return measure.getDataFormat().createImmutableSparseListMeasure(measure, this.sharedRes);
    }

    @NotNull
    public final IMutableCanSetListLong createMutableMeasureIndex(@NotNull Measure measure, long rowCount) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        CubeBigContainerResource sr = this.sharedRes;
        UUID uuid = measure.getGlobalID();
        MeasureSource measureContainer = sr.getStandardMeasureContainer(uuid);
        IMutableFullSegmentContainer indexContainer = measureContainer.getIndexContainer();
        long realLength = Math.min(indexContainer.getContentBuffer().getCapacity() / (long)8, rowCount);
        VirtualListMetadata listMetadata = new VirtualListMetadata(realLength, 0L, 2, null);
        return new MutableCanSetListLong(listMetadata, indexContainer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/storages/CubeDataStorage$Companion;", "", "()V", "outerMeasureSegmentSize", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\n\u0010\b\u001a\u00060\tj\u0002`\nR \u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/storages/CubeDataStorage$LazyMeasuresCreator;", "", "sparseMeasureList", "", "Lkd/bos/olapServer2/collections/IMutableSparseList;", "(Lkd/bos/olapServer2/storages/CubeDataStorage;[Lkd/bos/olapServer2/collections/IMutableSparseList;)V", "[Lkd/bos/olapServer2/collections/IMutableSparseList;", "create", "index", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nCubeDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeDataStorage.kt\nkd/bos/olapServer2/storages/CubeDataStorage$LazyMeasuresCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
    private final class LazyMeasuresCreator {
        @NotNull
        private final IMutableSparseList<Object>[] sparseMeasureList;

        public LazyMeasuresCreator(IMutableSparseList<Object>[] sparseMeasureList) {
            Intrinsics.checkNotNullParameter(sparseMeasureList, (String)"sparseMeasureList");
            this.sparseMeasureList = sparseMeasureList;
        }

        @NotNull
        public final IMutableSparseList<Object> create(int index2) {
            IMutableSparseList iMutableSparseList;
            Measure currentMeasure = (Measure)CubeDataStorage.this.cube.getMeasures().get(index2);
            if (currentMeasure.getDataFormat().isSparse()) {
                if (currentMeasure.getDataFormat() == OlapDataFormats.MeasureFormat_Dif) {
                    int rightMeasureIndex;
                    IMutableSparseList<Object> iMutableSparseList2;
                    IMutableSparseList<Object> leftMeasureList;
                    Measure leftMeasure = currentMeasure.getLeftMeasure();
                    Measure rightMeasure = currentMeasure.getRightMeasure();
                    if (!(leftMeasure != null && rightMeasure != null)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    int leftMeasureIndex = leftMeasure.getPosition();
                    IMutableSparseList<Object> iMutableSparseList3 = this.sparseMeasureList[leftMeasureIndex];
                    if (iMutableSparseList3 == null) {
                        IMutableSparseList<Object> iMutableSparseList4;
                        IMutableSparseList<Object> it = iMutableSparseList4 = this.create(leftMeasureIndex);
                        boolean bl = false;
                        this.sparseMeasureList[index2] = it;
                        iMutableSparseList3 = leftMeasureList = iMutableSparseList4;
                    }
                    if ((iMutableSparseList2 = this.sparseMeasureList[rightMeasureIndex = rightMeasure.getPosition()]) == null) {
                        IMutableSparseList<Object> iMutableSparseList5;
                        IMutableSparseList<Object> it = iMutableSparseList5 = this.create(rightMeasureIndex);
                        boolean bl = false;
                        this.sparseMeasureList[index2] = it;
                        iMutableSparseList2 = iMutableSparseList5;
                    }
                    IMutableSparseList<Object> rightMeasureList = iMutableSparseList2;
                    iMutableSparseList = new MutableDifferenceSparseList<Object>(leftMeasureList, rightMeasureList);
                } else {
                    iMutableSparseList = currentMeasure.getDataFormat().createMutableSparseListMeasure(currentMeasure, CubeDataStorage.this.sharedRes);
                }
            } else {
                throw new NotSupportedException("no support lazy create measure DataFormat: " + (Object)((Object)currentMeasure.getDataFormat()));
            }
            return iMutableSparseList;
        }
    }
}

