/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Flushable;
import java.util.BitSet;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.collections.IIndexScanner;
import kd.bos.olapServer2.collections.IQueryBitmap;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.VirtualListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFullSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.MutableBitmapContainer;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListLargeByteOffset;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncodingV3.MutableRunLengthListInt;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.builds.MemberBuilder;
import kd.bos.olapServer2.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer2.metadata.events.CreateMemberEvent;
import kd.bos.olapServer2.metadata.events.DropDimensionEvent;
import kd.bos.olapServer2.metadata.events.DropMemberEvent;
import kd.bos.olapServer2.metadata.events.MetadataEvent;
import kd.bos.olapServer2.metadata.xBuilds.XDimension;
import kd.bos.olapServer2.query.ImmutableAndBitmap2;
import kd.bos.olapServer2.query.ImmutableInvBitmapKt;
import kd.bos.olapServer2.query.ImmutableRowValidBitmap;
import kd.bos.olapServer2.query.IndexIterator;
import kd.bos.olapServer2.query.ValidValueIterator;
import kd.bos.olapServer2.storages.CubeBigContainerResource;
import kd.bos.olapServer2.storages.CubeBigContainerStorage;
import kd.bos.olapServer2.storages.CubeDataStorage;
import kd.bos.olapServer2.storages.CubeMetadataBinding;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/storages/CubeMetadataBinding;", "", "pool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "(Lkd/bos/olapServer2/storages/CubeResourcePool;)V", "bind", "", "event", "Lkd/bos/olapServer2/metadata/events/MetadataEvent;", "createDimensionBind", "Lkd/bos/olapServer2/metadata/events/CreateDimensionEvent;", "createMemberBind", "dropDimensionBind", "Lkd/bos/olapServer2/metadata/events/DropDimensionEvent;", "dropMemberBind", "Lkd/bos/olapServer2/metadata/events/DropMemberEvent;", "AddOneDimensionKey", "Companion", "DeleteOneDimensionKey", "bos-olap-core2"})
public final class CubeMetadataBinding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CubeResourcePool pool;

    public CubeMetadataBinding(@NotNull CubeResourcePool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
    }

    public final void bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof DropMemberEvent) {
            this.dropMemberBind((DropMemberEvent)event);
        } else if (metadataEvent instanceof DropDimensionEvent) {
            this.dropDimensionBind((DropDimensionEvent)event);
        } else if (metadataEvent instanceof CreateMemberEvent) {
            this.createMemberBind();
        } else if (metadataEvent instanceof CreateDimensionEvent) {
            this.createDimensionBind((CreateDimensionEvent)event);
        }
    }

    private final void createDimensionBind(CreateDimensionEvent event) {
        event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
            final /* synthetic */ CreateDimensionEvent $event;
            final /* synthetic */ CubeMetadataBinding this$0;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MemberBuilder defaultMemberBuilder = this.$event.getDefaultMemberBuilder();
                long rowCount = CubeMetadataBinding.access$getPool$p(this.this$0).getRowCount();
                if (rowCount > 0L) {
                    if (!(defaultMemberBuilder != null)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    long splitCount = CubeMetadataBinding.access$getPool$p(this.this$0).getSplitCount();
                    CubeDataStorage dataStorage = CubeMetadataBinding.access$getPool$p(this.this$0).getDataStorage();
                    CubeBigContainerResource sr = CubeMetadataBinding.access$getPool$p(this.this$0).getSharedResource();
                    XDimension dim = this.$event.getDimBuilder().build();
                    int dimensionPosition = dim.getPosition();
                    int memberPosition = dim.getMembers().get(defaultMemberBuilder.getName()).getPosition();
                    MutableRunLengthListInt zipDimensionList = dataStorage.createZipMutableListInt(dim);
                    int n = 0;
                    int[] nArray = new int[65536];
                    while (n < 65536) {
                        int n2 = n++;
                        nArray[n2] = memberPosition;
                    }
                    int[] intArray = nArray;
                    long l = splitCount / (long)65536;
                    for (long it = 0L; it < l; ++it) {
                        zipDimensionList.add(intArray);
                    }
                    Flushable flushable = zipDimensionList instanceof Flushable ? (Flushable)zipDimensionList : null;
                    if (flushable != null) {
                        flushable.flush();
                    }
                    IMinMutableBitmap bitmap2 = dataStorage.createMutableBitmap(defaultMemberBuilder.getGlobalID());
                    int n3 = 0;
                    long[] lArray = new long[256];
                    while (n3 < 256) {
                        int n4 = n3++;
                        lArray[n4] = -1L;
                    }
                    long[] longArray = lArray;
                    int n5 = 0;
                    long[] lArray2 = new long[4];
                    while (n5 < 4) {
                        int n6 = n5++;
                        lArray2[n6] = -1L;
                    }
                    BitSet bitSet = BitSet.valueOf(lArray2);
                    long l2 = splitCount / (long)16384;
                    for (long i = 0L; i < l2; ++i) {
                        long l3 = i * (long)256;
                        Intrinsics.checkNotNull((Object)bitSet);
                        bitmap2.update(l3, longArray, bitSet);
                    }
                    Flushable flushable2 = bitmap2 instanceof Flushable ? (Flushable)((Object)bitmap2) : null;
                    if (flushable2 != null) {
                        flushable2.flush();
                    }
                    MinMutableListDimensionKeys oldList = dataStorage.createUnzipMutableListDimensionKeys(rowCount);
                    sr.getMainUnzipKeyMetadata().setValidCount(0L);
                    sr.getMainUnzipKeyMetadata().setStart(CubeMetadataBinding.access$getPool$p(this.this$0).getSplitCount() / (long)65536);
                    int oldDimensionCount = CubeMetadataBinding.access$getPool$p(this.this$0).getCube().getDimensions().getCount();
                    int newDimensionCount = oldDimensionCount + 1;
                    CubeBigContainerStorage bigContainerStorage = new CubeBigContainerStorage(sr.getBufferProvider());
                    IMutableFullSegmentContainer mainUnzipKeyContainer = bigContainerStorage.createMainUnzipKeyContainer(newDimensionCount);
                    IMutableFixedSegmentContainer mainUnzipDataContainer = bigContainerStorage.createMainUnzipDataContainer(newDimensionCount);
                    MinMutableListLargeByteOffset newSegmentIndex = new MinMutableListLargeByteOffset(sr.getMainUnzipKeyMetadata(), mainUnzipKeyContainer);
                    MinMutableListDimensionKeys newList = new MinMutableListDimensionKeys(newDimensionCount, newSegmentIndex, new VirtualListMetadata(splitCount, 0L, 2, null), mainUnzipDataContainer);
                    for (long i = splitCount; i < rowCount; ++i) {
                        IDimensionKeys keys = oldList.get(i);
                        newList.add(new AddOneDimensionKey(keys, dimensionPosition, memberPosition));
                    }
                    newList.flush();
                }
            }
        }));
    }

    private final void dropDimensionBind(DropDimensionEvent event) {
        long rowCount = this.pool.getRowCount();
        long splitCount = this.pool.getSplitCount();
        event.before((Function0<Unit>)((Function0)new Function0<Unit>(this, event, splitCount, rowCount){
            final /* synthetic */ CubeMetadataBinding this$0;
            final /* synthetic */ DropDimensionEvent $event;
            final /* synthetic */ long $splitCount;
            final /* synthetic */ long $rowCount;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$splitCount = $splitCount;
                this.$rowCount = $rowCount;
                super(0);
            }

            public final void invoke() {
                if (CubeMetadataBinding.access$getPool$p(this.this$0).getRowCount() != 0L) {
                    CubeDataStorage dataStorage = CubeMetadataBinding.access$getPool$p(this.this$0).getDataStorage();
                    IImmutableListInt list2 = dataStorage.createImmutableListInt(this.$event.getDimension(), this.$splitCount, this.$rowCount);
                    long l = list2.getCount();
                    for (long i = 0L; i < l; ++i) {
                        if (list2.get(i) == 0) continue;
                        this.$event.setOnlyDefaultMember(false);
                        break;
                    }
                }
            }
        }));
        event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this, rowCount, splitCount){
            final /* synthetic */ DropDimensionEvent $event;
            final /* synthetic */ CubeMetadataBinding this$0;
            final /* synthetic */ long $rowCount;
            final /* synthetic */ long $splitCount;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                this.$rowCount = $rowCount;
                this.$splitCount = $splitCount;
                super(0);
            }

            public final void invoke() {
                if (!this.$event.isRebuild() && CubeMetadataBinding.access$getPool$p(this.this$0).getRowCount() != 0L) {
                    CubeDataStorage dataStorage = CubeMetadataBinding.access$getPool$p(this.this$0).getDataStorage();
                    CubeBigContainerResource sr = CubeMetadataBinding.access$getPool$p(this.this$0).getSharedResource();
                    MinMutableListDimensionKeys oldList = dataStorage.createUnzipMutableListDimensionKeys(this.$rowCount);
                    sr.getMainUnzipKeyMetadata().setValidCount(0L);
                    sr.getMainUnzipKeyMetadata().setStart(CubeMetadataBinding.access$getPool$p(this.this$0).getSplitCount() / (long)65536);
                    int newDimensionCount = CubeMetadataBinding.access$getPool$p(this.this$0).getCube().getDimensions().getCount() - 1;
                    CubeBigContainerStorage bigContainerStorage = new CubeBigContainerStorage(sr.getBufferProvider());
                    IMutableFullSegmentContainer mainUnzipKeyContainer = bigContainerStorage.createMainUnzipKeyContainer(newDimensionCount);
                    IMutableFixedSegmentContainer mainUnzipDataContainer = bigContainerStorage.createMainUnzipDataContainer(newDimensionCount);
                    MinMutableListLargeByteOffset newSegmentIndex = new MinMutableListLargeByteOffset(sr.getMainUnzipKeyMetadata(), mainUnzipKeyContainer);
                    MinMutableListDimensionKeys newList = new MinMutableListDimensionKeys(newDimensionCount, newSegmentIndex, new VirtualListMetadata(this.$splitCount, 0L, 2, null), mainUnzipDataContainer);
                    for (long i = this.$splitCount; i < this.$rowCount; ++i) {
                        IDimensionKeys keys = oldList.get(i);
                        newList.add(new DeleteOneDimensionKey(keys, this.$event.getDimension().getPosition()));
                    }
                    newList.flush();
                }
            }
        }));
    }

    private final void createMemberBind() {
    }

    private final void dropMemberBind(DropMemberEvent event) {
        long splitCount = this.pool.getSplitCount();
        long rowCount = this.pool.getRowCount();
        if (!event.isPartitionDimension()) {
            event.before((Function0<Unit>)((Function0)new Function0<Unit>(event, this, splitCount, rowCount){
                final /* synthetic */ DropMemberEvent $event;
                final /* synthetic */ CubeMetadataBinding this$0;
                final /* synthetic */ long $splitCount;
                final /* synthetic */ long $rowCount;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    this.$splitCount = $splitCount;
                    this.$rowCount = $rowCount;
                    super(0);
                }

                public final void invoke() {
                    IQueryBitmap rowValidBitmap;
                    Dimension dimension = this.$event.getDimension();
                    Object[] members2 = this.$event.getDropMembers();
                    IQueryBitmap queryBitmap = CubeMetadataBinding.access$getPool$p(this.this$0).getDataStorage().createQueryBitmap(dimension, (Member[])members2, this.$splitCount, this.$rowCount);
                    if (CubeMetadataBinding.Companion.memberHasReference(this.$rowCount, queryBitmap, rowValidBitmap = CubeMetadataBinding.access$getPool$p(this.this$0).getDataStorage().getRowValidBitmaps().createQueryMutableBitmap(MutableBitmapContainer.Companion.getROW_VALID_UUID()), this.$event)) {
                        if (!this.$event.getAllowDropMemberWhenRowReferenced()) {
                            String string2 = Res.INSTANCE.getMemberMetadataCommandException_3();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MemberMetadataCommandException_3>(...)");
                            Object[] objectArray = new Object[]{dimension.getName(), ArraysKt.joinToString$default((Object[])members2, null, null, null, (int)0, null, (Function1)dropMemberBind.1.INSTANCE, (int)31, null)};
                            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                        }
                        this.$event.markHasReference();
                    }
                }
            }));
        }
    }

    public static final /* synthetic */ CubeResourcePool access$getPool$p(CubeMetadataBinding $this) {
        return $this.pool;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u0010\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0011\u001a\u00060\u0004j\u0002`\u0005H\u0096\u0002R\u0018\u0010\b\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/storages/CubeMetadataBinding$AddOneDimensionKey;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "source", "addDimension", "", "Lkd/bos/olapServer2/common/int;", "addMember", "(Lkd/bos/olapServer2/dataEntities/IDimensionKeys;II)V", "Count", "getCount", "()I", "array", "", "getArray", "()[I", "arrayCache", "get", "dimensionIndex", "bos-olap-core2"})
    private static final class AddOneDimensionKey
    implements IDimensionKeys {
        @NotNull
        private final IDimensionKeys source;
        private final int addDimension;
        private final int addMember;
        @NotNull
        private int[] arrayCache;

        public AddOneDimensionKey(@NotNull IDimensionKeys source2, int addDimension, int addMember) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            this.source = source2;
            this.addDimension = addDimension;
            this.addMember = addMember;
            this.arrayCache = CommonTypesKt.getEmptyIntArray();
        }

        @Override
        public int getCount() {
            return this.source.getCount() + 1;
        }

        @Override
        public int get(int dimensionIndex) {
            return dimensionIndex > this.addDimension ? this.source.get(dimensionIndex - 1) : (dimensionIndex == this.addDimension ? this.addMember : this.source.get(dimensionIndex));
        }

        @Override
        @NotNull
        public int[] getArray() {
            if (this.arrayCache.length != this.getCount()) {
                int n = 0;
                int n2 = this.getCount();
                int[] nArray = new int[n2];
                AddOneDimensionKey addOneDimensionKey = this;
                while (n < n2) {
                    int n3 = n++;
                    nArray[n3] = this.get(n3);
                }
                addOneDimensionKey.arrayCache = nArray;
            } else {
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    this.arrayCache[i] = this.get(i);
                }
            }
            return this.arrayCache;
        }

        @Override
        public boolean equals2(@NotNull IDimensionKeys other) {
            return IDimensionKeys.DefaultImpls.equals2(this, other);
        }

        @Override
        public long hashCode2() {
            return IDimensionKeys.DefaultImpls.hashCode2(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/storages/CubeMetadataBinding$Companion;", "", "()V", "memberHasReference", "", "Lkd/bos/olapServer2/common/bool;", "rowCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "queryBitmap", "Lkd/bos/olapServer2/collections/IQueryBitmap;", "rowValidBitmap", "event", "Lkd/bos/olapServer2/metadata/events/DropMemberEvent;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean memberHasReference(long rowCount, @NotNull IQueryBitmap queryBitmap, @NotNull IQueryBitmap rowValidBitmap, @NotNull DropMemberEvent event) {
            Intrinsics.checkNotNullParameter((Object)queryBitmap, (String)"queryBitmap");
            Intrinsics.checkNotNullParameter((Object)rowValidBitmap, (String)"rowValidBitmap");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!queryBitmap.afterValueIsZero(0L)) {
                event.markRequiredDropMemberBitmap();
                ImmutableAndBitmap2 resultBitmap = new ImmutableAndBitmap2(queryBitmap, new ImmutableRowValidBitmap(rowCount, ImmutableInvBitmapKt.inv(rowValidBitmap)));
                IIndexScanner indexScanner = queryBitmap.getIndexScanner();
                long longCount = CommonTypesKt.bitCountToLongCount(rowCount);
                IndexIterator indexRange = new IndexIterator(indexScanner, 0L, longCount);
                ValidValueIterator validValueItr = new ValidValueIterator(resultBitmap, indexRange);
                if (validValueItr.next()) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u000f\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0010\u001a\u00060\u0004j\u0002`\u0005H\u0096\u0002R\u0018\u0010\u0007\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/storages/CubeMetadataBinding$DeleteOneDimensionKey;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "source", "deleteDimension", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/dataEntities/IDimensionKeys;I)V", "Count", "getCount", "()I", "array", "", "getArray", "()[I", "arrayCache", "get", "dimensionIndex", "bos-olap-core2"})
    private static final class DeleteOneDimensionKey
    implements IDimensionKeys {
        @NotNull
        private final IDimensionKeys source;
        private final int deleteDimension;
        @NotNull
        private int[] arrayCache;

        public DeleteOneDimensionKey(@NotNull IDimensionKeys source2, int deleteDimension) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            this.source = source2;
            this.deleteDimension = deleteDimension;
            this.arrayCache = CommonTypesKt.getEmptyIntArray();
        }

        @Override
        public int getCount() {
            return this.source.getCount() - 1;
        }

        @Override
        public int get(int dimensionIndex) {
            return dimensionIndex >= this.deleteDimension ? this.source.get(dimensionIndex + 1) : this.source.get(dimensionIndex);
        }

        @Override
        @NotNull
        public int[] getArray() {
            if (this.arrayCache.length != this.getCount()) {
                int n = 0;
                int n2 = this.getCount();
                int[] nArray = new int[n2];
                DeleteOneDimensionKey deleteOneDimensionKey = this;
                while (n < n2) {
                    int n3 = n++;
                    nArray[n3] = this.get(n3);
                }
                deleteOneDimensionKey.arrayCache = nArray;
            } else {
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    this.arrayCache[i] = this.get(i);
                }
            }
            return this.arrayCache;
        }

        @Override
        public boolean equals2(@NotNull IDimensionKeys other) {
            return IDimensionKeys.DefaultImpls.equals2(this, other);
        }

        @Override
        public long hashCode2() {
            return IDimensionKeys.DefaultImpls.hashCode2(this);
        }
    }
}

