/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.UnhandledExceptionEventArgs;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportContainer;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.storages.CubeMetadataLock;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.plugins.CubeWorkspaceEventArgs;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.TransactionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010'\u001a\u00020\u000fH\u0002J\u0006\u0010(\u001a\u00020)J%\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H+0-\u00a2\u0006\u0002\u0010.J+\u0010/\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002H+00\u00a2\u0006\u0002\u00102J%\u00103\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H+0-\u00a2\u0006\u0002\u0010.J\u0006\u00104\u001a\u00020)J\b\u00105\u001a\u00020)H\u0002J\u0018\u00106\u001a\u00020)2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010108H\u0002J\b\u00109\u001a\u0004\u0018\u00010\u000fJ\b\u0010:\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010;\u001a\u00020)J\u0006\u0010<\u001a\u00020)R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0019R\u0015\u0010\u001a\u001a\u00060\fj\u0002`\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006>"}, d2={"Lkd/bos/olapServer2/storages/CubeWorkspaceCreator;", "", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "parent", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "(ILjava/lang/String;Lkd/bos/olapServer2/storages/OlapWorkspace;)V", "_lastCommittedTransactionId", "", "_state", "_value", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "cubeDataPath", "getCubeDataPath", "()Ljava/lang/String;", "getCubeId", "()I", "getCubeName", "isInitialized", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "lastCommittedTransactionId", "Lkd/bos/olapServer2/common/long;", "getLastCommittedTransactionId", "()J", "metadataLock", "Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "getMetadataLock", "()Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "getParent", "()Lkd/bos/olapServer2/storages/OlapWorkspace;", "value", "getValue", "()Lkd/bos/olapServer2/storages/CubeWorkspace;", "create", "delete", "", "enterRead", "R", "body", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "enterReadForBackup", "Lkotlin/Function2;", "Ljava/io/Closeable;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "enterWrite", "gc", "gcCore", "realUnload", "getLock", "Lkotlin/Function0;", "shutdown", "tryGetValue", "tryUnload", "unload", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeWorkspaceCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeWorkspaceCreator.kt\nkd/bos/olapServer2/storages/CubeWorkspaceCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class CubeWorkspaceCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int cubeId;
    @NotNull
    private final String cubeName;
    @NotNull
    private final OlapWorkspace parent;
    @NotNull
    private final ICubeMetadataLock metadataLock;
    @Nullable
    private volatile CubeWorkspace _value;
    private int _state;
    private long _lastCommittedTransactionId;
    private static final int Ready = 0;
    private static final int IsClosed = 1;
    private static final int IsDeleted = 2;

    public CubeWorkspaceCreator(int cubeId, @NotNull String cubeName, @NotNull OlapWorkspace parent) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.cubeId = cubeId;
        this.cubeName = cubeName;
        this.parent = parent;
        this.metadataLock = new CubeMetadataLock();
        this._lastCommittedTransactionId = -1L;
    }

    public final int getCubeId() {
        return this.cubeId;
    }

    @NotNull
    public final String getCubeName() {
        return this.cubeName;
    }

    @NotNull
    public final OlapWorkspace getParent() {
        return this.parent;
    }

    @NotNull
    public final ICubeMetadataLock getMetadataLock() {
        return this.metadataLock;
    }

    public final boolean isInitialized() {
        return this._value != null;
    }

    private final String getCubeDataPath() {
        String[] stringArray = new String[]{this.cubeName};
        return ((Object)Paths.INSTANCE.get(this.parent.getRootPath(), stringArray)).toString();
    }

    @Nullable
    public final CubeWorkspace tryGetValue() {
        CubeWorkspace v = this._value;
        if (v != null && this._state == 0) {
            this.metadataLock.getBeings().active();
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CubeWorkspace getValue() {
        CubeWorkspace cubeWorkspace;
        CubeWorkspace v1 = this.tryGetValue();
        if (v1 != null) {
            return v1;
        }
        CubeWorkspaceCreator cubeWorkspaceCreator = this;
        synchronized (cubeWorkspaceCreator) {
            boolean bl = false;
            CubeWorkspace cubeWorkspace2 = this.tryGetValue();
            if (cubeWorkspace2 == null) {
                cubeWorkspace2 = this.create();
            }
            cubeWorkspace = cubeWorkspace2;
        }
        return cubeWorkspace;
    }

    private final CubeWorkspace create() {
        switch (this._state) {
            case 1: {
                String string2 = Res.INSTANCE.getOlapWorkspaceException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_4>(...)");
                Object[] objectArray = new Object[]{this.cubeName};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            case 2: {
                String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
                Object[] objectArray = new Object[]{this.cubeName};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }
        CubeWorkspace cubeWorkspace = new CubeWorkspace(this.getCubeDataPath(), this.cubeId, this.metadataLock);
        if (!Intrinsics.areEqual((Object)this.cubeName, (Object)cubeWorkspace.getMetadata().getName())) {
            boolean bl = false;
            String string4 = "cubeName:" + this.cubeName + ", but metadata.Name:" + cubeWorkspace.getMetadata().getName();
            throw new IllegalArgumentException(string4.toString());
        }
        this.parent.getCubeWorkspaceLoading().invoke(this.parent.getPluginContext$bos_olap_core2(), new CubeWorkspaceEventArgs(cubeWorkspace.getPlugins().getContext()));
        this._value = cubeWorkspace;
        return cubeWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R enterRead(@NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Object object2;
        Closeable lock;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Closeable closeable = lock = this.metadataLock.getReadLock();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            object2 = body.invoke((Object)this.getValue());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (R)object2;
    }

    /*
     * Exception decompiling
     */
    public final <R> R enterReadForBackup(@NotNull Function2<? super CubeWorkspace, ? super Closeable, ? extends R> body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R enterWrite(@NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Object object2;
        Closeable lock;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Closeable closeable = lock = this.metadataLock.getWriteLock();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            object2 = body.invoke((Object)this.getValue());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (R)object2;
    }

    public final void gc() {
        try {
            this.gcCore();
        }
        catch (Throwable ex) {
            if (this.isInitialized()) {
                HealthReportContainer healthReportContainer = this.getValue().getHealthReports();
                String string2 = "GC-" + CubeToolKt.getCurrentTime();
                String string3 = ex.getMessage();
                if (string3 == null) {
                    string3 = "gc error";
                }
                healthReportContainer.commit(new HealthReport(string2, this.cubeName, string3, HealthReportLevel.Error, PrivilegeType.None.getCode()));
                OlapRuntimeException ex2 = ex instanceof OlapRuntimeException ? (OlapRuntimeException)ex : new OlapRuntimeException("gc error at " + this.cubeName + ": " + ex.getMessage(), this.cubeName, ex);
                UnhandledExceptionEventArgs.Companion.onError$bos_olap_core2(this, ex2, "gc-" + this.cubeName);
            }
            throw ex;
        }
    }

    private final void gcCore() {
        CubeWorkspace current = this._value;
        if (current == null) {
            return;
        }
        if (this.metadataLock.getBeings().getLastActiveInterval() < OlapWorkspace.Companion.getCubeWorkspaceUnloadTimeout() && !current.isClosed()) {
            current.gc();
        } else {
            if (current.getMetadataLock().hasHolder()) {
                this.metadataLock.getBeings().active();
                return;
            }
            this.unload();
        }
    }

    public final void unload() {
        this.realUnload((Function0<? extends Closeable>)((Function0)new Function0<Closeable>((Object)this.metadataLock){

            @NotNull
            public final Closeable invoke() {
                return ((ICubeMetadataLock)this.receiver).getReadLock();
            }
        }));
    }

    public final void tryUnload() {
        this.realUnload((Function0<? extends Closeable>)((Function0)new Function0<Closeable>((Object)this.metadataLock){

            @Nullable
            public final Closeable invoke() {
                return ((ICubeMetadataLock)this.receiver).tryGetWriteLock();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void realUnload(Function0<? extends Closeable> getLock) {
        CubeWorkspace current = this._value;
        if (current == null) {
            return;
        }
        Closeable lock = (Closeable)getLock.invoke();
        if (lock == null) {
            return;
        }
        Closeable closeable = lock;
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            CubeWorkspaceCreator cubeWorkspaceCreator = this;
            synchronized (cubeWorkspaceCreator) {
                boolean bl2 = false;
                CubeWorkspace current2 = this._value;
                if (current2 != null && current == current2 && !current2.isClosed()) {
                    this._lastCommittedTransactionId = current2.getTransactionManager().getLastCommittedTransactionId();
                    this._value = null;
                    current2.close();
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void delete() {
        this._state = 2;
        this._lastCommittedTransactionId = -2L;
        CubeWorkspace cubeWorkspace = this._value;
        if (cubeWorkspace != null) {
            cubeWorkspace.close();
        }
        this._value = null;
    }

    @Nullable
    public final CubeWorkspace shutdown() {
        this._state = 1;
        return this._value;
    }

    public final long getLastCommittedTransactionId() {
        Object object2 = this._value;
        return object2 != null && (object2 = ((CubeWorkspace)object2).getTransactionManager()) != null ? ((TransactionManager)object2).getLastCommittedTransactionId() : this._lastCommittedTransactionId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/storages/CubeWorkspaceCreator$Companion;", "", "()V", "IsClosed", "", "IsDeleted", "Ready", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

