/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.File;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportContainer;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0015\u001a\u00060\u0014j\u0002`\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0018H\u0002R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/storages/DiskFreeSpaceChecker;", "", "reportId", "", "Lkd/bos/olapServer2/common/string;", "rootPath", "healthReports", "Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "dotReportError", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/lang/String;Ljava/lang/String;Lkd/bos/olapServer2/monitorReports/HealthReportContainer;Z)V", "freeSpaceFile", "Ljava/io/File;", "getFreeSpaceFile", "()Ljava/io/File;", "freeSpaceFile$delegate", "Lkotlin/Lazy;", "lastGetSpacePair", "Lkotlin/Pair;", "", "checkExecuteByFreeSpace", "Lkd/bos/olapServer2/common/long;", "repair", "Lkd/bos/olapServer2/monitorReports/HealthReportLevel;", "bos-olap-core2"})
public final class DiskFreeSpaceChecker {
    @NotNull
    private final String reportId;
    @NotNull
    private final String rootPath;
    @NotNull
    private final HealthReportContainer healthReports;
    private final boolean dotReportError;
    @NotNull
    private final Lazy freeSpaceFile$delegate;
    @NotNull
    private Pair<Long, Long> lastGetSpacePair;

    public DiskFreeSpaceChecker(@NotNull String reportId, @NotNull String rootPath, @NotNull HealthReportContainer healthReports, boolean dotReportError) {
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)healthReports, (String)"healthReports");
        this.reportId = reportId;
        this.rootPath = rootPath;
        this.healthReports = healthReports;
        this.dotReportError = dotReportError;
        this.freeSpaceFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ DiskFreeSpaceChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return PathsKt.fileSafeConstructor(DiskFreeSpaceChecker.access$getRootPath$p(this.this$0));
            }
        }));
        this.lastGetSpacePair = new Pair((Object)0L, (Object)0L);
    }

    private final File getFreeSpaceFile() {
        Lazy lazy = this.freeSpaceFile$delegate;
        return (File)lazy.getValue();
    }

    private final HealthReportLevel repair(HealthReportLevel $this$repair) {
        return this.dotReportError && $this$repair == HealthReportLevel.Error ? HealthReportLevel.Warning : $this$repair;
    }

    public final long checkExecuteByFreeSpace() {
        Pair last = this.lastGetSpacePair;
        long currentTime = System.currentTimeMillis();
        Pair pair = last;
        long lastFreeMB = ((Number)pair.component1()).longValue();
        long lastTime = ((Number)pair.component2()).longValue();
        if (lastFreeMB < 10240L || lastFreeMB < 30720L && currentTime - lastTime > 60000L || lastFreeMB >= 30720L && currentTime - lastTime > 1200000L) {
            long freeSpace = this.getFreeSpaceFile().getFreeSpace() / (long)0x100000;
            long l = freeSpace;
            boolean bl = 0L <= l ? l < 4097L : false;
            if (bl) {
                String string2 = Res.INSTANCE.getOlapWorkspaceException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_3>(...)");
                Object[] objectArray = new Object[]{freeSpace / (long)1024};
                HealthReport report = new HealthReport(this.reportId, null, Res.INSTANCE.format(string2, objectArray), this.repair(HealthReportLevel.Error), this.dotReportError ? PrivilegeType.None.getCode() : ~(PrivilegeType.Read.getCode() | PrivilegeType.SingleCubeBackup.getCode()));
                this.healthReports.commit(report);
            } else {
                boolean bl2 = 4096L <= l ? l < 10241L : false;
                if (bl2) {
                    String string3 = Res.INSTANCE.getOlapWorkspaceException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_3>(...)");
                    Object[] objectArray = new Object[]{freeSpace / (long)1024};
                    HealthReport report = new HealthReport(this.reportId, null, Res.INSTANCE.format(string3, objectArray), this.repair(HealthReportLevel.Error), this.dotReportError ? PrivilegeType.None.getCode() : PrivilegeType.Compute.getCode() | PrivilegeType.TotalRecovery.getCode() | PrivilegeType.TotalBackup.getCode() | PrivilegeType.SingleCubeRecovery.getCode());
                    this.healthReports.commit(report);
                } else {
                    boolean bl3 = 10240L <= l ? l < 30721L : false;
                    if (bl3) {
                        String string4 = Res.INSTANCE.getOlapWorkspaceException_10();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-OlapWorkspaceException_10>(...)");
                        Object[] objectArray = new Object[]{freeSpace / (long)1024};
                        HealthReport report = new HealthReport(this.reportId, null, Res.INSTANCE.format(string4, objectArray), HealthReportLevel.Warning, PrivilegeType.None.getCode());
                        this.healthReports.commit(report);
                    } else if (lastFreeMB != 0L && lastFreeMB <= 30720L) {
                        this.healthReports.solveById(this.reportId);
                    }
                }
            }
            this.lastGetSpacePair = last = new Pair((Object)currentTime, (Object)freeSpace);
        }
        return ((Number)last.getSecond()).longValue();
    }

    public static final /* synthetic */ String access$getRootPath$p(DiskFreeSpaceChecker $this) {
        return $this.rootPath;
    }
}

