/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.OlapDataFormats;
import kd.bos.olapServer2.storages.StaticMeasureValueCollection;
import kd.bos.olapServer2.storages.StaticMeasureValueCollectionProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0011\u001a\u00020\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\f\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0014\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u00020\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/storages/LoadOriginalValuesStrategy;", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "baseStrategy", "measures", "Lkd/bos/olapServer2/metadata/MeasureCollection;", "(Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;Lkd/bos/olapServer2/metadata/MeasureCollection;)V", "_effectiveMeasurePositions", "", "_originalValues", "Lkd/bos/olapServer2/storages/StaticMeasureValueCollection;", "_realPositions", "_staticMeasureValueCollectionProxy", "Lkd/bos/olapServer2/storages/StaticMeasureValueCollectionProxy;", "originalValues", "getOriginalValues", "()Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "addedValue", "index", "", "Lkd/bos/olapServer2/common/rowIdx;", "newValue", "allowAdd", "", "Lkd/bos/olapServer2/common/bool;", "getRealMeasurePosition", "", "Lkd/bos/olapServer2/common/int;", "measure", "Lkd/bos/olapServer2/metadata/Measure;", "modifiedValue", "originalValue", "bos-olap-core2"})
public final class LoadOriginalValuesStrategy
implements IAddOrUpdateStrategy<IMeasureValues> {
    @Nullable
    private final IAddOrUpdateStrategy<IMeasureValues> baseStrategy;
    @NotNull
    private final MeasureCollection measures;
    @NotNull
    private StaticMeasureValueCollection _originalValues;
    @NotNull
    private int[] _realPositions;
    @NotNull
    private int[] _effectiveMeasurePositions;
    @NotNull
    private StaticMeasureValueCollectionProxy _staticMeasureValueCollectionProxy;

    public LoadOriginalValuesStrategy(@Nullable IAddOrUpdateStrategy<IMeasureValues> baseStrategy, @NotNull MeasureCollection measures2) {
        Intrinsics.checkNotNullParameter((Object)measures2, (String)"measures");
        this.baseStrategy = baseStrategy;
        this.measures = measures2;
        this._originalValues = new StaticMeasureValueCollection(0);
        this._realPositions = CommonTypesKt.getEmptyIntArray();
        this._effectiveMeasurePositions = CommonTypesKt.getEmptyIntArray();
        this._staticMeasureValueCollectionProxy = new StaticMeasureValueCollectionProxy(this._originalValues, this._effectiveMeasurePositions, 0);
    }

    @NotNull
    public final IMeasureValues getOriginalValues() {
        return this._staticMeasureValueCollectionProxy;
    }

    @Override
    public boolean allowAdd() {
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this.baseStrategy;
        return iAddOrUpdateStrategy != null ? iAddOrUpdateStrategy.allowAdd() : true;
    }

    @Override
    @NotNull
    public IMeasureValues addedValue(long index2, @NotNull IMeasureValues newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this.baseStrategy;
        if (iAddOrUpdateStrategy == null || (iAddOrUpdateStrategy = iAddOrUpdateStrategy.addedValue(index2, newValue)) == null) {
            iAddOrUpdateStrategy = newValue;
        }
        return iAddOrUpdateStrategy;
    }

    @Override
    @NotNull
    public IMeasureValues modifiedValue(long index2, @NotNull IMeasureValues originalValue, @NotNull IMeasureValues newValue) {
        Intrinsics.checkNotNullParameter((Object)originalValue, (String)"originalValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        StaticMeasureValueCollection originalValues = this._originalValues;
        int[] realPositions = this._realPositions;
        if (originalValues.getCount() != newValue.getCount()) {
            originalValues = new StaticMeasureValueCollection(newValue.getCount());
            int[] effectiveMeasurePositions = new int[newValue.getCount()];
            realPositions = new int[newValue.getCount()];
            int n = newValue.getCount();
            for (int i = 0; i < n; ++i) {
                int realPosition;
                int position = newValue.getMeasureIndex(i);
                Measure measure = (Measure)this.measures.get(position);
                realPositions[i] = realPosition = this.getRealMeasurePosition(measure);
                effectiveMeasurePositions[i] = position;
            }
            this._realPositions = realPositions;
            this._originalValues = originalValues;
            this._effectiveMeasurePositions = effectiveMeasurePositions;
            this._staticMeasureValueCollectionProxy = new StaticMeasureValueCollectionProxy(originalValues, effectiveMeasurePositions, originalValue.getCount());
        }
        int n = newValue.getCount();
        for (int i = 0; i < n; ++i) {
            Object originValue = originalValue.getMeasureValue(realPositions[i]);
            originalValues.set(i, originValue);
        }
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this.baseStrategy;
        if (iAddOrUpdateStrategy == null || (iAddOrUpdateStrategy = iAddOrUpdateStrategy.modifiedValue(index2, originalValue, newValue)) == null) {
            iAddOrUpdateStrategy = newValue;
        }
        return iAddOrUpdateStrategy;
    }

    private final int getRealMeasurePosition(Measure measure) {
        int n;
        if (measure.getDataFormat() == OlapDataFormats.MeasureFormat_Dif) {
            Measure leftMeasure = measure.getLeftMeasure();
            if (!(leftMeasure != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            n = this.getRealMeasurePosition(leftMeasure);
        } else {
            n = measure.getPosition();
        }
        return n;
    }
}

