/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.MetadataVersionBuilder;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.extend.ExtendCubeBuilder;
import kd.bos.olapServer2.metadata.extend.IExtendCube;
import kd.bos.olapServer2.metadata.xObjectStorages.XObject;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectSession;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectStorage;
import kd.bos.olapServer2.storages.IMetadataDatabase;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b \u0018\u0000 62\u00020\u00012\u00020\u0002:\u000267B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u001c2\n\u0010\u001e\u001a\u00060\u0004j\u0002`\u0005H\u0016J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0012\u0010\"\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010\rH$J\b\u0010$\u001a\u00020%H\u0016J\f\u0010&\u001a\u00060\bj\u0002`'H$J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\r0)2\u0006\u0010+\u001a\u00020,H\u0004J\u0014\u0010-\u001a\u00020,2\n\u0010.\u001a\u00060\bj\u0002`'H\u0002J\b\u0010/\u001a\u00020\u001cH\u0002J \u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0014J\u0014\u00103\u001a\u00020,2\n\u0010.\u001a\u00060\bj\u0002`'H$J\u001e\u00104\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\r\u0018\u00010)2\u0006\u0010+\u001a\u00020,H\u0002J\b\u00105\u001a\u00020\u001cH$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lkd/bos/olapServer2/storages/MetadataDatabase;", "Ljava/io/Closeable;", "Lkd/bos/olapServer2/storages/IMetadataDatabase;", "path", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_isClosed", "", "_isInitialized", "_lastCube", "Lkd/bos/olapServer2/metadata/Cube;", "_lastCubeBuilder", "Lkd/bos/olapServer2/metadata/builds/CubeBuilder;", "_lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "extendCube", "Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "getExtendCube", "()Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "extendCubeBuilder", "Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "getExtendCubeBuilder", "()Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "getPath", "()Ljava/lang/String;", "build", "close", "", "copyTo", "targetPath", "createDatabase", "currentVersion", "Lkd/bos/olapServer2/common/Version;", "createDatabaseCore", "existCubeBuilder", "createWriterContext", "Lkd/bos/olapServer2/metadata/builds/IMetadataWriterContext;", "existDatabase", "Lkd/bos/olapServer2/common/bool;", "getCubeBuilderFromDB", "Lkotlin/Pair;", "Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectSession;", "storage", "Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectStorage;", "getStorage", "isReadonly", "init", "onSaved", "ctx", "builder", "open", "tryGetCubeBuilderFromLastBuild", "upgradeDatabase", "Companion", "MetadataWriterContext", "bos-olap-core2"})
public abstract class MetadataDatabase
implements Closeable,
IMetadataDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private volatile boolean _isInitialized;
    @NotNull
    private final ReentrantReadWriteLock _lock;
    @Nullable
    private CubeBuilder _lastCubeBuilder;
    @Nullable
    private Cube _lastCube;
    private volatile boolean _isClosed;
    @NotNull
    private static final Version MetadataV2StartVersion = new Version(8, 0);

    public MetadataDatabase(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this._lock = new ReentrantReadWriteLock();
    }

    @NotNull
    protected final String getPath() {
        return this.path;
    }

    @NotNull
    protected abstract XObjectStorage open(boolean var1);

    protected abstract void createDatabaseCore(@Nullable CubeBuilder var1);

    protected abstract boolean existDatabase();

    protected abstract void upgradeDatabase();

    private final XObjectStorage getStorage(boolean isReadonly) {
        if (!(!this._isClosed)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!this._isInitialized) {
            this.init();
        }
        return this.open(isReadonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init() {
        MetadataDatabase metadataDatabase = this;
        synchronized (metadataDatabase) {
            boolean bl = false;
            if (!this._isInitialized) {
                Version metadataVersion = Companion.getMetadataVersionFromCubeJson(this.path);
                if (metadataVersion == null || metadataVersion.compareTo(Cube.Companion.getMetadataRequireServerMinVersion()) < 0) {
                    this.createDatabase(metadataVersion);
                }
                this._isInitialized = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    protected void createDatabase(@Nullable Version currentVersion) {
        File jsonFile = Paths.INSTANCE.toFile(this.path, "cube.json");
        if (!jsonFile.exists()) {
            FileTools.INSTANCE.autoMakeDir(this.path);
            new MetadataVersionBuilder().save(jsonFile);
            return;
        }
        if (currentVersion == null || currentVersion.compareTo(MetadataV2StartVersion) < 0) {
            this.upgradeDatabase();
            return;
        }
    }

    @Override
    @NotNull
    public IMetadataWriterContext createWriterContext() {
        IMetadataWriterContext iMetadataWriterContext;
        ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
        writeLock.lock();
        XObjectStorage storage = null;
        try {
            storage = this.getStorage(false);
            Pair<XObjectSession, CubeBuilder> pair = this.tryGetCubeBuilderFromLastBuild(storage);
            if (pair == null) {
                pair = this.getCubeBuilderFromDB(storage);
            }
            Pair<XObjectSession, CubeBuilder> pair2 = pair;
            XObjectSession session = (XObjectSession)pair2.component1();
            CubeBuilder cubeBuilder = (CubeBuilder)pair2.component2();
            ExtendCubeBuilder extendCubeBuilder = this.getExtendCubeBuilder();
            Intrinsics.checkNotNull((Object)writeLock);
            iMetadataWriterContext = new MetadataWriterContext(cubeBuilder, extendCubeBuilder, session, storage, writeLock, this);
        }
        catch (Exception ex) {
            XObjectStorage xObjectStorage = storage;
            if (xObjectStorage != null) {
                xObjectStorage.close();
            }
            writeLock.unlock();
            throw ex;
        }
        return iMetadataWriterContext;
    }

    @Override
    @NotNull
    public abstract IExtendCube getExtendCube();

    @NotNull
    protected abstract ExtendCubeBuilder getExtendCubeBuilder();

    protected void onSaved(@NotNull IMetadataWriterContext ctx, @NotNull CubeBuilder builder, @NotNull XObjectStorage storage) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this._lastCubeBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Cube build() {
        Cube cube;
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        try {
            Cube lastCube;
            Cube cube2;
            boolean bl = false;
            CubeBuilder cubeBuilder = this._lastCubeBuilder;
            if (cubeBuilder == null) {
                Closeable closeable = this.getStorage(true);
                Throwable throwable = null;
                try {
                    XObjectStorage storage = (XObjectStorage)closeable;
                    boolean bl2 = false;
                    Cube lastCube2 = this._lastCube;
                    if (lastCube2 != null && lastCube2.getChangeVersion() == storage.getChangeVersion()) {
                        Cube cube3 = lastCube2;
                        Cube cube4 = cube3;
                        return cube4;
                    }
                    Cube cube5 = ((CubeBuilder)this.getCubeBuilderFromDB(storage).getSecond()).build(this.getExtendCube());
                    cube2 = cube5;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                this._lastCubeBuilder = null;
                cube2 = cubeBuilder.build(this.getExtendCube());
            }
            this._lastCube = lastCube = cube2;
            cube = lastCube;
        }
        finally {
            readLock.unlock();
        }
        return cube;
    }

    @NotNull
    protected final Pair<XObjectSession, CubeBuilder> getCubeBuilderFromDB(@NotNull XObjectStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        XObjectSession session = XObjectSession.Companion.loadAll(storage);
        XObject xCube = session.getOrCreateObject("__root__");
        return new Pair((Object)session, (Object)new CubeBuilder(xCube, storage.getChangeVersion()));
    }

    private final Pair<XObjectSession, CubeBuilder> tryGetCubeBuilderFromLastBuild(XObjectStorage storage) {
        Pair pair;
        Cube lastCube = this._lastCube;
        if (lastCube != null && lastCube.getChangeVersion() == storage.getChangeVersion()) {
            CubeBuilder newBuilder = new CubeBuilder(lastCube);
            pair = new Pair((Object)XObjectSession.Companion.load(storage, newBuilder.getX(), "__root__"), (Object)newBuilder);
        } else {
            pair = null;
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
        writeLock.lock();
        try {
            for (String file : this.getFileNames()) {
                File source2 = Paths.INSTANCE.toFile(this.path, file);
                File target = Paths.INSTANCE.toFile(targetPath, file);
                FilesKt.copyTo$default((File)source2, (File)target, (boolean)false, (int)0, (int)6, null);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this._isClosed) {
            ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
            writeLock.lock();
            try {
                this.unload();
                this._isClosed = true;
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    @Override
    public void unload() {
        IMetadataDatabase.DefaultImpls.unload(this);
    }

    @Override
    public void optimize() {
        IMetadataDatabase.DefaultImpls.optimize(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\u0010\b\u001a\u00060\tj\u0002`\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/storages/MetadataDatabase$Companion;", "", "()V", "MetadataV2StartVersion", "Lkd/bos/olapServer2/common/Version;", "getMetadataV2StartVersion", "()Lkd/bos/olapServer2/common/Version;", "getMetadataVersionFromCubeJson", "path", "", "Lkd/bos/olapServer2/common/string;", "TempCubeJson", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getMetadataV2StartVersion() {
            return MetadataV2StartVersion;
        }

        @Nullable
        public final Version getMetadataVersionFromCubeJson(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File jsonFile = Paths.INSTANCE.toFile(path, "cube.json");
            Version version = null;
            if (jsonFile.exists()) {
                Version version2 = Version.Companion.getCurrentVersion();
                if (version2 == null) {
                    version2 = new Version(5, 3);
                }
                Version currentServerVersion = version2;
                try {
                    String txt;
                    long fileSize = jsonFile.length();
                    boolean bl = 25L <= fileSize ? fileSize < 35L : false;
                    if (bl && StringsKt.contains$default((CharSequence)(txt = FilesKt.readText((File)jsonFile, (Charset)Charsets.UTF_8)), (CharSequence)"metadataVersion", (boolean)false, (int)2, null)) {
                        TempCubeJson obj = (TempCubeJson)JsonHelper.INSTANCE.getMapper().readValue(txt, TempCubeJson.class);
                        version = Version.Companion.createVersion(obj.getMetadataVersion());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (version != null && version.compareTo(currentServerVersion) > 0) {
                    String string2 = Res.INSTANCE.getMetadataXFileDatabaseException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MetadataXFileDatabaseException_1>(...)");
                    Object[] objectArray = new Object[]{currentServerVersion, version};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
            }
            return version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/storages/MetadataDatabase$Companion$TempCubeJson;", "", "()V", "metadataVersion", "", "Lkd/bos/olapServer2/common/string;", "getMetadataVersion", "()Ljava/lang/String;", "setMetadataVersion", "(Ljava/lang/String;)V", "bos-olap-core2"})
        private static final class TempCubeJson {
            @NotNull
            private String metadataVersion = "";

            @NotNull
            public final String getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(@NotNull String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
                this.metadataVersion = string2;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0011j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer2/storages/MetadataDatabase$MetadataWriterContext;", "Ljava/io/Closeable;", "Lkd/bos/olapServer2/metadata/builds/IMetadataWriterContext;", "cubeBuilder", "Lkd/bos/olapServer2/metadata/builds/CubeBuilder;", "extendCubeBuilder", "Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "session", "Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectSession;", "storage", "Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectStorage;", "writeLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "db", "Lkd/bos/olapServer2/storages/MetadataDatabase;", "(Lkd/bos/olapServer2/metadata/builds/CubeBuilder;Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectSession;Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectStorage;Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;Lkd/bos/olapServer2/storages/MetadataDatabase;)V", "_isClosed", "", "getCubeBuilder", "()Lkd/bos/olapServer2/metadata/builds/CubeBuilder;", "getExtendCubeBuilder", "()Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "isClosed", "Lkd/bos/olapServer2/common/bool;", "()Z", "close", "", "save", "bos-olap-core2"})
    private static final class MetadataWriterContext
    implements Closeable,
    IMetadataWriterContext {
        @NotNull
        private final CubeBuilder cubeBuilder;
        @NotNull
        private final ExtendCubeBuilder extendCubeBuilder;
        @NotNull
        private final XObjectSession session;
        @NotNull
        private final XObjectStorage storage;
        @NotNull
        private final ReentrantReadWriteLock.WriteLock writeLock;
        @NotNull
        private final MetadataDatabase db;
        private boolean _isClosed;

        public MetadataWriterContext(@NotNull CubeBuilder cubeBuilder, @NotNull ExtendCubeBuilder extendCubeBuilder, @NotNull XObjectSession session, @NotNull XObjectStorage storage, @NotNull ReentrantReadWriteLock.WriteLock writeLock, @NotNull MetadataDatabase db) {
            Intrinsics.checkNotNullParameter((Object)cubeBuilder, (String)"cubeBuilder");
            Intrinsics.checkNotNullParameter((Object)extendCubeBuilder, (String)"extendCubeBuilder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)writeLock, (String)"writeLock");
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.cubeBuilder = cubeBuilder;
            this.extendCubeBuilder = extendCubeBuilder;
            this.session = session;
            this.storage = storage;
            this.writeLock = writeLock;
            this.db = db;
        }

        @Override
        @NotNull
        public CubeBuilder getCubeBuilder() {
            return this.cubeBuilder;
        }

        @Override
        @NotNull
        public ExtendCubeBuilder getExtendCubeBuilder() {
            return this.extendCubeBuilder;
        }

        @Override
        public boolean isClosed() {
            return this._isClosed;
        }

        @Override
        public void close() {
            if (!this._isClosed) {
                this.storage.close();
                this.writeLock.unlock();
                this._isClosed = true;
            }
        }

        @Override
        public void save() {
            XObjectSession.save$default(this.session, false, 1, null);
            this.getCubeBuilder().setChangeVersion(this.storage.getChangeVersion());
            this.db.onSaved(this, this.getCubeBuilder(), this.storage);
        }
    }
}

