/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import kd.bos.olapServer.dataAdapter.ICubeReadAdapter;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.MetadataVersionBuilder;
import kd.bos.olapServer2.metadata.ReBuilderFolder;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.extend.ExtendCubeBuilder;
import kd.bos.olapServer2.metadata.extend.ExtendCube;
import kd.bos.olapServer2.metadata.extend.IExtendCube;
import kd.bos.olapServer2.metadata.xObjectStorages.MetadataJsonTools;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectSession;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectStorage;
import kd.bos.olapServer2.metadata.xObjectStorages.xFiles.XFileStorage;
import kd.bos.olapServer2.storages.CubeExtendMetadataStorage;
import kd.bos.olapServer2.storages.MetadataDatabase;
import kd.bos.olapServer2.storages.writers.CubeSwitcher;
import kd.bos.olapServer2.storages.writers.CubeWriteAdapter;
import kd.bos.olapServer2.tools.CubeFactoryCreator;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\f\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0014J\u0017\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0014J\u0014\u0010$\u001a\u00020#2\n\u0010%\u001a\u00060\u0019j\u0002`\u001aH\u0014J\b\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u0015H\u0016J\b\u0010(\u001a\u00020\u0015H\u0014J\"\u0010)\u001a\u00020\u00152\n\u0010*\u001a\u00060\u0003j\u0002`\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lkd/bos/olapServer2/storages/MetadataXFileDatabase;", "Lkd/bos/olapServer2/storages/MetadataDatabase;", "path", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_extendMetadataStorage", "Lkd/bos/olapServer2/storages/CubeExtendMetadataStorage;", "extendCube", "Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "getExtendCube", "()Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "extendCubeBuilder", "Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "getExtendCubeBuilder", "()Lkd/bos/olapServer2/metadata/builds/extend/ExtendCubeBuilder;", "extendMetadataLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "getExtendMetadataLock", "()Ljava/util/concurrent/locks/ReadWriteLock;", "createDatabaseCore", "", "existCubeBuilder", "Lkd/bos/olapServer2/metadata/builds/CubeBuilder;", "existDatabase", "", "Lkd/bos/olapServer2/common/bool;", "getFileNames", "", "()[Ljava/lang/String;", "onSaved", "ctx", "Lkd/bos/olapServer2/metadata/builds/IMetadataWriterContext;", "builder", "storage", "Lkd/bos/olapServer2/metadata/xObjectStorages/XObjectStorage;", "open", "isReadonly", "optimize", "unload", "upgradeDatabase", "upgradeStorageStructure", "targetPath", "metadataUpdateBlock", "Lkotlin/Function0;", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMetadataXFileDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataXFileDatabase.kt\nkd/bos/olapServer2/storages/MetadataXFileDatabase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,167:1\n13309#2,2:168\n13309#2,2:170\n37#3,2:172\n*S KotlinDebug\n*F\n+ 1 MetadataXFileDatabase.kt\nkd/bos/olapServer2/storages/MetadataXFileDatabase\n*L\n129#1:168,2\n142#1:170,2\n154#1:172,2\n*E\n"})
public final class MetadataXFileDatabase
extends MetadataDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CubeExtendMetadataStorage _extendMetadataStorage;

    public MetadataXFileDatabase(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path);
        this._extendMetadataStorage = new CubeExtendMetadataStorage(path);
    }

    @Override
    @NotNull
    protected ExtendCubeBuilder getExtendCubeBuilder() {
        return new ExtendCubeBuilder(this._extendMetadataStorage);
    }

    @Override
    @NotNull
    public IExtendCube getExtendCube() {
        return new ExtendCube(this._extendMetadataStorage);
    }

    @Override
    @NotNull
    protected XObjectStorage open(boolean isReadonly) {
        Version currentVersion;
        XFileStorage xFileStorage;
        XFileStorage storage = xFileStorage = new XFileStorage(this.getPath(), isReadonly);
        boolean bl = false;
        Version minVersion = storage.getMetadataVersion();
        Version version = Version.Companion.getCurrentVersion();
        if (version == null) {
            version = currentVersion = new Version(7, 1);
        }
        if (!minVersion.isEmpty() && minVersion.compareTo(currentVersion) > 0) {
            storage.close();
            String string2 = Res.INSTANCE.getMetadataXFileDatabaseException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MetadataXFileDatabaseException_1>(...)");
            Object[] objectArray = new Object[]{currentVersion, minVersion};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return xFileStorage;
    }

    @Override
    protected boolean existDatabase() {
        return Paths.INSTANCE.toFile(this.getPath(), "cube.metaE2").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void upgradeDatabase() {
        File cubeFile = PathsKt.fileSafeConstructor(this.getPath());
        String string2 = cubeFile.getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        String string3 = cubeFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        Closeable closeable = new ReBuilderFolder(string2, string3);
        Throwable throwable = null;
        try {
            ReBuilderFolder reBuilderFolder = (ReBuilderFolder)closeable;
            boolean bl = false;
            String tempPath = reBuilderFolder.createTempPath();
            File jsonFile = Paths.INSTANCE.toFile(tempPath, "cube.json");
            new MetadataVersionBuilder().save(jsonFile);
            this.upgradeStorageStructure(tempPath, (Function0<Unit>)((Function0)new Function0<Unit>(tempPath, this){
                final /* synthetic */ String $tempPath;
                final /* synthetic */ MetadataXFileDatabase this$0;
                {
                    this.$tempPath = $tempPath;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Closeable closeable = new XFileStorage(this.$tempPath, false);
                    MetadataXFileDatabase metadataXFileDatabase = this.this$0;
                    Throwable throwable = null;
                    try {
                        XFileStorage storage = (XFileStorage)closeable;
                        boolean bl = false;
                        Pair<XObjectSession, CubeBuilder> pair = metadataXFileDatabase.getCubeBuilderFromDB(storage);
                        XObjectSession session = (XObjectSession)pair.component1();
                        CubeBuilder cubeBuilder = (CubeBuilder)pair.component2();
                        cubeBuilder.repair();
                        XObjectSession.save$default(session, false, 1, null);
                        kd.bos.olapServer2.storages.MetadataXFileDatabase$Companion.access$updateCurrentMetadataVersion(MetadataXFileDatabase.Companion, storage);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }));
            ReBuilderFolder.moveFiles$default(reBuilderFolder, null, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void optimize() {
        MetadataJsonTools.INSTANCE.optimize(this, this.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upgradeStorageStructure(String targetPath, Function0<Unit> metadataUpdateBlock) {
        Closeable closeable = (Closeable)CubeFactoryCreator.INSTANCE.create().openCubeReadAdapter(this.getPath());
        Throwable throwable = null;
        try {
            ICubeReadAdapter cubeReadAdapter = (ICubeReadAdapter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)((Object)new CubeWriteAdapter(targetPath));
            Throwable throwable2 = null;
            try {
                CubeWriteAdapter cubeWriteAdapter = (CubeWriteAdapter)((Object)closeable2);
                boolean bl2 = false;
                Closeable closeable3 = new CubeSwitcher();
                Throwable throwable3 = null;
                try {
                    CubeSwitcher switcher = (CubeSwitcher)closeable3;
                    boolean bl3 = false;
                    switcher.switchMetadata(cubeReadAdapter, cubeWriteAdapter, metadataUpdateBlock);
                    switcher.switchData(cubeReadAdapter, cubeWriteAdapter);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createDatabaseCore(@Nullable CubeBuilder existCubeBuilder) {
        block8: {
            try {
                if (existCubeBuilder == null) break block8;
                Closeable closeable = new XFileStorage(this.getPath(), false);
                Throwable throwable = null;
                try {
                    XFileStorage storage = (XFileStorage)closeable;
                    boolean bl = false;
                    XObjectSession.save$default(XObjectSession.Companion.create(storage, existCubeBuilder.getX(), "__root__"), false, 1, null);
                    MetadataXFileDatabase.Companion.updateCurrentMetadataVersion(storage);
                    storage = Unit.INSTANCE;
                }
                catch (Throwable storage) {
                    throwable = storage;
                    throw storage;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception ex) {
                String[] $this$forEach$iv = this.getFileNames();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Paths.INSTANCE.toFile(this.getPath(), it).delete();
                }
                throw ex;
            }
        }
    }

    @Override
    protected void onSaved(@NotNull IMetadataWriterContext ctx, @NotNull CubeBuilder builder, @NotNull XObjectStorage storage) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        MetadataXFileDatabase.Companion.updateCurrentMetadataVersion((XFileStorage)storage);
        super.onSaved(ctx, builder, storage);
    }

    @Override
    @NotNull
    public String[] getFileNames() {
        List res = new ArrayList();
        File[] fileArray = Paths.INSTANCE.toFile(this.getPath()).listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String fileName = it.getName();
                Intrinsics.checkNotNull((Object)fileName);
                if (!(StringsKt.endsWith$default((String)fileName, (String)"metaB2", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"metaE2", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"metaH2", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fileName, (String)"extendMeta", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)fileName, (String)"boot", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fileName, (String)"extendMeta", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)fileName, (String)"dat", (boolean)false, (int)2, null)) && (!StringsKt.startsWith$default((String)fileName, (String)"extendMeta", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)fileName, (String)"heap", (boolean)false, (int)2, null))) continue;
                res.add(fileName);
            }
        }
        Collection $this$toTypedArray$iv = res;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public ReadWriteLock getExtendMetadataLock() {
        return this._extendMetadataStorage.getExtendMetadataLock();
    }

    @Override
    public void unload() {
        this._extendMetadataStorage.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/storages/MetadataXFileDatabase$Companion;", "", "()V", "updateCurrentMetadataVersion", "", "storage", "Lkd/bos/olapServer2/metadata/xObjectStorages/xFiles/XFileStorage;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateCurrentMetadataVersion(XFileStorage storage) {
            Version fVersion = storage.getMetadataVersion();
            Version cVersion = Cube.Companion.getMetadataRequireServerMinVersion();
            if (cVersion.compareTo(fVersion) > 0) {
                storage.setMetadataVersion(cVersion);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

