/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.metadata.CubeEntryCollection;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0013\u001a\u00020\u00072\n\u0010\u0014\u001a\u00060\u0005j\u0002`\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u00162\n\u0010\u0014\u001a\u00060\u0005j\u0002`\u0006H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/storages/OlapLockManager;", "", "()V", "_locks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer2/common/string;", "Lkd/bos/olapServer2/storages/OlapLockManager$CubeLock;", "_stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "stateLock", "getStateLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "enterRead", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterWrite", "lock", "cubeName", "markIsFormal", "", "cubes", "Lkd/bos/olapServer2/metadata/CubeEntryCollection;", "release", "CubeLock", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapLockManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapLockManager.kt\nkd/bos/olapServer2/storages/OlapLockManager\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n72#2,2:98\n1#3:100\n1855#4,2:101\n*S KotlinDebug\n*F\n+ 1 OlapLockManager.kt\nkd/bos/olapServer2/storages/OlapLockManager\n*L\n38#1:98,2\n38#1:100\n51#1:101,2\n*E\n"})
public final class OlapLockManager {
    @NotNull
    private final ConcurrentHashMap<String, CubeLock> _locks = new ConcurrentHashMap();
    @NotNull
    private final ReentrantReadWriteLock _stateLock = new ReentrantReadWriteLock();

    @NotNull
    public final ReentrantReadWriteLock getStateLock() {
        return this._stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T enterWrite(@NotNull Function0<? extends T> action) {
        Object object2;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock reentrantReadWriteLock = this._stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            object2 = action.invoke();
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return (T)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T enterRead(@NotNull Function0<? extends T> action) {
        Object object2;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock.ReadLock readLock = this._stateLock.readLock();
        readLock.lock();
        try {
            object2 = action.invoke();
        }
        finally {
            readLock.unlock();
        }
        return (T)object2;
    }

    public final void markIsFormal(@NotNull CubeEntryCollection cubes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cubes, (String)"cubes");
        Iterator<String> iterator2 = cubes.getNames();
        while (iterator2.hasNext()) {
            String string2;
            Object cubeName;
            Object object2 = cubeName = iterator2.next();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)((String)object2).toUpperCase(locale), (String)"this as java.lang.String).toUpperCase(locale)");
            ConcurrentMap $this$getOrPut$iv = this._locks;
            boolean $i$f$getOrPut = false;
            Object object3 = $this$getOrPut$iv.get(string2);
            if (object3 == null) {
                bl = false;
                CubeLock default$iv = new CubeLock(string2, this);
                boolean bl2 = false;
                object3 = $this$getOrPut$iv.putIfAbsent(string2, default$iv);
                if (object3 == null) {
                    object3 = default$iv;
                }
            }
            CubeLock item = (CubeLock)object3;
            item.markIsFormal();
        }
        List removedKeys = new ArrayList();
        for (Map.Entry entry : ((Map)this._locks).entrySet()) {
            String k = (String)entry.getKey();
            CubeLock v = (CubeLock)entry.getValue();
            if (cubes.contains(k) || !v.getIsFormal()) continue;
            removedKeys.add(k);
        }
        Iterable $this$forEach$iv = removedKeys;
        boolean bl2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            bl = false;
            this._locks.remove(it);
        }
    }

    @NotNull
    public final CubeLock lock(@NotNull String cubeName) {
        CubeLock preItem;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        String name2 = string3;
        CubeLock item = new CubeLock(name2, this);
        CubeLock cubeLock = this._locks.get(name2);
        if (cubeLock == null) {
            cubeLock = this._locks.putIfAbsent(name2, item);
        }
        if ((preItem = cubeLock) != null) {
            if (preItem.getIsFormal()) {
                String string4 = Res.INSTANCE.getOlapLockManagerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-OlapLockManagerException_1>(...)");
                Object[] objectArray = new Object[]{name2};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_1());
        }
        return item;
    }

    private final void release(String cubeName) {
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        this._locks.remove(string3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/storages/OlapLockManager$CubeLock;", "Ljava/io/Closeable;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "owner", "Lkd/bos/olapServer2/storages/OlapLockManager;", "(Ljava/lang/String;Lkd/bos/olapServer2/storages/OlapLockManager;)V", "IsFormal", "", "getIsFormal", "()Z", "_isFormal", "close", "", "markIsFormal", "bos-olap-core2"})
    public static final class CubeLock
    implements Closeable {
        @NotNull
        private final String cubeName;
        @NotNull
        private final OlapLockManager owner;
        private boolean _isFormal;

        public CubeLock(@NotNull String cubeName, @NotNull OlapLockManager owner) {
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.cubeName = cubeName;
            this.owner = owner;
        }

        public final boolean getIsFormal() {
            return this._isFormal;
        }

        public final void markIsFormal() {
            this._isFormal = true;
        }

        @Override
        public void close() {
            if (!this._isFormal) {
                this.owner.release(this.cubeName);
            }
        }
    }
}

