/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.nio.file.ClosedFileSystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.UnhandledExceptionEventArgs;
import kd.bos.olapServer2.computingEngine.thread.DefaultThreadFactory;
import kd.bos.olapServer2.function.FunctionManager;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.metadata.CubeEntryCollection;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportContainer;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.security.AccessStrategyCollection;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspaceCreator;
import kd.bos.olapServer2.storages.DiskFreeSpaceChecker;
import kd.bos.olapServer2.storages.OlapLockManager;
import kd.bos.olapServer2.storages.OlapMetadataLock;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.plugins.CubeWorkspaceEventArgs;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.PluginCollection;
import kd.bos.olapServer2.storages.sandboxs.SandboxWorkspaceCollection;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u0081\u00012\u00020\u0001:\u0002\u0081\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010K\u001a\u00060\u0012j\u0002`\u0013J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0003H\u0002J\n\u0010O\u001a\u00060\u0015j\u0002`\u0016J\b\u0010P\u001a\u00020MH\u0002J\b\u0010Q\u001a\u00020MH\u0016J\u0012\u0010R\u001a\u00020S2\n\u0010T\u001a\u00060\u0005j\u0002`\u0006J\u001e\u0010U\u001a\u00020V2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\n\u0010W\u001a\u00060\u0005j\u0002`\u0006J\"\u0010X\u001a\u00060Sj\u0002`Y2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\n\u0010W\u001a\u00060\u0005j\u0002`\u0006J1\u0010Z\u001a\u0002H[\"\u0004\b\u0000\u0010[2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u0002H[0]\u00a2\u0006\u0002\u0010^J7\u0010_\u001a\u0002H[\"\u0004\b\u0000\u0010[2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H[0`\u00a2\u0006\u0002\u0010aJ=\u0010b\u001a\u0002H[\"\u0004\b\u0000\u0010[2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\n\u0010W\u001a\u00060\u0005j\u0002`\u00062\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u0002H[0]\u00a2\u0006\u0002\u0010cJ1\u0010d\u001a\u0002H[\"\u0004\b\u0000\u0010[2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u0002H[0]\u00a2\u0006\u0002\u0010^J1\u0010e\u001a\u0002H[\"\u0004\b\u0000\u0010[2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u0002H[0]\u00a2\u0006\u0002\u0010^J\b\u0010f\u001a\u00020MH\u0002J\u0012\u0010g\u001a\u00020V2\n\u0010T\u001a\u00060\u0005j\u0002`\u0006J\u0012\u0010h\u001a\u00020V2\n\u0010i\u001a\u00060\u0012j\u0002`\u0013J\u0012\u0010j\u001a\u00020\u001f2\n\u0010T\u001a\u00060\u0005j\u0002`\u0006J\u0013\u0010k\u001a\b\u0012\u0004\u0012\u00020V0lH\u0000\u00a2\u0006\u0002\bmJ\u001e\u0010n\u001a\u00020V2\n\u0010T\u001a\u00060\u0005j\u0002`\u00062\n\u0010W\u001a\u00060\u0005j\u0002`\u0006J\u0012\u0010o\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010T\u001a\u00020\u0005J\n\u0010p\u001a\u00060Sj\u0002`YJ \u0010q\u001a\u00020M2\n\u0010i\u001a\u00060\u0012j\u0002`\u00132\n\u0010T\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010r\u001a\u00020\u0003H\u0002J\u0006\u0010s\u001a\u00020MJ\u0018\u0010t\u001a\u00060Sj\u0002`Y2\f\b\u0002\u0010u\u001a\u00060\u0015j\u0002`\u0016J\u0010\u0010v\u001a\u0004\u0018\u00010V2\u0006\u0010T\u001a\u00020\u0005J\u0014\u0010w\u001a\u0004\u0018\u00010V2\n\u0010i\u001a\u00060\u0012j\u0002`\u0013J\u0014\u0010x\u001a\u0004\u0018\u00010\u001f2\n\u0010T\u001a\u00060\u0005j\u0002`\u0006J\u0017\u0010y\u001a\u0004\u0018\u00010V2\u0006\u0010T\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bzJ\r\u0010{\u001a\u00020MH\u0000\u00a2\u0006\u0002\b|J\u001f\u0010}\u001a\u00020M2\u0006\u0010~\u001a\u00020\u007f2\u000f\u0010\u0080\u0001\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0012j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001d\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+0%\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0016\u00103\u001a\n 5*\u0004\u0018\u00010404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u001d\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020&0B\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006\u0082\u0001"}, d2={"Lkd/bos/olapServer2/storages/OlapWorkspace;", "Ljava/io/Closeable;", "olapMetadata", "Lkd/bos/olapServer2/metadata/OlapMetadata;", "RootPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/metadata/OlapMetadata;Ljava/lang/String;)V", "LockManager", "Lkd/bos/olapServer2/storages/OlapLockManager;", "getLockManager", "()Lkd/bos/olapServer2/storages/OlapLockManager;", "Metadata", "getMetadata", "()Lkd/bos/olapServer2/metadata/OlapMetadata;", "getRootPath", "()Ljava/lang/String;", "_initCubeId", "", "Lkd/bos/olapServer2/common/int;", "_lastGcNanoTime", "", "Lkd/bos/olapServer2/common/long;", "_state", "_stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_tempPool", "Lkotlin/Lazy;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "_workspaces", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer2/storages/CubeWorkspaceCreator;", "accessStrategies", "Lkd/bos/olapServer2/security/AccessStrategyCollection;", "getAccessStrategies", "()Lkd/bos/olapServer2/security/AccessStrategyCollection;", "collecting", "Lkd/bos/olapServer2/common/EventHandlerList;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "Lkd/bos/olapServer2/common/EventArgs;", "getCollecting", "()Lkd/bos/olapServer2/common/EventHandlerList;", "cubeWorkspaceLoading", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspaceEventArgs;", "getCubeWorkspaceLoading", "freeSpaceChecker", "Lkd/bos/olapServer2/storages/DiskFreeSpaceChecker;", "functions", "Lkd/bos/olapServer2/function/FunctionManager;", "getFunctions", "()Lkd/bos/olapServer2/function/FunctionManager;", "gcPool", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "healthReports", "Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "getHealthReports", "()Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "olapMetadataLock", "Lkd/bos/olapServer2/storages/OlapMetadataLock;", "getOlapMetadataLock", "()Lkd/bos/olapServer2/storages/OlapMetadataLock;", "pluginContext", "getPluginContext$bos_olap_core2", "()Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "plugins", "Lkd/bos/olapServer2/storages/plugins/PluginCollection;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePlugin;", "getPlugins", "()Lkd/bos/olapServer2/storages/plugins/PluginCollection;", "sandboxWorkspaces", "Lkd/bos/olapServer2/storages/sandboxs/SandboxWorkspaceCollection;", "tempPool", "getTempPool", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "assignNextId", "buildOlapWorkspaces", "", "newMetadata", "checkExecuteByFreeSpace", "checkState", "close", "contains", "", "cubeName", "createSandboxWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "identity", "dropSandboxWorkspace", "Lkd/bos/olapServer2/common/bool;", "enterRead", "R", "body", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "enterReadForBackup", "Lkotlin/Function2;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "enterSandbox", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "enterWrite", "execute", "gc", "getCubeWorkspace", "getCubeWorkspaceByCubeId", "cubeId", "getCubeWorkspaceCreator", "getLoadedWorkspaces", "", "getLoadedWorkspaces$bos_olap_core2", "getSandboxWorkspace", "getTransactionVersion", "isFree", "putWorkspace", "reBuildMetadata", "reloadOlapMetadata", "startGC", "gcTimePeriod", "tryGet", "tryGetByCubeId", "tryGetCubeWorkspaceCreator", "tryGetWithoutLazyLoad", "tryGetWithoutLazyLoad$bos_olap_core2", "unloadWorkspaces", "unloadWorkspaces$bos_olap_core2", "updateMetadata", "action", "Lkd/bos/olapServer2/common/CommandTypes;", "updateCubeName", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapWorkspace.kt\nkd/bos/olapServer2/storages/OlapWorkspace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,613:1\n1855#2,2:614\n37#3,2:616\n11383#4,9:618\n13309#4:627\n13310#4:629\n11392#4:630\n1#5:628\n1#5:631\n*S KotlinDebug\n*F\n+ 1 OlapWorkspace.kt\nkd/bos/olapServer2/storages/OlapWorkspace\n*L\n130#1:614,2\n219#1:616,2\n220#1:618,9\n220#1:627\n220#1:629\n220#1:630\n220#1:628\n*E\n"})
public final class OlapWorkspace
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile OlapMetadata olapMetadata;
    @NotNull
    private final String RootPath;
    private int _initCubeId;
    @NotNull
    private final ConcurrentHashMap<String, CubeWorkspaceCreator> _workspaces;
    @NotNull
    private final AccessStrategyCollection accessStrategies;
    @NotNull
    private final HealthReportContainer healthReports;
    @NotNull
    private final OlapLockManager LockManager;
    @NotNull
    private final OlapMetadataLock olapMetadataLock;
    private volatile int _state;
    @NotNull
    private final OlapWorkspacePluginContext pluginContext;
    @NotNull
    private final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> plugins;
    @NotNull
    private final FunctionManager functions;
    @NotNull
    private final SandboxWorkspaceCollection sandboxWorkspaces;
    @NotNull
    private final EventHandlerList<OlapWorkspacePluginContext, CubeWorkspaceEventArgs> cubeWorkspaceLoading;
    @NotNull
    private final Lazy<ByteBufferResourcePool> _tempPool;
    private final ScheduledExecutorService gcPool;
    private long _lastGcNanoTime;
    @NotNull
    private final EventHandlerList<OlapWorkspacePluginContext, EventArgs> collecting;
    @NotNull
    private final ReentrantReadWriteLock _stateLock;
    @NotNull
    private final DiskFreeSpaceChecker freeSpaceChecker;
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem gcTimePeriodConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("GC_TimePeriod", 0L, ByteBufferResourcePool.Companion.getResourceTimeoutConfigItem$bos_olap_core2().getMinValue(), ByteBufferResourcePool.Companion.getResourceTimeoutConfigItem$bos_olap_core2().getMaxValue(), null, false, false, OlapWorkspace::gcTimePeriodConfigItem$lambda$4, 114, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem cubeWorkspaceUnloadTimeoutConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("GC_CubeWorkspaceUnloadTimeout", 0L, 1L, Long.MAX_VALUE, null, false, false, OlapWorkspace::cubeWorkspaceUnloadTimeoutConfigItem$lambda$5, 114, null);

    public OlapWorkspace(@NotNull OlapMetadata olapMetadata, @NotNull String RootPath) {
        Intrinsics.checkNotNullParameter((Object)olapMetadata, (String)"olapMetadata");
        Intrinsics.checkNotNullParameter((Object)RootPath, (String)"RootPath");
        this.olapMetadata = olapMetadata;
        this.RootPath = RootPath;
        this._initCubeId = this.olapMetadata.getMaxId();
        this._workspaces = new ConcurrentHashMap(this.olapMetadata.getCubes().getCount());
        this.accessStrategies = new AccessStrategyCollection();
        this.healthReports = new HealthReportContainer(this.accessStrategies);
        this.LockManager = new OlapLockManager();
        this.olapMetadataLock = new OlapMetadataLock(this.LockManager, this._workspaces);
        this._state = 0;
        this.buildOlapWorkspaces(this.olapMetadata);
        this.LockManager.markIsFormal(this.olapMetadata.getCubes());
        this._state = 1;
        this.pluginContext = new OlapWorkspacePluginContext(this);
        this.plugins = new PluginCollection(this.pluginContext);
        this.functions = FunctionManager.Companion.createDefault$bos_olap_core2();
        this.sandboxWorkspaces = new SandboxWorkspaceCollection();
        this.cubeWorkspaceLoading = new EventHandlerList();
        this._tempPool = LazyKt.lazy((Function0)_tempPool.1.INSTANCE);
        this.gcPool = Executors.newScheduledThreadPool(1, new DefaultThreadFactory("OlapGcThread-", 0, 2, null));
        this.collecting = new EventHandlerList();
        this._stateLock = new ReentrantReadWriteLock();
        this.freeSpaceChecker = new DiskFreeSpaceChecker("Out-Of-Disk-Space", this.RootPath, this.healthReports, false);
    }

    @NotNull
    public final String getRootPath() {
        return this.RootPath;
    }

    @NotNull
    public final OlapMetadata getMetadata() {
        return this.olapMetadata;
    }

    @NotNull
    public final AccessStrategyCollection getAccessStrategies() {
        return this.accessStrategies;
    }

    @NotNull
    public final HealthReportContainer getHealthReports() {
        return this.healthReports;
    }

    @NotNull
    public final OlapLockManager getLockManager() {
        return this.LockManager;
    }

    @NotNull
    public final OlapMetadataLock getOlapMetadataLock() {
        return this.olapMetadataLock;
    }

    @NotNull
    public final OlapWorkspacePluginContext getPluginContext$bos_olap_core2() {
        return this.pluginContext;
    }

    @NotNull
    public final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> getPlugins() {
        return this.plugins;
    }

    @NotNull
    public final FunctionManager getFunctions() {
        return this.functions;
    }

    public final synchronized int assignNextId() {
        if (this._initCubeId == Integer.MAX_VALUE || this._initCubeId < 0) {
            String string2 = Res.INSTANCE.getOlapWorkspaceException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_4>(...)");
            Object[] objectArray = new Object[]{this._initCubeId};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        int n = this._initCubeId;
        this._initCubeId = n + 1;
        return this._initCubeId;
    }

    private final void buildOlapWorkspaces(OlapMetadata newMetadata) {
        Object cube2;
        for (Object cube2 : newMetadata.getCubes()) {
            String name2;
            int cubeId = ((CubeEntry)cube2).getId();
            String string2 = ((CubeEntry)cube2).getName();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toUpperCase(locale), (String)"this as java.lang.String).toUpperCase(locale)");
            if (this._workspaces.containsKey(name2)) continue;
            this.putWorkspace(cubeId, ((CubeEntry)cube2).getName());
        }
        List removedCubes = new ArrayList();
        Enumeration<String> enumeration = this._workspaces.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        cube2 = CollectionsKt.iterator(enumeration);
        while (cube2.hasNext()) {
            String cubeName = (String)cube2.next();
            CubeEntryCollection cubeEntryCollection = newMetadata.getCubes();
            Intrinsics.checkNotNull((Object)cubeName);
            if (cubeEntryCollection.contains(cubeName)) continue;
            removedCubes.add(cubeName);
        }
        Iterable $this$forEach$iv = removedCubes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this._workspaces.remove(it);
        }
    }

    private final void putWorkspace(int cubeId, String cubeName) {
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        String name2 = string3;
        this._workspaces.putIfAbsent(name2, new CubeWorkspaceCreator(cubeId, cubeName, this));
    }

    @NotNull
    public final EventHandlerList<OlapWorkspacePluginContext, CubeWorkspaceEventArgs> getCubeWorkspaceLoading() {
        return this.cubeWorkspaceLoading;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string2);
        if (cubeWorkspaceCreator == null) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        CubeWorkspaceCreator lazyObj = cubeWorkspaceCreator;
        return lazyObj.getValue();
    }

    @NotNull
    public final CubeWorkspaceCreator getCubeWorkspaceCreator(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        CubeWorkspaceCreator cubeWorkspaceCreator = this.tryGetCubeWorkspaceCreator(cubeName);
        if (cubeWorkspaceCreator == null) {
            String string2 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_1>(...)");
            Object[] objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return cubeWorkspaceCreator;
    }

    @Nullable
    public final CubeWorkspaceCreator tryGetCubeWorkspaceCreator(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator lazyObj = this._workspaces.get(string3);
        return lazyObj;
    }

    public final <R> R enterRead(@NotNull String cubeName, @NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string2);
        if (cubeWorkspaceCreator == null) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        CubeWorkspaceCreator lazyObj = cubeWorkspaceCreator;
        return lazyObj.enterRead(body);
    }

    public final <R> R execute(@NotNull String cubeName, @NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string2);
        if (cubeWorkspaceCreator == null) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        CubeWorkspaceCreator lazyObj = cubeWorkspaceCreator;
        return (R)body.invoke((Object)lazyObj.getValue());
    }

    public final <R> R enterReadForBackup(@NotNull String cubeName, @NotNull Function2<? super CubeWorkspace, ? super Closeable, ? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string2);
        if (cubeWorkspaceCreator == null) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        CubeWorkspaceCreator lazyObj = cubeWorkspaceCreator;
        return lazyObj.enterReadForBackup(body);
    }

    public final <R> R enterWrite(@NotNull String cubeName, @NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string2);
        if (cubeWorkspaceCreator == null) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_1>(...)");
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        CubeWorkspaceCreator lazyObj = cubeWorkspaceCreator;
        return lazyObj.enterWrite(body);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CubeWorkspace> getLoadedWorkspaces$bos_olap_core2() {
        void $this$mapNotNullTo$iv$iv;
        CubeWorkspaceCreator[] cubeWorkspaceCreatorArray = this._workspaces.values();
        Intrinsics.checkNotNullExpressionValue(cubeWorkspaceCreatorArray, (String)"<get-values>(...)");
        CubeWorkspaceCreator[] $this$toTypedArray$iv = cubeWorkspaceCreatorArray;
        boolean $i$f$toTypedArray = false;
        CubeWorkspaceCreator[] thisCollection$iv = $this$toTypedArray$iv;
        CubeWorkspaceCreator[] $this$mapNotNull$iv = thisCollection$iv.toArray(new CubeWorkspaceCreator[0]);
        boolean $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            CubeWorkspace it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            CubeWorkspaceCreator it = (CubeWorkspaceCreator)element$iv$iv;
            boolean bl2 = false;
            if (it.tryGetValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void unloadWorkspaces$bos_olap_core2() {
        Collection<CubeWorkspaceCreator> collection = this._workspaces.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<CubeWorkspaceCreator> workspaces = collection;
        Ref.ObjectRef ex = new Ref.ObjectRef();
        List threads = new ArrayList();
        for (CubeWorkspaceCreator creator : workspaces) {
            threads.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(creator, (Ref.ObjectRef<Exception>)ex){
                final /* synthetic */ CubeWorkspaceCreator $creator;
                final /* synthetic */ Ref.ObjectRef<Exception> $ex;
                {
                    this.$creator = $creator;
                    this.$ex = $ex;
                    super(0);
                }

                public final void invoke() {
                    try {
                        this.$creator.unload();
                    }
                    catch (Exception vex) {
                        this.$ex.element = vex;
                    }
                }
            }), (int)31, null));
        }
        for (Thread t2 : threads) {
            t2.join(60000L);
        }
        Exception ex2 = (Exception)ex.element;
        if (ex2 != null) {
            throw ex2;
        }
    }

    @Nullable
    public final CubeWorkspace tryGet(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string3);
        return cubeWorkspaceCreator != null ? cubeWorkspaceCreator.getValue() : null;
    }

    @Nullable
    public final CubeWorkspace tryGetWithoutLazyLoad$bos_olap_core2(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator cubeWorkspaceCreator = this._workspaces.get(string3);
        return cubeWorkspaceCreator != null ? cubeWorkspaceCreator.tryGetValue() : null;
    }

    @Nullable
    public final CubeWorkspace tryGetByCubeId(int cubeId) {
        CubeWorkspace cubeWorkspace;
        String string2 = this.getMetadata().getCubes().tryGetCubeNameById(cubeId);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            cubeWorkspace = this.tryGet(it);
        } else {
            cubeWorkspace = null;
        }
        return cubeWorkspace;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspaceByCubeId(int cubeId) {
        return this.getCubeWorkspace(this.getMetadata().getCubes().getCubeNameById(cubeId));
    }

    public final boolean isFree() {
        Iterator iterator2 = ((Map)this._workspaces).entrySet().iterator();
        while (iterator2.hasNext()) {
            CubeWorkspaceCreator v = (CubeWorkspaceCreator)iterator2.next().getValue();
            if (!v.isInitialized() || !v.getMetadataLock().hasHolder()) continue;
            return false;
        }
        return true;
    }

    public final long getTransactionVersion(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string2 = cubeName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        CubeWorkspaceCreator creator = this._workspaces.get(string3);
        return creator == null ? -2L : creator.getLastCommittedTransactionId();
    }

    public final boolean contains(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string2 = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        return this._workspaces.containsKey(string3);
    }

    @NotNull
    public final ByteBufferResourcePool getTempPool() {
        return (ByteBufferResourcePool)this._tempPool.getValue();
    }

    private final void checkState() {
        if (this._state != 1) {
            throw new ClosedFileSystemException();
        }
    }

    public final void updateMetadata(@NotNull CommandTypes action, @Nullable String updateCubeName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        this.checkState();
        ConcurrentHashMap<String, CubeWorkspaceCreator> currentWorkspaces = this._workspaces;
        String string3 = updateCubeName;
        if (string3 != null) {
            String string4 = string3;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string5 = string4.toUpperCase(locale);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(locale)");
        } else {
            string2 = null;
        }
        String cubeNameUpperCase = string2;
        CubeWorkspaceCreator creator = (CubeWorkspaceCreator)((Map)currentWorkspaces).get(cubeNameUpperCase);
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                if (updateCubeName == null) break;
                this.reBuildMetadata();
                int cubeId = ((CubeEntry)this.olapMetadata.getCubes().get(updateCubeName)).getId();
                this.putWorkspace(cubeId, updateCubeName);
                break;
            }
            case 2: {
                throw new NotSupportedException();
            }
            case 3: {
                CubeWorkspaceCreator cubeWorkspaceCreator = creator;
                if (cubeWorkspaceCreator != null) {
                    cubeWorkspaceCreator.delete();
                }
                this.reBuildMetadata();
                TypeIntrinsics.asMutableMap((Object)this._workspaces).remove(cubeNameUpperCase);
                break;
            }
            case 4: {
                OlapMetadata newMetadata = this.reBuildMetadata();
                this.buildOlapWorkspaces(newMetadata);
            }
        }
    }

    public final void reloadOlapMetadata() {
        this.checkState();
        this.reBuildMetadata();
    }

    private final OlapMetadata reBuildMetadata() {
        return (OlapMetadata)this.LockManager.enterWrite((Function0)new Function0<OlapMetadata>(this){
            final /* synthetic */ OlapWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OlapMetadata invoke() {
                OlapMetadata newMetadata = OlapMetadataBuilder.Companion.readFrom(this.this$0.getRootPath()).build();
                this.this$0.getLockManager().markIsFormal(newMetadata.getCubes());
                OlapWorkspace.access$setOlapMetadata$p(this.this$0, newMetadata);
                return newMetadata;
            }
        });
    }

    public final boolean startGC(long gcTimePeriod) {
        long currentGcTimePeriod;
        long l = currentGcTimePeriod = gcTimePeriod < 0L ? Companion.getGcTimePeriod() : gcTimePeriod;
        if (this._state == 1 && currentGcTimePeriod > 0L) {
            this.gcPool.scheduleAtFixedRate(this::gc, currentGcTimePeriod, currentGcTimePeriod, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean startGC$default(OlapWorkspace olapWorkspace, long l, int n, Object object2) {
        if ((n & 1) != 0) {
            l = -1L;
        }
        return olapWorkspace.startGC(l);
    }

    @NotNull
    public final EventHandlerList<OlapWorkspacePluginContext, EventArgs> getCollecting() {
        return this.collecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void gc() {
        if (this._state != 1) {
            return;
        }
        if (System.nanoTime() - this._lastGcNanoTime < Companion.getGcTimePeriod() * 1000000000L / (long)2) {
            return;
        }
        try {
            ConcurrentHashMap<String, CubeWorkspaceCreator> workspaces = this._workspaces;
            Iterator iterator2 = ((Map)workspaces).entrySet().iterator();
            while (iterator2.hasNext()) {
                CubeWorkspaceCreator v = (CubeWorkspaceCreator)iterator2.next().getValue();
                v.gc();
            }
            this.sandboxWorkspaces.gc();
            if (this._tempPool.isInitialized()) {
                ((ByteBufferResourcePool)this._tempPool.getValue()).gc();
            }
            this.collecting.invoke(this.pluginContext, EventArgs.Default.INSTANCE);
        }
        catch (Throwable ex) {
            String string2 = "GC-" + CubeToolKt.getCurrentTime();
            String string3 = ex.getMessage();
            if (string3 == null) {
                string3 = "gc error";
            }
            this.healthReports.commit(new HealthReport(string2, null, string3, HealthReportLevel.Error, PrivilegeType.None.getCode()));
            UnhandledExceptionEventArgs.Companion.onError$bos_olap_core2(this, ex, "gc");
        }
        finally {
            this._lastGcNanoTime = System.nanoTime();
        }
    }

    @NotNull
    public final CubeWorkspace createSandboxWorkspace(@NotNull String cubeName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return (CubeWorkspace)this.enterRead(cubeName, (Function1)new Function1<CubeWorkspace, CubeWorkspace>(this, identity){
            final /* synthetic */ OlapWorkspace this$0;
            final /* synthetic */ String $identity;
            {
                this.this$0 = $receiver;
                this.$identity = $identity;
                super(1);
            }

            @NotNull
            public final CubeWorkspace invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                return OlapWorkspace.access$getSandboxWorkspaces$p(this.this$0).createSandboxWorkspace(cubeWorkspace, this.$identity, this.this$0.getTempPool());
            }
        });
    }

    @NotNull
    public final CubeWorkspace getSandboxWorkspace(@NotNull String cubeName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return this.sandboxWorkspaces.get(this.getCubeWorkspace(cubeName), identity);
    }

    public final boolean dropSandboxWorkspace(@NotNull String cubeName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return this.sandboxWorkspaces.drop(this.getCubeWorkspace(cubeName), identity);
    }

    public final <R> R enterSandbox(@NotNull String cubeName, @NotNull String identity, @NotNull Function1<? super CubeWorkspace, ? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.checkState();
        CubeWorkspace sandbox = this.getSandboxWorkspace(cubeName, identity);
        if (sandbox.isClosed()) {
            String string2 = Res.INSTANCE.getOlapWorkspaceException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_4>(...)");
            Object[] objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return (R)sandbox.getMetadataLock().enterRead((Function0)new Function0<R>(sandbox, cubeName, body){
            final /* synthetic */ CubeWorkspace $sandbox;
            final /* synthetic */ String $cubeName;
            final /* synthetic */ Function1<CubeWorkspace, R> $body;
            {
                this.$sandbox = $sandbox;
                this.$cubeName = $cubeName;
                this.$body = $body;
                super(0);
            }

            public final R invoke() {
                if (this.$sandbox.isClosed()) {
                    String string2 = Res.INSTANCE.getOlapWorkspaceException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_4>(...)");
                    Object[] objectArray = new Object[]{this.$cubeName};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                return (R)this.$body.invoke((Object)this.$sandbox);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this._state != 1) {
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this._stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this._state != 1) {
                return;
            }
            this._state = 4;
            this.sandboxWorkspaces.close();
            this.gcPool.shutdown();
            Ref.ObjectRef ex = new Ref.ObjectRef();
            ConcurrentHashMap<String, CubeWorkspaceCreator> workspaces = this._workspaces;
            List threads = new ArrayList();
            Iterator iterator2 = ((Map)workspaces).entrySet().iterator();
            while (iterator2.hasNext()) {
                CubeWorkspaceCreator v = (CubeWorkspaceCreator)iterator2.next().getValue();
                CubeWorkspace cubeWorkspace = v.shutdown();
                if (cubeWorkspace == null) continue;
                threads.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(cubeWorkspace, (Ref.ObjectRef<Exception>)ex){
                    final /* synthetic */ CubeWorkspace $cubeWorkspace;
                    final /* synthetic */ Ref.ObjectRef<Exception> $ex;
                    {
                        this.$cubeWorkspace = $cubeWorkspace;
                        this.$ex = $ex;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            this.$cubeWorkspace.close();
                        }
                        catch (Exception vex) {
                            this.$ex.element = vex;
                        }
                    }
                }), (int)31, null));
            }
            for (Thread t2 : threads) {
                t2.join();
            }
            if (this._tempPool.isInitialized()) {
                ((ByteBufferResourcePool)this._tempPool.getValue()).close();
            }
            this.plugins.close$bos_olap_core2();
            this.gcPool.awaitTermination(10L, TimeUnit.SECONDS);
            this._state = 5;
            Exception ex2 = (Exception)ex.element;
            if (ex2 != null) {
                throw ex2;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final long checkExecuteByFreeSpace() {
        return this.freeSpaceChecker.checkExecuteByFreeSpace();
    }

    private static final long gcTimePeriodConfigItem$lambda$4() {
        return ByteBufferResourcePool.Companion.getResourceTimeout() + 10L;
    }

    private static final long cubeWorkspaceUnloadTimeoutConfigItem$lambda$5() {
        return gcTimePeriodConfigItem.getValue() * (long)60;
    }

    public static final /* synthetic */ void access$setOlapMetadata$p(OlapWorkspace $this, OlapMetadata olapMetadata) {
        $this.olapMetadata = olapMetadata;
    }

    public static final /* synthetic */ SandboxWorkspaceCollection access$getSandboxWorkspaces$p(OlapWorkspace $this) {
        return $this.sandboxWorkspaces;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR,\u0010\u000b\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/storages/OlapWorkspace$Companion;", "", "()V", "value", "", "Lkd/bos/olapServer2/common/long;", "GcTimePeriod", "getGcTimePeriod", "()J", "setGcTimePeriod", "(J)V", "cubeWorkspaceUnloadTimeout", "getCubeWorkspaceUnloadTimeout", "setCubeWorkspaceUnloadTimeout", "cubeWorkspaceUnloadTimeoutConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "gcTimePeriodConfigItem", "getGcTimePeriodConfigItem$bos_olap_core2", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getGcTimePeriodConfigItem$bos_olap_core2() {
            return gcTimePeriodConfigItem;
        }

        public final long getGcTimePeriod() {
            return this.getGcTimePeriodConfigItem$bos_olap_core2().getValue();
        }

        public final void setGcTimePeriod(long value2) {
            this.getGcTimePeriodConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2() {
            return cubeWorkspaceUnloadTimeoutConfigItem;
        }

        public final long getCubeWorkspaceUnloadTimeout() {
            return this.getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().getValue();
        }

        public final void setCubeWorkspaceUnloadTimeout(long value2) {
            this.getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().setValue(value2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            try {
                nArray[CommandTypes.create.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.alter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.drop.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.repair.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

