/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.util.concurrent.locks.ReadWriteLock;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.events.ClearDSCacheEvent;
import kd.bos.olapServer2.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer2.metadata.events.CreateMemberEvent;
import kd.bos.olapServer2.metadata.events.MetadataEvent;
import kd.bos.olapServer2.metadata.extend.IExtendCube;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CommonCubeMetadataStorage;
import kd.bos.olapServer2.storages.CubeMetadataStorage;
import kd.bos.olapServer2.storages.ICubeMetadataStorage;
import kd.bos.olapServer2.storages.IMetadataDatabase;
import kd.bos.olapServer2.storages.IPartitionCubeWorkspaceCollection;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0015\u0010\u0016\u001a\u00020\u00152\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\u0018\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0018j\u0002`\u00190\u001dH\u0096\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016J\t\u0010#\u001a\u00020\u0015H\u0096\u0001J\t\u0010$\u001a\u00020\u0015H\u0096\u0001R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkd/bos/olapServer2/storages/PartitionCubeMetadataStorage;", "Lkd/bos/olapServer2/storages/ICubeMetadataStorage;", "Lkd/bos/olapServer2/storages/IMetadataDatabase;", "metaDatabase", "subCubeWorkspaces", "Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;", "Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "(Lkd/bos/olapServer2/storages/IMetadataDatabase;Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;)V", "extendCube", "Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "getExtendCube", "()Lkd/bos/olapServer2/metadata/extend/IExtendCube;", "extendMetadataLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "getExtendMetadataLock", "()Ljava/util/concurrent/locks/ReadWriteLock;", "getMetaDatabase", "()Lkd/bos/olapServer2/storages/IMetadataDatabase;", "build", "Lkd/bos/olapServer2/metadata/Cube;", "close", "", "copyTo", "targetPath", "", "Lkd/bos/olapServer2/common/string;", "createWriterContext", "Lkd/bos/olapServer2/metadata/builds/IMetadataWriterContext;", "getFileNames", "", "()[Ljava/lang/String;", "invokeAll", "event", "Lkd/bos/olapServer2/metadata/events/MetadataEvent;", "invokeEvent", "optimize", "unload", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nPartitionCubeMetadataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartitionCubeMetadataStorage.kt\nkd/bos/olapServer2/storages/PartitionCubeMetadataStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1855#2,2:67\n1855#2,2:69\n1855#2,2:71\n1855#2,2:73\n*S KotlinDebug\n*F\n+ 1 PartitionCubeMetadataStorage.kt\nkd/bos/olapServer2/storages/PartitionCubeMetadataStorage\n*L\n27#1:67,2\n36#1:69,2\n50#1:71,2\n59#1:73,2\n*E\n"})
public final class PartitionCubeMetadataStorage
implements ICubeMetadataStorage,
IMetadataDatabase {
    @NotNull
    private final IMetadataDatabase metaDatabase;
    @NotNull
    private final IPartitionCubeWorkspaceCollection<PartitionCubeWorkspace> subCubeWorkspaces;

    public PartitionCubeMetadataStorage(@NotNull IMetadataDatabase metaDatabase, @NotNull IPartitionCubeWorkspaceCollection<PartitionCubeWorkspace> subCubeWorkspaces) {
        Intrinsics.checkNotNullParameter((Object)metaDatabase, (String)"metaDatabase");
        Intrinsics.checkNotNullParameter(subCubeWorkspaces, (String)"subCubeWorkspaces");
        this.metaDatabase = metaDatabase;
        this.subCubeWorkspaces = subCubeWorkspaces;
    }

    @NotNull
    public final IMetadataDatabase getMetaDatabase() {
        return this.metaDatabase;
    }

    @Override
    @NotNull
    public IExtendCube getExtendCube() {
        return this.metaDatabase.getExtendCube();
    }

    @Override
    @NotNull
    public ReadWriteLock getExtendMetadataLock() {
        return this.metaDatabase.getExtendMetadataLock();
    }

    @Override
    @NotNull
    public Cube build() {
        return this.metaDatabase.build();
    }

    @Override
    public void close() {
        this.metaDatabase.close();
    }

    @Override
    public void copyTo(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.metaDatabase.copyTo(targetPath);
    }

    @Override
    @NotNull
    public IMetadataWriterContext createWriterContext() {
        return this.metaDatabase.createWriterContext();
    }

    @Override
    @NotNull
    public String[] getFileNames() {
        return this.metaDatabase.getFileNames();
    }

    @Override
    public void optimize() {
        this.metaDatabase.optimize();
    }

    @Override
    public void unload() {
        this.metaDatabase.unload();
    }

    @Override
    public void invokeEvent(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommonCubeMetadataStorage.INSTANCE.bind(event);
        this.invokeAll(event);
    }

    private final void invokeAll(MetadataEvent event) {
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateMemberEvent) {
            Iterable $this$forEach$iv = this.subCubeWorkspaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PartitionCubeWorkspace subWorkspace = (PartitionCubeWorkspace)element$iv;
                boolean bl = false;
                if (!subWorkspace.getMetadata().getDimensions().contains(((CreateMemberEvent)event).getDimBuilder().getName())) continue;
                subWorkspace.getMetadataStorage().bind(subWorkspace, event);
            }
        } else if (metadataEvent instanceof CreateDimensionEvent) {
            Iterable $this$forEach$iv = this.subCubeWorkspaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PartitionCubeWorkspace subWorkspace = (PartitionCubeWorkspace)element$iv;
                boolean bl = false;
                long subRowCount = subWorkspace.getRowCount();
                if (subRowCount <= 0L) continue;
                ((CreateDimensionEvent)event).setRowCount(subRowCount);
                subWorkspace.getMetadataStorage().bind(subWorkspace, event);
            }
        } else if (metadataEvent instanceof ClearDSCacheEvent) {
            Iterable $this$forEach$iv = ((ClearDSCacheEvent)event).getBasePartitionItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPartitionItem basePartitionItem = (IPartitionItem)element$iv;
                boolean bl = false;
                IPartitionItem cachePartitionItem = ((ClearDSCacheEvent)event).getCube().getDSCachePartition(basePartitionItem);
                if (Intrinsics.areEqual((Object)cachePartitionItem, (Object)EmptyPartitionItem.INSTANCE)) continue;
                PartitionCubeWorkspace subWorkspace = this.subCubeWorkspaces.tryGet(cachePartitionItem.getId());
                Object object2 = subWorkspace;
                if (object2 == null || (object2 = ((AbstractCubeWorkspace)object2).getMetadataStorage()) == null) continue;
                ((CubeMetadataStorage)object2).bind(subWorkspace, event);
            }
        } else {
            Iterable $this$forEach$iv = this.subCubeWorkspaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PartitionCubeWorkspace subWorkspace = (PartitionCubeWorkspace)element$iv;
                boolean bl = false;
                subWorkspace.getMetadataStorage().bind(subWorkspace, event);
            }
        }
        event.invoke();
    }
}

