/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.selects.IQuerySession;
import kd.bos.olapServer2.selects.PartitionQuerySession;
import kd.bos.olapServer2.selects.Query;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.ICubeMetadataStorage;
import kd.bos.olapServer2.storages.ICubeWorkspaceProxy;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.IMetadataDatabase;
import kd.bos.olapServer2.storages.IPartitionCubeWorkspaceCollection;
import kd.bos.olapServer2.storages.InputRowWriterOption;
import kd.bos.olapServer2.storages.PartitionCubeMetadataStorage;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kd.bos.olapServer2.storages.PartitionCubeWorkspaceCollection;
import kd.bos.olapServer2.storages.PartitionInputRowWriter;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.IDSCacheCredibleSnapshot;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.PartitionDSCacheCredibleSnapshot;
import kd.bos.olapServer2.transactions.TransactionManager;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u001c\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u00060'j\u0002`(H\u0016J*\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\f\u00107\u001a\u000608j\u0002`9H\u0016J\u0010\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006="}, d2={"Lkd/bos/olapServer2/storages/PartitionCubeWorkspaceProxy;", "Lkd/bos/olapServer2/storages/ICubeWorkspaceProxy;", "owner", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "metadataBase", "Lkd/bos/olapServer2/storages/IMetadataDatabase;", "path", "", "Lkd/bos/olapServer2/common/string;", "transactionManager", "Lkd/bos/olapServer2/transactions/TransactionManager;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/storages/IMetadataDatabase;Ljava/lang/String;Lkd/bos/olapServer2/transactions/TransactionManager;)V", "newSubCubeWorkspaces", "Lkd/bos/olapServer2/storages/PartitionCubeWorkspaceCollection;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/storages/IMetadataDatabase;Lkd/bos/olapServer2/storages/PartitionCubeWorkspaceCollection;Lkd/bos/olapServer2/transactions/TransactionManager;)V", "_metadataStorage", "Lkd/bos/olapServer2/storages/PartitionCubeMetadataStorage;", "_owner", "_subCubeWorkspaces", "_tranManager", "metadataStorage", "Lkd/bos/olapServer2/storages/ICubeMetadataStorage;", "getMetadataStorage", "()Lkd/bos/olapServer2/storages/ICubeMetadataStorage;", "partitionWorkspaces", "Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "getPartitionWorkspaces", "()Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;", "getTransactionManager", "()Lkd/bos/olapServer2/transactions/TransactionManager;", "clearTidMap", "", "close", "createQuerySession", "Lkd/bos/olapServer2/selects/IQuerySession;", "query", "Lkd/bos/olapServer2/selects/Query;", "isParallel", "", "Lkd/bos/olapServer2/common/bool;", "createWriter", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "strategy", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "option", "Lkd/bos/olapServer2/storages/InputRowWriterOption;", "gc", "metadataLock", "Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "getDSCacheCredibleSnapshot", "Lkd/bos/olapServer2/storages/dynamicCalcAndStored/IDSCacheCredibleSnapshot;", "getRowCount", "", "Lkd/bos/olapServer2/common/long;", "onMetadataUpdated", "newMetadata", "Lkd/bos/olapServer2/metadata/Cube;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nPartitionCubeWorkspaceProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartitionCubeWorkspaceProxy.kt\nkd/bos/olapServer2/storages/PartitionCubeWorkspaceProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1855#2,2:121\n1855#2,2:123\n1855#2,2:125\n1855#2,2:127\n1855#2,2:129\n*S KotlinDebug\n*F\n+ 1 PartitionCubeWorkspaceProxy.kt\nkd/bos/olapServer2/storages/PartitionCubeWorkspaceProxy\n*L\n72#1:121,2\n83#1:123,2\n93#1:125,2\n111#1:127,2\n118#1:129,2\n*E\n"})
public final class PartitionCubeWorkspaceProxy
implements ICubeWorkspaceProxy {
    @NotNull
    private final CubeWorkspace _owner;
    @NotNull
    private final PartitionCubeMetadataStorage _metadataStorage;
    @NotNull
    private final PartitionCubeWorkspaceCollection _subCubeWorkspaces;
    @NotNull
    private final TransactionManager _tranManager;

    public PartitionCubeWorkspaceProxy(@NotNull CubeWorkspace owner, @NotNull IMetadataDatabase metadataBase, @NotNull String path, @NotNull TransactionManager transactionManager) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)metadataBase, (String)"metadataBase");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        this._owner = owner;
        this._subCubeWorkspaces = new PartitionCubeWorkspaceCollection(owner.getMetadata(), path);
        this._metadataStorage = new PartitionCubeMetadataStorage(metadataBase, this._subCubeWorkspaces);
        this._tranManager = transactionManager;
    }

    private PartitionCubeWorkspaceProxy(CubeWorkspace owner, IMetadataDatabase metadataBase, PartitionCubeWorkspaceCollection newSubCubeWorkspaces, TransactionManager transactionManager) {
        this._owner = owner;
        this._subCubeWorkspaces = newSubCubeWorkspaces;
        this._metadataStorage = new PartitionCubeMetadataStorage(metadataBase, this._subCubeWorkspaces);
        this._tranManager = transactionManager;
    }

    @Override
    @NotNull
    public ICubeMetadataStorage getMetadataStorage() {
        return this._metadataStorage;
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this._tranManager;
    }

    @Override
    @NotNull
    public IInputRowWriter createWriter(@Nullable IAddOrUpdateStrategy<IMeasureValues> strategy, @Nullable WriteTransaction transaction, @NotNull InputRowWriterOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new PartitionInputRowWriter(this._owner, transaction, strategy, this._subCubeWorkspaces, option);
    }

    @Override
    @NotNull
    public IQuerySession createQuerySession(@NotNull Query query2, boolean isParallel) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        return new PartitionQuerySession(this._owner.getMetadata(), query2, this._subCubeWorkspaces, isParallel);
    }

    @Override
    public long getRowCount() {
        long count = 0L;
        Iterable $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartitionCubeWorkspace it = (PartitionCubeWorkspace)element$iv;
            boolean bl = false;
            if (!this._owner.getMetadata().isBasePartition(it.getPartitionItem())) continue;
            count += it.getRowCount();
        }
        return count;
    }

    @Override
    public void gc(@NotNull ICubeMetadataLock metadataLock) {
        Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
        Iterable $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartitionCubeWorkspace it = (PartitionCubeWorkspace)element$iv;
            boolean bl = false;
            it.gc(this._owner.getHealthReports(), metadataLock);
        }
    }

    @Override
    @NotNull
    public ICubeWorkspaceProxy onMetadataUpdated(@NotNull Cube newMetadata) {
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        if (newMetadata.getPartitionItems().equalsCollection(this._subCubeWorkspaces.getCube().getPartitionItems())) {
            Iterable $this$forEach$iv = this._subCubeWorkspaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PartitionCubeWorkspace workspace = (PartitionCubeWorkspace)element$iv;
                boolean bl = false;
                IPartitionItem partitionItem = newMetadata.getPartitionItems().get(workspace.getPartitionItem().getKey());
                workspace.onMetadataUpdated(newMetadata.getPartitionCubeMetadata(partitionItem), partitionItem);
            }
        } else {
            PartitionCubeWorkspaceCollection newSubCubeWorkspaces = this._subCubeWorkspaces.clone(newMetadata, true);
            return new PartitionCubeWorkspaceProxy(this._owner, this._metadataStorage.getMetaDatabase(), newSubCubeWorkspaces, this._tranManager);
        }
        PartitionCubeWorkspaceCollection newSubCubeWorkspaces = this._subCubeWorkspaces.clone(newMetadata, false);
        return new PartitionCubeWorkspaceProxy(this._owner, this._metadataStorage.getMetaDatabase(), newSubCubeWorkspaces, this._tranManager);
    }

    @Override
    @NotNull
    public IDSCacheCredibleSnapshot getDSCacheCredibleSnapshot() {
        return new PartitionDSCacheCredibleSnapshot(this._owner.getMetadata(), this._subCubeWorkspaces);
    }

    @Override
    public void clearTidMap() {
        Iterable $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartitionCubeWorkspace it = (PartitionCubeWorkspace)element$iv;
            boolean bl = false;
            it.clearTidMap();
        }
    }

    @Override
    @NotNull
    public IPartitionCubeWorkspaceCollection<AbstractCubeWorkspace> getPartitionWorkspaces() {
        return this._subCubeWorkspaces;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartitionCubeWorkspace it = (PartitionCubeWorkspace)element$iv;
            boolean bl = false;
            it.close();
        }
    }
}

