/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.collections.IMutableDictionaryObserver;
import kd.bos.olapServer2.collections.IMutableMapLong2Long;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.IInputRow;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.dataEntities.IMeasureValuesKt;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.BaseAndCachePartitionMetadata;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.EmptyDimensionKeys;
import kd.bos.olapServer2.storages.ICubeDataObserver;
import kd.bos.olapServer2.storages.ICubeDataObserverContext;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.IPartitionCubeWorkspaceCollection;
import kd.bos.olapServer2.storages.InputRowList;
import kd.bos.olapServer2.storages.InputRowWriterOption;
import kd.bos.olapServer2.storages.LoadOriginalValuesStrategy;
import kd.bos.olapServer2.storages.MarkDimensionKeys;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.storages.TransactionStrategy;
import kd.bos.olapServer2.storages.UnMarkDimensionKeys;
import kd.bos.olapServer2.storages.gc.RuntimeZipTaskExecutor;
import kd.bos.olapServer2.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b!\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B=\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u0005H\u0016J0\u0010Y\u001a\u00020V2\n\u0010L\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00052\n\u0010Z\u001a\u00060\u0013j\u0002`\u0016H\u0016J\u001c\u0010[\u001a\u000608j\u0002`\\2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u0005H\u0016J\u0018\u0010^\u001a\u00020V2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u0005H\u0016J$\u0010_\u001a\u00020V2\n\u0010L\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u0005H\u0016J\u0014\u0010`\u001a\u00020V2\n\u0010a\u001a\u00060\u0013j\u0002`\u0014H\u0016J\b\u0010b\u001a\u00020VH\u0016J\b\u0010c\u001a\u00020VH\u0002J\b\u0010d\u001a\u00020VH\u0016J\u0014\u0010e\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010W\u001a\u00020\u0004H\u0016J\u0014\u0010f\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010g\u001a\u00020%H\u0002J\u0014\u0010h\u001a\u00020%2\n\u0010i\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0010\u0010h\u001a\u00020%2\u0006\u0010W\u001a\u00020\u0004H\u0002J\u001c\u0010h\u001a\u00020%2\u0006\u0010W\u001a\u00020\u00042\n\u0010i\u001a\u00060\u001bj\u0002`\u001cH\u0002J0\u0010j\u001a\u000608j\u0002`\\2\n\u0010L\u001a\u00060\u001bj\u0002`\u001c2\n\u0010k\u001a\u00060\u0013j\u0002`\u00142\n\u0010l\u001a\u00060\u0013j\u0002`\u0016H\u0016J$\u0010m\u001a\u00020V2\n\u0010n\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010W\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u0005H\u0016J$\u0010o\u001a\u00020V2\n\u0010a\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010W\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u0005H\u0016J\u0010\u0010p\u001a\u00020%2\u0006\u0010q\u001a\u00020\u000eH\u0002J\b\u0010r\u001a\u00020VH\u0002J4\u0010s\u001a\u00020V2\n\u0010L\u001a\u00060\u001bj\u0002`\u001c2\n\u0010k\u001a\u00060\u0013j\u0002`\u00142\n\u0010R\u001a\u00060\u0013j\u0002`\u00162\u0006\u0010t\u001a\u00020\u0005H\u0016J\u0014\u0010u\u001a\u00020V2\n\u00109\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u0014\u0010v\u001a\u00020V2\n\u0010w\u001a\u00060\u0013j\u0002`\u0016H\u0002J\u0014\u0010x\u001a\u00020%2\n\u0010i\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0014\u0010y\u001a\u00020\u000e2\n\u0010i\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u001c\u0010z\u001a\u00020V2\n\u0010k\u001a\u00060\u0013j\u0002`\u00162\u0006\u0010X\u001a\u00020\u0005H\u0016J2\u0010{\u001a\u00020V2\n\u0010L\u001a\u00060\u001bj\u0002`\u001c2\n\u0010k\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010X\u001a\u00020\u00052\b\u0010|\u001a\u0004\u0018\u00010\u0005H\u0016R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0013j\u0002`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0013j\u0002`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00060\u001bj\u0002`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00104\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00109\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u0014\u0010;\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010BR\u0015\u0010C\u001a\u00020D8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0018\u0010L\u001a\u00060\u001bj\u0002`\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u001eR\u000e\u0010N\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0018\u0010R\u001a\u00060\u0013j\u0002`\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u00106R\u000e\u0010T\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lkd/bos/olapServer2/storages/PartitionInputRowWriter;", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "Lkd/bos/olapServer2/storages/ICubeDataObserverContext;", "Lkd/bos/olapServer2/collections/IMutableDictionaryObserver;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "strategy", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "subCubeWorkspaces", "Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;", "Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "option", "Lkd/bos/olapServer2/storages/InputRowWriterOption;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/transactions/WriteTransaction;Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;Lkd/bos/olapServer2/storages/IPartitionCubeWorkspaceCollection;Lkd/bos/olapServer2/storages/InputRowWriterOption;)V", "_index", "", "Lkd/bos/olapServer2/common/rowIdx;", "_lockTime", "Lkd/bos/olapServer2/common/long;", "_undoTid", "creatingEventArgs", "Lkd/bos/olapServer2/storages/plugins/InputRowWriterCreatingEventArgs;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "currentCubeWorkspace", "getCurrentCubeWorkspace", "()Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "setCurrentCubeWorkspace", "(Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;)V", "currentInputRowList", "Lkd/bos/olapServer2/storages/InputRowList;", "currentLock", "Ljava/io/Closeable;", "currentMarkKey", "Lkd/bos/olapServer2/storages/MarkDimensionKeys;", "currentPartitionInitSegmentIndex", "currentPartitionItem", "Lkd/bos/olapServer2/metadata/partitions/IPartitionItem;", "currentPartitionPosition", "currentTidMap", "Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "getCurrentTidMap", "()Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "dataObserver", "Lkd/bos/olapServer2/storages/ICubeDataObserver;", "globalIndex", "getGlobalIndex", "()J", "hasValidWrite", "", "index", "getIndex", "keyInPartition", "getKeyInPartition", "()Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "lastPartitionPosition", "matchContext", "", "", "[Ljava/lang/Object;", "metadata", "Lkd/bos/olapServer2/metadata/Cube;", "getMetadata", "()Lkd/bos/olapServer2/metadata/Cube;", "getOption", "()Lkd/bos/olapServer2/storages/InputRowWriterOption;", "originalValues", "getOriginalValues", "()Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "partitionId", "getPartitionId", "partitionValidWriteCount", "partitionWriteCount", "getTransaction", "()Lkd/bos/olapServer2/transactions/WriteTransaction;", "undoTid", "getUndoTid", "writeCount", "add4Calc", "", "key", "values", "add4Redo", "expectRowIndex", "addOrUpdate", "Lkd/bos/olapServer2/common/bool;", "value", "addOrUpdate4Calc", "addOrUpdate4Redo", "beforeUpdate", "updateIndex", "close", "flushCurrentInputRowList", "force", "getKeyIndex", "getLastSegmentIndex", "inputRowList", "getSubInputRowList", "partitionPosition", "isRowNeedRollback", "rowIndex", "rollbackTid", "onAdded", "addIndex", "onUpdated", "refreshInputRowList", "newSubCubeWorkspace", "resetDSVersion", "rollback", "undoValues", "setRowTid", "submitDataZip", "taskCount", "switchInputRowList", "switchLock", "update4Calc", "update4Redo", "expectOldValue", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nPartitionInputRowWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartitionInputRowWriter.kt\nkd/bos/olapServer2/storages/PartitionInputRowWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,404:1\n43#1:405\n43#1:407\n43#1:414\n1#2:406\n31#3,6:408\n*S KotlinDebug\n*F\n+ 1 PartitionInputRowWriter.kt\nkd/bos/olapServer2/storages/PartitionInputRowWriter\n*L\n57#1:405\n87#1:407\n282#1:414\n180#1:408,6\n*E\n"})
public final class PartitionInputRowWriter
implements IInputRowWriter,
ICubeDataObserverContext,
IMutableDictionaryObserver<IDimensionKeys, IMeasureValues> {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @Nullable
    private final WriteTransaction transaction;
    @NotNull
    private final IPartitionCubeWorkspaceCollection<PartitionCubeWorkspace> subCubeWorkspaces;
    @NotNull
    private final InputRowWriterOption option;
    @NotNull
    private final InputRowWriterCreatingEventArgs creatingEventArgs;
    private long _lockTime;
    @Nullable
    private final ICubeDataObserver dataObserver;
    @Nullable
    private Closeable currentLock;
    @Nullable
    private InputRowList currentInputRowList;
    @Nullable
    private PartitionCubeWorkspace currentCubeWorkspace;
    private long currentPartitionInitSegmentIndex;
    private int currentPartitionPosition;
    @NotNull
    private IPartitionItem currentPartitionItem;
    @NotNull
    private MarkDimensionKeys currentMarkKey;
    @Nullable
    private final IAddOrUpdateStrategy<IMeasureValues> strategy;
    @NotNull
    private final Object[] matchContext;
    private long partitionWriteCount;
    private long writeCount;
    private long partitionValidWriteCount;
    private boolean hasValidWrite;
    private int lastPartitionPosition;
    private long _index;
    private long _undoTid;

    public PartitionInputRowWriter(@NotNull CubeWorkspace cubeWorkspace, @Nullable WriteTransaction transaction, @Nullable IAddOrUpdateStrategy<IMeasureValues> strategy, @NotNull IPartitionCubeWorkspaceCollection<PartitionCubeWorkspace> subCubeWorkspaces, @NotNull InputRowWriterOption option) {
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy;
        boolean enableLoadOriginalValues;
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter(subCubeWorkspaces, (String)"subCubeWorkspaces");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.cubeWorkspace = cubeWorkspace;
        this.transaction = transaction;
        this.subCubeWorkspaces = subCubeWorkspaces;
        this.option = option;
        this.creatingEventArgs = new InputRowWriterCreatingEventArgs(this);
        this.currentPartitionPosition = -1;
        this.currentPartitionItem = EmptyPartitionItem.INSTANCE;
        PartitionInputRowWriter this_$iv = this;
        boolean $i$f$getMetadata = false;
        this.currentMarkKey = new MarkDimensionKeys(this_$iv.cubeWorkspace.getMetadata(), EmptyDimensionKeys.INSTANCE);
        this.matchContext = this.getOption().getWriteToBase() ? BaseAndCachePartitionMetadata.INSTANCE.getBaseContext() : BaseAndCachePartitionMetadata.INSTANCE.getCacheContext();
        boolean bl = enableLoadOriginalValues = this.getOption().getEnableLoadOriginalValues() || this.getTransaction() != null;
        if (enableLoadOriginalValues) {
            LoadOriginalValuesStrategy t2 = new LoadOriginalValuesStrategy(strategy, this.cubeWorkspace.getMetadata().getMeasures());
            iAddOrUpdateStrategy = this.getTransaction() != null ? (IAddOrUpdateStrategy)new TransactionStrategy(t2, this) : (IAddOrUpdateStrategy<IMeasureValues>)t2;
        } else {
            iAddOrUpdateStrategy = this.strategy = strategy;
        }
        if (this.getOption().getEnableCreatingEvent()) {
            this.cubeWorkspace.getInputRowWriterCreating().invoke(this.cubeWorkspace.getPlugins().getContext(), this.creatingEventArgs);
        }
        this.dataObserver = this.creatingEventArgs.createCubeDataObserver$bos_olap_core2();
        this.lastPartitionPosition = -1;
        this._index = -1L;
        this._undoTid = -1L;
    }

    @Override
    @Nullable
    public WriteTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    @NotNull
    public InputRowWriterOption getOption() {
        return this.option;
    }

    private final Cube getMetadata() {
        boolean $i$f$getMetadata = false;
        return this.cubeWorkspace.getMetadata();
    }

    @Override
    @Nullable
    public PartitionCubeWorkspace getCurrentCubeWorkspace() {
        return this.currentCubeWorkspace;
    }

    public void setCurrentCubeWorkspace(@Nullable PartitionCubeWorkspace partitionCubeWorkspace) {
        this.currentCubeWorkspace = partitionCubeWorkspace;
    }

    private final IMutableMapLong2Long getCurrentTidMap() {
        Object object2 = this.getCurrentCubeWorkspace();
        if (object2 == null || (object2 = ((AbstractCubeWorkspace)object2).getTidMap()) == null) {
            throw new RuntimeException();
        }
        return object2;
    }

    private final InputRowList getSubInputRowList(IDimensionKeys key2, int partitionPosition) {
        InputRowList inputRowList;
        InputRowList it = inputRowList = this.getSubInputRowList(partitionPosition);
        boolean bl = false;
        this.currentMarkKey.setBaseKeys(key2);
        return inputRowList;
    }

    private final InputRowList getSubInputRowList(IDimensionKeys key2) {
        InputRowList inputRowList;
        PartitionInputRowWriter this_$iv = this;
        boolean $i$f$getMetadata = false;
        int partitionPosition = this_$iv.cubeWorkspace.getMetadata().getPartitionItems().match(key2, this.matchContext);
        InputRowList it = inputRowList = this.getSubInputRowList(partitionPosition);
        boolean bl = false;
        this.currentMarkKey.setBaseKeys(key2);
        return inputRowList;
    }

    private final InputRowList getSubInputRowList(int partitionPosition) {
        InputRowList inputRowList;
        InputRowList inputRowList2 = this.currentInputRowList;
        PartitionCubeWorkspace cp = this.getCurrentCubeWorkspace();
        if (cp == null || partitionPosition != this.currentPartitionPosition || inputRowList2 == null) {
            inputRowList = this.switchInputRowList(partitionPosition);
        } else if (this.partitionWriteCount >= 524287L) {
            if (cp.getDataLock().getHasQueuedThreads()) {
                inputRowList = this.switchInputRowList(partitionPosition);
            } else {
                this.flushCurrentInputRowList();
                inputRowList = this.refreshInputRowList(cp);
            }
        } else {
            inputRowList = inputRowList2;
        }
        return inputRowList;
    }

    private final long getLastSegmentIndex(InputRowList inputRowList) {
        return inputRowList.getCount() >> 16;
    }

    private final InputRowList switchInputRowList(int partitionPosition) {
        PartitionCubeWorkspace newSubCubeWorkspace = this.switchLock(partitionPosition);
        this.setCurrentCubeWorkspace(newSubCubeWorkspace);
        this.currentPartitionPosition = partitionPosition;
        this.currentMarkKey = new MarkDimensionKeys(newSubCubeWorkspace.getMetadata(), EmptyDimensionKeys.INSTANCE);
        this.currentPartitionItem = newSubCubeWorkspace.getPartitionItem();
        return this.refreshInputRowList(newSubCubeWorkspace);
    }

    private final InputRowList refreshInputRowList(PartitionCubeWorkspace newSubCubeWorkspace) {
        InputRowList inputRowList;
        InputRowList it = inputRowList = newSubCubeWorkspace.getInputRowList();
        boolean bl = false;
        this.currentInputRowList = it;
        this.currentPartitionInitSegmentIndex = this.getLastSegmentIndex(it);
        return inputRowList;
    }

    private final void flushCurrentInputRowList() {
        block4: {
            long lastSegmentIndex;
            InputRowList inputRowList = this.currentInputRowList;
            if (inputRowList == null) break block4;
            InputRowList $this$flushCurrentInputRowList_u24lambda_u243 = inputRowList;
            boolean bl = false;
            $this$flushCurrentInputRowList_u24lambda_u243.flush();
            if (this.partitionWriteCount > 0L) {
                this.writeCount += this.partitionWriteCount;
                if (this.partitionValidWriteCount > 0L) {
                    this.hasValidWrite = true;
                    ICubeDataObserver iCubeDataObserver = this.dataObserver;
                    if (iCubeDataObserver != null) {
                        iCubeDataObserver.onForcePartition();
                    }
                    this.partitionValidWriteCount = 0L;
                }
                StandardCommandStatistics.INSTANCE.inc(CommandStatisticsItem.Companion.getWriteCount(), this.partitionWriteCount);
                this.partitionWriteCount = 0L;
            }
            if ((lastSegmentIndex = this.getLastSegmentIndex($this$flushCurrentInputRowList_u24lambda_u243)) > this.currentPartitionInitSegmentIndex) {
                this.submitDataZip(lastSegmentIndex - this.currentPartitionInitSegmentIndex);
            }
        }
    }

    private final PartitionCubeWorkspace switchLock(int partitionPosition) {
        this.flushCurrentInputRowList();
        Closeable closeable = this.currentLock;
        if (closeable != null) {
            Closeable closeable2;
            Closeable $this$switchLock_u24lambda_u244 = closeable2 = closeable;
            boolean bl = false;
            $this$switchLock_u24lambda_u244.close();
        }
        PartitionCubeWorkspace newSubCubeWorkspace = this.subCubeWorkspaces.getOrCreate(partitionPosition);
        if (this.getOption().getEnableLock()) {
            boolean $i$f$measureNanoTime = false;
            long start$iv = System.nanoTime();
            long l = this._lockTime;
            PartitionInputRowWriter partitionInputRowWriter = this;
            boolean bl = false;
            this.currentLock = newSubCubeWorkspace.getDataLock().getWriteLock(1800L, TimeUnit.SECONDS);
            Unit unit = Unit.INSTANCE;
            partitionInputRowWriter._lockTime = l + (System.nanoTime() - start$iv);
        }
        return newSubCubeWorkspace;
    }

    @Override
    public boolean addOrUpdate(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        PartitionInputRowWriter observer = this.dataObserver == null ? null : this;
        boolean it = bl = this.getSubInputRowList(key2).addOrUpdate(this.currentMarkKey, value2, this.strategy, (IMutableDictionaryObserver<IDimensionKeys, IMeasureValues>)observer) < 0L;
        boolean bl2 = false;
        long l = this.partitionWriteCount;
        this.partitionWriteCount = l + 1L;
        return bl;
    }

    @Override
    public void addOrUpdate4Calc(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.addOrUpdate(key2, value2);
    }

    @Override
    public void add4Calc(@NotNull IDimensionKeys key2, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this.strategy;
        if (!(iAddOrUpdateStrategy != null ? !iAddOrUpdateStrategy.allowAdd() : false)) {
            long addIndex = this.getSubInputRowList(key2).add$bos_olap_core2(this.currentMarkKey, values);
            this.onAdded(addIndex, key2, values);
        }
    }

    @Override
    public void update4Calc(long rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        long index2 = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        InputRowList inputRowList = this.getSubInputRowList(RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex));
        IMeasureValues newValues = values;
        if (this.strategy != null) {
            newValues = this.strategy.modifiedValue(index2, inputRowList.getMeasureValues(index2), values);
        }
        this.beforeUpdate(index2);
        IDimensionKeys key2 = inputRowList.update$bos_olap_core2(index2, newValues);
        this.currentMarkKey.setBaseKeys(new UnMarkDimensionKeys(this.cubeWorkspace.getMetadata(), this.currentPartitionItem, key2));
        this.onUpdated(index2, this.currentMarkKey.getBaseKeys(), newValues);
        long l = this.partitionWriteCount;
        this.partitionWriteCount = l + 1L;
    }

    private final void resetDSVersion() {
        if (this.currentPartitionPosition != this.lastPartitionPosition) {
            PartitionCubeWorkspace partitionCubeWorkspace = this.getCurrentCubeWorkspace();
            if (partitionCubeWorkspace == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            PartitionCubeWorkspace cc = partitionCubeWorkspace;
            if (cc.getResourcePool().getDsVersion() != 0L) {
                cc.getResourcePool().setDsVersion(0L);
            }
            this.lastPartitionPosition = this.currentPartitionPosition;
        }
    }

    @Override
    public void add4Redo(int partitionId, @NotNull IDimensionKeys key2, @NotNull IMeasureValues values, long expectRowIndex) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        InputRowList inputRowList = this.getSubInputRowList(partitionId);
        this.currentMarkKey.setBaseKeys(key2);
        this.resetDSVersion();
        long realIndex = inputRowList.add$bos_olap_core2(this.currentMarkKey, values);
        if (expectRowIndex != -1L && realIndex != expectRowIndex) {
            String string2 = Res.INSTANCE.getInputRowWriterException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-InputRowWriterException_1>(...)");
            Object[] objectArray = new Object[]{this.cubeWorkspace.getMetadata().getName(), this.currentMarkKey.toString(), expectRowIndex, realIndex};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    @Override
    public void update4Redo(int partitionId, long rowIndex, @NotNull IMeasureValues values, @Nullable IMeasureValues expectOldValue) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        InputRowList inputRowList = this.getSubInputRowList(partitionId);
        this.resetDSVersion();
        IMeasureValues originValue = inputRowList.getMeasureValues(rowIndex);
        if (expectOldValue != null && !IMeasureValuesKt.isEqual(expectOldValue, originValue)) {
            this.currentMarkKey.setBaseKeys(inputRowList.get(rowIndex).getKey());
            String string2 = Res.INSTANCE.getInputRowWriterException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-InputRowWriterException_2>(...)");
            Object[] objectArray = new Object[]{this.cubeWorkspace.getMetadata().getName(), this.currentMarkKey.toString(), IMeasureValuesKt.asString(expectOldValue), IMeasureValuesKt.asString(originValue)};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        inputRowList.update$bos_olap_core2(rowIndex, values);
    }

    @Override
    public void addOrUpdate4Redo(int partitionId, @NotNull IDimensionKeys key2, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        InputRowList inputRowList = this.getSubInputRowList(partitionId);
        this.currentMarkKey.setBaseKeys(key2);
        this.resetDSVersion();
        inputRowList.addOrUpdate(this.currentMarkKey, values);
    }

    @Override
    public long getKeyIndex(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        long l = this.partitionWriteCount;
        this.partitionWriteCount = l + 1L;
        PartitionInputRowWriter this_$iv = this;
        boolean $i$f$getMetadata = false;
        int partitionPosition = this_$iv.cubeWorkspace.getMetadata().getPartitionItems().match(key2, this.matchContext);
        long rowIndex = this.getSubInputRowList(key2, partitionPosition).getKeyIndex(this.currentMarkKey);
        return RowIndexUtil.INSTANCE.getRowIndex(partitionPosition, rowIndex);
    }

    @Override
    public void beforeUpdate(long updateIndex) {
        block0: {
            ICubeDataObserver iCubeDataObserver = this.dataObserver;
            if (iCubeDataObserver == null) break block0;
            ICubeDataObserver $this$beforeUpdate_u24lambda_u247 = iCubeDataObserver;
            boolean bl = false;
            this._index = updateIndex;
            $this$beforeUpdate_u24lambda_u247.beforeUpdate();
        }
    }

    @Override
    public void onAdded(long addIndex, @NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ICubeDataObserver iCubeDataObserver = this.dataObserver;
            if (iCubeDataObserver == null) break block0;
            ICubeDataObserver $this$onAdded_u24lambda_u248 = iCubeDataObserver;
            boolean bl = false;
            this.setRowTid(addIndex);
            this._index = addIndex;
            $this$onAdded_u24lambda_u248.onAdded(this.currentMarkKey.getBaseKeys(), value2);
            long l = this.partitionValidWriteCount;
            this.partitionValidWriteCount = l + 1L;
        }
    }

    @Override
    public void onUpdated(long updateIndex, @NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ICubeDataObserver iCubeDataObserver = this.dataObserver;
            if (iCubeDataObserver == null) break block1;
            ICubeDataObserver $this$onUpdated_u24lambda_u249 = iCubeDataObserver;
            boolean bl = false;
            if (!IMeasureValuesKt.allValuesIsIgnoreValue(value2)) {
                this.setRowTid(updateIndex);
                $this$onUpdated_u24lambda_u249.onUpdated(this.currentMarkKey.getBaseKeys(), value2);
                long l = this.partitionValidWriteCount;
                this.partitionValidWriteCount = l + 1L;
            }
        }
    }

    @Override
    public int getCubeId() {
        return this.cubeWorkspace.getCubeId();
    }

    @Override
    public int getPartitionId() {
        return this.currentPartitionPosition;
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public long getGlobalIndex() {
        return RowIndexUtil.INSTANCE.getRowIndex(this.currentPartitionPosition, this._index);
    }

    @Override
    @NotNull
    public IDimensionKeys getKeyInPartition() {
        return this.currentMarkKey;
    }

    @Override
    @NotNull
    public IMeasureValues getOriginalValues() {
        IMeasureValues iMeasureValues;
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this.strategy;
        if (iAddOrUpdateStrategy instanceof LoadOriginalValuesStrategy) {
            iMeasureValues = ((LoadOriginalValuesStrategy)this.strategy).getOriginalValues();
        } else if (iAddOrUpdateStrategy instanceof TransactionStrategy) {
            iMeasureValues = ((TransactionStrategy)this.strategy).getOriginalValues();
        } else {
            throw new NotSupportedException("please set loadOriginalValuesEnabled = true");
        }
        return iMeasureValues;
    }

    private final void submitDataZip(long taskCount) {
        block0: {
            PartitionCubeWorkspace current;
            ICubeMetadataLock metadataLock = this.cubeWorkspace.getMetadataLock();
            PartitionCubeWorkspace partitionCubeWorkspace = current = this.getCurrentCubeWorkspace();
            if (partitionCubeWorkspace == null) break block0;
            PartitionCubeWorkspace $this$submitDataZip_u24lambda_u2410 = partitionCubeWorkspace;
            boolean bl = false;
            $this$submitDataZip_u24lambda_u2410.getResourcePool().getZipTaskExecutor().submit(new RuntimeZipTaskExecutor.ZipTaskContext(this.cubeWorkspace.getHealthReports(), $this$submitDataZip_u24lambda_u2410.getResourcePool(), metadataLock, $this$submitDataZip_u24lambda_u2410.getDataLock()), taskCount);
        }
    }

    @Override
    public void force() {
        block2: {
            this.flushCurrentInputRowList();
            PartitionCubeWorkspace partitionCubeWorkspace = this.getCurrentCubeWorkspace();
            if (partitionCubeWorkspace != null) {
                PartitionCubeWorkspace it = partitionCubeWorkspace;
                boolean bl = false;
                this.refreshInputRowList(it);
            }
            if (!this.hasValidWrite) break block2;
            ICubeDataObserver iCubeDataObserver = this.dataObserver;
            if (iCubeDataObserver != null) {
                iCubeDataObserver.onFlush();
            }
        }
    }

    @Override
    public void close() {
        block0: {
            Closeable closeable = this.currentLock;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    private final void setRowTid(long index2) {
        if (this.getTransaction() == null) {
            return;
        }
        if (index2 != Long.MIN_VALUE) {
            long realIndex = index2 < 0L ? -index2 - 1L : index2;
            this._undoTid = this.getCurrentTidMap().get(realIndex);
            this.getCurrentTidMap().set(realIndex, this.getTransaction().getVersion());
        }
    }

    @Override
    public boolean isRowNeedRollback(int partitionId, long rowIndex, long rollbackTid) {
        this.getSubInputRowList(partitionId);
        return this.getCurrentTidMap().get(rowIndex) == rollbackTid;
    }

    @Override
    public void rollback(int partitionId, long rowIndex, long undoTid, @NotNull IMeasureValues undoValues) {
        Intrinsics.checkNotNullParameter((Object)undoValues, (String)"undoValues");
        InputRowList inputRowList = this.getSubInputRowList(partitionId);
        IMeasureValues newValues = null;
        newValues = undoValues;
        if (this.strategy != null) {
            newValues = this.strategy.modifiedValue(rowIndex, inputRowList.getMeasureValues(rowIndex), undoValues);
        }
        this.beforeUpdate(rowIndex);
        IDimensionKeys key2 = inputRowList.update$bos_olap_core2(rowIndex, newValues);
        this.currentMarkKey.setBaseKeys(new UnMarkDimensionKeys(this.cubeWorkspace.getMetadata(), this.currentPartitionItem, key2));
        this.getCurrentTidMap().set(rowIndex, undoTid);
        this._undoTid = undoTid;
        ICubeDataObserver iCubeDataObserver = this.dataObserver;
        if (iCubeDataObserver != null) {
            ICubeDataObserver $this$rollback_u24lambda_u2412 = iCubeDataObserver;
            boolean bl = false;
            this._index = rowIndex;
            $this$rollback_u24lambda_u2412.onUpdated(this.currentMarkKey.getBaseKeys(), newValues);
            long l = this.partitionValidWriteCount;
            this.partitionValidWriteCount = l + 1L;
        }
        long l = this.partitionWriteCount;
        this.partitionWriteCount = l + 1L;
    }

    @Override
    public long getUndoTid() {
        return this._undoTid;
    }

    @Override
    public boolean addOrUpdate(@NotNull IInputRow row) {
        return IInputRowWriter.DefaultImpls.addOrUpdate(this, row);
    }
}

