/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.BufferedReader;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.collections.NumberToNumberMap;
import kd.bos.olapServer2.common.BoxedBoolean;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.ParallelTaskManager;
import kd.bos.olapServer2.computingEngine.AggShieldRuleFilterBuilder;
import kd.bos.olapServer2.computingEngine.AlwaysFalseDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.AlwaysTrueDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.IDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.StoredFilter;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.dataSources.FixedDimension;
import kd.bos.olapServer2.dataSources.FixedMeasureItem;
import kd.bos.olapServer2.dataSources.IntStringPair;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.ReadonlyStrategy;
import kd.bos.olapServer2.storages.SaveDataValuesIterators;
import kd.bos.olapServer2.storages.SaveIncrementStrategy;
import kd.bos.olapServer2.storages.SaveStrategy;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r0\f\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010&\u001a\u00060'j\u0002`(2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010)\u001a\u00020\u001f2\n\u0010*\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0014\u0010+\u001a\u00060'j\u0002`(2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010,\u001a\u00060'j\u0002`(H\u0002J\u0014\u0010-\u001a\u00060'j\u0002`(2\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u0010.\u001a\u00020/R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0012\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lkd/bos/olapServer2/storages/SaveCommandExecutor;", "", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "saveCommandInfo", "Lkd/bos/olapServer2/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/dataSources/SaveCommandInfo;Ljava/io/BufferedReader;Lkd/bos/olapServer2/transactions/WriteTransaction;)V", "dataValuesList", "", "", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/dataSources/SaveCommandInfo;Ljava/util/Iterator;Lkd/bos/olapServer2/transactions/WriteTransaction;)V", "_resultCount", "", "dataLockFilter", "Lkd/bos/olapServer2/computingEngine/IDimensionKeysFilter;", "dimArray", "Lkd/bos/olapServer2/metadata/Dimension;", "[Lkd/bos/olapServer2/metadata/Dimension;", "fixedMeasureValues", "[Ljava/lang/Object;", "meaArray", "Lkd/bos/olapServer2/metadata/Measure;", "[Lkd/bos/olapServer2/metadata/Measure;", "measureSize", "", "Lkd/bos/olapServer2/common/int;", "numberToMemberMaps", "Lkd/bos/olapServer2/collections/NumberToNumberMap;", "[Lkd/bos/olapServer2/collections/NumberToNumberMap;", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "storedFilter", "Lkd/bos/olapServer2/computingEngine/StoredFilter;", "validFilter", "allowWrite", "", "Lkd/bos/olapServer2/common/bool;", "getNumberToMemberMap", "dimIndex", "isStored", "isUnLock", "isValid", "write", "", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSaveCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveCommandExecutor.kt\nkd/bos/olapServer2/storages/SaveCommandExecutor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,258:1\n26#2:259\n*S KotlinDebug\n*F\n+ 1 SaveCommandExecutor.kt\nkd/bos/olapServer2/storages/SaveCommandExecutor\n*L\n96#1:259\n*E\n"})
public final class SaveCommandExecutor {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final SaveCommandInfo saveCommandInfo;
    @NotNull
    private final Iterator<Object[]> dataValuesList;
    @Nullable
    private final WriteTransaction transaction;
    @NotNull
    private final InputRow row;
    @NotNull
    private final Dimension[] dimArray;
    @NotNull
    private final Measure[] meaArray;
    private final int measureSize;
    @Nullable
    private final StoredFilter storedFilter;
    @NotNull
    private final IDimensionKeysFilter validFilter;
    @NotNull
    private final IDimensionKeysFilter dataLockFilter;
    @Nullable
    private NumberToNumberMap[] numberToMemberMaps;
    @NotNull
    private final Object[] fixedMeasureValues;
    private long _resultCount;

    public SaveCommandExecutor(@NotNull CubeWorkspace cubeWorkspace, @NotNull SaveCommandInfo saveCommandInfo, @NotNull Iterator<Object[]> dataValuesList, @Nullable WriteTransaction transaction) {
        Object object2;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)saveCommandInfo, (String)"saveCommandInfo");
        Intrinsics.checkNotNullParameter(dataValuesList, (String)"dataValuesList");
        this.cubeWorkspace = cubeWorkspace;
        this.saveCommandInfo = saveCommandInfo;
        this.dataValuesList = dataValuesList;
        this.transaction = transaction;
        Cube metadata = this.cubeWorkspace.getMetadata();
        int dimSize = this.saveCommandInfo.getDimensions().size();
        DimensionCollection dims = metadata.getDimensions();
        int allDimSize = metadata.getDimensions().getCount();
        int n2 = 0;
        Dimension[] dimensionArray = new Dimension[dimSize];
        SaveCommandExecutor saveCommandExecutor = this;
        while (n2 < dimSize) {
            int n3 = n2++;
            dimensionArray[n3] = dims.get(this.saveCommandInfo.getDimensions().get(n3));
        }
        saveCommandExecutor.dimArray = dimensionArray;
        this.measureSize = this.saveCommandInfo.getMeasures().size();
        if (this.measureSize <= 0) {
            String string2 = Res.INSTANCE.getSaveCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        MeasureCollection meas = this.cubeWorkspace.getMetadata().getMeasures();
        List list2 = this.saveCommandInfo.getFixedMeasures();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List fixedMeasures = list2;
        HashSet<Measure> measureSet = new HashSet<Measure>();
        int n4 = this.measureSize + fixedMeasures.size();
        Object object3 = new Measure[n4];
        saveCommandExecutor = this;
        for (int i = 0; i < n4; ++i) {
            Measure measure;
            int n5;
            Measure[] measureArray;
            Unit unit;
            Measure it;
            Measure[] measureArray2;
            int n6;
            n = i;
            if (n < this.measureSize) {
                objectArray = meas.get(this.saveCommandInfo.getMeasures().get(n));
                Measure measure2 = (Measure)objectArray;
                n6 = n;
                measureArray2 = object3;
                boolean bl = false;
                if (!measureSet.add(it)) {
                    String string3 = Res.INSTANCE.getSaveCommandExecutorException_10();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-SaveCommandExecutorException_10>(...)");
                    Object[] objectArray2 = new Object[]{it.getName()};
                    throw Res.INSTANCE.getRuntimeException(string3, objectArray2);
                }
                unit = Unit.INSTANCE;
                measureArray = measureArray2;
                n5 = n6;
                measure = (Measure)objectArray;
            } else {
                objectArray = meas.get(((FixedMeasureItem)fixedMeasures.get(n - this.measureSize)).getName());
                it = (Measure)objectArray;
                boolean bl = false;
                if (!measureSet.add(it)) {
                    String string4 = Res.INSTANCE.getSaveCommandExecutorException_10();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-SaveCommandExecutorException_10>(...)");
                    Object[] objectArray3 = new Object[]{it.getName()};
                    throw Res.INSTANCE.getRuntimeException(string4, objectArray3);
                }
                unit = Unit.INSTANCE;
                measureArray = measureArray2;
                n5 = n6;
                measure = (Measure)objectArray;
            }
            measureArray[n5] = measure;
        }
        saveCommandExecutor.meaArray = object3;
        this.row = new InputRow(metadata, new MeasureCollection(this.meaArray, null, 2, null));
        SaveCommandExecutor saveCommandExecutor2 = this;
        if (!((Collection)fixedMeasures).isEmpty()) {
            int i;
            n4 = fixedMeasures.size();
            saveCommandExecutor = saveCommandExecutor2;
            for (i = 0; i < n4; ++i) {
                this.row.setMeasureValue(this.measureSize + i, ((FixedMeasureItem)fixedMeasures.get(i)).getValue());
            }
            i = 0;
            n4 = fixedMeasures.size();
            object3 = new Object[n4];
            while (i < n4) {
                n = i++;
                object3[n] = this.row.getValues().getMeasureValue(this.measureSize + n);
            }
            saveCommandExecutor2 = saveCommandExecutor;
            object2 = object3;
        } else {
            boolean $i$f$emptyArray = false;
            object2 = new Object[]{};
        }
        saveCommandExecutor2.fixedMeasureValues = object2;
        HashSet<Object> dimSet = new HashSet<Object>();
        AggShieldRuleFilterBuilder builder = new AggShieldRuleFilterBuilder(this.cubeWorkspace.getMetadata());
        for (FixedDimension fixDim : this.saveCommandInfo.getFixedDimensions()) {
            String name2 = fixDim.getName();
            Dimension dimension = (Dimension)dims.get(name2);
            Member member = dimension.getMembers().get(fixDim.getValue());
            if (!dimSet.add(dimension)) {
                String string5 = Res.INSTANCE.getSaveCommandExecutorException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-SaveCommandExecutorException_2>(...)");
                Object[] objectArray4 = new Object[]{name2};
                throw Res.INSTANCE.getRuntimeException(string5, objectArray4);
            }
            builder.scanForSave(dimension, member);
            this.row.setDimensionValue(name2, fixDim.getValue());
        }
        for (String dim : this.saveCommandInfo.getDimensions()) {
            if (dimSet.add(dims.get(dim))) continue;
            String string6 = Res.INSTANCE.getSaveCommandExecutorException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-SaveCommandExecutorException_3>(...)");
            objectArray = new Object[]{dim};
            throw Res.INSTANCE.getRuntimeException(string6, objectArray);
        }
        if (dimSet.size() != allDimSize) {
            String string7 = Res.INSTANCE.getSaveCommandExecutorException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-SaveCommandExecutorException_4>(...)");
            object3 = new Object[]{allDimSize};
            throw Res.INSTANCE.getRuntimeException(string7, (Object[])object3);
        }
        this.storedFilter = CommonTypesKt.getDynamicCalcEnabled() ? builder.getStoredFilter() : null;
        this.validFilter = this.cubeWorkspace.getMetadata().getValidDataRules().getValidFilter();
        this.dataLockFilter = this.saveCommandInfo.getIgnoreDataLock() ? (IDimensionKeysFilter)AlwaysFalseDimensionKeysFilter.INSTANCE : this.cubeWorkspace.getMetadata().getCubeDataLockScopes().getDimensionKeysFilter();
    }

    public /* synthetic */ SaveCommandExecutor(CubeWorkspace cubeWorkspace, SaveCommandInfo saveCommandInfo, Iterator iterator2, WriteTransaction writeTransaction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            writeTransaction = null;
        }
        this(cubeWorkspace, saveCommandInfo, iterator2, writeTransaction);
    }

    public SaveCommandExecutor(@NotNull CubeWorkspace cubeWorkspace, @NotNull SaveCommandInfo saveCommandInfo, @NotNull BufferedReader reader, @Nullable WriteTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)saveCommandInfo, (String)"saveCommandInfo");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this(cubeWorkspace, saveCommandInfo, SaveDataValuesIterators.INSTANCE.createDataValuesIterator$bos_olap_core2(cubeWorkspace.getMetadata(), saveCommandInfo, reader), transaction);
    }

    public /* synthetic */ SaveCommandExecutor(CubeWorkspace cubeWorkspace, SaveCommandInfo saveCommandInfo, BufferedReader bufferedReader, WriteTransaction writeTransaction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            writeTransaction = null;
        }
        this(cubeWorkspace, saveCommandInfo, bufferedReader, writeTransaction);
    }

    private final NumberToNumberMap getNumberToMemberMap(int dimIndex) {
        NumberToNumberMap[] maps = this.numberToMemberMaps;
        if (maps == null) {
            int n = 0;
            int n2 = this.dimArray.length;
            NumberToNumberMap[] numberToNumberMapArray = new NumberToNumberMap[n2];
            while (n < n2) {
                int n3 = n++;
                Dimension dim = this.dimArray[n3];
                numberToNumberMapArray[n3] = new NumberToNumberMap(arg_0 -> SaveCommandExecutor.getNumberToMemberMap$lambda$2(dim, arg_0));
            }
            this.numberToMemberMaps = maps = numberToNumberMapArray;
        }
        return maps[dimIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write() {
        StandardCommandStatistics.INSTANCE.reportTimeState(CommandStatisticsItem.Companion.getWriting());
        BoxedBoolean isFixedMeasureChanged = new BoxedBoolean();
        IAddOrUpdateStrategy<IMeasureValues> saveStrategy = ReadonlyStrategy.Companion.withReadonlyStrategy(this.saveCommandInfo.isIncrement() ? (IAddOrUpdateStrategy)new SaveIncrementStrategy(this.row, this.measureSize, this.meaArray, isFixedMeasureChanged) : (IAddOrUpdateStrategy)new SaveStrategy(this.row, this.measureSize, this.meaArray, isFixedMeasureChanged), this.row, this.cubeWorkspace.getMetadata(), this.meaArray, this.measureSize);
        Closeable closeable = CubeWorkspace.createWriter$default(this.cubeWorkspace, saveStrategy, this.transaction, null, 4, null);
        Throwable throwable = null;
        try {
            Object object2;
            IInputRowWriter writer = (IInputRowWriter)closeable;
            boolean bl = false;
            try {
                IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                object2 = this.dataValuesList;
                while (object2.hasNext()) {
                    int i;
                    int n;
                    Object[] values = object2.next();
                    if (!continueToken.canContinue()) {
                        break;
                    }
                    if (this.dimArray.length + this.measureSize != values.length) {
                        String string2 = Res.INSTANCE.getSaveCommandExecutorException_5();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_5>(...)");
                        Object[] objectArray = new Object[]{this.dimArray.length, this.measureSize, values.length};
                        throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                    }
                    Dimension[] dimensionArray = this.dimArray;
                    int n2 = dimensionArray.length;
                    for (n = 0; n < n2; ++n) {
                        i = n;
                        Dimension dim = dimensionArray[n];
                        Object value2 = values[this.measureSize + i];
                        if (value2 instanceof Integer) {
                            this.row.setDimensionValue(dim.getPosition(), this.getNumberToMemberMap(i).map(((Number)value2).intValue()));
                            continue;
                        }
                        if (value2 instanceof IntStringPair) {
                            this.row.setDimensionValue(dim.getPosition(), this.getNumberToMemberMap(i).map(((IntStringPair)value2).getNumber(), ((IntStringPair)value2).getValue()));
                            continue;
                        }
                        if (value2 instanceof String) {
                            this.row.setDimensionValue(dim.getPosition(), this.getNumberToMemberMap(i).map((String)value2));
                            continue;
                        }
                        if (value2 instanceof Member) {
                            this.row.setDimensionValue(dim, (Member)value2);
                            continue;
                        }
                        throw new NotSupportedException();
                    }
                    n = this.measureSize;
                    for (int it = 0; it < n; ++it) {
                        Object currentValue = values[it];
                        this.row.setMeasureValue(it, currentValue);
                    }
                    if (isFixedMeasureChanged.getValue()) {
                        Object[] it = this.fixedMeasureValues;
                        int currentValue = it.length;
                        for (n = 0; n < currentValue; ++n) {
                            i = n;
                            Object fixedValue = it[n];
                            this.row.directSetMeasureValue(this.measureSize + i, fixedValue);
                        }
                        isFixedMeasureChanged.setValue(false);
                    }
                    if (!this.allowWrite(this.row)) continue;
                    writer.addOrUpdate(this.row.getKeys(), this.row.getValues());
                    long l = this._resultCount;
                    this._resultCount = l + 1L;
                }
            }
            finally {
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                object2 = ptm;
                Throwable throwable2 = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)object2;
                    boolean bl2 = false;
                    writer.force();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        StandardCommandStatistics.INSTANCE.reportTimeState(CommandStatisticsItem.Companion.getFinishing());
    }

    private final boolean allowWrite(InputRow row) {
        return this.isStored(row) & this.isValid(row) & this.isUnLock();
    }

    private final boolean isUnLock() {
        boolean isLock = this.dataLockFilter.match(this.row.getKeys());
        if (isLock && this.saveCommandInfo.getDisallowLockData()) {
            String string2 = Res.INSTANCE.getSaveCommandExecutorException_11();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_11>(...)");
            Object[] objectArray = new Object[]{this.row};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return !isLock;
    }

    private final boolean isStored(InputRow row) {
        boolean storedMatch;
        boolean bl = storedMatch = this.storedFilter == null || this.storedFilter.match(row.getKeys());
        if (!storedMatch && this.saveCommandInfo.getDisallowDynamicData()) {
            String string2 = Res.INSTANCE.getSaveCommandExecutorException_8();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_8>(...)");
            Object[] objectArray = new Object[]{row};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return storedMatch;
    }

    private final boolean isValid(InputRow row) {
        boolean validFilterMatch;
        boolean bl = validFilterMatch = this.validFilter == AlwaysTrueDimensionKeysFilter.INSTANCE || this.validFilter.match(row.getKeys());
        if (!validFilterMatch && this.saveCommandInfo.getDisallowInvalidData()) {
            String string2 = Res.INSTANCE.getSaveCommandExecutorException_9();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_9>(...)");
            Object[] objectArray = new Object[]{row};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return validFilterMatch;
    }

    private static final int getNumberToMemberMap$lambda$2(Dimension $dim, String memberName) {
        Intrinsics.checkNotNullParameter((Object)$dim, (String)"$dim");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return $dim.getMembers().getOrAddSimpleMember(memberName, true);
    }
}

