/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import kd.bos.olapServer2.dataSources.ArrayJsonReader;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.dataSources.SaveCommandInfoV1;
import kd.bos.olapServer2.dataSources.SaveCommandInfoV2;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.OlapDataTypes;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/storages/SaveDataValuesIterators;", "", "()V", "createDataValuesIterator", "", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "saveCommandInfo", "Lkd/bos/olapServer2/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "createDataValuesIterator$bos_olap_core2", "getDataTypes", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "cmd", "(Lkd/bos/olapServer2/dataSources/SaveCommandInfo;Lkd/bos/olapServer2/metadata/Cube;)[Lkd/bos/olapServer2/metadata/OlapDataTypes;", "DataValuesIteratorV1", "DataValuesIteratorV2", "DataValuesIteratorV3", "bos-olap-core2"})
public final class SaveDataValuesIterators {
    @NotNull
    public static final SaveDataValuesIterators INSTANCE = new SaveDataValuesIterators();

    private SaveDataValuesIterators() {
    }

    @NotNull
    public final Iterator<Object[]> createDataValuesIterator$bos_olap_core2(@NotNull Cube cube, @NotNull SaveCommandInfo saveCommandInfo, @NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)saveCommandInfo, (String)"saveCommandInfo");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        OlapDataTypes[] types = this.getDataTypes(saveCommandInfo, cube);
        SaveCommandInfo saveCommandInfo2 = saveCommandInfo;
        return saveCommandInfo2 instanceof SaveCommandInfoV1 ? (Iterator)new DataValuesIteratorV1(reader, types) : (saveCommandInfo2 instanceof SaveCommandInfoV2 ? (Iterator)new DataValuesIteratorV2(reader, types) : (Iterator)new DataValuesIteratorV3(reader, types));
    }

    private final OlapDataTypes[] getDataTypes(SaveCommandInfo cmd, Cube cube) {
        MeasureCollection meas = cube.getMeasures();
        int measureSize = cmd.getMeasures().size();
        int n = measureSize + cmd.getDimensions().size();
        OlapDataTypes[] olapDataTypesArray = new OlapDataTypes[n];
        for (int i = 0; i < n; ++i) {
            OlapDataTypes olapDataTypes;
            int n2;
            int n3 = n2 = i;
            OlapDataTypes[] olapDataTypesArray2 = olapDataTypesArray;
            if (n2 < measureSize) {
                Measure mea = (Measure)meas.get(cmd.getMeasures().get(n2));
                olapDataTypes = mea.getDataType();
            } else {
                olapDataTypes = OlapDataTypes.string;
            }
            olapDataTypesArray2[n3] = olapDataTypes;
        }
        return olapDataTypesArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/storages/SaveDataValuesIterators$DataValuesIteratorV1;", "", "", "", "br", "Ljava/io/BufferedReader;", "valueTypes", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "(Ljava/io/BufferedReader;[Lkd/bos/olapServer2/metadata/OlapDataTypes;)V", "line", "", "[Lkd/bos/olapServer2/metadata/OlapDataTypes;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core2"})
    private static final class DataValuesIteratorV1
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final BufferedReader br;
        @NotNull
        private final OlapDataTypes[] valueTypes;
        @NotNull
        private final Object[] values;
        @NotNull
        private String line;

        public DataValuesIteratorV1(@NotNull BufferedReader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.br = br;
            this.valueTypes = valueTypes;
            this.values = new Object[this.valueTypes.length];
            this.line = "";
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            String newLine = this.br.readLine();
            if (newLine != null) {
                this.line = newLine;
                bl = true;
            } else {
                this.line = "";
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Object[] next() {
            String line2 = this.line;
            try {
                StringReader sr = new StringReader(line2);
                int p1 = StringsKt.indexOf$default((CharSequence)line2, (String)"{\"dataValues\":", (int)0, (boolean)false, (int)6, null);
                if (p1 >= 0) {
                    sr.skip(p1 + 14);
                }
                Closeable closeable = sr;
                Throwable throwable = null;
                try {
                    StringReader it = (StringReader)closeable;
                    boolean bl = false;
                    ArrayJsonReader reader = new ArrayJsonReader(this.valueTypes, sr, 1);
                    if (reader.next()) {
                        reader.read(this.values);
                    }
                    Object[] objectArray = this.values;
                    return objectArray;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                String string2 = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_6>(...)");
                Object[] objectArray = new Object[]{line2, e.getMessage()};
                throw Res.INSTANCE.getRuntimeException(string2, e, objectArray);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/storages/SaveDataValuesIterators$DataValuesIteratorV2;", "", "", "", "br", "Ljava/io/Reader;", "valueTypes", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "(Ljava/io/Reader;[Lkd/bos/olapServer2/metadata/OlapDataTypes;)V", "lineCount", "", "reader", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core2"})
    private static final class DataValuesIteratorV2
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final ArrayJsonReader reader;
        @NotNull
        private final Object[] values;
        private int lineCount;

        public DataValuesIteratorV2(@NotNull Reader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.reader = new ArrayJsonReader(valueTypes, br, 1);
            this.values = new Object[valueTypes.length];
        }

        @Override
        public boolean hasNext() {
            try {
                int n = this.lineCount;
                this.lineCount = n + 1;
                return this.reader.next() ? this.reader.read(this.values) : false;
            }
            catch (Exception e) {
                String string2 = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_6>(...)");
                Object[] objectArray = new Object[]{this.lineCount - 1, e.getMessage()};
                throw new RuntimeException(Res.INSTANCE.format(string2, objectArray), e);
            }
        }

        @Override
        @NotNull
        public Object[] next() {
            return this.values;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/storages/SaveDataValuesIterators$DataValuesIteratorV3;", "", "", "", "br", "Ljava/io/Reader;", "valueTypes", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "(Ljava/io/Reader;[Lkd/bos/olapServer2/metadata/OlapDataTypes;)V", "lineCount", "", "reader", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core2"})
    private static final class DataValuesIteratorV3
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final ArrayJsonReader reader;
        @NotNull
        private final Object[] values;
        private int lineCount;

        public DataValuesIteratorV3(@NotNull Reader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.reader = new ArrayJsonReader(valueTypes, br, 0, 4, null);
            this.values = new Object[valueTypes.length];
        }

        @Override
        public boolean hasNext() {
            try {
                int n = this.lineCount;
                this.lineCount = n + 1;
                return this.reader.next() ? this.reader.read(this.values) : false;
            }
            catch (Exception e) {
                String string2 = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SaveCommandExecutorException_6>(...)");
                Object[] objectArray = new Object[]{this.lineCount - 1, e.getMessage()};
                throw Res.INSTANCE.getRuntimeException(string2, e, objectArray);
            }
        }

        @Override
        @NotNull
        public Object[] next() {
            return this.values;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

