/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.common.BoxedBoolean;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.metadata.Measure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00022\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/storages/SaveStrategy;", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "measureSize", "", "Lkd/bos/olapServer2/common/int;", "meaArray", "", "Lkd/bos/olapServer2/metadata/Measure;", "isFixedMeasureChanged", "Lkd/bos/olapServer2/common/BoxedBoolean;", "(Lkd/bos/olapServer2/dataEntities/InputRow;I[Lkd/bos/olapServer2/metadata/Measure;Lkd/bos/olapServer2/common/BoxedBoolean;)V", "[Lkd/bos/olapServer2/metadata/Measure;", "allowAdd", "", "Lkd/bos/olapServer2/common/bool;", "modifiedValue", "index", "", "Lkd/bos/olapServer2/common/rowIdx;", "originalValue", "newValue", "bos-olap-core2"})
public final class SaveStrategy
implements IAddOrUpdateStrategy<IMeasureValues> {
    @NotNull
    private final InputRow row;
    private final int measureSize;
    @NotNull
    private final Measure[] meaArray;
    @NotNull
    private final BoxedBoolean isFixedMeasureChanged;

    public SaveStrategy(@NotNull InputRow row, int measureSize, @NotNull Measure[] meaArray, @NotNull BoxedBoolean isFixedMeasureChanged) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)meaArray, (String)"meaArray");
        Intrinsics.checkNotNullParameter((Object)isFixedMeasureChanged, (String)"isFixedMeasureChanged");
        this.row = row;
        this.measureSize = measureSize;
        this.meaArray = meaArray;
        this.isFixedMeasureChanged = isFixedMeasureChanged;
    }

    @Override
    public boolean allowAdd() {
        int n = this.measureSize;
        for (int effectiveMeasureIndex = 0; effectiveMeasureIndex < n; ++effectiveMeasureIndex) {
            Object value2 = this.row.getValues().getMeasureValue(effectiveMeasureIndex);
            if (value2 == CommonTypesKt.getIgnoreValue() || value2 == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public IMeasureValues modifiedValue(long index2, @NotNull IMeasureValues originalValue, @NotNull IMeasureValues newValue) {
        Intrinsics.checkNotNullParameter((Object)originalValue, (String)"originalValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        boolean hasAnyValid = false;
        int n = this.measureSize;
        for (int effectiveMeasureIndex = 0; effectiveMeasureIndex < n; ++effectiveMeasureIndex) {
            Object newMeasure = newValue.getMeasureValue(effectiveMeasureIndex);
            if (newMeasure == CommonTypesKt.getIgnoreValue()) continue;
            Object oldMeasure = originalValue.getMeasureValue(newValue.getMeasureIndex(effectiveMeasureIndex));
            if (DragonEngine.Companion.valueEquals(newMeasure, oldMeasure)) {
                this.row.setMeasureValue(effectiveMeasureIndex, CommonTypesKt.getIgnoreValue());
                continue;
            }
            hasAnyValid = true;
        }
        if (!hasAnyValid && this.measureSize < this.meaArray.length) {
            n = this.meaArray.length;
            for (int i = this.measureSize; i < n; ++i) {
                this.row.setMeasureValue(i, CommonTypesKt.getIgnoreValue());
            }
            this.isFixedMeasureChanged.setValue(true);
        }
        return newValue;
    }

    @Override
    @NotNull
    public IMeasureValues addedValue(long index2, @NotNull IMeasureValues newValue) {
        return IAddOrUpdateStrategy.DefaultImpls.addedValue(this, index2, newValue);
    }
}

