/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u000e\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u000e\u001a\u00060\u0006j\u0002`\u0007H\u0016R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/storages/StaticMeasureValueCollectionProxy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "currentMeasures", "effectiveMeasurePositions", "", "count", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/dataEntities/IMeasureValues;[II)V", "getCount", "()I", "getCurrentMeasures", "()Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "getMeasureIndex", "effectiveMeasureIndex", "getMeasureValue", "", "bos-olap-core2"})
public final class StaticMeasureValueCollectionProxy
implements IMeasureValues {
    @NotNull
    private final IMeasureValues currentMeasures;
    @NotNull
    private final int[] effectiveMeasurePositions;
    private final int count;

    public StaticMeasureValueCollectionProxy(@NotNull IMeasureValues currentMeasures, @NotNull int[] effectiveMeasurePositions, int count) {
        Intrinsics.checkNotNullParameter((Object)currentMeasures, (String)"currentMeasures");
        Intrinsics.checkNotNullParameter((Object)effectiveMeasurePositions, (String)"effectiveMeasurePositions");
        this.currentMeasures = currentMeasures;
        this.effectiveMeasurePositions = effectiveMeasurePositions;
        this.count = count;
        if (!(this.effectiveMeasurePositions.length == this.currentMeasures.getCount())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final IMeasureValues getCurrentMeasures() {
        return this.currentMeasures;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    @Nullable
    public Object getMeasureValue(int effectiveMeasureIndex) {
        if (!(0 <= effectiveMeasureIndex ? effectiveMeasureIndex < this.getCount() : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int realIndex = ArraysKt.indexOf((int[])this.effectiveMeasurePositions, (int)effectiveMeasureIndex);
        return realIndex == -1 ? CommonTypesKt.getIgnoreValue() : this.currentMeasures.getMeasureValue(realIndex);
    }

    @Override
    public int getMeasureIndex(int effectiveMeasureIndex) {
        if (!(0 <= effectiveMeasureIndex ? effectiveMeasureIndex < this.getCount() : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return effectiveMeasureIndex;
    }

    @Override
    public int getFirstMeasureIndex() {
        return IMeasureValues.DefaultImpls.getFirstMeasureIndex(this);
    }

    @Override
    @Nullable
    public Object getFirstMeasureValue() {
        return IMeasureValues.DefaultImpls.getFirstMeasureValue(this);
    }
}

