/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.bitmapIndexes;

import java.util.Iterator;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinMutableBitmap;
import kd.bos.olapServer2.metadata.dependencies.IDependencyDiagram;
import kd.bos.olapServer2.storages.bitmapIndexes.MemoryBitmapSegment;
import kd.bos.olapServer2.storages.bitmapIndexes.WriterArrayPool;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\"\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R \u0010\u0007\u001a\u0014\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/DimensionBitmapIndexesWriter;", "", "memberSize", "", "Lkd/bos/olapServer2/common/int;", "memberDependencies", "Lkd/bos/olapServer2/metadata/dependencies/IDependencyDiagram;", "getBitmap", "Lkotlin/Function1;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinMutableBitmap;", "(ILkd/bos/olapServer2/metadata/dependencies/IDependencyDiagram;Lkotlin/jvm/functions/Function1;)V", "getMemberSize", "()I", "add", "", "rowIndex", "", "Lkd/bos/olapServer2/common/rowIdx;", "values", "", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "collectDirtyFlags", "bitmapSegments", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "dirtyFlags", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$DirtyCollection;", "putToFile", "bitmapIndex", "updateDependencyBitmap", "bos-olap-core2"})
public final class DimensionBitmapIndexesWriter {
    private final int memberSize;
    @NotNull
    private final IDependencyDiagram<?> memberDependencies;
    @NotNull
    private final Function1<Integer, IMinMutableBitmap> getBitmap;

    public DimensionBitmapIndexesWriter(int memberSize, @NotNull IDependencyDiagram<?> memberDependencies, @NotNull Function1<? super Integer, ? extends IMinMutableBitmap> getBitmap) {
        Intrinsics.checkNotNullParameter(memberDependencies, (String)"memberDependencies");
        Intrinsics.checkNotNullParameter(getBitmap, (String)"getBitmap");
        this.memberSize = memberSize;
        this.memberDependencies = memberDependencies;
        this.getBitmap = getBitmap;
    }

    public final int getMemberSize() {
        return this.memberSize;
    }

    public final void add(long rowIndex, @NotNull int[] values, @NotNull WriterArrayPool arrayPool) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
        if (!(values.length == 65536)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long bitmapIndex = rowIndex >>> 6;
        WriterArrayPool.BitmapCache bitmapSegmentCache = arrayPool.createBitmapCache(this.memberSize);
        int i = 0;
        int n = values.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)16384);
        if (i <= n2) {
            while (true) {
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)i, (int)(i + 16384))), (int)64);
                int j = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                if (n4 > 0 && j <= n3 || n4 < 0 && n3 <= j) {
                    while (true) {
                        bitmapSegmentCache.put64Values(values, j);
                        if (j == n3) break;
                        j += n4;
                    }
                }
                this.updateDependencyBitmap(bitmapSegmentCache);
                this.putToFile(bitmapIndex, bitmapSegmentCache);
                bitmapIndex += (long)256;
                if (i == n2) break;
                i += 16384;
            }
        }
        bitmapSegmentCache.release();
    }

    private final void putToFile(long bitmapIndex, WriterArrayPool.BitmapCache bitmapSegments) {
        bitmapSegments.getBitmaps().foreach((arg_0, arg_1) -> DimensionBitmapIndexesWriter.putToFile$lambda$0(this, bitmapIndex, arg_0, arg_1));
        bitmapSegments.reset();
    }

    private final void updateDependencyBitmap(WriterArrayPool.BitmapCache bitmapSegments) {
        WriterArrayPool.LevelDirtyCollection dirtyLevels = bitmapSegments.getDirtyLevels();
        WriterArrayPool.DirtyCollection currentDirtyFlags = dirtyLevels.getDirtyLevel(0);
        int levelIndex = 0;
        this.collectDirtyFlags(bitmapSegments, currentDirtyFlags);
        while (true) {
            int dirtySize = currentDirtyFlags.getSize();
            int[] dirtyItems = currentDirtyFlags.getDirtyItems();
            for (int i = 0; i < dirtySize; ++i) {
                int dirtyMemberIndex = dirtyItems[i];
                MemoryBitmapSegment bitmap2 = bitmapSegments.getOrCreateBitmap(dirtyMemberIndex);
                if (bitmap2.isMerged()) continue;
                Object[] dependencies = this.memberDependencies.getParents(dirtyMemberIndex);
                if (dependencies != null) {
                    Iterator iterator2 = ArrayIteratorKt.iterator((Object[])dependencies);
                    while (iterator2.hasNext()) {
                        IDependencyDiagram.INode node = (IDependencyDiagram.INode)iterator2.next();
                        bitmapSegments.getOrCreateBitmap(node.getId()).or(bitmap2);
                        dirtyLevels.setDirty(node.getLevel(), node.getId());
                    }
                }
                bitmap2.setMerged(true);
            }
            currentDirtyFlags.clear();
            if (++levelIndex > dirtyLevels.getMaxDirtyLevelIndex()) break;
            currentDirtyFlags = dirtyLevels.getDirtyLevel(levelIndex);
        }
        dirtyLevels.clear();
    }

    private final void collectDirtyFlags(WriterArrayPool.BitmapCache bitmapSegments, WriterArrayPool.DirtyCollection dirtyFlags) {
        bitmapSegments.getBitmaps().foreach((arg_0, arg_1) -> DimensionBitmapIndexesWriter.collectDirtyFlags$lambda$1(dirtyFlags, arg_0, arg_1));
    }

    private static final void putToFile$lambda$0(DimensionBitmapIndexesWriter this$0, long $bitmapIndex, int memberIndex, MemoryBitmapSegment bitmapSegment) {
        block0: {
            IMinMutableBitmap bitmap2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)bitmapSegment, (String)"bitmapSegment");
            IMinMutableBitmap iMinMutableBitmap = bitmap2 = (IMinMutableBitmap)this$0.getBitmap.invoke((Object)memberIndex);
            if (iMinMutableBitmap == null) break block0;
            iMinMutableBitmap.update($bitmapIndex, bitmapSegment.getValues(), bitmapSegment.getDirtyFlags());
        }
    }

    private static final void collectDirtyFlags$lambda$1(WriterArrayPool.DirtyCollection $dirtyFlags, int i, MemoryBitmapSegment memoryBitmapSegment) {
        Intrinsics.checkNotNullParameter((Object)$dirtyFlags, (String)"$dirtyFlags");
        Intrinsics.checkNotNullParameter((Object)memoryBitmapSegment, (String)"<anonymous parameter 1>");
        $dirtyFlags.setDirty(i);
    }
}

