/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.bitmapIndexes;

import java.util.Arrays;
import java.util.BitSet;
import kd.bos.olapServer2.collections.IImmutableList;
import kd.bos.olapServer2.collections.IntMaps;
import kd.bos.olapServer2.collections.UnThreadSafeObjectPools;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.storages.bitmapIndexes.MemoryBitmapSegment;
import kd.bos.olapServer2.storages.bitmapIndexes.WriterArrayPool;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0005\u001d\u001e\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0018j\u0002`\u0019R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "", "()V", "bigDirtyPool", "Lkd/bos/olapServer2/collections/UnThreadSafeObjectPools$ObjectPool;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$DirtyCollection;", "columnsCache", "Lkd/bos/olapServer2/collections/UnThreadSafeObjectPools$ArrayCache;", "", "", "dirtyLevelsPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection;", "lastValuesCache", "", "segmentsArrayPool", "Lkd/bos/olapServer2/collections/IntMaps$ArrayIntMap;", "Lkd/bos/olapServer2/storages/bitmapIndexes/MemoryBitmapSegment;", "segmentsCache", "veryBigLastValuePool", "", "Lkd/bos/olapServer2/common/long;", "createBitmapCache", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "membersSize", "", "Lkd/bos/olapServer2/common/int;", "createSegmentCellSetCache", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$SegmentCellSetCache;", "dimensionCount", "BitmapCache", "Companion", "DirtyCollection", "LevelDirtyCollection", "SegmentCellSetCache", "bos-olap-core2"})
public final class WriterArrayPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnThreadSafeObjectPools.ArrayCache<long[]> lastValuesCache = UnThreadSafeObjectPools.INSTANCE.createLongArrayCache();
    @NotNull
    private final UnThreadSafeObjectPools.ObjectPool<IntMaps.ArrayIntMap<MemoryBitmapSegment>> segmentsArrayPool = new UnThreadSafeObjectPools.ObjectPool(3, segmentsArrayPool.1.INSTANCE);
    @NotNull
    private final UnThreadSafeObjectPools.ObjectPool<MemoryBitmapSegment> segmentsCache = new UnThreadSafeObjectPools.ObjectPool(65536, segmentsCache.1.INSTANCE);
    @NotNull
    private final UnThreadSafeObjectPools.ObjectPool<LevelDirtyCollection> dirtyLevelsPool = new UnThreadSafeObjectPools.ObjectPool(3, dirtyLevelsPool.1.INSTANCE);
    @NotNull
    private final UnThreadSafeObjectPools.ObjectPool<IntMaps.ArrayIntMap<Long>> veryBigLastValuePool = new UnThreadSafeObjectPools.ObjectPool(3, veryBigLastValuePool.1.INSTANCE);
    @NotNull
    private final UnThreadSafeObjectPools.ObjectPool<DirtyCollection> bigDirtyPool = new UnThreadSafeObjectPools.ObjectPool(3, bigDirtyPool.1.INSTANCE);
    @NotNull
    private final UnThreadSafeObjectPools.ArrayCache<int[][]> columnsCache = UnThreadSafeObjectPools.INSTANCE.createSegmentIntArrayCache();
    @NotNull
    private static final ThreadLocal<WriterArrayPool> threadCache = new ThreadLocal();

    @NotNull
    public final BitmapCache createBitmapCache(int membersSize) {
        if (!(membersSize >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return membersSize < 65536 ? (BitmapCache)new BitmapCache.SmallArrayBitmapCache(membersSize, this) : (membersSize < 0x800000 ? (BitmapCache)new BitmapCache.BigArrayBitmapCache(membersSize, this) : (BitmapCache)new BitmapCache.VeryBigBitmapCache(membersSize, this));
    }

    @NotNull
    public final SegmentCellSetCache createSegmentCellSetCache(int dimensionCount) {
        return new SegmentCellSetCache(dimensionCount, this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u001f !B\u001b\b\u0004\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0016\u001a\u00020\n2\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H&J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "", "membersSize", "", "Lkd/bos/olapServer2/common/int;", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "(ILkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;)V", "_bitmaps", "Lkd/bos/olapServer2/collections/IntMaps$ArrayIntMap;", "Lkd/bos/olapServer2/storages/bitmapIndexes/MemoryBitmapSegment;", "getArrayPool", "()Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "bitmaps", "getBitmaps", "()Lkd/bos/olapServer2/collections/IntMaps$ArrayIntMap;", "dirtyLevels", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection;", "getDirtyLevels", "()Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection;", "getMembersSize", "()I", "getOrCreateBitmap", "memberIndex", "put64Values", "", "values", "", "start", "release", "reset", "BigArrayBitmapCache", "SmallArrayBitmapCache", "VeryBigBitmapCache", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$BigArrayBitmapCache;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$SmallArrayBitmapCache;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$VeryBigBitmapCache;", "bos-olap-core2"})
    public static abstract class BitmapCache {
        private final int membersSize;
        @NotNull
        private final WriterArrayPool arrayPool;
        @NotNull
        private final LevelDirtyCollection dirtyLevels;
        @NotNull
        private IntMaps.ArrayIntMap<MemoryBitmapSegment> _bitmaps;

        private BitmapCache(int membersSize, WriterArrayPool arrayPool) {
            this.membersSize = membersSize;
            this.arrayPool = arrayPool;
            this.dirtyLevels = (LevelDirtyCollection)this.arrayPool.dirtyLevelsPool.create();
            this._bitmaps = (IntMaps.ArrayIntMap)this.arrayPool.segmentsArrayPool.create();
        }

        protected final int getMembersSize() {
            return this.membersSize;
        }

        @NotNull
        protected final WriterArrayPool getArrayPool() {
            return this.arrayPool;
        }

        @NotNull
        public final LevelDirtyCollection getDirtyLevels() {
            return this.dirtyLevels;
        }

        public abstract void put64Values(@NotNull int[] var1, int var2);

        @NotNull
        public final IntMaps.ArrayIntMap<MemoryBitmapSegment> getBitmaps() {
            return this._bitmaps;
        }

        public void reset() {
            this._bitmaps.foreach((arg_0, arg_1) -> BitmapCache.reset$lambda$0(this, arg_0, arg_1));
            this._bitmaps.clear();
            this.dirtyLevels.clear();
        }

        @NotNull
        public final MemoryBitmapSegment getOrCreateBitmap(int memberIndex) {
            MemoryBitmapSegment bitmap2 = this._bitmaps.get(memberIndex);
            if (bitmap2 == null) {
                bitmap2 = (MemoryBitmapSegment)this.arrayPool.segmentsCache.create();
                this._bitmaps = this._bitmaps.addOrUpdate(memberIndex, bitmap2);
            }
            return bitmap2;
        }

        public void release() {
            this.arrayPool.dirtyLevelsPool.release(this.dirtyLevels);
            this.arrayPool.segmentsArrayPool.release(this._bitmaps);
        }

        private static final void reset$lambda$0(BitmapCache this$0, int n, MemoryBitmapSegment bitmap2) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
            bitmap2.clear();
            this$0.arrayPool.segmentsCache.release(bitmap2);
        }

        public /* synthetic */ BitmapCache(int membersSize, WriterArrayPool arrayPool, DefaultConstructorMarker $constructor_marker) {
            this(membersSize, arrayPool);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$BigArrayBitmapCache;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "membersSize", "", "Lkd/bos/olapServer2/common/int;", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "(ILkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;)V", "_dirtyMembers", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$DirtyCollection;", "lastValues", "", "longIndex", "put64Values", "", "values", "", "start", "putAndResetLastValues", "release", "reset", "bos-olap-core2"})
        public static final class BigArrayBitmapCache
        extends BitmapCache {
            @NotNull
            private final long[] lastValues;
            @NotNull
            private final DirtyCollection _dirtyMembers;
            private int longIndex;

            public BigArrayBitmapCache(int membersSize, @NotNull WriterArrayPool arrayPool) {
                Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
                super(membersSize, arrayPool, null);
                this.lastValues = (long[])arrayPool.lastValuesCache.createArray(membersSize);
                this._dirtyMembers = (DirtyCollection)arrayPool.bigDirtyPool.create();
            }

            @Override
            public void put64Values(@NotNull int[] values, int start) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                for (int remCount = 0; remCount < 64; ++remCount) {
                    int memberIndex = values[start + remCount];
                    this.lastValues[memberIndex] = this.lastValues[memberIndex] | 1L << remCount;
                    this._dirtyMembers.setDirty(memberIndex);
                }
                this.putAndResetLastValues();
            }

            private final void putAndResetLastValues() {
                int[] dirtyMembers = this._dirtyMembers.getDirtyItems();
                int dirtyArraySize = this._dirtyMembers.getSize();
                for (int j = 0; j < dirtyArraySize; ++j) {
                    int i = dirtyMembers[j];
                    if (this.lastValues[i] == 0L) continue;
                    MemoryBitmapSegment bitmap2 = this.getOrCreateBitmap(i);
                    bitmap2.set(this.longIndex, this.lastValues[i]);
                    this.lastValues[i] = 0L;
                }
                this._dirtyMembers.clear();
                int n = this.longIndex;
                this.longIndex = n + 1;
            }

            @Override
            public void reset() {
                if (!(this.longIndex == 256)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (this.longIndex != 256) {
                    int n = this.getMembersSize();
                    for (int i = 0; i < n; ++i) {
                        this.lastValues[i] = 0L;
                    }
                    this._dirtyMembers.clear();
                }
                this.longIndex = 0;
                super.reset();
            }

            @Override
            public void release() {
                if (this.longIndex > 0) {
                    this.reset();
                }
                this.longIndex = -1;
                this.getArrayPool().lastValuesCache.release(this.lastValues);
                this.getArrayPool().bigDirtyPool.release(this._dirtyMembers);
                super.release();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u0016J \u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$SmallArrayBitmapCache;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "membersSize", "", "Lkd/bos/olapServer2/common/int;", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "(ILkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;)V", "lastValues", "", "longIndex", "put64Values", "", "values", "", "start", "putAndResetLastValues", "minMemberIndex", "maxMemberIndex", "release", "reset", "bos-olap-core2"})
        public static final class SmallArrayBitmapCache
        extends BitmapCache {
            @NotNull
            private final long[] lastValues;
            private int longIndex;

            public SmallArrayBitmapCache(int membersSize, @NotNull WriterArrayPool arrayPool) {
                Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
                super(membersSize, arrayPool, null);
                this.lastValues = (long[])arrayPool.lastValuesCache.createArray(membersSize);
            }

            @Override
            public void put64Values(@NotNull int[] values, int start) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                int maxMemberIndex = -1;
                int minMemberIndex = Integer.MAX_VALUE;
                for (int remCount = 0; remCount < 64; ++remCount) {
                    int memberIndex = values[start + remCount];
                    maxMemberIndex = Math.max(maxMemberIndex, memberIndex);
                    minMemberIndex = Math.min(minMemberIndex, memberIndex);
                    this.lastValues[memberIndex] = this.lastValues[memberIndex] | 1L << remCount;
                }
                this.putAndResetLastValues(minMemberIndex, maxMemberIndex);
            }

            private final void putAndResetLastValues(int minMemberIndex, int maxMemberIndex) {
                int i = minMemberIndex;
                while (i + 4 <= maxMemberIndex) {
                    long lastValue3;
                    long lastValue2;
                    long lastValue1;
                    long lastValue0 = this.lastValues[i];
                    if (lastValue0 != 0L) {
                        MemoryBitmapSegment bitmap2 = this.getOrCreateBitmap(i);
                        bitmap2.set(this.longIndex, lastValue0);
                        this.lastValues[i] = 0L;
                    }
                    if ((lastValue1 = this.lastValues[i + 1]) != 0L) {
                        MemoryBitmapSegment bitmap3 = this.getOrCreateBitmap(i + 1);
                        bitmap3.set(this.longIndex, lastValue1);
                        this.lastValues[i + 1] = 0L;
                    }
                    if ((lastValue2 = this.lastValues[i + 2]) != 0L) {
                        MemoryBitmapSegment bitmap4 = this.getOrCreateBitmap(i + 2);
                        bitmap4.set(this.longIndex, lastValue2);
                        this.lastValues[i + 2] = 0L;
                    }
                    if ((lastValue3 = this.lastValues[i + 3]) != 0L) {
                        MemoryBitmapSegment bitmap5 = this.getOrCreateBitmap(i + 3);
                        bitmap5.set(this.longIndex, lastValue3);
                        this.lastValues[i + 3] = 0L;
                    }
                    i += 4;
                }
                int j = i;
                if (j <= maxMemberIndex) {
                    while (true) {
                        long lastValue;
                        if ((lastValue = this.lastValues[j]) != 0L) {
                            MemoryBitmapSegment bitmap6 = this.getOrCreateBitmap(j);
                            bitmap6.set(this.longIndex, lastValue);
                            this.lastValues[j] = 0L;
                        }
                        if (j == maxMemberIndex) break;
                        ++j;
                    }
                }
                int n = this.longIndex;
                this.longIndex = n + 1;
            }

            @Override
            public void reset() {
                if (!(this.longIndex == 256)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (this.longIndex != 256) {
                    int n = this.getMembersSize();
                    for (int i = 0; i < n; ++i) {
                        this.lastValues[i] = 0L;
                    }
                }
                this.longIndex = 0;
                super.reset();
            }

            @Override
            public void release() {
                if (this.longIndex > 0) {
                    this.reset();
                }
                this.longIndex = -1;
                this.getArrayPool().lastValuesCache.release(this.lastValues);
                super.release();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache$VeryBigBitmapCache;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$BitmapCache;", "membersSize", "", "Lkd/bos/olapServer2/common/int;", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "(ILkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;)V", "lastValues", "Lkd/bos/olapServer2/collections/IntMaps$ArrayIntMap;", "", "Lkd/bos/olapServer2/common/long;", "longIndex", "put64Values", "", "values", "", "start", "putAndResetLastValues", "release", "reset", "bos-olap-core2"})
        public static final class VeryBigBitmapCache
        extends BitmapCache {
            @NotNull
            private IntMaps.ArrayIntMap<Long> lastValues;
            private int longIndex;

            public VeryBigBitmapCache(int membersSize, @NotNull WriterArrayPool arrayPool) {
                Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
                super(membersSize, arrayPool, null);
                this.lastValues = (IntMaps.ArrayIntMap)arrayPool.veryBigLastValuePool.create();
            }

            @Override
            public void put64Values(@NotNull int[] values, int start) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                for (int remCount = 0; remCount < 64; ++remCount) {
                    int memberIndex = values[start + remCount];
                    Long l = this.lastValues.get(memberIndex);
                    long oldValue = l != null ? l : 0L;
                    this.lastValues = this.lastValues.addOrUpdate(memberIndex, oldValue | 1L << remCount);
                }
                this.putAndResetLastValues();
            }

            private final void putAndResetLastValues() {
                this.lastValues.foreach((arg_0, arg_1) -> VeryBigBitmapCache.putAndResetLastValues$lambda$0(this, arg_0, arg_1));
                this.lastValues.clear();
                int n = this.longIndex;
                this.longIndex = n + 1;
            }

            @Override
            public void reset() {
                if (!(this.longIndex == 256)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (this.longIndex != 256) {
                    this.lastValues.clear();
                }
                this.longIndex = 0;
                super.reset();
            }

            @Override
            public void release() {
                if (this.longIndex > 0) {
                    this.reset();
                }
                this.longIndex = -1;
                this.getArrayPool().veryBigLastValuePool.release(this.lastValues);
                super.release();
            }

            private static final void putAndResetLastValues$lambda$0(VeryBigBitmapCache this$0, int i, long value2) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                MemoryBitmapSegment bitmap2 = this$0.getOrCreateBitmap(i);
                bitmap2.set(this$0.longIndex, value2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$Companion;", "", "()V", "threadCache", "Ljava/lang/ThreadLocal;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "getOrCreate", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nWriterArrayPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriterArrayPool.kt\nkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WriterArrayPool getOrCreate() {
            ThreadLocal threadLocal = threadCache;
            Object object2 = threadLocal.get();
            if (object2 == null) {
                WriterArrayPool writerArrayPool;
                boolean bl = false;
                WriterArrayPool writerArrayPool2 = writerArrayPool = new WriterArrayPool();
                threadLocal.set(writerArrayPool2);
                object2 = writerArrayPool;
            }
            return (WriterArrayPool)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u00060\u0006j\u0002`\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0006j\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$DirtyCollection;", "", "()V", "_dirtyItems", "", "_size", "", "dirtyItems", "getDirtyItems", "()[I", "size", "Lkd/bos/olapServer2/common/int;", "getSize", "()I", "clear", "", "resize", "setDirty", "index", "bos-olap-core2"})
    public static final class DirtyCollection {
        @NotNull
        private int[] _dirtyItems = new int[64];
        private int _size;

        public final int getSize() {
            return this._size;
        }

        @NotNull
        public final int[] getDirtyItems() {
            return this._dirtyItems;
        }

        public final void setDirty(int index2) {
            int[] items2 = this._dirtyItems;
            if (this._size >= items2.length) {
                items2 = this.resize();
            }
            int n = this._size;
            this._size = n + 1;
            items2[n] = index2;
        }

        private final int[] resize() {
            int[] nArray = Arrays.copyOf(this._dirtyItems, this._dirtyItems.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this._dirtyItems = nArray;
            return this._dirtyItems;
        }

        public final void clear() {
            this._size = 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u00052\n\u0010\u000e\u001a\u00060\u0007j\u0002`\u000fJ\u001e\u0010\u0010\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u0007j\u0002`\u000f2\n\u0010\u0011\u001a\u00060\u0007j\u0002`\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection;", "", "()V", "_levels", "Lkd/bos/olapServer2/collections/IntMaps$ArrayIntMap;", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$DirtyCollection;", "_maxDirtyLevelIndex", "", "maxDirtyLevelIndex", "getMaxDirtyLevelIndex", "()I", "clear", "", "getDirtyLevel", "levelIndex", "Lkd/bos/olapServer2/common/int;", "setDirty", "memberIndex", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nWriterArrayPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriterArrayPool.kt\nkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection\n+ 2 IntMaps.kt\nkd/bos/olapServer2/collections/IntMaps\n*L\n1#1,407:1\n13#2:408\n*S KotlinDebug\n*F\n+ 1 WriterArrayPool.kt\nkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$LevelDirtyCollection\n*L\n84#1:408\n*E\n"})
    public static final class LevelDirtyCollection {
        @NotNull
        private IntMaps.ArrayIntMap<DirtyCollection> _levels;
        private int _maxDirtyLevelIndex;

        public LevelDirtyCollection() {
            IntMaps intMaps = IntMaps.INSTANCE;
            int splitSize$iv = 16;
            boolean $i$f$create = false;
            this._levels = new IntMaps.ArrayIntMap<DirtyCollection>(new DirtyCollection[splitSize$iv], new BitSet());
        }

        public final int getMaxDirtyLevelIndex() {
            return this._maxDirtyLevelIndex;
        }

        @NotNull
        public final DirtyCollection getDirtyLevel(int levelIndex) {
            DirtyCollection level = this._levels.get(levelIndex);
            if (level == null) {
                level = new DirtyCollection();
                this._levels = this._levels.addOrUpdate(levelIndex, level);
            }
            return level;
        }

        public final void setDirty(int levelIndex, int memberIndex) {
            this.getDirtyLevel(levelIndex).setDirty(memberIndex);
            this._maxDirtyLevelIndex = Math.max(this._maxDirtyLevelIndex, levelIndex);
        }

        public final void clear() {
            this._maxDirtyLevelIndex = 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J\u0012\u0010\u0014\u001a\u00020\n2\n\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$SegmentCellSetCache;", "", "columnSize", "", "Lkd/bos/olapServer2/common/int;", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "(ILkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;)V", "_columns", "", "", "[[I", "fill", "", "source", "Lkd/bos/olapServer2/collections/IImmutableList;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "startIndex", "", "Lkd/bos/olapServer2/common/rowIdx;", "getIntArray", "columnIndex", "bos-olap-core2"})
    public static final class SegmentCellSetCache {
        @NotNull
        private final int[][] _columns;

        public SegmentCellSetCache(int columnSize, @NotNull WriterArrayPool arrayPool) {
            Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
            this._columns = (int[][])arrayPool.columnsCache.createArray(columnSize);
        }

        public final void fill(@NotNull IImmutableList<? extends IDimensionKeys> source2, long startIndex) {
            Intrinsics.checkNotNullParameter(source2, (String)"source");
            int[][] columns = this._columns;
            for (int i = 0; i < 65536; ++i) {
                long index2 = (long)i + startIndex;
                IDimensionKeys values = source2.get(index2);
                int n = values.getCount();
                for (int j = 0; j < n; ++j) {
                    columns[j][i] = values.get(j);
                }
            }
        }

        @NotNull
        public final int[] getIntArray(int columnIndex) {
            return this._columns[columnIndex];
        }
    }
}

