/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.dynamicCalcAndStored;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.olapServer2.computingEngine.SingleMeasureValues;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.NullMeasureValues;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eJ$\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001b\u001a\u00060\rj\u0002`\u000eH\u0002J\u0016\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eJ&\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001a\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001b\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001e\u001a\u00020\u000fR(\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\b\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/storages/dynamicCalcAndStored/CubeOriginValueCollection;", "", "partitionRowSizeSnapshot", "", "observerPartitions", "", "", "Lkd/bos/olapServer2/common/int;", "measureCount", "([JLjava/util/List;I)V", "items", "", "Ljava/util/concurrent/ConcurrentMap;", "", "Lkd/bos/olapServer2/common/rowIdx;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "[Ljava/util/concurrent/ConcurrentMap;", "nullValue", "Lkd/bos/olapServer2/storages/dynamicCalcAndStored/NullMeasureValues;", "getPartitionRowSizeSnapshot", "()[J", "getOrigin", "rowIndex", "isOutOfPartitionRange", "", "Lkd/bos/olapServer2/common/bool;", "partitionIndex", "partitionRowIndex", "setOrigin", "", "value", "bos-olap-core2"})
public final class CubeOriginValueCollection {
    @NotNull
    private final long[] partitionRowSizeSnapshot;
    private final int measureCount;
    @NotNull
    private final NullMeasureValues nullValue;
    @NotNull
    private final ConcurrentMap<Long, IMeasureValues>[] items;

    public CubeOriginValueCollection(@NotNull long[] partitionRowSizeSnapshot, @NotNull List<Integer> observerPartitions, int measureCount) {
        Intrinsics.checkNotNullParameter((Object)partitionRowSizeSnapshot, (String)"partitionRowSizeSnapshot");
        Intrinsics.checkNotNullParameter(observerPartitions, (String)"observerPartitions");
        this.partitionRowSizeSnapshot = partitionRowSizeSnapshot;
        this.measureCount = measureCount;
        this.nullValue = new NullMeasureValues(this.measureCount);
        this.items = new ConcurrentMap[this.partitionRowSizeSnapshot.length];
        Iterator<Integer> iterator2 = observerPartitions.iterator();
        while (iterator2.hasNext()) {
            int partition = ((Number)iterator2.next()).intValue();
            this.items[partition] = new ConcurrentHashMap<Long, IMeasureValues>();
        }
    }

    @NotNull
    public final long[] getPartitionRowSizeSnapshot() {
        return this.partitionRowSizeSnapshot;
    }

    @Nullable
    public final IMeasureValues getOrigin(long rowIndex) {
        IMeasureValues iMeasureValues;
        long partitionRowIndex;
        int partitionIndex = RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex);
        if (this.isOutOfPartitionRange(partitionIndex, partitionRowIndex = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex))) {
            iMeasureValues = this.nullValue;
        } else {
            ConcurrentMap<Long, IMeasureValues> concurrentMap = this.items[partitionIndex];
            iMeasureValues = concurrentMap != null ? (IMeasureValues)concurrentMap.get(partitionRowIndex) : null;
        }
        return iMeasureValues;
    }

    public final void setOrigin(int partitionIndex, long partitionRowIndex, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ConcurrentMap<Long, IMeasureValues> concurrentMap = this.items[partitionIndex];
        if (concurrentMap == null) {
            return;
        }
        ConcurrentMap<Long, IMeasureValues> item = concurrentMap;
        if (this.isOutOfPartitionRange(partitionIndex, partitionRowIndex) || item.get(partitionRowIndex) != null) {
            return;
        }
        Long l = partitionRowIndex;
        ((Map)item).put(l, new SingleMeasureValues(0, value2.getMeasureValue(0)));
    }

    private final boolean isOutOfPartitionRange(int partitionIndex, long partitionRowIndex) {
        return partitionRowIndex >= this.partitionRowSizeSnapshot[partitionIndex];
    }

    public final boolean isOutOfPartitionRange(long rowIndex) {
        int partitionIndex = RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex);
        long partitionRowIndex = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        return this.isOutOfPartitionRange(partitionIndex, partitionRowIndex);
    }
}

