/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.dynamicCalcAndStored;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.computingEngine.SingleMeasureValues;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.dataEntities.IMeasureValuesKt;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.ICubeDataObserver;
import kd.bos.olapServer2.storages.ICubeDataObserverContext;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kd.bos.olapServer2.storages.SimpleRowKey;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheDerivation;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheIncrementEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\f\u0010$\u001a\u00060%j\u0002`&H\u0002J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkd/bos/olapServer2/storages/dynamicCalcAndStored/DynamicCalcAndStoredDataObserver;", "Lkd/bos/olapServer2/storages/ICubeDataObserver;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "derivation", "Lkd/bos/olapServer2/storages/dynamicCalcAndStored/DSCacheDerivation;", "dataObserverContext", "Lkd/bos/olapServer2/storages/ICubeDataObserverContext;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/storages/dynamicCalcAndStored/DSCacheDerivation;Lkd/bos/olapServer2/storages/ICubeDataObserverContext;)V", "changeKeys", "", "Lkd/bos/olapServer2/storages/SimpleRowKey;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "currentCubeWorkspace", "Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "getCurrentCubeWorkspace", "()Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "dimensionCount", "", "Lkd/bos/olapServer2/common/int;", "incrementState", "lastPartitionId", "values", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "emitEvent", "", "getMeasureValues", "Lkd/bos/olapServer2/computingEngine/SingleMeasureValues;", "value", "onAdded", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "onFlush", "onForcePartition", "onUpdated", "requireDS", "", "Lkd/bos/olapServer2/common/bool;", "tryAddIncrementKey", "bos-olap-core2"})
public final class DynamicCalcAndStoredDataObserver
implements ICubeDataObserver {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final DSCacheDerivation derivation;
    @NotNull
    private final ICubeDataObserverContext dataObserverContext;
    @NotNull
    private final Cube cube;
    private final int dimensionCount;
    @NotNull
    private List<SimpleRowKey> changeKeys;
    @NotNull
    private List<IMeasureValues> values;
    private int lastPartitionId;
    private int incrementState;

    public DynamicCalcAndStoredDataObserver(@NotNull CubeWorkspace cubeWorkspace, @NotNull DSCacheDerivation derivation, @NotNull ICubeDataObserverContext dataObserverContext) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)derivation, (String)"derivation");
        Intrinsics.checkNotNullParameter((Object)dataObserverContext, (String)"dataObserverContext");
        this.cubeWorkspace = cubeWorkspace;
        this.derivation = derivation;
        this.dataObserverContext = dataObserverContext;
        this.cube = this.cubeWorkspace.getMetadata();
        this.dimensionCount = this.cubeWorkspace.getMetadata().getDimensions().getCount();
        this.changeKeys = new ArrayList();
        this.values = new ArrayList();
        this.lastPartitionId = -1;
    }

    private final PartitionCubeWorkspace getCurrentCubeWorkspace() {
        AbstractCubeWorkspace abstractCubeWorkspace = this.dataObserverContext.getCurrentCubeWorkspace();
        Intrinsics.checkNotNull((Object)abstractCubeWorkspace, (String)"null cannot be cast to non-null type kd.bos.olapServer2.storages.PartitionCubeWorkspace");
        return (PartitionCubeWorkspace)abstractCubeWorkspace;
    }

    private final boolean requireDS() {
        if (this.dataObserverContext.getPartitionId() != this.lastPartitionId) {
            this.lastPartitionId = this.dataObserverContext.getPartitionId();
            this.incrementState = this.cube.getDSCachePartition(this.getCurrentCubeWorkspace().getPartitionItem()) == EmptyPartitionItem.INSTANCE ? 0 : 1;
        }
        return this.incrementState != 0;
    }

    private final void tryAddIncrementKey(IDimensionKeys key2, SingleMeasureValues value2) {
        SimpleRowKey newKey = new SimpleRowKey(this.cube, new int[this.dimensionCount]);
        ArraysKt.copyInto$default((int[])key2.getArray(), (int[])newKey.getArray(), (int)0, (int)0, (int)0, (int)14, null);
        this.changeKeys.add(newKey);
        this.values.add(value2);
        if (this.incrementState == 1) {
            CubeResourcePool cubeResourcePool = this.getCurrentCubeWorkspace().getResourcePool();
            long l = cubeResourcePool.getDsVersion();
            cubeResourcePool.setDsVersion(l + 1L);
            this.incrementState = 2;
        }
    }

    @Override
    public void onAdded(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        SingleMeasureValues incrementValues;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.requireDS() && this.derivation.needDeriveToDS(key2) && (incrementValues = this.getMeasureValues(value2)) != null) {
            this.tryAddIncrementKey(key2, incrementValues);
        }
    }

    private final SingleMeasureValues getMeasureValues(IMeasureValues value2) {
        int n = value2.getCount();
        for (int i = 0; i < n; ++i) {
            if (value2.getMeasureIndex(i) != 0 || value2.getMeasureValue(i) == CommonTypesKt.getIgnoreValue()) continue;
            return new SingleMeasureValues(0, value2.getMeasureValue(i));
        }
        return null;
    }

    @Override
    public void onUpdated(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        SingleMeasureValues realValue;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.requireDS() && this.derivation.needDeriveToDS(key2) && (realValue = this.getMeasureValues(value2)) != null) {
            IMeasureValues originalValues = this.dataObserverContext.getOriginalValues();
            SingleMeasureValues incrementValues = new SingleMeasureValues(realValue.getFirstMeasureIndex(), null, 2, null);
            Object v = realValue.getFirstMeasureValue();
            Object originalValue = originalValues.getFirstMeasureValue();
            Object incrementValue = originalValue == CommonTypesKt.getUndefined() ? v : DragonEngine.Companion.sub(v, originalValue);
            incrementValues.setMainMeasureValue(DragonEngine.Companion.isNullOrDefaultValue(incrementValue) ? CommonTypesKt.getIgnoreValue() : incrementValue);
            if (!IMeasureValuesKt.allValuesIsIgnoreValue(incrementValues)) {
                this.tryAddIncrementKey(key2, incrementValues);
            }
        }
    }

    private final void emitEvent() {
        if (!((Collection)this.changeKeys).isEmpty()) {
            PartitionCubeWorkspace base = this.getCurrentCubeWorkspace();
            long newDSVersion = base.getResourcePool().getDsVersion();
            IPartitionItem cachePartitionItem = this.cubeWorkspace.getMetadata().getDSCachePartition(base.getPartitionItem());
            this.cubeWorkspace.submitEvent(new DSCacheIncrementEvent(cachePartitionItem, newDSVersion, this.changeKeys, this.values));
            this.changeKeys = new ArrayList();
            this.values = new ArrayList();
        }
        this.lastPartitionId = -1;
    }

    @Override
    public void onForcePartition() {
        this.emitEvent();
    }

    @Override
    public void onFlush() {
    }

    @Override
    public void beforeUpdate() {
        ICubeDataObserver.DefaultImpls.beforeUpdate(this);
    }
}

