/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.gc;

import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.common.UnhandledExceptionEventArgs;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportContainer;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.bitmapIndexes.WriterArrayPool;
import kd.bos.olapServer2.storages.gc.ZipInputRowList;
import kd.bos.olapServer2.storages.gc.ZipTaskExecutor;
import kd.bos.olapServer2.tools.CubeToolKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00022\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\n\u0010\u0018\u001a\u00060\u0016j\u0002`\u0017H\u0014J\u001c\u0010\u0019\u001a\u00060\u0005j\u0002`\u001a2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/storages/gc/RuntimeZipTaskExecutor;", "Lkd/bos/olapServer2/storages/gc/ZipTaskExecutor;", "Lkd/bos/olapServer2/storages/gc/RuntimeZipTaskExecutor$ZipTaskContext;", "()V", "_checked", "", "checkLastTask", "", "healthReports", "Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "pool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "metadataLock", "Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "onError", "context", "ex", "", "onSubmit", "oldTaskCount", "", "Lkd/bos/olapServer2/common/long;", "newTaskCount", "runCore", "Lkd/bos/olapServer2/common/bool;", "runLock", "Ljava/util/concurrent/locks/Lock;", "ZipTaskContext", "bos-olap-core2"})
public final class RuntimeZipTaskExecutor
extends ZipTaskExecutor<ZipTaskContext> {
    private boolean _checked;

    public final void checkLastTask(@NotNull HealthReportContainer healthReports, @NotNull CubeResourcePool pool, @NotNull ICubeMetadataLock metadataLock, @NotNull ICubeDataLock dataLock) {
        Intrinsics.checkNotNullParameter((Object)healthReports, (String)"healthReports");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
        Intrinsics.checkNotNullParameter((Object)dataLock, (String)"dataLock");
        if (!this._checked) {
            this._checked = true;
            long splitSegmentIndex = pool.getSplitCount() >> 16;
            long rowSegmentIndex = pool.getRowCount() >> 16;
            long needZipSegmentCount = rowSegmentIndex - splitSegmentIndex;
            if (needZipSegmentCount > 0L) {
                this.submit(new ZipTaskContext(healthReports, pool, metadataLock, dataLock), needZipSegmentCount);
            }
        }
    }

    @Override
    protected void onSubmit(@NotNull ZipTaskContext context, long oldTaskCount, long newTaskCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ZipTaskContext $this$onSubmit_u24lambda_u240 = context;
        boolean bl = false;
        if ($this$onSubmit_u24lambda_u240.getDataLock().notHasReader()) {
            $this$onSubmit_u24lambda_u240.getPool().getSharedResource().gcForWriter1();
            $this$onSubmit_u24lambda_u240.getPool().getSharedResource().gcForWriter2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runCore(@NotNull ZipTaskContext context, @NotNull Lock runLock) {
        Closeable readLock;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)runLock, (String)"runLock");
        ZipTaskContext $this$runCore_u24lambda_u243 = context;
        boolean bl = false;
        Closeable closeable = $this$runCore_u24lambda_u243.getMetadataLock().tryGetReadLock();
        if (closeable == null) {
            return false;
        }
        Closeable closeable2 = readLock = closeable;
        Throwable throwable = null;
        try {
            Closeable it = closeable2;
            boolean bl2 = false;
            Lock lock = runLock;
            lock.lock();
            try {
                boolean bl3 = false;
                if (this.isClosed()) {
                    boolean bl4 = true;
                    boolean bl5 = bl4;
                    return bl5;
                }
                long splitCount = $this$runCore_u24lambda_u243.getPool().getSplitCount();
                if ($this$runCore_u24lambda_u243.getPool().getRowCount() - splitCount >= 65536L) {
                    ZipInputRowList zipInputRowList = $this$runCore_u24lambda_u243.getPool().getZipInputRowList();
                    zipInputRowList.zip(WriterArrayPool.Companion.getOrCreate(), splitCount);
                    $this$runCore_u24lambda_u243.getPool().setSplitCount(splitCount + (long)65536);
                }
                if ($this$runCore_u24lambda_u243.getDataLock().notHasReader() && $this$runCore_u24lambda_u243.getDataLock().notHasWriter()) {
                    $this$runCore_u24lambda_u243.getPool().getSharedResource().gcForZip();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
        }
        return true;
    }

    @Override
    protected void onError(@NotNull ZipTaskContext context, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        String cubeName = context.getPool().getCube().getName();
        OlapRuntimeException ex2 = new OlapRuntimeException("Zip data task error at " + cubeName + ". " + ex.getMessage(), cubeName, ex);
        HealthReportContainer healthReportContainer = context.getHealthReports();
        String string2 = "zip-" + CubeToolKt.getCurrentTime();
        String string3 = ex.getMessage();
        if (string3 == null) {
            string3 = "zip data error";
        }
        healthReportContainer.commit(new HealthReport(string2, cubeName, string3, HealthReportLevel.Error, PrivilegeType.Write.getCode()));
        UnhandledExceptionEventArgs.Companion.onError$bos_olap_core2(this, ex2, "ZipData");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/storages/gc/RuntimeZipTaskExecutor$ZipTaskContext;", "", "healthReports", "Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "pool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "metadataLock", "Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "(Lkd/bos/olapServer2/monitorReports/HealthReportContainer;Lkd/bos/olapServer2/storages/CubeResourcePool;Lkd/bos/olapServer2/storages/ICubeMetadataLock;Lkd/bos/olapServer2/storages/ICubeDataLock;)V", "getDataLock", "()Lkd/bos/olapServer2/storages/ICubeDataLock;", "getHealthReports", "()Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "getMetadataLock", "()Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "getPool", "()Lkd/bos/olapServer2/storages/CubeResourcePool;", "bos-olap-core2"})
    public static final class ZipTaskContext {
        @NotNull
        private final HealthReportContainer healthReports;
        @NotNull
        private final CubeResourcePool pool;
        @NotNull
        private final ICubeMetadataLock metadataLock;
        @NotNull
        private final ICubeDataLock dataLock;

        public ZipTaskContext(@NotNull HealthReportContainer healthReports, @NotNull CubeResourcePool pool, @NotNull ICubeMetadataLock metadataLock, @NotNull ICubeDataLock dataLock) {
            Intrinsics.checkNotNullParameter((Object)healthReports, (String)"healthReports");
            Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
            Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
            Intrinsics.checkNotNullParameter((Object)dataLock, (String)"dataLock");
            this.healthReports = healthReports;
            this.pool = pool;
            this.metadataLock = metadataLock;
            this.dataLock = dataLock;
        }

        @NotNull
        public final HealthReportContainer getHealthReports() {
            return this.healthReports;
        }

        @NotNull
        public final CubeResourcePool getPool() {
            return this.pool;
        }

        @NotNull
        public final ICubeMetadataLock getMetadataLock() {
            return this.metadataLock;
        }

        @NotNull
        public final ICubeDataLock getDataLock() {
            return this.dataLock;
        }
    }
}

