/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.gc;

import java.util.BitSet;
import java.util.List;
import kd.bos.olapServer2.collections.IntMaps;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncodingV3.MutableRunLengthListInt;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.dependencies.DirectedAcyclicDiagram;
import kd.bos.olapServer2.storages.CubeDataStorage;
import kd.bos.olapServer2.storages.bitmapIndexes.DimensionBitmapIndexesWriter;
import kd.bos.olapServer2.storages.bitmapIndexes.WriterArrayPool;
import kd.bos.olapServer2.storages.gc.ZipInputRowList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u0019R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/storages/gc/ZipInputRowList;", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "dataStorage", "Lkd/bos/olapServer2/storages/CubeDataStorage;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/storages/CubeDataStorage;)V", "bitmapWriters", "", "Lkd/bos/olapServer2/storages/bitmapIndexes/DimensionBitmapIndexesWriter;", "[Lkd/bos/olapServer2/storages/bitmapIndexes/DimensionBitmapIndexesWriter;", "rkLists", "Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt;", "[Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt;", "zip", "", "arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "dimensionPosition", "", "Lkd/bos/olapServer2/common/int;", "dimensionIntArray", "", "startIndex", "", "Lkd/bos/olapServer2/common/rowIdx;", "splitCount", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nZipInputRowList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipInputRowList.kt\nkd/bos/olapServer2/storages/gc/ZipInputRowList\n+ 2 IntMaps.kt\nkd/bos/olapServer2/collections/IntMaps\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 ZipInputRowList.kt\nkd/bos/olapServer2/storages/gc/ZipInputRowList\n*L\n51#1:100\n*E\n"})
public final class ZipInputRowList {
    @NotNull
    private final Cube cube;
    @NotNull
    private final CubeDataStorage dataStorage;
    @NotNull
    private final MutableRunLengthListInt[] rkLists;
    @NotNull
    private final DimensionBitmapIndexesWriter[] bitmapWriters;

    public ZipInputRowList(@NotNull Cube cube, @NotNull CubeDataStorage dataStorage) {
        int n;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)dataStorage, (String)"dataStorage");
        this.cube = cube;
        this.dataStorage = dataStorage;
        DimensionCollection dimensions2 = this.cube.getDimensions();
        int n2 = 0;
        int n3 = dimensions2.getCount();
        Object[] objectArray = new MutableRunLengthListInt[n3];
        ZipInputRowList zipInputRowList = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = this.dataStorage.createZipMutableListInt((Dimension)dimensions2.get(n));
        }
        zipInputRowList.rkLists = objectArray;
        n2 = 0;
        n3 = dimensions2.getCount();
        objectArray = new DimensionBitmapIndexesWriter[n3];
        zipInputRowList = this;
        while (n2 < n3) {
            n = n2++;
            MemberCollection members2 = ((Dimension)dimensions2.get(n)).getMembers();
            List items2 = CollectionsKt.emptyList();
            DirectedAcyclicDiagram dag2 = new DirectedAcyclicDiagram(items2, members2.getNextUnusedPosition() - 1, 2.dag.1.INSTANCE);
            IntMaps intMaps = IntMaps.INSTANCE;
            int splitSize$iv = 65536;
            boolean $i$f$create = false;
            IntMaps.ArrayIntMap<IMinMutableBitmap> bitmaps = new IntMaps.ArrayIntMap<IMinMutableBitmap>(new IMinMutableBitmap[splitSize$iv], new BitSet());
            objectArray[n] = new DimensionBitmapIndexesWriter(members2.getNextUnusedPosition(), dag2, (Function1<? super Integer, ? extends IMinMutableBitmap>)((Function1)new Function1<Integer, IMinMutableBitmap>(bitmaps, members2, this){
                final /* synthetic */ IntMaps.ArrayIntMap<IMinMutableBitmap> $bitmaps;
                final /* synthetic */ MemberCollection $members;
                final /* synthetic */ ZipInputRowList this$0;
                {
                    this.$bitmaps = $bitmaps;
                    this.$members = $members;
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final IMinMutableBitmap invoke(int memberId) {
                    if (memberId >= 0xFFFFFF) {
                        return null;
                    }
                    IMinMutableBitmap bitmap2 = this.$bitmaps.get(memberId);
                    if (bitmap2 == null) {
                        Member member = this.$members.getMemberByFixedNumber(memberId);
                        bitmap2 = ZipInputRowList.access$getDataStorage$p(this.this$0).createMutableBitmap(member.getGlobalID());
                        this.$bitmaps.addOrUpdate(memberId, bitmap2);
                    }
                    return bitmap2;
                }
            }));
        }
        zipInputRowList.bitmapWriters = objectArray;
    }

    public final void zip(@NotNull WriterArrayPool arrayPool, long splitCount) {
        Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
        int dimensionCount = this.cube.getDimensions().getCount();
        MinMutableListDimensionKeys standardList = this.dataStorage.createUnzipMutableListDimensionKeys(splitCount + (long)65536);
        WriterArrayPool.SegmentCellSetCache segmentCellSetCache = arrayPool.createSegmentCellSetCache(dimensionCount);
        segmentCellSetCache.fill(standardList, splitCount);
        for (int i = 0; i < dimensionCount; ++i) {
            int[] dimensionIntArray = segmentCellSetCache.getIntArray(i);
            this.zip(arrayPool, i, dimensionIntArray, splitCount);
        }
        standardList.release(splitCount / (long)65536);
    }

    public final void zip(@NotNull WriterArrayPool arrayPool, int dimensionPosition, @NotNull int[] dimensionIntArray, long startIndex) {
        Intrinsics.checkNotNullParameter((Object)arrayPool, (String)"arrayPool");
        Intrinsics.checkNotNullParameter((Object)dimensionIntArray, (String)"dimensionIntArray");
        MutableRunLengthListInt rkList = this.rkLists[dimensionPosition];
        rkList.add(dimensionIntArray);
        rkList.flush();
        DimensionBitmapIndexesWriter bitmapWriter = this.bitmapWriters[dimensionPosition];
        bitmapWriter.add(startIndex, dimensionIntArray, arrayPool);
    }

    public static final /* synthetic */ CubeDataStorage access$getDataStorage$p(ZipInputRowList $this) {
        return $this.dataStorage;
    }
}

