/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.pools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.olapServer2.collections.LockFreeStack;
import kd.bos.olapServer2.common.CommonTypesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0015\u001a\u00020\rJ\u0015\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0018\u001a\u00020\r2%\u0010\u0019\u001a!\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001aH\u0004R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/storages/pools/ObjectPool;", "K", "V", "", "()V", "_itemsDict", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer2/collections/LockFreeStack;", "maxObjectCount", "", "getMaxObjectCount", "()I", "closeObj", "", "key", "obj", "(Ljava/lang/Object;Ljava/lang/Object;)V", "createObject", "(Ljava/lang/Object;)Ljava/lang/Object;", "get", "release", "removeAll", "reuse", "value", "scan", "removeFun", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "v", "", "Lkd/bos/olapServer2/common/bool;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nObjectPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectPool.kt\nkd/bos/olapServer2/storages/pools/ObjectPool\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n72#2,2:88\n72#2,2:91\n1#3:90\n1#3:93\n*S KotlinDebug\n*F\n+ 1 ObjectPool.kt\nkd/bos/olapServer2/storages/pools/ObjectPool\n*L\n42#1:88,2\n78#1:91,2\n42#1:90\n78#1:93\n*E\n"})
public abstract class ObjectPool<K, V> {
    @NotNull
    private final ConcurrentHashMap<K, LockFreeStack<V>> _itemsDict = new ConcurrentHashMap();

    public V get(K key2) {
        V result2;
        LockFreeStack<V> stack = this._itemsDict.get(key2);
        if (stack != null && (result2 = stack.tryPop()) != null) {
            return this.reuse(result2);
        }
        return this.createObject(key2);
    }

    protected abstract V createObject(K var1);

    protected V reuse(V value2) {
        return value2;
    }

    protected int getMaxObjectCount() {
        return CommonTypesKt.getAvailableProcessors() * 99;
    }

    public void release(K key2, V obj) {
        LockFreeStack stack;
        ConcurrentMap $this$getOrPut$iv = this._itemsDict;
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(key2);
        if (object2 == null) {
            boolean bl = false;
            LockFreeStack default$iv = new LockFreeStack();
            boolean bl2 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key2, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        if ((stack = (LockFreeStack)object2).getSize() < this.getMaxObjectCount()) {
            stack.push(obj);
        } else {
            this.closeObj(key2, obj);
        }
    }

    protected abstract void closeObj(K var1, V var2);

    public final void removeAll() {
        for (Map.Entry entry : ((Map)this._itemsDict).entrySet()) {
            Object key2 = entry.getKey();
            LockFreeStack stack = (LockFreeStack)entry.getValue();
            Object item = stack.tryPop();
            while (item != null) {
                this.closeObj(key2, item);
                item = stack.tryPop();
            }
        }
    }

    protected final void scan(@NotNull Function1<? super V, Boolean> removeFun) {
        LockFreeStack stack;
        Intrinsics.checkNotNullParameter(removeFun, (String)"removeFun");
        List removeKeys = new ArrayList();
        for (Map.Entry entry : ((Map)this._itemsDict).entrySet()) {
            Object key2 = entry.getKey();
            stack = (LockFreeStack)entry.getValue();
            stack.gc(removeFun, (Function1)new Function1<V, Unit>(this, key2){
                final /* synthetic */ ObjectPool<K, V> this$0;
                final /* synthetic */ K $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(1);
                }

                public final void invoke(V it) {
                    this.this$0.closeObj(this.$key, it);
                }
            });
            if (!stack.isEmpty()) continue;
            removeKeys.add(key2);
        }
        for (Map.Entry key3 : removeKeys) {
            LockFreeStack<V> removedItems = this._itemsDict.remove(key3);
            if (removedItems == null || removedItems.isEmpty()) continue;
            ConcurrentMap $this$getOrPut$iv = this._itemsDict;
            boolean $i$f$getOrPut = false;
            Object object2 = $this$getOrPut$iv.get(key3);
            if (object2 == null) {
                boolean bl = false;
                LockFreeStack default$iv = new LockFreeStack();
                boolean bl2 = false;
                object2 = $this$getOrPut$iv.putIfAbsent(key3, default$iv);
                if (object2 == null) {
                    object2 = default$iv;
                }
            }
            stack = (LockFreeStack)object2;
            V item = removedItems.tryPop();
            while (item != null) {
                stack.push(item);
                item = removedItems.tryPop();
            }
        }
    }
}

