/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.pools;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.storages.pools.ObjectPool;
import kd.bos.olapServer2.storages.pools.PoolEntry;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\r\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0014\b\u0002\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00012\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H$\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\f\u0010\u0019\u001a\u00060\u0011j\u0002`\u0012H$J\u0013\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u001d\u001a\u00028\u00022\u0006\u0010\u001b\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/storages/pools/PoolWithVersion;", "TKey", "TValue", "TEntry", "Lkd/bos/olapServer2/storages/pools/PoolEntry;", "Lkd/bos/olapServer2/storages/pools/ObjectPool;", "()V", "_garbageCollecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closeObj", "", "key", "obj", "(Ljava/lang/Object;Lkd/bos/olapServer2/storages/pools/PoolEntry;)V", "createEntry", "value", "changeVersion", "", "Lkd/bos/olapServer2/common/long;", "(Ljava/lang/Object;Ljava/lang/Object;J)Lkd/bos/olapServer2/storages/pools/PoolEntry;", "createObject", "(Ljava/lang/Object;)Lkd/bos/olapServer2/storages/pools/PoolEntry;", "createValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "gc", "getChangeVersion", "release", "entry", "(Lkd/bos/olapServer2/storages/pools/PoolEntry;)V", "reuse", "(Lkd/bos/olapServer2/storages/pools/PoolEntry;)Lkd/bos/olapServer2/storages/pools/PoolEntry;", "bos-olap-core2"})
public abstract class PoolWithVersion<TKey, TValue, TEntry extends PoolEntry<? extends TKey, ? extends TValue>>
extends ObjectPool<TKey, TEntry> {
    @NotNull
    private final AtomicBoolean _garbageCollecting = new AtomicBoolean();

    @Override
    @NotNull
    protected TEntry createObject(TKey key2) {
        return this.createEntry(key2, this.createValue(key2), this.getChangeVersion());
    }

    protected abstract TValue createValue(TKey var1);

    protected abstract long getChangeVersion();

    @NotNull
    protected abstract TEntry createEntry(TKey var1, TValue var2, long var3);

    @Override
    @NotNull
    protected TEntry reuse(@NotNull TEntry entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        throw new NotImplementedError(null, 1, null);
    }

    public final void release(@NotNull TEntry entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.release((TKey)((PoolEntry)entry).getKey(), entry);
    }

    @Override
    public void release(TKey key2, @NotNull TEntry obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    protected void closeObj(TKey key2, @NotNull TEntry obj) {
        block0: {
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            Object TValue = ((PoolEntry)obj).getValue();
            Closeable closeable = TValue instanceof Closeable ? (Closeable)TValue : null;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void gc() {
        if (this._garbageCollecting.compareAndSet(false, true)) {
            try {
                long min = System.nanoTime() - ByteBufferResourcePool.Companion.getResourceTimeout() * 1000000000L;
                this.scan((Function1)new Function1<TEntry, Boolean>(min){
                    final /* synthetic */ long $min;
                    {
                        this.$min = $min;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull TEntry it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return ((PoolEntry)it).getReleaseTime() < this.$min;
                    }
                });
            }
            finally {
                this._garbageCollecting.set(false);
            }
        }
    }
}

