/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.rowValid;

import java.io.Closeable;
import java.util.Iterator;
import kd.bos.olapServer2.collections.IImmutableBitmap;
import kd.bos.olapServer2.collections.IIndexScanner;
import kd.bos.olapServer2.collections.IQueryBitmap;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.DefaultThreadPoolExecutor;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.MutableBitmapContainer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.MutableBitmapX;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.query.IndexIterator;
import kd.bos.olapServer2.query.ValidValueIterator;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.BasicCubeWorkspace;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.rowValid.AutoMergeMutableBitmapX;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/storages/rowValid/MemberDropBitmapWriter;", "", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "dropMembers", "", "Lkd/bos/olapServer2/metadata/Member;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/metadata/Dimension;[Lkd/bos/olapServer2/metadata/Member;)V", "[Lkd/bos/olapServer2/metadata/Member;", "basicSetBitmap", "", "basicCubeWorkspace", "Lkd/bos/olapServer2/storages/BasicCubeWorkspace;", "getDropMemberQueryBitmap", "Lkd/bos/olapServer2/collections/IQueryBitmap;", "pool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "partitionSetBitmap", "setBitmap", "workspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMemberDropBitmapWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberDropBitmapWriter.kt\nkd/bos/olapServer2/storages/rowValid/MemberDropBitmapWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1#2:110\n1855#3,2:111\n*S KotlinDebug\n*F\n+ 1 MemberDropBitmapWriter.kt\nkd/bos/olapServer2/storages/rowValid/MemberDropBitmapWriter\n*L\n60#1:111,2\n*E\n"})
public final class MemberDropBitmapWriter {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Dimension dimension;
    @NotNull
    private final Member[] dropMembers;

    public MemberDropBitmapWriter(@NotNull CubeWorkspace cubeWorkspace, @NotNull Dimension dimension, @NotNull Member[] dropMembers) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)dropMembers, (String)"dropMembers");
        this.cubeWorkspace = cubeWorkspace;
        this.dimension = dimension;
        this.dropMembers = dropMembers;
    }

    public final void setBitmap() {
        Cube cube = this.cubeWorkspace.getMetadata();
        boolean enablePartition = cube.getEnabledPartition();
        if (enablePartition) {
            this.partitionSetBitmap();
        } else {
            AbstractCubeWorkspace workspace = this.cubeWorkspace.getPartitionWorkspacesWithOutCache().iterator().next();
            if (!(workspace instanceof BasicCubeWorkspace)) {
                boolean bl = false;
                String string2 = "error,must be BasicCubeWorkspace.";
                throw new IllegalArgumentException(string2.toString());
            }
            this.basicSetBitmap((BasicCubeWorkspace)workspace);
        }
    }

    private final void basicSetBitmap(BasicCubeWorkspace basicCubeWorkspace) {
        if (basicCubeWorkspace.getRowCount() == 0L) {
            return;
        }
        this.setBitmap(basicCubeWorkspace);
    }

    private final IQueryBitmap getDropMemberQueryBitmap(CubeResourcePool pool) {
        return pool.getDataStorage().createQueryBitmap(this.dimension, this.dropMembers, pool.getSplitCount(), pool.getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void partitionSetBitmap() {
        Closeable closeable = new DefaultThreadPoolExecutor("MemberDeleteBitmapWriter");
        Throwable throwable = null;
        try {
            DefaultThreadPoolExecutor threadPool = (DefaultThreadPoolExecutor)closeable;
            boolean bl = false;
            Iterable<AbstractCubeWorkspace> $this$forEach$iv = this.cubeWorkspace.getPartitionWorkspacesWithOutCache();
            boolean $i$f$forEach = false;
            Iterator<AbstractCubeWorkspace> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                AbstractCubeWorkspace element$iv;
                AbstractCubeWorkspace subWorkspace = element$iv = iterator2.next();
                boolean bl2 = false;
                if (subWorkspace.getRowCount() == 0L) continue;
                threadPool.submit((Function0<Unit>)((Function0)new Function0<Unit>(this, subWorkspace){
                    final /* synthetic */ MemberDropBitmapWriter this$0;
                    final /* synthetic */ AbstractCubeWorkspace $subWorkspace;
                    {
                        this.this$0 = $receiver;
                        this.$subWorkspace = $subWorkspace;
                        super(0);
                    }

                    public final void invoke() {
                        MemberDropBitmapWriter.access$setBitmap(this.this$0, this.$subWorkspace);
                    }
                }));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void setBitmap(AbstractCubeWorkspace workspace) {
        long rowCount = workspace.getRowCount();
        CubeResourcePool resourcePool = workspace.getResourcePool();
        IQueryBitmap droppingQueryBitmap = this.getDropMemberQueryBitmap(resourcePool);
        if (droppingQueryBitmap.afterValueIsZero(0L)) {
            return;
        }
        MutableBitmapContainer rowValidBitmaps2 = resourcePool.getDataStorage().getRowValidBitmaps();
        IQueryBitmap droppedMemberBitmap = rowValidBitmaps2.createQueryMutableBitmap(MutableBitmapContainer.Companion.getDROPPED_MEMBER_UUID());
        MutableBitmapX droppedResultBitmap = rowValidBitmaps2.createMutableBitmap(MutableBitmapContainer.Companion.getDROPPED_MEMBER_UUID());
        IQueryBitmap validDataBitmap = rowValidBitmaps2.createQueryMutableBitmap(MutableBitmapContainer.Companion.getVALID_DATA_RULE_UUID());
        MutableBitmapX rowValidBitmap = rowValidBitmaps2.createMutableBitmap(MutableBitmapContainer.Companion.getROW_VALID_UUID());
        IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[]{validDataBitmap};
        AutoMergeMutableBitmapX rowValidMergeBitmap = new AutoMergeMutableBitmapX(rowCount, droppedResultBitmap, iImmutableBitmapArray, rowValidBitmap);
        IIndexScanner indexScanner = droppingQueryBitmap.getIndexScanner();
        long longCount = CommonTypesKt.bitCountToLongCount(rowCount);
        IndexIterator indexRange = new IndexIterator(indexScanner, 0L, longCount);
        ValidValueIterator validValueItr = new ValidValueIterator(droppingQueryBitmap, indexRange);
        while (validValueItr.next()) {
            long index2 = validValueItr.getIndex();
            long value2 = validValueItr.getValue();
            rowValidMergeBitmap.set(index2, droppedMemberBitmap.get(index2) | value2);
        }
        rowValidMergeBitmap.flush();
    }

    public static final /* synthetic */ void access$setBitmap(MemberDropBitmapWriter $this, AbstractCubeWorkspace workspace) {
        $this.setBitmap(workspace);
    }
}

