/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.sandboxs;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.common.UnhandledExceptionEventArgs;
import kd.bos.olapServer2.metadata.sandboxs.SandboxUtils;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u001d\u001eB\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J'\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00028\u00002\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u000e\u0012\f0\bR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/LockProxy;", "TLock", "Ljava/io/Closeable;", "threadName", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_closeMail", "Lkd/bos/olapServer2/storages/sandboxs/LockProxy$LockApplyMail;", "_isClosed", "", "_proxyThread", "Ljava/lang/Thread;", "_queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "clearQueue", "", "close", "getLock", "metadataLock", "timeout", "", "Lkd/bos/olapServer2/common/long;", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Ljava/io/Closeable;", "run", "tryGetLock", "(Ljava/lang/Object;)Ljava/io/Closeable;", "LockApplyMail", "LockState", "bos-olap-core2"})
public abstract class LockProxy<TLock>
implements Closeable {
    @NotNull
    private final Thread _proxyThread;
    @NotNull
    private final ArrayBlockingQueue<LockApplyMail> _queue;
    private volatile boolean _isClosed;
    @NotNull
    private final LockApplyMail _closeMail;

    public LockProxy(@NotNull String threadName) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        this._proxyThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)threadName, (int)0, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                LockProxy.access$run((LockProxy)this.receiver);
            }
        }), (int)22, null);
        this._queue = new ArrayBlockingQueue(64);
        this._closeMail = new LockApplyMail();
        this._proxyThread.start();
    }

    @Nullable
    protected abstract Closeable tryGetLock(TLock var1);

    private final void run() {
        boolean running = true;
        while (running) {
            try {
                LockApplyMail mail = this._queue.take();
                if (mail == this._closeMail) {
                    this.clearQueue();
                    running = false;
                    continue;
                }
                if (mail.getLockState() == LockState.Applying) {
                    mail.applyingLock();
                    continue;
                }
                if (mail.getLockState() != LockState.Closing) continue;
                mail.closeLock();
            }
            catch (Throwable ex) {
                String string2 = this._proxyThread.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                UnhandledExceptionEventArgs.Companion.onError$bos_olap_core2(this, ex, string2);
            }
        }
    }

    private final void clearQueue() {
        LockApplyMail mail = this._queue.poll();
        while (mail != null) {
            if (mail != this._closeMail) {
                switch (WhenMappings.$EnumSwitchMapping$0[mail.getLockState().ordinal()]) {
                    case 1: {
                        mail.signalServiceClosed();
                        break;
                    }
                    case 2: {
                        mail.closeLock();
                        break;
                    }
                    default: {
                        throw SandboxUtils.INSTANCE.notSupportedException(mail.getLockState().toString());
                    }
                }
            }
            mail = this._queue.poll();
        }
    }

    @NotNull
    public final Closeable getLock(TLock metadataLock, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this._isClosed) {
            String string2 = Res.INSTANCE.getOlapWorkspaceException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_4>(...)");
            throw new OlapRuntimeException(string2, null, null, 6, null);
        }
        LockApplyMail lockInstance = new LockApplyMail();
        lockInstance.waitLock(metadataLock, timeout, unit);
        return lockInstance;
    }

    @Override
    public void close() {
        if (!this._isClosed) {
            this._isClosed = true;
            this._queue.put(this._closeMail);
        }
        this._proxyThread.join(300000L);
    }

    public static final /* synthetic */ void access$run(LockProxy $this) {
        $this.run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0011J'\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u00002\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/LockProxy$LockApplyMail;", "Ljava/io/Closeable;", "(Lkd/bos/olapServer2/storages/sandboxs/LockProxy;)V", "_lock", "Ljava/util/concurrent/locks/ReentrantLock;", "_lockInstance", "_lockState", "Lkd/bos/olapServer2/storages/sandboxs/LockProxy$LockState;", "_olapLock", "Ljava/lang/Object;", "_pleaseCheck", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "lockState", "getLockState", "()Lkd/bos/olapServer2/storages/sandboxs/LockProxy$LockState;", "applyingLock", "", "close", "closeLock", "signalCheck", "signalServiceClosed", "waitLock", "olapLock", "timeout", "", "Lkd/bos/olapServer2/common/long;", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)V", "bos-olap-core2"})
    private final class LockApplyMail
    implements Closeable {
        @NotNull
        private final ReentrantLock _lock = new ReentrantLock();
        private final Condition _pleaseCheck = this._lock.newCondition();
        @Nullable
        private TLock _olapLock;
        @Nullable
        private Closeable _lockInstance;
        @NotNull
        private volatile LockState _lockState = LockState.Applying;

        @NotNull
        public final LockState getLockState() {
            return this._lockState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitLock(TLock olapLock, long timeout, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            long nanos = unit.toNanos(timeout);
            long startTime = System.nanoTime();
            int tryCount = 0;
            this._olapLock = olapLock;
            ReentrantLock lock = this._lock;
            try {
                lock.lockInterruptibly();
                LockProxy.this._queue.put(this);
                block9: while (true) {
                    this._pleaseCheck.await();
                    switch (WhenMappings.$EnumSwitchMapping$0[this._lockState.ordinal()]) {
                        case 1: {
                            if (timeout > 0L && System.nanoTime() - startTime >= nanos) {
                                String string2 = Res.INSTANCE.getCubeDataLockException_1();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeDataLockException_1>(...)");
                                Object[] objectArray = new Object[]{unit.toSeconds(timeout)};
                                throw new TimeoutException(Res.INSTANCE.format(string2, objectArray));
                            }
                            Thread.yield();
                            if (tryCount++ > 100) {
                                Thread.sleep(1L);
                            }
                            this._lockState = LockState.Applying;
                            LockProxy.this._queue.put(this);
                            continue block9;
                        }
                        case 2: {
                            return;
                        }
                        case 3: 
                        case 4: {
                            String string3 = Res.INSTANCE.getOlapWorkspaceException_4();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_4>(...)");
                            throw new OlapRuntimeException(string3, null, null, 6, null);
                        }
                    }
                    break;
                }
                throw SandboxUtils.INSTANCE.notSupportedException(String.valueOf((Object)this._lockState));
            }
            finally {
                lock.unlock();
            }
        }

        public final void applyingLock() {
            Object TLock = this._olapLock;
            Intrinsics.checkNotNull(TLock);
            Closeable readLock = LockProxy.this.tryGetLock(TLock);
            if (readLock == null) {
                this._lockState = LockState.Fail;
            } else {
                this._lockInstance = readLock;
                this._olapLock = null;
                this._lockState = LockState.Ready;
            }
            this.signalCheck();
        }

        public final void closeLock() {
            Closeable closeable = this._lockInstance;
            if (closeable != null) {
                closeable.close();
            }
            this._lockInstance = null;
            this._lockState = LockState.Closed;
        }

        public final void signalServiceClosed() {
            this._olapLock = null;
            this._lockState = LockState.Closed;
            this.signalCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void signalCheck() {
            ReentrantLock lock = this._lock;
            lock.lockInterruptibly();
            try {
                this._pleaseCheck.signal();
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            if (this._lockState == LockState.Ready) {
                this._lockState = LockState.Closing;
                LockProxy.this._queue.put(this);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LockState.values().length];
                try {
                    nArray[LockState.Fail.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LockState.Ready.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LockState.Closing.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LockState.Closed.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/LockProxy$LockState;", "", "(Ljava/lang/String;I)V", "Applying", "Fail", "Ready", "Closing", "Closed", "bos-olap-core2"})
    private static final class LockState
    extends Enum<LockState> {
        public static final /* enum */ LockState Applying = new LockState();
        public static final /* enum */ LockState Fail = new LockState();
        public static final /* enum */ LockState Ready = new LockState();
        public static final /* enum */ LockState Closing = new LockState();
        public static final /* enum */ LockState Closed = new LockState();
        private static final /* synthetic */ LockState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LockState[] values() {
            return (LockState[])$VALUES.clone();
        }

        public static LockState valueOf(String value2) {
            return Enum.valueOf(LockState.class, value2);
        }

        @NotNull
        public static EnumEntries<LockState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lockStateArray = new LockState[]{LockState.Applying, LockState.Fail, LockState.Ready, LockState.Closing, LockState.Closed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LockState.values().length];
            try {
                nArray[LockState.Applying.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LockState.Closing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

