/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.sandboxs;

import java.io.Closeable;
import java.io.Flushable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.collections.IImmutableDictionary;
import kd.bos.olapServer2.collections.IImmutableList;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.collections.IMutableDictionary;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.CachedByteBufferProvider;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspaceUtils;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.storages.sandboxs.GetRowIndexByKeyFun;
import kd.bos.olapServer2.storages.sandboxs.SandboxCubeStorage;
import kd.bos.olapServer2.storages.sandboxs.SandboxMutableDictionary4Added;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001dJ\b\u0010(\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u0014\u0012\b\u0012\u00060\nj\u0002`\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0*J\b\u0010+\u001a\u00020'H\u0016J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bJ\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d02J\u0014\u00103\u001a\u0004\u0018\u00010\u001d2\n\u00104\u001a\u00060\nj\u0002`\u001cJ\n\u00105\u001a\u00060\nj\u0002`\u000bJ\u0018\u00106\u001a\u0014\u0012\b\u0012\u00060\nj\u0002`\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bJ\u0012\u00107\u001a\u00020\u001f2\n\u00104\u001a\u00060\nj\u0002`\u001cJ\u000e\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:J\u001c\u0010;\u001a\u00020'2\n\u00104\u001a\u00060\nj\u0002`\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u001dR\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0018\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR \u0010\u001a\u001a\u0014\u0012\b\u0012\u00060\nj\u0002`\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lkd/bos/olapServer2/storages/sandboxs/SandboxInputRowList;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "tempPool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;)V", "addedDataCount", "", "Lkd/bos/olapServer2/common/long;", "getAddedDataCount", "()J", "addedDataMap", "Lkd/bos/olapServer2/storages/sandboxs/SandboxMutableDictionary4Added;", "dataLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getDataLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "partitionRowSizeSnapshot", "", "sandboxCubeStorage", "Lkd/bos/olapServer2/storages/sandboxs/SandboxCubeStorage;", "updatedDataCount", "getUpdatedDataCount", "updatedDataMap", "Lkd/bos/olapServer2/collections/IMutableDictionary;", "Lkd/bos/olapServer2/common/rowIdx;", "", "addOrUpdate", "", "Lkd/bos/olapServer2/common/bool;", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "value", "getRowIndex", "Lkd/bos/olapServer2/storages/sandboxs/GetRowIndexByKeyFun;", "addOrUpdate4Calc", "", "close", "createImmutableSandboxUpdatedDict", "Lkd/bos/olapServer2/collections/IImmutableDictionary;", "flush", "getAddedDataDimensionList", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "getAddedDataMap", "getAddedDataMeasureList", "Lkd/bos/olapServer2/collections/IImmutableList;", "getAddedDataValue", "rowIndex", "getRowCount", "getUpdatedDataMap", "isOutOfPartitionRange", "onMetadataUpdated", "newMetadata", "Lkd/bos/olapServer2/metadata/Cube;", "update4Calc", "Companion", "bos-olap-core2"})
public final class SandboxInputRowList
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMutableDictionary<Long, Object> updatedDataMap;
    @NotNull
    private SandboxMutableDictionary4Added addedDataMap;
    @NotNull
    private final long[] partitionRowSizeSnapshot;
    @NotNull
    private final ReentrantReadWriteLock dataLock;
    @NotNull
    private final SandboxCubeStorage sandboxCubeStorage;
    public static final int SANDBOX_ADD_DATA_PARTITION = 0x7FFFFF;

    public SandboxInputRowList(@NotNull CubeWorkspace cubeWorkspace, @NotNull ByteBufferResourcePool tempPool) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)tempPool, (String)"tempPool");
        this.dataLock = new ReentrantReadWriteLock();
        this.sandboxCubeStorage = new SandboxCubeStorage(cubeWorkspace.getMetadata(), new CachedByteBufferProvider(tempPool));
        this.updatedDataMap = this.sandboxCubeStorage.createMutableSandboxUpdatedDict();
        this.addedDataMap = this.sandboxCubeStorage.createSandboxAddedDict();
        this.partitionRowSizeSnapshot = CubeWorkspaceUtils.INSTANCE.getPartitionRowSizeSnapshot(cubeWorkspace);
    }

    public SandboxInputRowList(@NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this(cubeWorkspace, new ByteBufferResourcePool(""));
    }

    public final long getAddedDataCount() {
        return this.addedDataMap.getCount();
    }

    public final long getUpdatedDataCount() {
        return this.updatedDataMap.getCount();
    }

    @NotNull
    public final ReentrantReadWriteLock getDataLock() {
        return this.dataLock;
    }

    public final boolean addOrUpdate(@NotNull IDimensionKeys key2, @Nullable Object value2, @NotNull GetRowIndexByKeyFun getRowIndex) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)getRowIndex, (String)"getRowIndex");
        long rowIndex = getRowIndex.invoke(key2);
        if (rowIndex == -1L || this.isOutOfPartitionRange(rowIndex)) {
            this.addedDataMap.addOrUpdate(key2, value2);
        } else {
            this.updatedDataMap.addOrUpdate(rowIndex, value2);
        }
        return true;
    }

    public final void update4Calc(long rowIndex, @Nullable Object value2) {
        int partitionIndex = RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex);
        if (partitionIndex == 0x7FFFFF) {
            long partitionRowIndex = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
            this.addedDataMap.update(partitionRowIndex, value2);
        } else {
            this.updatedDataMap.addOrUpdate(rowIndex, value2);
        }
    }

    public final void addOrUpdate4Calc(@NotNull IDimensionKeys key2, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.addedDataMap.add(key2, value2);
    }

    public final boolean isOutOfPartitionRange(long rowIndex) {
        int partitionIndex = RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex);
        long partitionRowIndex = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        return partitionIndex >= this.partitionRowSizeSnapshot.length || partitionRowIndex >= this.partitionRowSizeSnapshot[partitionIndex];
    }

    public final long getRowCount() {
        return ArraysKt.sum((long[])this.partitionRowSizeSnapshot) + this.getAddedDataCount();
    }

    @NotNull
    public final IImmutableDictionary<Long, Object> createImmutableSandboxUpdatedDict() {
        return this.sandboxCubeStorage.createImmutableSandboxUpdatedDict();
    }

    @NotNull
    public final IImmutableListInt getAddedDataDimensionList(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.sandboxCubeStorage.createSandboxAddedImmutableDimensionList(dimension);
    }

    @NotNull
    public final IImmutableList<Object> getAddedDataMeasureList() {
        return this.sandboxCubeStorage.createSandboxAddedImmutableListMeasure();
    }

    @Override
    public void close() {
        this.sandboxCubeStorage.close();
    }

    @Override
    public void flush() {
        block1: {
            SandboxMutableDictionary4Added sandboxMutableDictionary4Added = this.updatedDataMap;
            Flushable flushable = sandboxMutableDictionary4Added instanceof Flushable ? (Flushable)sandboxMutableDictionary4Added : null;
            if (flushable != null) {
                flushable.flush();
            }
            sandboxMutableDictionary4Added = this.addedDataMap;
            Flushable flushable2 = sandboxMutableDictionary4Added instanceof Flushable ? (Flushable)sandboxMutableDictionary4Added : null;
            if (flushable2 == null) break block1;
            flushable2.flush();
        }
    }

    public final void onMetadataUpdated(@NotNull Cube newMetadata) {
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        if (this.sandboxCubeStorage.updateAddDictZipStructure(newMetadata)) {
            this.addedDataMap = this.sandboxCubeStorage.createSandboxAddedDict();
        }
    }

    @NotNull
    public final IMutableDictionary<Long, Object> getUpdatedDataMap() {
        return this.updatedDataMap;
    }

    @NotNull
    public final IMutableDictionary<IDimensionKeys, Object> getAddedDataMap() {
        return this.addedDataMap;
    }

    @Nullable
    public final Object getAddedDataValue(long rowIndex) {
        return this.addedDataMap.getAddedDataValue(rowIndex);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/SandboxInputRowList$Companion;", "", "()V", "SANDBOX_ADD_DATA_PARTITION", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

