/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.sandboxs;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.common.ManagedResourceList;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.sandboxs.SandboxCubeWorkspaceProxy;
import kd.bos.olapServer2.storages.sandboxs.SandboxMetadataLock;
import kd.bos.olapServer2.storages.sandboxs.SandboxMetadataReadLockProxy;
import kd.bos.olapServer2.storages.sandboxs.SandboxWorkspaceCollection;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00060\u0004j\u0002`\u00152\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0007j\u0002`\bJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u001a\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0007j\u0002`\bJ \u0010\u001a\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0007j\u0002`\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/SandboxWorkspaceCollection;", "Ljava/io/Closeable;", "()V", "_isClosed", "", "_items", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer2/common/string;", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "_metadataReadLockProxy", "Lkotlin/Lazy;", "Lkd/bos/olapServer2/storages/sandboxs/SandboxMetadataReadLockProxy;", "close", "", "createSandboxWorkspace", "source", "identity", "tempPool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "drop", "Lkd/bos/olapServer2/common/bool;", "gc", "gcSandboxWorkspace", "sandBoxWorkspace", "get", "markKey", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSandboxWorkspaceCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SandboxWorkspaceCollection.kt\nkd/bos/olapServer2/storages/sandboxs/SandboxWorkspaceCollection\n+ 2 ResourceCreator.kt\nkd/bos/olapServer2/common/ResourceCreatorKt\n*L\n1#1,183:1\n13#2,17:184\n*S KotlinDebug\n*F\n+ 1 SandboxWorkspaceCollection.kt\nkd/bos/olapServer2/storages/sandboxs/SandboxWorkspaceCollection\n*L\n58#1:184,17\n*E\n"})
public final class SandboxWorkspaceCollection
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, CubeWorkspace> _items = new ConcurrentHashMap();
    @NotNull
    private final Lazy<SandboxMetadataReadLockProxy> _metadataReadLockProxy = LazyKt.lazy((Function0)_metadataReadLockProxy.1.INSTANCE);
    private volatile boolean _isClosed;
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem sandboxCubeWorkspaceUnUseTimeoutConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("GC_SandboxCubeWorkspaceLifeSpan", 1800, 1, Integer.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem sandCubeWorkspaceUnloadTimeoutConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("GC_SandboxCubeWorkspaceUnloadTimeout", 0L, 1L, Long.MAX_VALUE, null, false, false, SandboxWorkspaceCollection::sandCubeWorkspaceUnloadTimeoutConfigItem$lambda$1, 114, null);

    private final String markKey(CubeWorkspace source2, String identity) {
        return source2.getMetadata().getName() + ':' + identity;
    }

    @NotNull
    public final CubeWorkspace createSandboxWorkspace(@NotNull CubeWorkspace source2, @NotNull String identity, @NotNull ByteBufferResourcePool tempPool) {
        CubeWorkspace cubeWorkspace;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)tempPool, (String)"tempPool");
        if (!(!StringsKt.isBlank((CharSequence)identity))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this._isClosed) {
            String string3 = Res.INSTANCE.getOlapWorkspaceException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_4>(...)");
            throw new OlapRuntimeException(string3, null, null, 6, null);
        }
        String key2 = this.markKey(source2, identity);
        CubeWorkspace newItem = this._items.get(key2);
        if (newItem != null) {
            String string4 = Res.INSTANCE.getMetadataCollectionException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-MetadataCollectionException_1>(...)");
            Object[] objectArray = new Object[]{identity};
            throw new OlapRuntimeException(Res.INSTANCE.format(string4, objectArray), null, null, 6, null);
        }
        boolean $i$f$createManagedResource = false;
        List list$iv = new ArrayList();
        ManagedResourceList resources$iv = new ManagedResourceList(list$iv);
        try {
            ManagedResourceList $this$createSandboxWorkspace_u24lambda_u240 = resources$iv;
            boolean bl = false;
            Closeable metadataLockInstance = $this$createSandboxWorkspace_u24lambda_u240.put(((SandboxMetadataReadLockProxy)this._metadataReadLockProxy.getValue()).getLock(source2.getMetadataLock(), 1800L, TimeUnit.SECONDS));
            SandboxCubeWorkspaceProxy sandBoxProxy = $this$createSandboxWorkspace_u24lambda_u240.put(new SandboxCubeWorkspaceProxy(source2, tempPool, metadataLockInstance));
            CubeWorkspace newItem2 = $this$createSandboxWorkspace_u24lambda_u240.put(new CubeWorkspace("Sandbox_" + key2, -1, new SandboxMetadataLock(), sandBoxProxy.getMetadataStorage(), sandBoxProxy));
            CubeWorkspace oldItem = this._items.putIfAbsent(key2, newItem2);
            if (oldItem != null) {
                newItem2.close();
                cubeWorkspace = oldItem;
            } else {
                cubeWorkspace = newItem2;
            }
        }
        catch (Throwable ex$iv) {
            for (AutoCloseable res$iv : list$iv) {
                try {
                    res$iv.close();
                }
                catch (Throwable throwable) {}
            }
            throw ex$iv;
        }
        return cubeWorkspace;
    }

    @NotNull
    public final CubeWorkspace get(@NotNull CubeWorkspace source2, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        String key2 = this.markKey(source2, identity);
        CubeWorkspace cubeWorkspace = this._items.get(key2);
        if (cubeWorkspace == null) {
            String string2 = Res.INSTANCE.getMetadataCollectionException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MetadataCollectionException_4>(...)");
            Object[] objectArray = new Object[]{source2.getMetadata().getName(), identity};
            throw new OlapRuntimeException(Res.INSTANCE.format(string2, objectArray), null, null, 6, null);
        }
        return cubeWorkspace;
    }

    public final boolean drop(@NotNull CubeWorkspace source2, @NotNull String identity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        String key2 = this.markKey(source2, identity);
        CubeWorkspace item = this._items.remove(key2);
        if (item != null) {
            item.close();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void gc() {
        List items2 = MapsKt.toList((Map)this._items);
        for (Pair pair : items2) {
            String identity = (String)pair.component1();
            CubeWorkspace item = (CubeWorkspace)pair.component2();
            if (!item.isClosed()) {
                this.gcSandboxWorkspace(item);
            }
            if (!item.isClosed()) continue;
            this._items.remove(identity);
        }
    }

    private final void gcSandboxWorkspace(CubeWorkspace sandBoxWorkspace) {
        sandBoxWorkspace.gc();
        ICubeMetadataLock metadataLock = sandBoxWorkspace.getMetadataLock();
        if (metadataLock.getBeings().getInitInterval() > (long)Companion.getSandboxCubeWorkspaceUnUseTimeout()) {
            sandBoxWorkspace.close();
            return;
        }
        if (metadataLock.hasHolder()) {
            metadataLock.getBeings().active();
            return;
        }
        if (metadataLock.getBeings().getLastActiveInterval() > Companion.getSandCubeWorkspaceUnloadTimeout()) {
            sandBoxWorkspace.close();
        }
    }

    @Override
    public void close() {
        this._isClosed = true;
        for (CubeWorkspace item : this._items.values()) {
            item.close();
        }
        this._items.clear();
        if (this._metadataReadLockProxy.isInitialized()) {
            ((SandboxMetadataReadLockProxy)this._metadataReadLockProxy.getValue()).close();
        }
    }

    private static final long sandCubeWorkspaceUnloadTimeoutConfigItem$lambda$1() {
        return OlapWorkspace.Companion.getGcTimePeriod() * (long)4;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0011\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0003\u001a\u00060\u000fj\u0002`\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/storages/sandboxs/SandboxWorkspaceCollection$Companion;", "", "()V", "value", "", "Lkd/bos/olapServer2/common/long;", "sandCubeWorkspaceUnloadTimeout", "getSandCubeWorkspaceUnloadTimeout", "()J", "setSandCubeWorkspaceUnloadTimeout", "(J)V", "sandCubeWorkspaceUnloadTimeoutConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "getSandCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "", "Lkd/bos/olapServer2/common/int;", "sandboxCubeWorkspaceUnUseTimeout", "getSandboxCubeWorkspaceUnUseTimeout", "()I", "setSandboxCubeWorkspaceUnUseTimeout", "(I)V", "sandboxCubeWorkspaceUnUseTimeoutConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "getSandboxCubeWorkspaceUnUseTimeoutConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getSandboxCubeWorkspaceUnUseTimeoutConfigItem$bos_olap_core2() {
            return sandboxCubeWorkspaceUnUseTimeoutConfigItem;
        }

        public final int getSandboxCubeWorkspaceUnUseTimeout() {
            return this.getSandboxCubeWorkspaceUnUseTimeoutConfigItem$bos_olap_core2().getValue();
        }

        public final void setSandboxCubeWorkspaceUnUseTimeout(int value2) {
            this.getSandboxCubeWorkspaceUnUseTimeoutConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getSandCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2() {
            return sandCubeWorkspaceUnloadTimeoutConfigItem;
        }

        public final long getSandCubeWorkspaceUnloadTimeout() {
            return this.getSandCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().getValue();
        }

        public final void setSandCubeWorkspaceUnloadTimeout(long value2) {
            this.getSandCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().setValue(value2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

