/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.tempStorages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer2.collections.IMutableList;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.storages.tempStorages.IGetIndexFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004:\u0003\u001c\u001d\u001eB-\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0011\u001a\u00120\u0012R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00028\u00000\u001b0\u001aR&\u0010\r\u001a\u0018\u0012\u0014\u0012\u00120\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList;", "TList", "Lkd/bos/olapServer2/collections/IMutableList;", "E", "", "containerSize", "", "Lkd/bos/olapServer2/common/int;", "listCreator", "Lkotlin/Function0;", "saveToFunc", "Lkd/bos/olapServer2/storages/tempStorages/IGetIndexFunction;", "(ILkotlin/jvm/functions/Function0;Lkd/bos/olapServer2/storages/tempStorages/IGetIndexFunction;)V", "_containers", "", "Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$ContainerUnit;", "[Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$ContainerUnit;", "createWriter", "Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$Writer;", "flush", "", "getCreatedList", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "(Ljava/util/concurrent/atomic/AtomicInteger;)Lkd/bos/olapServer2/collections/IMutableList;", "getCreatedListIterator", "", "Lkotlin/Pair;", "Companion", "ContainerUnit", "Writer", "bos-olap-core2"})
public final class ConcurrentMutableList<TList extends IMutableList<E>, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IGetIndexFunction<E> saveToFunc;
    @NotNull
    private final ContainerUnit[] _containers;
    private static final int DEFAULT_BUFFER_SIZE = 128;

    public ConcurrentMutableList(int containerSize, @NotNull Function0<? extends TList> listCreator, @NotNull IGetIndexFunction<? super E> saveToFunc) {
        Intrinsics.checkNotNullParameter(listCreator, (String)"listCreator");
        Intrinsics.checkNotNullParameter(saveToFunc, (String)"saveToFunc");
        this.saveToFunc = saveToFunc;
        int n = 0;
        ContainerUnit[] containerUnitArray = new ContainerUnit[containerSize];
        ConcurrentMutableList concurrentMutableList = this;
        while (n < containerSize) {
            int n2 = n++;
            containerUnitArray[n2] = new ContainerUnit(listCreator);
        }
        concurrentMutableList._containers = containerUnitArray;
    }

    @Nullable
    public final TList getCreatedList(@NotNull AtomicInteger index2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        int i = index2.getAndIncrement();
        while (true) {
            boolean bl = 0 <= i ? i < this._containers.length : false;
            if (!bl) break;
            Object result2 = this._containers[i].getCreatedList();
            if (result2 != null) {
                return result2;
            }
            i = index2.getAndIncrement();
        }
        return null;
    }

    @NotNull
    public final Iterable<Pair<Integer, TList>> getCreatedListIterator() {
        List result2 = new ArrayList();
        int n = this._containers.length;
        for (int i = 0; i < n; ++i) {
            Object list2 = this._containers[i].getCreatedList();
            if (list2 == null) continue;
            result2.add(new Pair((Object)i, list2));
        }
        return result2;
    }

    @NotNull
    public final Writer createWriter() {
        return new Writer();
    }

    public final void flush() {
        for (ContainerUnit container : this._containers) {
            container.flush();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$Companion;", "", "()V", "DEFAULT_BUFFER_SIZE", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u000e\b\u0002\u0010\u0010*\b\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\u0011\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017H\u0002J\r\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000eR\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$ContainerUnit;", "", "listCreator", "Lkotlin/Function0;", "(Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList;Lkotlin/jvm/functions/Function0;)V", "_list", "Lkd/bos/olapServer2/collections/IMutableList;", "_lock", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "createdList", "getCreatedList", "()Lkd/bos/olapServer2/collections/IMutableList;", "addItems", "TList", "items", "(Ljava/lang/Iterable;)Ljava/lang/Iterable;", "flush", "", "flushCore", "list", "Lkd/bos/olapServer2/collections/IMutableList;", "getOrCreateList", "nullListCreator", "bos-olap-core2"})
    private final class ContainerUnit {
        @NotNull
        private Function0<? extends TList> listCreator;
        @NotNull
        private final AtomicBoolean _lock;
        @NotNull
        private final ConcurrentLinkedQueue<Iterable<E>> _queue;
        @Nullable
        private volatile TList _list;

        public ContainerUnit(Function0<? extends TList> listCreator) {
            Intrinsics.checkNotNullParameter(listCreator, (String)"listCreator");
            this.listCreator = listCreator;
            this._lock = new AtomicBoolean();
            this._queue = new ConcurrentLinkedQueue();
        }

        private final IMutableList<E> getOrCreateList() {
            Object result2 = this._list;
            if (result2 == null) {
                result2 = (IMutableList)this.listCreator.invoke();
                this.listCreator = new Function0<TList>(this){

                    @NotNull
                    public final TList invoke() {
                        return (TList)ContainerUnit.access$nullListCreator((ContainerUnit)this.receiver);
                    }
                };
                this._list = result2;
            }
            return result2;
        }

        @Nullable
        public final TList getCreatedList() {
            return this._list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final <TList extends Iterable<? extends E>> TList addItems(@NotNull TList items2) {
            TList TList;
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            if (this._lock.compareAndSet(false, true)) {
                TList TList2;
                try {
                    IMutableList list2 = this.getOrCreateList();
                    this.flushCore(list2);
                    for (Object item : items2) {
                        list2.add(item);
                    }
                    this.flushCore(list2);
                    TList2 = items2;
                }
                finally {
                    this._lock.set(false);
                }
                TList = TList2;
            } else {
                this._queue.offer(items2);
                TList = null;
            }
            return TList;
        }

        private final void flushCore(IMutableList<E> list2) {
            Iterable otherItems = this._queue.poll();
            while (otherItems != null) {
                for (Object item : otherItems) {
                    list2.add(item);
                }
                otherItems = this._queue.poll();
            }
        }

        public final void flush() {
            if (!((Collection)this._queue).isEmpty()) {
                boolean tryLock = this._lock.compareAndSet(false, true);
                if (!tryLock) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                this.flushCore(this.getOrCreateList());
            }
        }

        private final TList nullListCreator() {
            throw new NotSupportedException();
        }

        public static final /* synthetic */ IMutableList access$nullListCreator(ContainerUnit $this) {
            return $this.nullListCreator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\tJ$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0005j\b\u0012\u0004\u0012\u00028\u0001`\u00062\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002R&\u0010\u0003\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00010\u0005j\b\u0012\u0004\u0012\u00028\u0001`\u00060\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList$Writer;", "", "(Lkd/bos/olapServer2/storages/tempStorages/ConcurrentMutableList;)V", "_buffer", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "[Ljava/util/ArrayList;", "add", "", "item", "(Ljava/lang/Object;)V", "flush", "containerIndex", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
    public final class Writer {
        @NotNull
        private final ArrayList<E>[] _buffer;

        public Writer() {
            int n = 0;
            int n2 = ConcurrentMutableList.this._containers.length;
            ArrayList[] arrayListArray = new ArrayList[n2];
            Writer writer = this;
            while (n < n2) {
                int n3 = n++;
                arrayListArray[n3] = new ArrayList(128);
            }
            writer._buffer = arrayListArray;
        }

        public final void add(E item) {
            int containerIndex = ConcurrentMutableList.this.saveToFunc.invoke(item);
            ArrayList buffer = this._buffer[containerIndex];
            if (buffer.size() >= 128) {
                buffer = this.flush(containerIndex);
            }
            buffer.add(item);
        }

        public final void flush() {
            int n = this._buffer.length;
            for (int i = 0; i < n; ++i) {
                this.flush(i);
            }
        }

        private final ArrayList<E> flush(int containerIndex) {
            ArrayList arrayList;
            ArrayList currentBuffer = this._buffer[containerIndex];
            if (!((Collection)currentBuffer).isEmpty()) {
                ArrayList arrayList2;
                ArrayList buffer2 = (ArrayList)ConcurrentMutableList.this._containers[containerIndex].addItems((Iterable)currentBuffer);
                if (buffer2 == null) {
                    arrayList2 = new ArrayList(128);
                } else {
                    buffer2.clear();
                    arrayList2 = buffer2;
                }
                ArrayList result2 = arrayList2;
                this._buffer[containerIndex] = result2;
                arrayList = result2;
            } else {
                arrayList = currentBuffer;
            }
            return arrayList;
        }
    }
}

