/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.tempStorages;

import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.memoryMappedFiles.IntArrayEncoder;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodeContext;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.Encoding;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodingVersion;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.ImmutableListAny;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a\u00060\tj\u0002`\n2\n\u0010\b\u001a\u00060\tj\u0002`\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/MemorySubCube;", "", "dimAndMembers", "", "", "([[I)V", "converter", "Lkd/bos/olapServer2/memoryMappedFiles/IntArrayEncoder;", "value", "", "Lkd/bos/olapServer2/common/int;", "hashJoinMaxSize", "getHashJoinMaxSize", "()I", "setHashJoinMaxSize", "(I)V", "valueEncoder", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;", "values", "", "createWriter", "Lkd/bos/olapServer2/storages/tempStorages/MemorySubCube$MemorySubCubeWriter;", "get", "pos", "MemorySubCubeWriter", "bos-olap-core2"})
public final class MemorySubCube {
    @NotNull
    private final IntArrayEncoder converter;
    @NotNull
    private final Encoding valueEncoder;
    @NotNull
    private final long[] values;

    public MemorySubCube(@NotNull int[][] dimAndMembers) {
        Intrinsics.checkNotNullParameter((Object)dimAndMembers, (String)"dimAndMembers");
        this.converter = new IntArrayEncoder(dimAndMembers);
        this.valueEncoder = new Encoding(EncodingVersion.V2);
        if (this.converter.getMax() > this.getHashJoinMaxSize()) {
            String string2 = Res.INSTANCE.getMemorySubCubeException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MemorySubCubeException_1>(...)");
            Object[] objectArray = new Object[]{this.getHashJoinMaxSize()};
            throw Res.INSTANCE.getIllegalArgumentException(string2, objectArray);
        }
        this.values = new long[this.converter.getMax()];
    }

    private final int getHashJoinMaxSize() {
        return OlapConfigItems.INSTANCE.getHashJoinMaxSizeConfigItem$bos_olap_core2().getValue();
    }

    private final void setHashJoinMaxSize(int value2) {
        OlapConfigItems.INSTANCE.getHashJoinMaxSizeConfigItem$bos_olap_core2().setValue(value2);
    }

    @Nullable
    public final Object get(@NotNull int[] pos) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int idx = this.converter.toX(pos);
        long indexValue = this.values[idx];
        if (indexValue == 0L) {
            object2 = null;
        } else if (indexValue < 0L) {
            object2 = this.valueEncoder.decode(indexValue);
        } else {
            int len = ImmutableListAny.Companion.getLength(indexValue);
            if (len <= 6) {
                object2 = this.valueEncoder.decode(indexValue, len);
            } else {
                throw new NotSupportedException("not support from heap get value in MemorySubCube.");
            }
        }
        return object2;
    }

    @NotNull
    public final MemorySubCubeWriter createWriter() {
        return new MemorySubCubeWriter(this.converter, this.values, this.valueEncoder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/storages/tempStorages/MemorySubCube$MemorySubCubeWriter;", "", "converter", "Lkd/bos/olapServer2/memoryMappedFiles/IntArrayEncoder;", "values", "", "valueEncoder", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;", "(Lkd/bos/olapServer2/memoryMappedFiles/IntArrayEncoder;[JLkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;)V", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodeContext;", "set", "", "pos", "", "v", "bos-olap-core2"})
    public static final class MemorySubCubeWriter {
        @NotNull
        private final IntArrayEncoder converter;
        @NotNull
        private final long[] values;
        @NotNull
        private final Encoding valueEncoder;
        @NotNull
        private final EncodeContext ctx;

        public MemorySubCubeWriter(@NotNull IntArrayEncoder converter, @NotNull long[] values, @NotNull Encoding valueEncoder) {
            Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)valueEncoder, (String)"valueEncoder");
            this.converter = converter;
            this.values = values;
            this.valueEncoder = valueEncoder;
            this.ctx = new EncodeContext();
        }

        public final void set(@NotNull int[] pos, @Nullable Object v) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            int idx = this.converter.toX(pos);
            if (v == null) {
                this.values[idx] = 0L;
            } else {
                long indexValue = this.valueEncoder.encode(v, this.ctx);
                if (indexValue < 0L || this.ctx.getLen() <= 6) {
                    this.values[idx] = indexValue;
                } else {
                    throw new NotSupportedException("not support set value[" + v + "] to heap in MemorySubCube.");
                }
            }
        }
    }
}

