/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.writers;

import kd.bos.olapServer.dataAdapter.IDimensionKeysWriter;
import kd.bos.olapServer2.collections.IMutableIndexMap;
import kd.bos.olapServer2.collections.IntArrayDimensionKeys;
import kd.bos.olapServer2.collections.MutableIndexMap;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.minListIntV3.MinMutableListDimensionKeys;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.storages.bitmapIndexes.WriterArrayPool;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0014\u0010\u0019\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u0012j\u0002`\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u00122\n\u0010\u001a\u001a\u00060\u0012j\u0002`\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u00122\n\u0010\u001a\u001a\u00060\u0012j\u0002`\u001bH\u0002J\u0014\u0010\u001e\u001a\u00020\u00102\n\u0010\u001a\u001a\u00060\u0012j\u0002`\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/storages/writers/DimensionKeysWriter;", "Lkd/bos/olapServer/dataAdapter/IDimensionKeysWriter;", "type", "", "Lkd/bos/olapServer2/common/string;", "resourcePool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "(Ljava/lang/String;Lkd/bos/olapServer2/storages/CubeResourcePool;)V", "_arrayPool", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool;", "_cache", "Lkd/bos/olapServer2/storages/bitmapIndexes/WriterArrayPool$SegmentCellSetCache;", "_dimensionCount", "", "Lkd/bos/olapServer2/common/int;", "_isFlush", "", "_writeCount", "", "getType", "()Ljava/lang/String;", "buildDictionary", "", "close", "flush", "getLastSegmentCount", "rowCount", "Lkd/bos/olapServer2/common/rowIdx;", "getSegmentCount", "getSegmentStartIndex", "isFullSegment", "write", "keys", "", "writeUnzipSegment", "bos-olap-core2"})
public final class DimensionKeysWriter
implements IDimensionKeysWriter {
    @NotNull
    private final String type;
    @NotNull
    private final CubeResourcePool resourcePool;
    private final int _dimensionCount;
    @NotNull
    private final WriterArrayPool _arrayPool;
    @NotNull
    private final WriterArrayPool.SegmentCellSetCache _cache;
    private long _writeCount;
    private boolean _isFlush;

    public DimensionKeysWriter(@NotNull String type, @NotNull CubeResourcePool resourcePool) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)resourcePool, (String)"resourcePool");
        this.type = type;
        this.resourcePool = resourcePool;
        this._dimensionCount = this.resourcePool.getSharedResource().getDimensionCount();
        this._arrayPool = WriterArrayPool.Companion.getOrCreate();
        this._cache = this._arrayPool.createSegmentCellSetCache(this._dimensionCount);
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    private final long getSegmentStartIndex(long rowCount) {
        return rowCount & 0x7FFFFFFFFFFF0000L;
    }

    private final int getLastSegmentCount(long rowCount) {
        return (int)(rowCount & 0xFFFFL);
    }

    private final boolean isFullSegment(long rowCount) {
        return (rowCount & 0xFFFFL) == 0L;
    }

    private final long getSegmentCount(long rowCount) {
        return rowCount >> 16;
    }

    public void write(@NotNull int[] keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        if (!(!this._isFlush)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int lastSegmentCount = this.getLastSegmentCount(this._writeCount);
        int n = this._dimensionCount;
        for (int i = 0; i < n; ++i) {
            this._cache.getIntArray((int)i)[lastSegmentCount] = keys[i];
        }
        long i = this._writeCount;
        this._writeCount = i + 1L;
        if (this.isFullSegment(this._writeCount)) {
            n = this._dimensionCount;
            for (int dimensionPosition = 0; dimensionPosition < n; ++dimensionPosition) {
                this.resourcePool.getZipInputRowList().zip(this._arrayPool, dimensionPosition, this._cache.getIntArray(dimensionPosition), this._writeCount - (long)65536);
            }
        }
    }

    private final void writeUnzipSegment() {
        long splitCount = this.getSegmentStartIndex(this._writeCount);
        this.resourcePool.getSharedResource().getMainUnzipKeyMetadata().setStart(this.getSegmentCount(splitCount));
        MinMutableListDimensionKeys list2 = this.resourcePool.getDataStorage().createUnzipMutableListDimensionKeys(splitCount);
        int[] cacheArray = new int[this._dimensionCount];
        IntArrayDimensionKeys dimensionKeys = new IntArrayDimensionKeys(cacheArray);
        int n = this.getLastSegmentCount(this._writeCount);
        for (int segmentRowIndex = 0; segmentRowIndex < n; ++segmentRowIndex) {
            int n2 = this._dimensionCount;
            for (int dimension = 0; dimension < n2; ++dimension) {
                cacheArray[dimension] = this._cache.getIntArray(dimension)[segmentRowIndex];
            }
            list2.add(dimensionKeys);
        }
        list2.flush();
        this.resourcePool.setSplitCount(splitCount);
        this.resourcePool.setRowCount(this._writeCount);
    }

    private final void buildDictionary() {
        IMutableIndexMap<IDimensionKeys> map2 = this.resourcePool.getDataStorage().createDimensionKeysMap(this.resourcePool.getSplitCount(), this.resourcePool.getRowCount());
        Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kd.bos.olapServer2.collections.MutableIndexMap<kd.bos.olapServer2.dataEntities.IDimensionKeys>");
        ((MutableIndexMap)map2).buildDictionary();
        ((MutableIndexMap)map2).flush();
    }

    public void flush() {
        if (!this._isFlush) {
            this._isFlush = true;
            this.writeUnzipSegment();
            this.buildDictionary();
        }
    }

    public void close() {
    }
}

