/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages.writers;

import kd.bos.olapServer.dataAdapter.IMetadataWriter;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.DefaultByteBufferProvider;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IntArrayOutputStream;
import kd.bos.olapServer2.memoryMappedFiles.xObjects.XObjectDictionary;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\"\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer2/storages/writers/MetadataWriter;", "Lkd/bos/olapServer/dataAdapter/IMetadataWriter;", "path", "", "Lkd/bos/olapServer2/common/string;", "onMetadataUpdate", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "_lastCustomFieldId", "", "_lastObjectId", "_lastSpecialId", "dict", "Lkd/bos/olapServer2/memoryMappedFiles/xObjects/XObjectDictionary;", "provider", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider;", "type", "getType", "()Ljava/lang/String;", "close", "flush", "updateLastId", "objectId", "fieldId", "write", "value", "", "bos-olap-core2"})
public final class MetadataWriter
implements IMetadataWriter {
    @NotNull
    private final Function0<Unit> onMetadataUpdate;
    @NotNull
    private final DefaultByteBufferProvider provider;
    @NotNull
    private final XObjectDictionary dict;
    private int _lastObjectId;
    private int _lastSpecialId;
    private int _lastCustomFieldId;

    public MetadataWriter(@NotNull String path, @NotNull Function0<Unit> onMetadataUpdate) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(onMetadataUpdate, (String)"onMetadataUpdate");
        this.onMetadataUpdate = onMetadataUpdate;
        this.provider = new DefaultByteBufferProvider(path);
        this.dict = XObjectDictionary.Companion.create(this.provider, false);
        this._lastObjectId = -1;
        this._lastSpecialId = -2;
        this._lastCustomFieldId = 10000;
    }

    public void write(int objectId, int fieldId, @Nullable Object value2) {
        this.updateLastId(objectId, fieldId);
        if (value2 instanceof int[]) {
            this.dict.add(objectId, fieldId, new IntArrayOutputStream((int[])value2));
        } else {
            this.dict.add(objectId, fieldId, value2);
        }
    }

    private final void updateLastId(int objectId, int fieldId) {
        if (objectId > this._lastObjectId) {
            this._lastObjectId = objectId;
        } else if (objectId < this._lastSpecialId) {
            this._lastSpecialId = objectId;
        }
        if (fieldId > this._lastCustomFieldId) {
            this._lastCustomFieldId = fieldId;
        }
    }

    @NotNull
    public String getType() {
        return "Metadata Writer";
    }

    public void flush() {
        this.dict.incrementXObjectId(this._lastObjectId - -1);
        this.dict.decrementSpecialId(-2 - this._lastSpecialId);
        this.dict.incrementFieldId(this._lastCustomFieldId - 10000);
        this.dict.flush();
    }

    public void close() {
        this.provider.close();
        this.onMetadataUpdate.invoke();
    }
}

