/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.collections.IQueryBitmap;
import kd.bos.olapServer2.collections.NumberSetFilter;
import kd.bos.olapServer2.collections.VirtualImmutableListLong;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/tools/BitMapCheckTool;", "", "()V", "check", "", "workspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "checkBitMap", "olapServer", "Lkd/bos/olapServer2/server/OlapServer;", "path", "", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nBitMapCheckTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitMapCheckTool.kt\nkd/bos/olapServer2/tools/BitMapCheckTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1855#2,2:128\n1855#2,2:130\n*S KotlinDebug\n*F\n+ 1 BitMapCheckTool.kt\nkd/bos/olapServer2/tools/BitMapCheckTool\n*L\n32#1:128,2\n124#1:130,2\n*E\n"})
public final class BitMapCheckTool {
    @NotNull
    public static final BitMapCheckTool INSTANCE = new BitMapCheckTool();

    private BitMapCheckTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkBitMap(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long t2 = OlapWorkspace.Companion.getCubeWorkspaceUnloadTimeout();
        try {
            OlapWorkspace.Companion.setCubeWorkspaceUnloadTimeout(1L);
            Closeable closeable = new OlapServer(path, true, 10L);
            Throwable throwable = null;
            try {
                OlapServer it = (OlapServer)closeable;
                boolean bl = false;
                INSTANCE.checkBitMap(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            OlapWorkspace.Companion.setCubeWorkspaceUnloadTimeout(t2);
        }
    }

    public final void checkBitMap(@NotNull OlapServer olapServer) {
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        List<String> cubes = olapServer.getCubes();
        int count = 0;
        Iterable $this$forEach$iv = cubes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CubeWorkspace workspace;
            Object object2;
            CubeWorkspace cubeWorkspace;
            String it = (String)element$iv;
            boolean bl = false;
            ++count;
            try {
                cubeWorkspace = olapServer.getOlapWorkspace$bos_olap_core2().getCubeWorkspace(it);
            }
            catch (Throwable e) {
                System.out.println((Object)("\u52a0\u8f7d'" + it + "' \u5728\u521d\u59cb\u5316CubeWorkspace\u7684\u65f6\u5019\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + e.getMessage()));
                cubeWorkspace = null;
            }
            if ((object2 = (workspace = cubeWorkspace)) != null && (object2 = ((CubeWorkspace)object2).getMetadataLock()) != null) {
                object2.enterRead((Function0)new Function0<Unit>(workspace){
                    final /* synthetic */ CubeWorkspace $workspace;
                    {
                        this.$workspace = $workspace;
                        super(0);
                    }

                    public final void invoke() {
                        Iterator<T> iterator2 = this.$workspace.getPartitionWorkspaces().iterator();
                        while (iterator2.hasNext()) {
                            BitMapCheckTool.access$check(BitMapCheckTool.INSTANCE, (AbstractCubeWorkspace)iterator2.next());
                        }
                    }
                });
            }
            if (count % 100 != 0) continue;
            System.out.println((Object)("\u5df2\u5904\u7406cube\u4e2a\u6570\uff1a\u3010" + count + '/' + cubes.size() + '\u3011'));
        }
    }

    private final void check(AbstractCubeWorkspace workspace) {
        Cube cube = workspace.getMetadata();
        long rowSize = workspace.getRowCount();
        List tasks = new ArrayList();
        long splitCount = workspace.getResourcePool().getSplitCount();
        if (splitCount == 0L) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(CollectionsKt.count((Iterable)cube.getDimensions()));
        if (splitCount % (long)64 != 0L) {
            throw new RuntimeException("splitCount \u4e3a " + splitCount + ", \u4e0d\u662f 64 \u7684\u500d\u6570\u3002");
        }
        long longSize = splitCount / (long)64;
        for (Dimension dim : cube.getDimensions()) {
            IImmutableListInt source2 = workspace.getDataStorage().createImmutableListInt(dim, splitCount, rowSize);
            Future<?> task = executor.submit(() -> BitMapCheckTool.check$lambda$2(splitCount, source2, dim, workspace, cube, longSize));
            Intrinsics.checkNotNull(task);
            tasks.add(task);
        }
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
        executor.shutdown();
    }

    private static final void check$lambda$2(long $splitCount, IImmutableListInt $source, Dimension $dim, AbstractCubeWorkspace $workspace, Cube $cube, long $longSize) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$dim, (String)"$dim");
        Intrinsics.checkNotNullParameter((Object)$workspace, (String)"$workspace");
        Intrinsics.checkNotNullParameter((Object)$cube, (String)"$cube");
        Set set = new LinkedHashSet();
        for (long s = 0L; s < $splitCount; ++s) {
            set.add($source.get(s));
        }
        List list2 = new ArrayList();
        for (Member member : $dim.getMembers()) {
            if (member.isSimpleMember()) continue;
            IQueryBitmap b1 = $workspace.getDataStorage().createQueryBitmap(member.getGlobalID());
            if (!set.contains(member.getPosition())) {
                if (b1.afterValueIsZero(0L)) continue;
                throw new RuntimeException("cube\u540d\u79f0\uff1a" + $cube.getName() + ", \u7ef4\u5ea6\u540d\u79f0\uff1a" + $dim.getName() + ", \u6210\u5458\u540d\u79f0\uff1a" + member.getName() + " \u4e3b\u6570\u636e\u4e2d\u6ca1\u6570\u636e\uff0c\u4f46\u662f\u4f4d\u56fe\u4e2d\u6709\u6570\u636e\u3002");
            }
            list2.add(new Pair((Object)member.getPosition(), (Object)b1));
        }
        for (long i = 0L; i < $longSize; ++i) {
            Set set64 = new LinkedHashSet();
            long l = i * (long)64 + (long)64;
            for (long j = i * (long)64; j < l; ++j) {
                set64.add($source.get(j));
            }
            for (Pair pair : list2) {
                int position = ((Number)pair.component1()).intValue();
                IQueryBitmap bitmap2 = (IQueryBitmap)pair.component2();
                if (!set64.contains(position)) {
                    if (bitmap2.get(i) == 0L) continue;
                    throw new RuntimeException("cube\u540d\u79f0\uff1a" + $cube.getName() + ", \u7ef4\u5ea6\u540d\u79f0\uff1a" + $dim.getName() + ", \u6210\u5458\u540d\u79f0\uff1a" + $dim.getMembers().get(position).getName() + ", \u7b2c " + i + " \u4e2aLong\u503c, \u671f\u671b\u662f 0, \u5b9e\u9645\u662f " + bitmap2.get(i) + ' ');
                }
                NumberSetFilter matcher = new NumberSetFilter(16384);
                matcher.add(position);
                VirtualImmutableListLong b2 = new VirtualImmutableListLong($source, matcher.getWhiteListFilter());
                if (b2.get(i) == bitmap2.get(i)) continue;
                throw new RuntimeException("cube\u540d\u79f0\uff1a" + $cube.getName() + ", \u7ef4\u5ea6\u540d\u79f0\uff1a" + $dim.getName() + ", \u6210\u5458\u540d\u79f0\uff1a" + $dim.getMembers().get(position).getName() + ", \u7b2c " + i + " \u4e2aLong\u503c, \u671f\u671b\u662f " + b2.get(i) + ", \u5b9e\u9645\u662f " + bitmap2.get(i) + ' ');
            }
        }
    }

    public static final /* synthetic */ void access$check(BitMapCheckTool $this, AbstractCubeWorkspace workspace) {
        $this.check(workspace);
    }
}

