/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\"\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\n\u0010\u0010\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u0011\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0012\u001a\u00020\nJ5\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0016\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\u0018J\"\u0010\u0019\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001a\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001b\u001a\u00060\u0006j\u0002`\u0007J\u000e\u0010\u001c\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007J\u0012\u0010\u001d\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\n\u0010\u001e\u001a\u00060\rj\u0002`\u000eJD\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0010\u0010\"\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070#2\f\b\u0002\u0010$\u001a\u00060\rj\u0002`\u000e2\f\b\u0002\u0010%\u001a\u00060\rj\u0002`\u000eJ\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002J\u001e\u0010)\u001a\u00060\rj\u0002`\u000e2\u0006\u0010*\u001a\u00020\n2\n\u0010+\u001a\u00060\u0006j\u0002`\u0007J\"\u0010,\u001a\u00060\rj\u0002`\u000e2\n\u0010-\u001a\u00060\u0006j\u0002`\u00072\n\u0010.\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006/"}, d2={"Lkd/bos/olapServer2/tools/FileTools;", "", "()V", "autoMakeDir", "", "path", "", "Lkd/bos/olapServer2/common/string;", "copyFileByChannel", "sourceFile", "Ljava/io/File;", "targetFile", "createFile", "", "Lkd/bos/olapServer2/common/bool;", "filePath", "isfile", "deleteDir", "dir", "getContainerCount", "", "Lkd/bos/olapServer2/common/int;", "pre", "suffix", "getContainerCount$bos_olap_core2", "getOrCreateDir", "rootPath", "key", "getServerRootFolderPath", "isExist", "isWin", "moveDir", "sourceDir", "targetDir", "doNotMoveFileSet", "", "isThrowException", "skipExistingFile", "moveFile", "srcFile", "destFile", "rename", "file", "newName", "writeToFile", "contents", "url", "bos-olap-core2"})
public final class FileTools {
    @NotNull
    public static final FileTools INSTANCE = new FileTools();

    private FileTools() {
    }

    public final boolean createFile(@NotNull String filePath, boolean isfile) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File f = PathsKt.fileSafeConstructor(filePath);
        return isfile ? f.createNewFile() : f.mkdirs();
    }

    public final boolean isExist(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File f = PathsKt.fileSafeConstructor(filePath);
        return f.exists();
    }

    public final void autoMakeDir(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File f = PathsKt.fileSafeConstructor(path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public final boolean rename(@NotNull File file, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String preName = file.getName();
        String string2 = file.getParentFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        Intrinsics.checkNotNull((Object)preName);
        File targetFile = Paths.INSTANCE.toFile(string2, StringsKt.replace$default((String)string3, (String)preName, (String)newName, (boolean)false, (int)4, null));
        return file.renameTo(targetFile);
    }

    @NotNull
    public final String getOrCreateDir(@NotNull String rootPath, @NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        String[] stringArray = new String[]{key2};
        String dir = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
        this.autoMakeDir(dir);
        return dir;
    }

    public final boolean deleteDir(@NotNull File dir) {
        String[] children;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        boolean result2 = true;
        if (dir.isDirectory() && !((stringArray = (children = dir.list())) == null || stringArray.length == 0)) {
            Intrinsics.checkNotNull((Object)children);
            for (String element : children) {
                Intrinsics.checkNotNull((Object)element);
                boolean success = this.deleteDir(Paths.INSTANCE.toFile(dir, element));
                if (success) continue;
                result2 = false;
            }
        }
        return result2 ? dir.delete() : false;
    }

    public final int getContainerCount$bos_olap_core2(@NotNull String path, @NotNull String pre, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pre, (String)"pre");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (!(((CharSequence)pre).length() > 0 && ((CharSequence)suffix).length() > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int count = 0;
        File file = Paths.INSTANCE.toFile(path, pre + '.' + suffix);
        while (file.exists() && file.isFile()) {
            file = Paths.INSTANCE.toFile(path, pre + ++count + '.' + suffix);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeToFile(@NotNull String contents, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            FileWriter writer = new FileWriter(url);
            Closeable closeable = writer;
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                writer.write(contents);
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            String string2 = Res.INSTANCE.getFileToolsException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-FileToolsException_1>(...)");
            Object[] objectArray = new Object[]{e.getMessage()};
            throw Res.INSTANCE.getRuntimeException(string2, e, objectArray);
        }
        return true;
    }

    public final void moveDir(@NotNull File sourceDir, @NotNull File targetDir, @NotNull Set<String> doNotMoveFileSet, boolean isThrowException, boolean skipExistingFile) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(doNotMoveFileSet, (String)"doNotMoveFileSet");
        if (!(sourceDir.exists() && sourceDir.isDirectory())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(!targetDir.exists() || sourceDir.isDirectory())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        if ((files = sourceDir.listFiles()) != null) {
            for (File file : files) {
                String string4 = targetDir.getAbsolutePath().toString();
                String string5 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                File targetFile = Paths.INSTANCE.toFile(string4, string5);
                if (file.isFile()) {
                    if (doNotMoveFileSet.contains(file.getName())) continue;
                    try {
                        if (skipExistingFile && targetFile.exists()) continue;
                        Intrinsics.checkNotNull((Object)file);
                        this.moveFile(file, targetFile);
                        continue;
                    }
                    catch (Exception e) {
                        if (!isThrowException) continue;
                        String string6 = Res.INSTANCE.getFileToolsException_2();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-FileToolsException_2>(...)");
                        Object[] objectArray = new Object[]{file.getName()};
                        throw Res.INSTANCE.getRuntimeException(string6, objectArray);
                    }
                }
                if (doNotMoveFileSet.contains(file.getName())) continue;
                Intrinsics.checkNotNull((Object)file);
                FileTools.moveDir$default(this, file, targetFile, doNotMoveFileSet, isThrowException, false, 16, null);
            }
        }
        File[] fileArray = sourceDir.listFiles();
        boolean bl = fileArray != null ? fileArray.length == 0 : false;
        if (bl && !sourceDir.delete() && isThrowException) {
            String string7 = Res.INSTANCE.getFileToolsException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-FileToolsException_3>(...)");
            Object[] objectArray = new Object[]{sourceDir.getName()};
            throw Res.INSTANCE.getRuntimeException(string7, objectArray);
        }
    }

    public static /* synthetic */ void moveDir$default(FileTools fileTools, File file, File file2, Set set, boolean bl, boolean bl2, int n, Object object2) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        fileTools.moveDir(file, file2, set, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFileByChannel(@NotNull File sourceFile, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile + " not found");
        }
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        Object object2 = new OpenOption[]{StandardOpenOption.READ};
        object2 = FileChannel.open(sourceFile.toPath(), object2);
        Throwable throwable = null;
        try {
            long l;
            FileChannel source2 = (FileChannel)object2;
            boolean bl = false;
            Object object3 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            object3 = FileChannel.open(targetFile.toPath(), object3);
            Throwable throwable2 = null;
            try {
                FileChannel target = (FileChannel)object3;
                boolean bl2 = false;
                l = target.transferFrom(source2, 0L, source2.size());
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    private final void moveFile(File srcFile, File destFile) {
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source " + srcFile + " does not exist");
        }
        if (!srcFile.isFile()) {
            throw new IllegalArgumentException("Parameter srcFile is not a file: " + srcFile);
        }
        if (destFile.exists()) {
            throw new FileExistsException("File element in parameter destFile already exists: " + destFile);
        }
        boolean rename = srcFile.renameTo(destFile);
        if (!rename) {
            if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
                throw new IllegalArgumentException("File canonical paths are equal: " + srcFile.getCanonicalPath() + " (file1=" + srcFile + ", file2=" + destFile + ')');
            }
            if (!destFile.getParentFile().mkdirs() && !destFile.getParentFile().isDirectory()) {
                throw new IOException("Cannot create directory '" + destFile.getParentFile() + "'.");
            }
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Files.copy(srcFile.toPath(), destFile.toPath(), copyOptionArray);
            if (!srcFile.delete()) {
                FileUtils.deleteQuietly((File)destFile);
                throw new RuntimeException("can not delete file: " + srcFile.getAbsolutePath());
            }
        }
    }

    public final boolean isWin() {
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return StringsKt.contains((CharSequence)string2, (CharSequence)"win", (boolean)true);
    }

    @Nullable
    public final String getServerRootFolderPath() {
        String string2;
        String jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        Intrinsics.checkNotNull((Object)jarPath);
        if (StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
            if (!PathsKt.toFile(jarPath).exists()) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            File olapServerFolder = PathsKt.toFile(jarPath).getParentFile().getParentFile().getParentFile();
            if (!olapServerFolder.exists()) {
                String string4 = "Failed requirement.";
                throw new IllegalArgumentException(string4.toString());
            }
            string2 = olapServerFolder.getAbsolutePath();
        } else {
            string2 = null;
        }
        return string2;
    }
}

