/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kd.bos.olapServer2.dataSources.ExceptionInfo;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lkd/bos/olapServer2/tools/HttpTools;", "", "()V", "Companion", "bos-olap-core2"})
public final class HttpTools {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(Companion.getClass());

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nJ\u0016\u0010\u000b\u001a\u00060\tj\u0002`\n2\n\u0010\b\u001a\u00060\tj\u0002`\nJM\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\tj\u0002`\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\tj\u0002`\n2!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\r0\u0014J2\u0010\u0019\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\tj\u0002`\n2\n\u0010\u0012\u001a\u00060\tj\u0002`\n2\n\u0010\u001a\u001a\u00060\tj\u0002`\n2\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\tj\u0002`\n2\n\u0010\u001a\u001a\u00060\tj\u0002`\n2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0012\u001a\u00060\tj\u0002`\nH\u0002J\u000e\u0010\u001e\u001a\u00020\r*\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/tools/HttpTools$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInetAddressByString", "Ljava/net/InetAddress;", "ipAddress", "", "Lkd/bos/olapServer2/common/string;", "getStandardIpAddress", "remoteGetRecoveryFiles", "", "socketAddress", "startLsn", "", "Lkd/bos/olapServer2/common/LSN;", "token", "action", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "Lkotlin/ParameterName;", "name", "conn", "transportRecoveryFile", "cubeNameNew", "inputFile", "Ljava/io/File;", "transportRecoveryFileCore", "safeClose", "validateResult", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void remoteGetRecoveryFiles(@NotNull String socketAddress, long startLsn, @NotNull String token, @NotNull Function1<? super HttpURLConnection, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            HttpURLConnection conn = null;
            try {
                URLConnection uRLConnection = new URL("http://" + socketAddress + "/bos-olap-webserver/services/dbmanage/getRecoveryFilesByStartLsn").openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                conn = (HttpURLConnection)uRLConnection;
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "text/plain");
                conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
                conn.setRequestProperty("ClientVersion", "2");
                conn.setRequestProperty("startLsn", String.valueOf(startLsn));
                conn.setRequestProperty("Authorization", token);
                action.invoke((Object)conn);
                this.validateResult(conn);
                this.safeClose(conn);
            }
            catch (Throwable throwable) {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection != null) {
                    this.validateResult(httpURLConnection);
                }
                this.safeClose(conn);
                throw throwable;
            }
        }

        public final void transportRecoveryFile(@NotNull String socketAddress, @NotNull String token, @NotNull String cubeNameNew, @NotNull File inputFile) {
            Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)cubeNameNew, (String)"cubeNameNew");
            Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
            try {
                this.transportRecoveryFileCore(socketAddress, cubeNameNew, inputFile, token);
            }
            catch (Exception ex) {
                String string2 = ex.getMessage();
                boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"#HttpCommandExecutor200", (boolean)false, (int)2, null) : false;
                if (bl) {
                    throw new RuntimeException(Res.INSTANCE.getReplicationSlaveException_3(), ex);
                }
                throw ex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void transportRecoveryFileCore(String socketAddress, String cubeNameNew, File inputFile, String token) {
            URLConnection uRLConnection = new URL("http://" + socketAddress + "/bos-olap-webserver/services/dbmanage/transportFile").openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            WritableByteChannel outputChannel = null;
            OutputStream ous = null;
            try {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/octet-stream");
                conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
                conn.setRequestProperty("ClientVersion", "2");
                conn.setRequestProperty("cubeName", cubeNameNew);
                conn.setRequestProperty("fileName", inputFile.getName());
                conn.setRequestProperty("Authorization", token);
                conn.setFixedLengthStreamingMode(inputFile.length());
                OutputStream outputStream = ous = conn.getOutputStream();
                Intrinsics.checkNotNull((Object)outputStream);
                outputChannel = Channels.newChannel(outputStream);
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                Closeable closeable = Channels.newChannel(new FileInputStream(inputFile));
                Throwable throwable = null;
                try {
                    ReadableByteChannel inputChannel = (ReadableByteChannel)closeable;
                    boolean bl = false;
                    while (inputChannel.read(buffer) >= 0) {
                        buffer.flip();
                        outputChannel.write(buffer);
                        buffer.clear();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable t2) {
                try {
                    throw new RuntimeException("transport recovery file[" + cubeNameNew + "] to[" + socketAddress + "] error:" + t2.getMessage());
                }
                catch (Throwable throwable) {
                    OutputStream outputStream = ous;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    WritableByteChannel writableByteChannel = outputChannel;
                    if (writableByteChannel != null) {
                        writableByteChannel.close();
                    }
                    this.validateResult(conn);
                    this.safeClose(conn);
                    throw throwable;
                }
            }
            ous.close();
            WritableByteChannel writableByteChannel = outputChannel;
            if (writableByteChannel != null) {
                writableByteChannel.close();
            }
            this.validateResult(conn);
            this.safeClose(conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void validateResult(HttpURLConnection $this$validateResult) {
            if ($this$validateResult.getResponseCode() != 200) {
                StringBuilder strBuilder = new StringBuilder();
                Closeable closeable = new BufferedReader(new InputStreamReader($this$validateResult.getErrorStream(), "utf-8"));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    String line = reader.readLine();
                    String lineSeperator = System.lineSeparator();
                    while (line != null) {
                        if (((CharSequence)strBuilder).length() > 0) {
                            strBuilder.append(lineSeperator);
                        }
                        strBuilder.append(line);
                        line = reader.readLine();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if ($this$validateResult.getResponseCode() == 500) {
                    ExceptionInfo exInfo = (ExceptionInfo)JsonHelper.INSTANCE.getMapper().readValue(strBuilder.toString(), ExceptionInfo.class);
                    logger.error(exInfo.getErrorMsg(), exInfo.getStackTrace());
                    throw new RuntimeException(exInfo.getErrorMsg());
                }
                throw new RuntimeException(strBuilder.toString());
            }
        }

        private final void safeClose(HttpURLConnection $this$safeClose) {
            if ($this$safeClose != null) {
                if ($this$safeClose.getResponseCode() == 200) {
                    InputStream inputStream = $this$safeClose.getInputStream();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                $this$safeClose.disconnect();
            }
        }

        @NotNull
        public final String getStandardIpAddress(@NotNull String ipAddress) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
            InetAddress inetAddress = this.getInetAddressByString(ipAddress);
            if (inetAddress instanceof Inet4Address) {
                string2 = ((Inet4Address)inetAddress).getHostAddress();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append('[');
                String string3 = inetAddress.getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHostAddress(...)");
                String[] stringArray = new String[]{"%"};
                string2 = stringBuilder.append((String)StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)).append(']').toString();
            }
            String realIpAddress = string2;
            Intrinsics.checkNotNull((Object)realIpAddress);
            return realIpAddress;
        }

        @NotNull
        public final InetAddress getInetAddressByString(@NotNull String ipAddress) {
            InetAddress inetAddress;
            Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
            try {
                inetAddress = InetAddress.getByName(ipAddress);
                Intrinsics.checkNotNull((Object)inetAddress);
            }
            catch (Exception e) {
                String string2 = Res.INSTANCE.getNetException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-NetException_1>(...)");
                Object[] objectArray = new Object[]{ipAddress};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            return inetAddress;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

