/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00060\u0005j\u0002`\u00062\n\u0010\r\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0006\u0010\u000e\u001a\u00020\tJ$\u0010\u000f\u001a\u0016\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u0016\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/tools/RecoveryFilesParser;", "", "inputStream", "Ljava/io/InputStream;", "dstPath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/io/InputStream;Ljava/lang/String;)V", "checkFileHead", "", "file", "Ljava/io/File;", "checkFileName", "fileName", "parseAndSave", "parseFileInfo", "Lkotlin/Pair;", "", "Lkd/bos/olapServer2/common/long;", "readableChannel", "Ljava/nio/channels/ReadableByteChannel;", "parseInputStreamInfo", "", "Lkd/bos/olapServer2/common/int;", "saveFile", "inputChannel", "dstDir", "contentBuffer", "Ljava/nio/ByteBuffer;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRecoveryFilesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecoveryFilesParser.kt\nkd/bos/olapServer2/tools/RecoveryFilesParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n1855#3,2:135\n*S KotlinDebug\n*F\n+ 1 RecoveryFilesParser.kt\nkd/bos/olapServer2/tools/RecoveryFilesParser\n*L\n117#1:135,2\n*E\n"})
public final class RecoveryFilesParser {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final String dstPath;

    public RecoveryFilesParser(@NotNull InputStream inputStream, @NotNull String dstPath) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)dstPath, (String)"dstPath");
        this.inputStream = inputStream;
        this.dstPath = dstPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseAndSave() {
        Closeable closeable = Channels.newChannel(this.inputStream);
        Throwable throwable = null;
        try {
            ReadableByteChannel inputChannel = (ReadableByteChannel)closeable;
            boolean bl = false;
            ByteBuffer versionBuffer = ByteBuffer.allocate(1);
            inputChannel.read(versionBuffer);
            Intrinsics.checkNotNull((Object)inputChannel);
            int filesCount = ((Number)this.parseInputStreamInfo(inputChannel).component1()).intValue();
            if (filesCount > 0) {
                File dstDir = Paths.INSTANCE.toFile(this.dstPath);
                if (!(dstDir.isDirectory() && dstDir.exists())) {
                    boolean bl2 = false;
                    String string2 = "recoveryFiles parse error.";
                    throw new IllegalArgumentException(string2.toString());
                }
                ByteBuffer contentBuffer = ByteBuffer.allocate(4096);
                int n = CollectionsKt.count((Iterable)((Iterable)RangesKt.until((int)0, (int)filesCount)));
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)contentBuffer);
                    File targetFile = this.saveFile(inputChannel, dstDir, contentBuffer);
                    this.checkFileHead(targetFile);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Pair<Integer, Long> parseInputStreamInfo(ReadableByteChannel readableChannel) {
        ByteBuffer headByteBuffer = ByteBuffer.allocate(4);
        readableChannel.read(headByteBuffer);
        headByteBuffer.flip();
        int filesCount = headByteBuffer.getInt();
        headByteBuffer.clear();
        headByteBuffer = ByteBuffer.allocate(8);
        readableChannel.read(headByteBuffer);
        headByteBuffer.flip();
        long filesByteSize = headByteBuffer.getLong();
        headByteBuffer.clear();
        return new Pair((Object)filesCount, (Object)filesByteSize);
    }

    private final Pair<String, Long> parseFileInfo(ReadableByteChannel readableChannel) {
        ByteBuffer fileNameLenBuffer = ByteBuffer.allocate(1);
        readableChannel.read(fileNameLenBuffer);
        fileNameLenBuffer.flip();
        int fileNameLen = fileNameLenBuffer.get() & 0xFF;
        if (!(fileNameLen > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ByteBuffer fileNameByteBuffer = ByteBuffer.allocate(fileNameLen);
        readableChannel.read(fileNameByteBuffer);
        fileNameByteBuffer.flip();
        byte[] byArray = fileNameByteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        String fileName = new String(byArray2, charset);
        ByteBuffer fileLenByteBuffer = ByteBuffer.allocate(8);
        readableChannel.read(fileLenByteBuffer);
        fileLenByteBuffer.flip();
        long fileLen = fileLenByteBuffer.getLong();
        return new Pair((Object)fileName, (Object)fileLen);
    }

    private final String checkFileName(String fileName) {
        if (StringsKt.contains$default((CharSequence)fileName, (char)'\\', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fileName, (char)'/', (boolean)false, (int)2, null)) {
            String string2 = Res.INSTANCE.getRecoveryFilesParserException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RecoveryFilesParserException_1>(...)");
            Object[] objectArray = new Object[]{fileName};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkFileHead(File file) {
        if (!file.exists()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream fileInputStream = (FileInputStream)closeable;
            boolean bl = false;
            byte[] headerByte = new byte[23];
            int len = CommonTypesKt.readByteArray(fileInputStream, headerByte);
            if (len != 23) {
                String string3 = Res.INSTANCE.getRecoveryFilesParserException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-RecoveryFilesParserException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
            }
            String currentFileHeader = new String(headerByte, Charsets.UTF_8);
            if (!StringsKt.startsWith$default((String)currentFileHeader, (String)"Kingdee Shrek backup v", (boolean)false, (int)2, null)) {
                boolean isDeleted = file.delete();
                if (!isDeleted) {
                    String string4 = "Failed requirement.";
                    throw new IllegalArgumentException(string4.toString());
                }
                String string5 = Res.INSTANCE.getRecoveryFilesParserException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-RecoveryFilesParserException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string5, new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File saveFile(ReadableByteChannel inputChannel, File dstDir, ByteBuffer contentBuffer) {
        boolean isDeleted;
        Pair<String, Long> pair = this.parseFileInfo(inputChannel);
        String fileName = (String)pair.component1();
        long fileLen = ((Number)pair.component2()).longValue();
        String string2 = dstDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File targetFile = Paths.INSTANCE.toFile(string2, this.checkFileName(fileName).toString());
        if (targetFile.exists() && !(isDeleted = targetFile.delete())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        targetFile.createNewFile();
        if (!(fileLen > 0L)) {
            String string4 = "Failed requirement.";
            throw new IllegalArgumentException(string4.toString());
        }
        long readCount = fileLen / (long)4096;
        long remainSize = fileLen % (long)4096;
        Closeable closeable = Channels.newChannel(new FileOutputStream(targetFile));
        Throwable throwable = null;
        try {
            WritableByteChannel fileChannel = (WritableByteChannel)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (long)readCount);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                long element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl2 = false;
                inputChannel.read(contentBuffer);
                contentBuffer.flip();
                fileChannel.write(contentBuffer);
                contentBuffer.clear();
            }
            if (remainSize > 0L) {
                ByteBuffer minContentBuffer = ByteBuffer.allocate((int)remainSize);
                inputChannel.read(minContentBuffer);
                minContentBuffer.flip();
                fileChannel.write(minContentBuffer);
                minContentBuffer.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return targetFile;
    }
}

