/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/tools/RedoParser;", "", "startLSN", "", "Lkd/bos/olapServer2/common/long;", "endLSN", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "parseFilePath", "(JJLjava/lang/String;Ljava/lang/String;)V", "parse", "", "bos-olap-core2"})
public final class RedoParser {
    private final long startLSN;
    private final long endLSN;
    @NotNull
    private final String redoPath;
    @NotNull
    private final String parseFilePath;

    public RedoParser(long startLSN, long endLSN, @NotNull String redoPath, @NotNull String parseFilePath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)parseFilePath, (String)"parseFilePath");
        this.startLSN = startLSN;
        this.endLSN = endLSN;
        this.redoPath = redoPath;
        this.parseFilePath = parseFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse() {
        SlaveLSNContext slaveLSNContext = new SlaveLSNContext(this.startLSN, this.endLSN, -1L);
        File parseFile = PathsKt.fileSafeConstructor(this.parseFilePath);
        if (parseFile.isDirectory()) {
            throw new RuntimeException(this.parseFilePath + " is a directory, but required a file.");
        }
        Closeable closeable = new SeqRedoLogger(this.redoPath, 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null);
        Throwable throwable = null;
        try {
            SeqRedoLogger redoLogger = (SeqRedoLogger)closeable;
            boolean bl = false;
            Closeable closeable2 = new RedoRecordCombineReader(redoLogger, slaveLSNContext);
            Throwable throwable2 = null;
            try {
                RedoRecordCombineReader redoReader = (RedoRecordCombineReader)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new BufferedWriter(new OutputStreamWriter(PathsKt.safeOutputStream(parseFile)));
                Throwable throwable3 = null;
                try {
                    BufferedWriter writer = (BufferedWriter)closeable3;
                    boolean bl3 = false;
                    Closeable closeable4 = redoReader;
                    Throwable throwable4 = null;
                    try {
                        RedoRecordCombineReader it = (RedoRecordCombineReader)closeable4;
                        boolean bl4 = false;
                        while (redoReader.next()) {
                            RedoRecordWithPage recordWithPage = redoReader.getCurrent();
                            RedoPageInfo page = recordWithPage.getStartPage();
                            IRedoRecord record = recordWithPage.getRecord();
                            long lsn = page.getPageLSN();
                            int version = page.getVersion();
                            SimpleDateFormat sdf = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
                            sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
                            String timestamp = sdf.format(page.getTimestamp());
                            String lineHead = "" + '[' + lsn + ' ' + version + ' ' + timestamp + "] ";
                            writer.append(lineHead + record);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

