/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.io.Closeable;
import java.io.File;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.OlapBackup;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.OlapRecovery;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.RedoParser;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bJ(\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\u000e2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000bJ2\u0010\u0010\u001a\"\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\u00112\n\u0010\u000f\u001a\u00060\nj\u0002`\u000bJ\u001e\u0010\u0012\u001a\u00020\u00042\n\u0010\u0013\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0014\u001a\u00060\nj\u0002`\u000bJ\u001e\u0010\u0015\u001a\u00020\u00042\n\u0010\u0014\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u000bJ*\u0010\u0016\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0018\u001a\u00060\u0006j\u0002`\u0007J6\u0010\u0019\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0018\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001a\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/tools/ReplicationTool;", "", "()V", "parseRedo", "", "startLSN", "", "Lkd/bos/olapServer2/common/long;", "endLSN", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "parseFilePath", "readLSNControl", "Lkotlin/Pair;", "controlFilePath", "readOlapControl", "Lkotlin/Triple;", "totalBackup", "databasePath", "backupPath", "totalRecovery", "updateLSNControl", "recoveryStartLSN", "recoveryEndLSN", "updateOlapControl", "checkPointLSN", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationTool.kt\nkd/bos/olapServer2/tools/ReplicationTool\n+ 2 CancellableToken.kt\nkd/bos/olapServer2/common/CancellableToken\n*L\n1#1,96:1\n106#2,13:97\n106#2,13:110\n*S KotlinDebug\n*F\n+ 1 ReplicationTool.kt\nkd/bos/olapServer2/tools/ReplicationTool\n*L\n80#1:97,13\n90#1:110,13\n*E\n"})
public final class ReplicationTool {
    @Nullable
    public final Pair<Long, Long> readLSNControl(@NotNull String controlFilePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        if (PathsKt.fileSafeConstructor(controlFilePath).exists()) {
            ControlConfig controlConfig = ControlConfig.Companion.readControlConfig(controlFilePath);
            pair = new Pair((Object)controlConfig.getRecoveryStartLSN(), (Object)controlConfig.getRecoveryEndLSN());
        } else {
            pair = null;
        }
        return pair;
    }

    public final void updateLSNControl(@NotNull String controlFilePath, long recoveryStartLSN, long recoveryEndLSN) {
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        new ControlConfig(recoveryStartLSN, recoveryEndLSN, -1L).save(controlFilePath);
    }

    @Nullable
    public final Triple<Long, Long, Long> readOlapControl(@NotNull String controlFilePath) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        if (PathsKt.fileSafeConstructor(controlFilePath).exists()) {
            ControlConfig controlConfig = OlapControlFile.Companion.readOlapControl(controlFilePath).getControlConfig();
            triple = new Triple((Object)controlConfig.getRecoveryStartLSN(), (Object)controlConfig.getRecoveryEndLSN(), (Object)controlConfig.getCheckPointLSN());
        } else {
            triple = null;
        }
        return triple;
    }

    public final void updateOlapControl(@NotNull String controlFilePath, long recoveryStartLSN, long recoveryEndLSN, long checkPointLSN) {
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        new OlapControlFile(new ControlConfig(recoveryStartLSN, recoveryEndLSN, checkPointLSN), new ControlHead(0, 0, 0, 0L, 15, null)).save(controlFilePath, true);
    }

    public final void parseRedo(long startLSN, long endLSN, @NotNull String redoPath, @NotNull String parseFilePath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)parseFilePath, (String)"parseFilePath");
        new RedoParser(startLSN, endLSN, redoPath, parseFilePath).parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void totalBackup(@NotNull String databasePath, @NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        OlapWorkspace olapWorkspace = new OlapWorkspace(OlapMetadata.Companion.ReadFrom(databasePath), databasePath);
        File backupDir = PathsKt.fileSafeConstructor(backupPath);
        if (backupDir.isFile()) {
            throw new RuntimeException(backupPath + " is a file, but required a directory.");
        }
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        CancellableToken this_$iv = CancellableToken.INSTANCE;
        boolean $i$f$withCancellable = false;
        ICancellable ct$iv = OlapContext.Companion.tryGetContext(ICancellable.class);
        if (ct$iv == null) {
            ICancellable myCt$iv = this_$iv.createCancellable();
            OlapContext.Companion.push(myCt$iv);
            try {
                boolean bl = false;
                OlapBackup.Companion.backup(olapWorkspace, backupPath);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                OlapContext.Companion.pop(myCt$iv);
            }
        } else {
            boolean bl = false;
            OlapBackup.Companion.backup(olapWorkspace, backupPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void totalRecovery(@NotNull String backupPath, @NotNull String databasePath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        Closeable closeable = ReplicationWorkspace.Companion.createNoneWorkspace(databasePath);
        Throwable throwable = null;
        try {
            ReplicationWorkspace it = (ReplicationWorkspace)closeable;
            boolean bl = false;
            CancellableToken this_$iv = CancellableToken.INSTANCE;
            boolean $i$f$withCancellable = false;
            ICancellable ct$iv = OlapContext.Companion.tryGetContext(ICancellable.class);
            if (ct$iv == null) {
                ICancellable myCt$iv = this_$iv.createCancellable();
                OlapContext.Companion.push(myCt$iv);
                try {
                    boolean bl2 = false;
                    new OlapRecovery(it, "", backupPath, null, 8, null).recoveryAndReplay();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    OlapContext.Companion.pop(myCt$iv);
                }
            } else {
                boolean bl3 = false;
                new OlapRecovery(it, "", backupPath, null, 8, null).recoveryAndReplay();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

