/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.tools;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.olapServer2.metadata.BlackWhiteScope;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.CubeDataScope;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DiscretePointScope;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\n\u0010\b\u001a\u00060\u0005j\u0002`\tH\u0002J\u0016\u0010\n\u001a\u00060\u000bj\u0002`\f2\n\u0010\b\u001a\u00060\u0005j\u0002`\tJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J&\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\t0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\b\u001a\u00060\u0005j\u0002`\tH\u0002J&\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\t0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\b\u001a\u00060\u0005j\u0002`\tH\u0002J\u0016\u0010\u0016\u001a\u00060\u000bj\u0002`\f2\n\u0010\b\u001a\u00060\u0005j\u0002`\tJ,\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\t0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\b\u001a\u00060\u0005j\u0002`\t2\u0006\u0010\u0018\u001a\u00020\u0019J2\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\t0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\b\u001a\u00060\u0005j\u0002`\t2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/tools/StringValidator;", "", "()V", "keywords", "", "", "splitOwnerUniqueName", "", "str", "Lkd/bos/olapServer2/common/string;", "validate", "", "Lkd/bos/olapServer2/common/bool;", "validateCommon", "", "other", "Lkd/bos/olapServer2/tools/StringValidator$CharValidator;", "validateCubeDataScopeStrFormat", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "validateCubeLockRuleStrFormat", "validateMember", "validateOwnerUniqueName", "types", "Lkd/bos/olapServer2/metadata/MetadataTypes;", "validateStrFormat", "splitSize", "", "Lkd/bos/olapServer2/common/int;", "CharValidator", "MemberValidator", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nStringValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringValidator.kt\nkd/bos/olapServer2/tools/StringValidator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,245:1\n12474#2,2:246\n12474#2,2:248\n*S KotlinDebug\n*F\n+ 1 StringValidator.kt\nkd/bos/olapServer2/tools/StringValidator\n*L\n184#1:246,2\n185#1:248,2\n*E\n"})
public final class StringValidator {
    @NotNull
    public static final StringValidator INSTANCE = new StringValidator();
    @NotNull
    private static final Set<String> keywords;

    private StringValidator() {
    }

    public final boolean validate(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.validateCommon(str, null);
        return true;
    }

    private final void validateCommon(String str, CharValidator other) {
        if (((CharSequence)str).length() == 0) {
            String string2 = Res.INSTANCE.getStringValidatorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-StringValidatorException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        if (str.length() > 50) {
            String string3 = Res.INSTANCE.getStringValidatorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-StringValidatorException_2>(...)");
            Object[] objectArray = new Object[]{str, 50};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if ('a' <= c ? c < '{' : false) continue;
            if ('A' <= c ? c < '[' : false) continue;
            if (('0' <= c ? c < ':' : false) || (c == '_' || c == '-') && i > 0 || other != null && other.validate(c)) continue;
            if (c == ' ') {
                String string4 = Res.INSTANCE.getStringValidatorException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-StringValidatorException_3>(...)");
                Object[] objectArray = new Object[]{str};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
            String string5 = Res.INSTANCE.getStringValidatorException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-StringValidatorException_4>(...)");
            Object[] objectArray = new Object[]{str};
            throw Res.INSTANCE.getRuntimeException(string5, objectArray);
        }
        int pre = str.charAt(0);
        if (pre >= 97) {
            pre -= 32;
        }
        boolean bl = 3 <= (n = str.length()) ? n < 6 : false;
        if (bl && (pre == 65 || pre == 78 || pre == 79)) {
            String string6 = str.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String strTemp = string6;
            if (keywords.contains(strTemp)) {
                String string7 = Res.INSTANCE.getStringValidatorException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-StringValidatorException_5>(...)");
                Object[] objectArray = new Object[]{strTemp};
                throw Res.INSTANCE.getRuntimeException(string7, objectArray);
            }
        }
    }

    public final boolean validateMember(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.validateCommon(str, MemberValidator.INSTANCE);
        return true;
    }

    @NotNull
    public final List<String> validateOwnerUniqueName(@NotNull Cube cube, @NotNull String str, @NotNull MetadataTypes types) {
        List<String> list2;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)((Object)types), (String)"types");
        if (StringsKt.isBlank((CharSequence)str)) {
            String string2 = Res.INSTANCE.getStringValidatorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-StringValidatorException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[types.ordinal()]) {
            case 1: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 2: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 3: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 4: {
                list2 = this.validateStrFormat(cube, str, 2);
                break;
            }
            case 5: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 6: {
                list2 = this.validateStrFormat(cube, str, 3);
                break;
            }
            case 7: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 8: {
                list2 = this.validateCubeDataScopeStrFormat(cube, str);
                break;
            }
            case 9: {
                list2 = this.validateStrFormat(cube, str, 3);
                break;
            }
            case 10: {
                list2 = this.validateCubeLockRuleStrFormat(cube, str);
                break;
            }
            case 11: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            case 12: {
                list2 = this.validateStrFormat(cube, str, 2);
                break;
            }
            case 13: {
                list2 = this.validateStrFormat(cube, str, 1);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return list2;
    }

    private final List<String> validateCubeLockRuleStrFormat(Cube cube, String str) {
        List<String> list2;
        List<String> arr = this.splitOwnerUniqueName(str);
        String pattern = "cubeName.scopeName";
        if (arr.size() == 1) {
            list2 = this.validateStrFormat(cube, str, 1);
        } else {
            if (arr.size() != 2) {
                String string2 = Res.INSTANCE.getStringValidatorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-StringValidatorException_6>(...)");
                Object[] objectArray = new Object[]{str, pattern};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            String cubeName = arr.get(0);
            String scopeName = arr.get(1);
            if (!StringsKt.equals((String)cube.getName(), (String)cubeName, (boolean)true)) {
                String string3 = Res.INSTANCE.getStringValidatorException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-StringValidatorException_7>(...)");
                Object[] objectArray = new Object[]{cubeName};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            this.validate(scopeName);
            list2 = arr;
        }
        return list2;
    }

    private final List<String> validateCubeDataScopeStrFormat(Cube cube, String str) {
        List<String> arr;
        block15: {
            String discretePointScopeName;
            String blacksOrWhites;
            String scopeName;
            String cubeName;
            block14: {
                boolean bl;
                block12: {
                    CubeDataScope it;
                    CubeDataScope element$iv;
                    int n;
                    int n2;
                    boolean $i$f$any;
                    CubeDataScope[] $this$any$iv;
                    CubeDataScope scope;
                    block13: {
                        boolean bl2;
                        block11: {
                            arr = this.splitOwnerUniqueName(str);
                            String pattern = "cubeName.scopeName.blacks.discretePointScopeName or cubeName.scopeName.whites.discretePointScopeName";
                            if (arr.size() == 1) {
                                return this.validateStrFormat(cube, str, 1);
                            }
                            if (arr.size() != 4) {
                                String string2 = Res.INSTANCE.getStringValidatorException_6();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-StringValidatorException_6>(...)");
                                Object[] objectArray = new Object[]{str, pattern};
                                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                            }
                            cubeName = arr.get(0);
                            scopeName = arr.get(1);
                            blacksOrWhites = arr.get(2);
                            discretePointScopeName = arr.get(3);
                            if (!StringsKt.equals((String)cube.getName(), (String)cubeName, (boolean)true)) {
                                String string3 = Res.INSTANCE.getStringValidatorException_7();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-StringValidatorException_7>(...)");
                                Object[] objectArray = new Object[]{cubeName};
                                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                            }
                            if (!cube.getCubeDataScopes().contains(scopeName)) {
                                String string4 = Res.INSTANCE.getStringValidatorException_8();
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-StringValidatorException_8>(...)");
                                Object[] objectArray = new Object[]{cubeName, scopeName};
                                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
                            }
                            scope = (CubeDataScope)cube.getCubeDataScopes().get(scopeName);
                            if (!(scope instanceof BlackWhiteScope)) {
                                String string5 = Res.INSTANCE.getStringValidatorException_9();
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-StringValidatorException_9>(...)");
                                Object[] objectArray = new Object[]{cubeName, scopeName};
                                throw Res.INSTANCE.getRuntimeException(string5, objectArray);
                            }
                            if (!Intrinsics.areEqual((Object)blacksOrWhites, (Object)"blacks") && !Intrinsics.areEqual((Object)blacksOrWhites, (Object)"whites")) {
                                String string6 = Res.INSTANCE.getStringValidatorException_6();
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-StringValidatorException_6>(...)");
                                Object[] objectArray = new Object[]{str, pattern};
                                throw Res.INSTANCE.getRuntimeException(string6, objectArray);
                            }
                            if (!Intrinsics.areEqual((Object)blacksOrWhites, (Object)"blacks")) break block13;
                            $this$any$iv = ((BlackWhiteScope)scope).getBlacks();
                            $i$f$any = false;
                            n2 = $this$any$iv.length;
                            for (n = 0; n < n2; ++n) {
                                it = element$iv = $this$any$iv[n];
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)discretePointScopeName) && it instanceof DiscretePointScope)) continue;
                                bl2 = true;
                                break block11;
                            }
                            bl2 = false;
                        }
                        if (!bl2) break block14;
                    }
                    if (!Intrinsics.areEqual((Object)blacksOrWhites, (Object)"whites")) break block15;
                    $this$any$iv = ((BlackWhiteScope)scope).getWhites();
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$any$iv[n];
                        boolean bl4 = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)discretePointScopeName) && it instanceof DiscretePointScope)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
                if (bl) break block15;
            }
            String string7 = Res.INSTANCE.getStringValidatorException_10();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-StringValidatorException_10>(...)");
            Object[] objectArray = new Object[]{cubeName, scopeName, blacksOrWhites, discretePointScopeName};
            throw Res.INSTANCE.getRuntimeException(string7, objectArray);
        }
        return arr;
    }

    private final List<String> validateStrFormat(Cube cube, String str, int splitSize) {
        String string2;
        List<String> arr = this.splitOwnerUniqueName(str);
        switch (splitSize) {
            case 1: {
                string2 = "cubeName";
                break;
            }
            case 2: {
                string2 = "cubeName.dimensionName";
                break;
            }
            case 3: {
                string2 = "cubeName.dimensionName.memberName or cubeName.dimensionName@memberName";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        String pattern = string2;
        int arrSize = arr.size();
        if (arrSize != splitSize) {
            String string3 = Res.INSTANCE.getStringValidatorException_6();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-StringValidatorException_6>(...)");
            Object[] objectArray = new Object[]{str, pattern};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        if (arrSize >= 1) {
            if (!StringsKt.equals((String)cube.getName(), (String)arr.get(0), (boolean)true)) {
                String string4 = Res.INSTANCE.getStringValidatorException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-StringValidatorException_7>(...)");
                Object[] objectArray = new Object[]{arr.get(0)};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
            arr.set(0, cube.getName());
        }
        if (arrSize >= 2) {
            arr.set(1, ((Dimension)cube.getDimensions().get(arr.get(1))).getName());
        }
        if (arrSize >= 3) {
            arr.set(2, ((Dimension)cube.getDimensions().get(arr.get(1))).getMembers().get(arr.get(2)).getName());
        }
        return arr;
    }

    private final List<String> splitOwnerUniqueName(String str) {
        Object object2;
        int atIndex = StringsKt.indexOf$default((CharSequence)str, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (atIndex >= 0) {
            String string2 = str.substring(0, atIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object object3 = new String[]{"."};
            Object it = object3 = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)string2, (String[])object3, (boolean)false, (int)0, (int)6, null));
            boolean bl = false;
            String string3 = str.substring(atIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            it.add(string3);
            object2 = object3;
        } else {
            String[] stringArray = new String[]{"."};
            object2 = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return object2;
    }

    static {
        Object[] objectArray = new String[]{"all", "none", "other"};
        keywords = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/tools/StringValidator$CharValidator;", "", "()V", "validate", "", "Lkd/bos/olapServer2/common/bool;", "c", "", "bos-olap-core2"})
    private static abstract class CharValidator {
        public abstract boolean validate(char var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/tools/StringValidator$MemberValidator;", "Lkd/bos/olapServer2/tools/StringValidator$CharValidator;", "()V", "validate", "", "Lkd/bos/olapServer2/common/bool;", "c", "", "bos-olap-core2"})
    private static final class MemberValidator
    extends CharValidator {
        @NotNull
        public static final MemberValidator INSTANCE = new MemberValidator();

        private MemberValidator() {
        }

        @Override
        public boolean validate(char c) {
            return c == '.';
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetadataTypes.values().length];
            try {
                nArray[MetadataTypes.Dimension.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.AggShieldRule.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.ValidDataRule.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Member.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Measure.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.AggFactor.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Sandbox.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.CubeDataScope.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.PiecewiseExpression.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.CubeLockRule.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Partition.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.SimpleMember.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Tag.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

