/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.storages.CombinedLockInstance;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.LockInstance;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.MasterTransactionContext;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/transactions/ExtendMetadataTransaction;", "Lkd/bos/olapServer2/transactions/ITransaction;", "version", "", "Lkd/bos/olapServer2/common/long;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "master", "Lkd/bos/olapServer2/replication/ReplicationMaster;", "(JLkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/replication/ReplicationMaster;)V", "_lock", "Ljava/io/Closeable;", "_startTime", "_state", "Lkd/bos/olapServer2/transactions/TransactionStatus;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "getCubeName", "()Ljava/lang/String;", "masterTransactionContext", "Lkd/bos/olapServer2/transactions/MasterTransactionContext;", "startTime", "getStartTime", "()J", "state", "getState", "()Lkd/bos/olapServer2/transactions/TransactionStatus;", "type", "Lkd/bos/olapServer2/transactions/TransactionTypes;", "getType", "()Lkd/bos/olapServer2/transactions/TransactionTypes;", "getVersion", "commit", "", "rollback", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nExtendMetadataTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendMetadataTransaction.kt\nkd/bos/olapServer2/transactions/ExtendMetadataTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class ExtendMetadataTransaction
implements ITransaction {
    private final long version;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private TransactionStatus _state;
    @NotNull
    private final Closeable _lock;
    private final long _startTime;
    @NotNull
    private final MasterTransactionContext masterTransactionContext;

    public ExtendMetadataTransaction(long version, @NotNull CubeWorkspace cubeWorkspace, @NotNull ReplicationMaster master) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.version = version;
        this.cubeWorkspace = cubeWorkspace;
        this._state = TransactionStatus.Active;
        this._startTime = System.nanoTime();
        Closeable metadataReadLock = null;
        Closeable extendMetadataWriteLock = null;
        try {
            Lock lock;
            metadataReadLock = this.cubeWorkspace.getMetadataLock().getReadLock();
            Lock it = lock = this.cubeWorkspace.getMetadataStorage().getExtendMetadataLock().writeLock();
            boolean bl = false;
            it.lock();
            Lock lock2 = lock;
            Intrinsics.checkNotNullExpressionValue((Object)lock2, (String)"also(...)");
            Lock lock3 = lock2;
            extendMetadataWriteLock = new LockInstance(lock3);
            this._lock = new CombinedLockInstance(metadataReadLock, extendMetadataWriteLock);
            this.masterTransactionContext = master.getTransactionContext$bos_olap_core2();
            this.masterTransactionContext.getActiveWriteTranCount().incrementAndGet();
        }
        catch (Throwable th) {
            Closeable closeable = extendMetadataWriteLock;
            if (closeable != null) {
                closeable.close();
            }
            Closeable closeable2 = metadataReadLock;
            if (closeable2 != null) {
                closeable2.close();
            }
            throw th;
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public TransactionTypes getType() {
        return TransactionTypes.ExtendMetadataTransaction;
    }

    @Override
    @NotNull
    public String getCubeName() {
        return this.cubeWorkspace.getMetadata().getName();
    }

    @Override
    @NotNull
    public TransactionStatus getState() {
        return this._state;
    }

    @Override
    public long getStartTime() {
        return this._startTime;
    }

    @Override
    public void commit() {
        this._lock.close();
        if (this._state != TransactionStatus.Active) {
            String string2 = Res.INSTANCE.getTransactionManagerException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionManagerException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        this._state = TransactionStatus.Committed;
        if (this.masterTransactionContext.getActiveWriteTranCount().decrementAndGet() == 0) {
            this.masterTransactionContext.tryCheckPoint();
        }
    }

    @Override
    public void rollback() {
        this._lock.close();
        if (this._state != TransactionStatus.Active) {
            String string2 = Res.INSTANCE.getTransactionManagerException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionManagerException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        this._state = TransactionStatus.Aborted;
        if (this.masterTransactionContext.getActiveWriteTranCount().decrementAndGet() == 0) {
            this.masterTransactionContext.tryCheckPoint();
        }
    }
}

