/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0015\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/transactions/MasterTransactionContext;", "", "master", "Lkd/bos/olapServer2/replication/ReplicationMaster;", "(Lkd/bos/olapServer2/replication/ReplicationMaster;)V", "activeWriteTranCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getActiveWriteTranCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "getBackupPath", "()Ljava/lang/String;", "checkPointLsn", "", "Lkd/bos/olapServer2/common/LSN;", "getCheckPointLsn", "()J", "currentLsn", "getCurrentLsn", "redoPath", "getRedoPath", "tryCheckPoint", "", "bos-olap-core2"})
public final class MasterTransactionContext {
    @NotNull
    private final ReplicationMaster master;
    @NotNull
    private final AtomicInteger activeWriteTranCount;

    public MasterTransactionContext(@NotNull ReplicationMaster master) {
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.master = master;
        this.activeWriteTranCount = new AtomicInteger(0);
    }

    @NotNull
    public final AtomicInteger getActiveWriteTranCount() {
        return this.activeWriteTranCount;
    }

    public final void tryCheckPoint() {
        long currentLSN = this.master.getCurrentLSNContext().getCurrentPage();
        if (this.master.getCurrentLSNContext().getCheckPoint() == currentLSN) {
            return;
        }
        if (this.activeWriteTranCount.incrementAndGet() == 1 && this.master.getCurrentLSNContext().getCurrentPage() == currentLSN) {
            this.master.getCurrentLSNContext().setCheckPoint(currentLSN);
        }
        this.activeWriteTranCount.decrementAndGet();
    }

    public final long getCurrentLsn() {
        return LSNUtil.INSTANCE.nextPageLSN(this.master.getCurrentLSNContext().getFlushLSN());
    }

    public final long getCheckPointLsn() {
        return this.master.getCurrentLSNContext().getCheckPoint();
    }

    @NotNull
    public final String getRedoPath() {
        return this.master.getConf().get_node().getRedoPath();
    }

    @NotNull
    public final String getBackupPath() {
        return this.master.getConf().get_node().getBackupPath();
    }
}

