/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.CubeTransactionContext;
import kd.bos.olapServer2.transactions.IRollbackExecutor;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\t\u001a:\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\r0\nj\u001c\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\r`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/transactions/OlapRollbackExecutor;", "Lkd/bos/olapServer2/transactions/IRollbackExecutor;", "olap", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "master", "Lkd/bos/olapServer2/replication/ReplicationMaster;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/ReplicationMaster;)V", "recordItr", "Lkd/bos/olapServer2/replication/RedoRecordReader;", "unCommitedTidSet", "Ljava/util/HashMap;", "", "Lkd/bos/olapServer2/common/int;", "Ljava/util/LinkedList;", "", "Lkd/bos/olapServer2/common/long;", "Lkotlin/collections/HashMap;", "execute", "", "getUnCommitedTid", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapRollbackExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapRollbackExecutor.kt\nkd/bos/olapServer2/transactions/OlapRollbackExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n215#2:83\n216#2:88\n1855#3,2:84\n1855#3,2:86\n1855#3,2:89\n*S KotlinDebug\n*F\n+ 1 OlapRollbackExecutor.kt\nkd/bos/olapServer2/transactions/OlapRollbackExecutor\n*L\n66#1:83\n66#1:88\n68#1:84,2\n72#1:86,2\n77#1:89,2\n*E\n"})
public final class OlapRollbackExecutor
implements IRollbackExecutor {
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final ReplicationMaster master;
    @NotNull
    private final HashMap<Integer, LinkedList<Long>> unCommitedTidSet;
    @NotNull
    private final RedoRecordReader recordItr;

    public OlapRollbackExecutor(@NotNull OlapWorkspace olap, @NotNull ReplicationMaster master) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.olap = olap;
        this.master = master;
        this.unCommitedTidSet = new HashMap();
        this.recordItr = new RedoRecordReader(this.master.getConf().get_node().getRedoPath(), new SlaveLSNContext(this.master.getCurrentLSNContext().getCheckPoint(), this.master.getCurrentLSNContext().getCurrentPage(), -1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getUnCommitedTid() {
        Closeable closeable = this.recordItr;
        Throwable throwable = null;
        try {
            RedoRecordReader it = (RedoRecordReader)closeable;
            boolean bl = false;
            while (this.recordItr.next()) {
                LinkedList<Long> cubeTidSet;
                RedoRecordWithPage recordWithPage = this.recordItr.getCurrent();
                RedoPageInfo page = recordWithPage.getStartPage();
                int n = page.getVersion();
                if (!(0 <= n ? n < 4 : false)) {
                    throw Res.INSTANCE.getNotSupportedException("replay error,not support new page version.", new Object[0]);
                }
                IRedoRecord record = recordWithPage.getRecord();
                if (!(record instanceof ITranStatusRecord)) continue;
                if (((ITranStatusRecord)record).getTranStatus() == TransactionStatus.Active) {
                    Intrinsics.checkNotNullExpressionValue(this.unCommitedTidSet.getOrDefault(record.getCubeId(), new LinkedList()), (String)"getOrDefault(...)");
                    cubeTidSet.add(record.getTid());
                    ((Map)this.unCommitedTidSet).put(record.getCubeId(), cubeTidSet);
                    continue;
                }
                if (((ITranStatusRecord)record).getTranStatus() != TransactionStatus.Committed && ((ITranStatusRecord)record).getTranStatus() != TransactionStatus.Aborted || (cubeTidSet = this.unCommitedTidSet.get(record.getCubeId())) == null) continue;
                cubeTidSet.remove(record.getTid());
                ((Map)this.unCommitedTidSet).put(record.getCubeId(), cubeTidSet);
                if (!cubeTidSet.isEmpty()) continue;
                this.unCommitedTidSet.remove(record.getCubeId());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void execute() {
        Map.Entry element$iv;
        this.getUnCommitedTid();
        LinkedList<WriteTransaction> transactionSet = new LinkedList<WriteTransaction>();
        Object $this$forEach$iv = this.unCommitedTidSet;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry cubeTids = element$iv = iterator2.next();
            boolean bl = false;
            CubeTransactionContext cubeTransactionContext = new CubeTransactionContext();
            Iterable $this$forEach$iv2 = (Iterable)cubeTids.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                long it = ((Number)element$iv2).longValue();
                boolean bl2 = false;
                cubeTransactionContext.getRollbackTIDSet().add(it);
            }
            $this$forEach$iv2 = (Iterable)cubeTids.getValue();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                long tid = ((Number)element$iv2).longValue();
                boolean bl3 = false;
                transactionSet.add(new WriteTransaction(tid, this.olap.getCubeWorkspaceByCubeId(((Number)cubeTids.getKey()).intValue()), cubeTransactionContext, this.master, true));
            }
        }
        $this$forEach$iv = transactionSet;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            WriteTransaction it = (WriteTransaction)((Object)element$iv);
            boolean bl = false;
            it.rollback();
        }
    }
}

