/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.io.Closeable;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00060\rj\u0002`\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/transactions/ReadOnlyTransaction;", "Lkd/bos/olapServer2/transactions/ITransaction;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "_lock", "Ljava/io/Closeable;", "_startTime", "", "Lkd/bos/olapServer2/common/long;", "_state", "Lkd/bos/olapServer2/transactions/TransactionStatus;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "getCubeName", "()Ljava/lang/String;", "startTime", "getStartTime", "()J", "state", "getState", "()Lkd/bos/olapServer2/transactions/TransactionStatus;", "type", "Lkd/bos/olapServer2/transactions/TransactionTypes;", "getType", "()Lkd/bos/olapServer2/transactions/TransactionTypes;", "version", "getVersion", "commit", "", "rollback", "bos-olap-core2"})
public final class ReadOnlyTransaction
implements ITransaction {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private TransactionStatus _state;
    @NotNull
    private final Closeable _lock;
    private final long _startTime;

    public ReadOnlyTransaction(@NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.cubeWorkspace = cubeWorkspace;
        this._state = TransactionStatus.Active;
        this._startTime = System.nanoTime();
        this._lock = this.cubeWorkspace.getMetadataLock().getReadLock();
    }

    @Override
    @NotNull
    public TransactionTypes getType() {
        return TransactionTypes.ReadOnlyTransaction;
    }

    @Override
    @NotNull
    public String getCubeName() {
        return this.cubeWorkspace.getMetadata().getName();
    }

    @Override
    @NotNull
    public TransactionStatus getState() {
        return this._state;
    }

    @Override
    public long getVersion() {
        return -1L;
    }

    @Override
    public long getStartTime() {
        return this._startTime;
    }

    @Override
    public void commit() {
        this._lock.close();
        if (this._state != TransactionStatus.Active) {
            String string2 = Res.INSTANCE.getTransactionManagerException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionManagerException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        this._state = TransactionStatus.Committed;
    }

    @Override
    public void rollback() {
        this._lock.close();
        if (this._state != TransactionStatus.Active) {
            String string2 = Res.INSTANCE.getTransactionManagerException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionManagerException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        this._state = TransactionStatus.Aborted;
    }
}

