/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer2.collections.IMutableMapLong2Long;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.RedoRecordReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\fj\u0002`\r2\n\u0010\u001d\u001a\u00060\fj\u0002`\rH\u0002J\u0006\u0010\u001e\u001a\u00020\u0012R:\u0010\n\u001a.\u0012\b\u0012\u00060\fj\u0002`\r\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0016\u0012\b\u0012\u00060\fj\u0002`\r\u0012\b\u0012\u00060\fj\u0002`\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/transactions/TidReplayer;", "", "olap", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "lsnContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/SlaveLSNContext;Ljava/lang/String;)V", "activeCube", "Ljava/util/HashMap;", "", "Lkd/bos/olapServer2/common/int;", "Lkotlin/collections/HashMap;", "recordItr", "Lkd/bos/olapServer2/replication/RedoRecordReader;", "dealCompensationRecord", "", "record", "Lkd/bos/olapServer2/replication/IDMLRecord;", "dealDDLRecord", "Lkd/bos/olapServer2/replication/IDDLRecord;", "dealDMLRecord", "dealTranRecord", "Lkd/bos/olapServer2/replication/ITranStatusRecord;", "getTidMap", "Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "cubeId", "partitionId", "replay", "bos-olap-core2"})
public final class TidReplayer {
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final RedoRecordReader recordItr;
    @NotNull
    private final HashMap<Integer, Integer> activeCube;

    public TidReplayer(@NotNull OlapWorkspace olap, @NotNull SlaveLSNContext lsnContext, @NotNull String redoPath) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        this.olap = olap;
        this.recordItr = new RedoRecordReader(redoPath, lsnContext);
        this.activeCube = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replay() {
        Closeable closeable = this.recordItr;
        Throwable throwable = null;
        try {
            RedoRecordReader it = (RedoRecordReader)closeable;
            boolean bl = false;
            while (this.recordItr.next()) {
                RedoRecordWithPage current = this.recordItr.getCurrent();
                IRedoRecord record = current.getRecord();
                switch (WhenMappings.$EnumSwitchMapping$0[record.getRedoType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDDLRecord");
                        this.dealDDLRecord((IDDLRecord)record);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDMLRecord");
                        this.dealDMLRecord((IDMLRecord)record);
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDMLRecord");
                        this.dealCompensationRecord((IDMLRecord)record);
                        break;
                    }
                    case 5: {
                        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.ITranStatusRecord");
                        this.dealTranRecord((ITranStatusRecord)record);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void dealDDLRecord(IDDLRecord record) {
        int cubeId = record.getCubeId();
        if (cubeId == 0) {
            if (!this.activeCube.isEmpty()) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return;
        }
        CubeWorkspace cube = this.olap.getCubeWorkspaceByCubeId(cubeId);
        cube.clearTidMap();
    }

    private final void dealDMLRecord(IDMLRecord record) {
        IMutableMapLong2Long tidMap = this.getTidMap(record.getCubeId(), record.getPartitionId());
        tidMap.set(record.getRowIndex(), record.getTid());
    }

    private final void dealCompensationRecord(IDMLRecord record) {
        IMutableMapLong2Long tidMap = this.getTidMap(record.getCubeId(), record.getPartitionId());
        tidMap.set(record.getRowIndex(), record.getUndoTid());
    }

    private final void dealTranRecord(ITranStatusRecord record) {
        switch (WhenMappings.$EnumSwitchMapping$1[record.getTranStatus().ordinal()]) {
            case 1: {
                int count = ((Number)this.activeCube.getOrDefault(record.getCubeId(), 0)).intValue() + 1;
                Integer n = count;
                ((Map)this.activeCube).put(record.getCubeId(), n);
                break;
            }
            case 2: 
            case 3: {
                if (((Number)this.activeCube.getOrDefault(record.getCubeId(), 0)).intValue() + -1 != 0) break;
                this.olap.getCubeWorkspaceByCubeId(record.getCubeId()).clearTidMap();
                this.activeCube.remove(record.getCubeId());
            }
        }
    }

    private final IMutableMapLong2Long getTidMap(int cubeId, int partitionId) {
        CubeWorkspace cube = this.olap.getCubeWorkspaceByCubeId(cubeId);
        return cube.getMetadata().getEnabledPartition() ? cube.getPartitionWorkspaces().getOrCreate(partitionId).getTidMap() : cube.getPartitionWorkspaces().getOrCreate(-1).getTidMap();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.METADATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.INSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.TranStatus.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.CubeRecover.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TransactionStatus.values().length];
            try {
                nArray[TransactionStatus.Active.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Committed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Aborted.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Idle.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

