/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.transactions.IRollbackExecutor;
import kd.bos.olapServer2.transactions.RollbackTIDSet;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/transactions/TransactionRollbackExecutor;", "Lkd/bos/olapServer2/transactions/IRollbackExecutor;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "undoIterator", "", "Lkd/bos/olapServer2/replication/IRedoRecord;", "rollbackTIDSet", "Lkd/bos/olapServer2/transactions/RollbackTIDSet;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/transactions/WriteTransaction;Ljava/util/Iterator;Lkd/bos/olapServer2/transactions/RollbackTIDSet;)V", "preTranActive", "", "toDealRow", "Ljava/util/HashMap;", "", "Lkd/bos/olapServer2/common/rowIdx;", "Lkd/bos/olapServer2/dataEntities/InputRow;", "Lkotlin/collections/HashMap;", "execute", "", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nTransactionRollbackExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionRollbackExecutor.kt\nkd/bos/olapServer2/transactions/TransactionRollbackExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class TransactionRollbackExecutor
implements IRollbackExecutor {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final WriteTransaction transaction;
    @NotNull
    private final Iterator<IRedoRecord> undoIterator;
    @NotNull
    private final RollbackTIDSet rollbackTIDSet;
    @NotNull
    private HashMap<Long, InputRow> toDealRow;
    private boolean preTranActive;

    public TransactionRollbackExecutor(@NotNull CubeWorkspace cubeWorkspace, @NotNull WriteTransaction transaction, @NotNull Iterator<? extends IRedoRecord> undoIterator2, @NotNull RollbackTIDSet rollbackTIDSet) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(undoIterator2, (String)"undoIterator");
        Intrinsics.checkNotNullParameter((Object)rollbackTIDSet, (String)"rollbackTIDSet");
        this.cubeWorkspace = cubeWorkspace;
        this.transaction = transaction;
        this.undoIterator = undoIterator2;
        this.rollbackTIDSet = rollbackTIDSet;
        this.toDealRow = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        InputRow row = new InputRow(this.cubeWorkspace.getMetadata());
        Closeable closeable = CubeWorkspace.createWriter$default(this.cubeWorkspace, null, this.transaction, null, 5, null);
        Throwable throwable = null;
        try {
            IInputRowWriter writer = (IInputRowWriter)closeable;
            boolean bl = false;
            while (!(!this.undoIterator.hasNext() || this.preTranActive && this.toDealRow.isEmpty())) {
                Long l;
                IRedoRecord record = this.undoIterator.next();
                if (record instanceof ITranStatusRecord) {
                    if (((ITranStatusRecord)record).getTranStatus() != TransactionStatus.Active) continue;
                    this.preTranActive = true;
                    continue;
                }
                if (!(record instanceof IDMLRecord)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                int partitionId = ((IDMLRecord)record).getPartitionId();
                long rowIdx = ((IDMLRecord)record).getRowIndex();
                long globalIndex = RowIndexUtil.INSTANCE.getRowIndex(partitionId, rowIdx);
                if (record.getTid() != this.transaction.getVersion() && !((Map)this.toDealRow).containsKey(l = Long.valueOf(globalIndex))) continue;
                if (!writer.isRowNeedRollback(partitionId, rowIdx, this.transaction.getVersion())) {
                    l = globalIndex;
                    if (!((Map)this.toDealRow).containsKey(l)) continue;
                    this.toDealRow.remove(globalIndex);
                    continue;
                }
                long stamp = this.rollbackTIDSet.readLock();
                try {
                    Object object2;
                    InputRow realRow;
                    long undoTid;
                    block26: {
                        InputRow it;
                        Object object3;
                        block25: {
                            InputRow oldRow;
                            block22: {
                                Object object4;
                                block24: {
                                    block23: {
                                        undoTid = ((IDMLRecord)record).getUndoTid();
                                        if (!this.rollbackTIDSet.contain(undoTid)) break block22;
                                        oldRow = this.toDealRow.get(globalIndex);
                                        object4 = oldRow;
                                        if (object4 == null) break block23;
                                        object3 = object4;
                                        it = object3;
                                        boolean bl2 = false;
                                        ((IDMLRecord)record).getUndoValues(oldRow);
                                        object4 = object3;
                                        if (object4 != null) break block24;
                                    }
                                    object3 = new InputRow(this.cubeWorkspace.getMetadata());
                                    it = object3;
                                    boolean bl3 = false;
                                    ((IDMLRecord)record).getUndoValues(it);
                                    object4 = object3;
                                }
                                realRow = object4;
                                object3 = globalIndex;
                                ((Map)this.toDealRow).put(object3, realRow);
                                continue;
                            }
                            oldRow = this.toDealRow.get(globalIndex);
                            object2 = oldRow;
                            if (object2 == null) break block25;
                            object3 = object2;
                            it = object3;
                            boolean bl4 = false;
                            ((IDMLRecord)record).getUndoValues(it);
                            object2 = object3;
                            if (object2 != null) break block26;
                        }
                        object3 = row;
                        it = object3;
                        boolean bl5 = false;
                        ((IDMLRecord)record).getUndoValues(it);
                        object2 = object3;
                    }
                    realRow = object2;
                    writer.rollback(partitionId, rowIdx, undoTid, realRow.getValues());
                }
                finally {
                    this.rollbackTIDSet.unLockRead(stamp);
                    continue;
                }
                this.toDealRow.remove(globalIndex);
            }
            if (!this.toDealRow.isEmpty()) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            writer.force();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

