/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.transactions;

import java.util.Iterator;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.transactions.RecordIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BG\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\n\u0010\n\u001a\u00060\bj\u0002`\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0096\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/transactions/UndoRecordReader;", "Lkotlin/sequences/Sequence;", "Lkd/bos/olapServer2/replication/RedoRecordWithPage;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "backupPath", "leftLSN", "", "Lkd/bos/olapServer2/common/LSN;", "rightLSN", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/lang/String;Ljava/lang/String;JJLjava/lang/Integer;)V", "redoRecordReader", "Lkd/bos/olapServer2/replication/RedoRecordCombineReader;", "iterator", "", "bos-olap-core2"})
public final class UndoRecordReader
implements Sequence<RedoRecordWithPage> {
    @NotNull
    private final RedoRecordCombineReader redoRecordReader;

    public UndoRecordReader(@NotNull String redoPath, @NotNull String backupPath, long leftLSN, long rightLSN, @Nullable Integer cubeId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        String incrementPath = "";
        if (!StringsKt.isBlank((CharSequence)backupPath)) {
            incrementPath = RedoUtil.INSTANCE.getOrCreateIncrementPath(backupPath);
            l = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(incrementPath).getFirst();
        } else {
            l = Long.MAX_VALUE;
        }
        long minIncrementLsn = l;
        long minRedoLsn = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(redoPath).getFirst();
        long minLsn = Math.max(leftLSN, Math.min(minIncrementLsn, minRedoLsn));
        SeqRedoLogger redoLogger = new SeqRedoLogger(redoPath, 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null);
        SeqRedoLogger incrementRedoLogger = !StringsKt.isBlank((CharSequence)backupPath) ? new SeqRedoLogger(incrementPath, 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null) : null;
        this.redoRecordReader = new RedoRecordCombineReader(redoLogger, incrementRedoLogger, new SlaveLSNContext(minLsn, rightLSN, -1L), cubeId, false);
    }

    public /* synthetic */ UndoRecordReader(String string2, String string3, long l, long l2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        this(string2, string3, l, l2, n);
    }

    @NotNull
    public Iterator<RedoRecordWithPage> iterator() {
        return new RecordIterator(this.redoRecordReader);
    }
}

