/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import kd.bos.olapServer.grammar.DragonFunction;
import kd.bos.olapServer.grammar.Parser;
import kd.bos.olapServer.grammar.common.IntCompactUtil;
import kd.bos.olapServer.grammar.common.OperateUtils;
import kd.bos.olapServer.grammar.common.Res;
import kd.bos.olapServer.grammar.dragonExpr.DragonOpEqual;
import kd.bos.olapServer.grammar.dragonExpr.DragonOpMinus;
import kd.bos.olapServer.grammar.dragonExpr.DragonOpNotEqual;
import kd.bos.olapServer.grammar.dragonExpr.DragonOpPlus;
import kd.bos.olapServer.grammar.dragonExpr.handler.AddDragonCalcHandler;
import kd.bos.olapServer.grammar.dragonExpr.handler.DivDragonCalcHandler;
import kd.bos.olapServer.grammar.dragonExpr.handler.MulDragonCalcHandler;
import kd.bos.olapServer.grammar.dragonExpr.handler.SubDragonCalcHandler;
import kd.bos.olapServer.grammar.exception.AbstractDragonException;
import kd.bos.olapServer.grammar.exception.ExecuteException;
import kd.bos.olapServer.grammar.exception.ParserException;
import kd.bos.olapServer.grammar.exception.ScanCharException;
import kd.bos.olapServer.grammar.expr.ConstanceExpr;
import kd.bos.olapServer.grammar.expr.DragonFunctionExpr;
import kd.bos.olapServer.grammar.expr.IExpr;
import kd.bos.olapServer.grammar.expr.NegativeExpr;
import kd.bos.olapServer.grammar.expr.NumberExpr;
import kd.bos.olapServer.grammar.expr.StringExpr;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/grammar/DragonEngine;", "", "()V", "parser", "Lkd/bos/olapServer/grammar/Parser;", "getParser$bos_olap_dragonEngine", "()Lkd/bos/olapServer/grammar/Parser;", "parse", "Lkd/bos/olapServer/grammar/expr/IExpr;", "formula", "", "register", "", "funDef", "Lkd/bos/olapServer/grammar/DragonFunction;", "Companion", "bos-olap-dragonEngine"})
public final class DragonEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Parser parser = new Parser();

    @NotNull
    public final Parser getParser$bos_olap_dragonEngine() {
        return this.parser;
    }

    public final void register(@NotNull DragonFunction funDef) {
        Intrinsics.checkNotNullParameter((Object)funDef, (String)"funDef");
        this.parser.getFunctionProvider().regist(new DragonFunctionExpr(funDef));
    }

    @NotNull
    public final IExpr parse(@Nullable String formula) {
        return this.parser.parse(formula);
    }

    @JvmStatic
    @Nullable
    public static final Object add(@Nullable Object left, @Nullable Object right) {
        return Companion.add(left, right);
    }

    @JvmStatic
    @Nullable
    public static final Object sub(@Nullable Object left, @Nullable Object right) {
        return Companion.sub(left, right);
    }

    @JvmStatic
    @Nullable
    public static final Object mul(@Nullable Object left, @Nullable Object right) {
        return Companion.mul(left, right);
    }

    @JvmStatic
    @Nullable
    public static final Object div(@Nullable Object left, @Nullable Object right) {
        return Companion.div(left, right);
    }

    @JvmStatic
    @Nullable
    public static final Object plus(@Nullable Object value) {
        return Companion.plus(value);
    }

    @JvmStatic
    public static final boolean isNullOrDefaultValue(@Nullable Object value) {
        return Companion.isNullOrDefaultValue(value);
    }

    @JvmStatic
    @Nullable
    public static final Object negate(@Nullable Object value) {
        return Companion.negate(value);
    }

    @JvmStatic
    public static final boolean valueEquals(@Nullable Object a, @Nullable Object b) {
        return Companion.valueEquals(a, b);
    }

    @JvmStatic
    public static final boolean less(@Nullable Object a, @Nullable Object b) {
        return Companion.less(a, b);
    }

    @JvmStatic
    public static final boolean larger(@Nullable Object a, @Nullable Object b) {
        return Companion.larger(a, b);
    }

    @JvmStatic
    public static final boolean lessEqual(@Nullable Object a, @Nullable Object b) {
        return Companion.lessEqual(a, b);
    }

    @JvmStatic
    public static final boolean largerEqual(@Nullable Object a, @Nullable Object b) {
        return Companion.largerEqual(a, b);
    }

    @JvmStatic
    public static final boolean isInScope(@NotNull BigDecimal $this$isInScope) {
        return Companion.isInScope($this$isInScope);
    }

    @JvmStatic
    @Nullable
    public static final BigDecimal tryInScale(@NotNull BigDecimal $this$tryInScale) {
        return Companion.tryInScale($this$tryInScale);
    }

    @JvmStatic
    public static final boolean isInScope(@NotNull BigInteger $this$isInScope) {
        return Companion.isInScope($this$isInScope);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal toDecimal(@NotNull Object $this$toDecimal) {
        return Companion.toDecimal($this$toDecimal);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001e\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0007J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010#\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0007J\u001c\u0010&\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0007J\u001c\u0010'\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0007J\u001c\u0010(\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010)\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J\u0014\u0010*\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0007J\u0014\u0010+\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010,\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J\u001c\u0010-\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0007J\f\u0010.\u001a\u00020\u0004*\u00020/H\u0007J\f\u0010.\u001a\u00020\u0004*\u000200H\u0007J\f\u00101\u001a\u00020/*\u00020\u0001H\u0007J\u000e\u00102\u001a\u0004\u0018\u00010/*\u00020/H\u0007R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lkd/bos/olapServer/grammar/DragonEngine$Companion;", "", "()V", "value", "", "DEBUG", "getDEBUG", "()Z", "setDEBUG", "(Z)V", "Ljava/util/Locale;", "currentLocale", "getCurrentLocale", "()Ljava/util/Locale;", "setCurrentLocale", "(Ljava/util/Locale;)V", "add", "left", "right", "div", "getDragonEngineExceptionMsg", "", "e", "Lkd/bos/olapServer/grammar/exception/AbstractDragonException;", "isBooleanReturnData", "expr", "Lkd/bos/olapServer/grammar/expr/IExpr;", "isConstant", "isNegative", "isNull", "isNullOrDefaultValue", "isOpEqual", "isOpMinus", "isOpPlus", "isStringExpr", "larger", "a", "b", "largerEqual", "less", "lessEqual", "mul", "negate", "plus", "sub", "valueEquals", "isInScope", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "toDecimal", "tryInScale", "bos-olap-dragonEngine"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDEBUG() {
            return OperateUtils.INSTANCE.getDEBUG();
        }

        public final void setDEBUG(boolean value) {
            OperateUtils.INSTANCE.setDEBUG(value);
        }

        @NotNull
        public final Locale getCurrentLocale() {
            return Res.INSTANCE.getCurrentLocale();
        }

        public final void setCurrentLocale(@NotNull Locale value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Res.INSTANCE.setCurrentLocale(value);
        }

        public final boolean isConstant(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof StringExpr || expr instanceof NumberExpr || expr instanceof ConstanceExpr;
        }

        public final boolean isNegative(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof NegativeExpr;
        }

        public final boolean isOpPlus(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof DragonOpPlus;
        }

        public final boolean isOpMinus(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof DragonOpMinus;
        }

        public final boolean isStringExpr(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof StringExpr;
        }

        public final boolean isOpEqual(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr instanceof DragonOpEqual && !(expr instanceof DragonOpNotEqual);
        }

        public final boolean isNull(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return Intrinsics.areEqual((Object)expr, (Object)ConstanceExpr.NULL);
        }

        public final boolean isBooleanReturnData(@NotNull IExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return expr.getReturnDataType() == 6;
        }

        @JvmStatic
        @Nullable
        public final Object add(@Nullable Object left, @Nullable Object right) {
            if (left instanceof BigDecimal && right instanceof BigDecimal) {
                BigDecimal result = ((BigDecimal)left).add((BigDecimal)right);
                Intrinsics.checkNotNull((Object)result);
                if (!this.isInScope(result)) {
                    Object[] objectArray = new Object[]{left + " + " + right};
                    throw ExecuteException.Companion.returnDataOutScope(Res.INSTANCE.getCommonFunctionException_3(), objectArray);
                }
                return result;
            }
            return AddDragonCalcHandler.INSTANCE.operate(left, right);
        }

        @JvmStatic
        @Nullable
        public final Object sub(@Nullable Object left, @Nullable Object right) {
            if (left instanceof BigDecimal && right instanceof BigDecimal) {
                BigDecimal result = ((BigDecimal)left).subtract((BigDecimal)right);
                Intrinsics.checkNotNull((Object)result);
                if (!this.isInScope(result)) {
                    Object[] objectArray = new Object[]{left + " - " + right};
                    throw ExecuteException.Companion.returnDataOutScope(Res.INSTANCE.getCommonFunctionException_3(), objectArray);
                }
                return result;
            }
            return SubDragonCalcHandler.INSTANCE.operate(left, right);
        }

        @JvmStatic
        @Nullable
        public final Object mul(@Nullable Object left, @Nullable Object right) {
            return MulDragonCalcHandler.INSTANCE.operate(left, right);
        }

        @JvmStatic
        @Nullable
        public final Object div(@Nullable Object left, @Nullable Object right) {
            return DivDragonCalcHandler.INSTANCE.operate(left, right);
        }

        @JvmStatic
        @Nullable
        public final Object plus(@Nullable Object value) {
            return OperateUtils.plus(value);
        }

        @JvmStatic
        public final boolean isNullOrDefaultValue(@Nullable Object value) {
            return OperateUtils.isNullOrDefaultValue(value);
        }

        @JvmStatic
        @Nullable
        public final Object negate(@Nullable Object value) {
            return OperateUtils.negate(value);
        }

        @JvmStatic
        public final boolean valueEquals(@Nullable Object a, @Nullable Object b) {
            return OperateUtils.valueEquals(a, b);
        }

        @JvmStatic
        public final boolean less(@Nullable Object a, @Nullable Object b) {
            return OperateUtils.less(a, b);
        }

        @JvmStatic
        public final boolean larger(@Nullable Object a, @Nullable Object b) {
            return OperateUtils.larger(a, b);
        }

        @JvmStatic
        public final boolean lessEqual(@Nullable Object a, @Nullable Object b) {
            return OperateUtils.lessEqual(a, b);
        }

        @JvmStatic
        public final boolean largerEqual(@Nullable Object a, @Nullable Object b) {
            return OperateUtils.largerEqual(a, b);
        }

        @JvmStatic
        public final boolean isInScope(@NotNull BigDecimal $this$isInScope) {
            Intrinsics.checkNotNullParameter((Object)$this$isInScope, (String)"<this>");
            return IntCompactUtil.isInScope($this$isInScope);
        }

        @JvmStatic
        @Nullable
        public final BigDecimal tryInScale(@NotNull BigDecimal $this$tryInScale) {
            Intrinsics.checkNotNullParameter((Object)$this$tryInScale, (String)"<this>");
            return IntCompactUtil.tryInScale($this$tryInScale);
        }

        @JvmStatic
        public final boolean isInScope(@NotNull BigInteger $this$isInScope) {
            Intrinsics.checkNotNullParameter((Object)$this$isInScope, (String)"<this>");
            return IntCompactUtil.isInScope($this$isInScope);
        }

        @JvmStatic
        @NotNull
        public final BigDecimal toDecimal(@NotNull Object $this$toDecimal) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)$this$toDecimal, (String)"<this>");
            Object object = $this$toDecimal;
            if (object instanceof Long) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)$this$toDecimal).longValue());
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this)");
            } else if (object instanceof Float) {
                bigDecimal = new BigDecimal(String.valueOf(((Number)$this$toDecimal).floatValue()));
            } else if (object instanceof Double) {
                bigDecimal = new BigDecimal(String.valueOf(((Number)$this$toDecimal).doubleValue()));
            } else if (object instanceof Short) {
                BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)$this$toDecimal).shortValue());
                bigDecimal = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
            } else if (object instanceof BigInteger) {
                bigDecimal = new BigDecimal((BigInteger)$this$toDecimal);
            } else if (object instanceof Number) {
                bigDecimal = new BigDecimal($this$toDecimal.toString());
            } else {
                Object[] objectArray = new Object[]{$this$toDecimal.getClass() + " convertTo BigDecimal"};
                throw ExecuteException.Companion.dataTypeError(Res.INSTANCE.getCommonFunctionException_2(), objectArray);
            }
            return bigDecimal;
        }

        @NotNull
        public final String getDragonEngineExceptionMsg(@NotNull AbstractDragonException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String retMsg = Res.INSTANCE.getCurrentBundle().getString("DragonEngineException_" + e.getType());
            AbstractDragonException abstractDragonException = e;
            if (abstractDragonException instanceof ExecuteException) {
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.checkNotNull((Object)retMsg);
                    string = retMsg;
                }
                return string;
            }
            if (abstractDragonException instanceof ParserException) {
                if (((ParserException)e).getKeyText() == null) {
                    Intrinsics.checkNotNull((Object)retMsg);
                    return retMsg;
                }
                Intrinsics.checkNotNull((Object)retMsg);
                String string = retMsg;
                Object[] objectArray = new Object[]{((ParserException)e).getKeyText()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                return string2;
            }
            if (abstractDragonException instanceof ScanCharException) {
                Intrinsics.checkNotNull((Object)retMsg);
                String string = retMsg;
                Object[] objectArray = new Object[]{((ScanCharException)e).getChar()};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                return string3;
            }
            Intrinsics.checkNotNull((Object)retMsg);
            return retMsg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

