/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar;

import java.util.ArrayList;
import java.util.List;
import kd.bos.olapServer.grammar.Token;
import kd.bos.olapServer.grammar.exception.ScanCharException;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00182\u00020\u0001:\n\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkd/bos/olapServer/grammar/Scanner;", "", "()V", "_currentSearcher", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "_searchers", "", "lookupAnotherSearcher", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "", "lookupSearcher", "scan", "Lkd/bos/olapServer/grammar/Token;", "formula", "", "scanOneChar", "", "tokens", "", "idx", "", "AbstractSearcher", "BlankSearcher", "Companion", "LogicOperatorsSearcher", "NumberSearcher", "ReferenceSearcher", "RelationOperatorsSearcher", "SingleSignSearcher", "StringSearcher", "WordSearcher", "bos-olap-dragonEngine"})
public final class Scanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AbstractSearcher> _searchers;
    @Nullable
    private AbstractSearcher _currentSearcher;
    public static final char EOT = '\u0004';
    @NotNull
    private static final boolean[] RESERVED = new boolean[128];

    public Scanner() {
        ArrayList<AbstractSearcher> searchers = new ArrayList<AbstractSearcher>();
        searchers.add(new BlankSearcher());
        searchers.add(new SingleSignSearcher('+', Token.TokenType.PLUS));
        searchers.add(new SingleSignSearcher('-', Token.TokenType.MINUS));
        searchers.add(new SingleSignSearcher('*', Token.TokenType.MULTIPLY));
        searchers.add(new SingleSignSearcher('/', Token.TokenType.DIVIDE));
        searchers.add(new SingleSignSearcher('%', Token.TokenType.MOD));
        searchers.add(new SingleSignSearcher('(', Token.TokenType.LBRACKET));
        searchers.add(new SingleSignSearcher(')', Token.TokenType.RBRACKET));
        searchers.add(new SingleSignSearcher(',', Token.TokenType.COMMA));
        searchers.add(new SingleSignSearcher('?', Token.TokenType.IIF));
        searchers.add(new SingleSignSearcher(':', Token.TokenType.IIF2));
        searchers.add(new RelationOperatorsSearcher());
        searchers.add(new LogicOperatorsSearcher());
        searchers.add(new NumberSearcher());
        searchers.add(new StringSearcher('\"'));
        searchers.add(new StringSearcher('\''));
        searchers.add(new ReferenceSearcher('[', ']'));
        searchers.add(new WordSearcher());
        this._searchers = searchers;
    }

    @NotNull
    public final List<Token> scan(@NotNull String formula) throws ScanCharException {
        List tokens;
        block6: {
            AbstractSearcher abstractSearcher;
            Intrinsics.checkNotNullParameter((Object)formula, (String)"formula");
            tokens = new ArrayList();
            this._currentSearcher = null;
            int c = formula.length();
            for (int i = 0; i < c; ++i) {
                char chr = formula.charAt(i);
                try {
                    this.scanOneChar(tokens, chr, i);
                    continue;
                }
                catch (ScanCharException ex) {
                    AbstractSearcher abstractSearcher2 = this._currentSearcher;
                    if (abstractSearcher2 != null) {
                        abstractSearcher2.reset();
                    }
                    ex.setIdx(i);
                    throw ex;
                }
            }
            AbstractSearcher abstractSearcher3 = this._currentSearcher;
            if (abstractSearcher3 == null) break block6;
            AbstractSearcher $this$scan_u24lambda_u240 = abstractSearcher = abstractSearcher3;
            boolean bl = false;
            try {
                $this$scan_u24lambda_u240.check('\u0004');
            }
            catch (ScanCharException ex) {
                int afterStartMark = formula.length() - $this$scan_u24lambda_u240.getText().length();
                ex.setIdx(afterStartMark);
                $this$scan_u24lambda_u240.reset();
                throw ex;
            }
            tokens.add($this$scan_u24lambda_u240.createTokenAndReset(formula.length() - 1));
        }
        return tokens;
    }

    private final void scanOneChar(List<Token> tokens, char chr, int idx) throws ScanCharException {
        AbstractSearcher currentSearcher = this._currentSearcher;
        if (currentSearcher == null) {
            AbstractSearcher.CheckResult result = this.lookupSearcher(chr);
            if (result.isEnd()) {
                AbstractSearcher abstractSearcher = this._currentSearcher;
                Intrinsics.checkNotNull((Object)abstractSearcher);
                tokens.add(abstractSearcher.createTokenAndReset(idx));
                this._currentSearcher = null;
            }
        } else {
            AbstractSearcher.CheckResult result = currentSearcher.check(chr);
            if (result.isYield()) {
                AbstractSearcher oldSearcher = currentSearcher;
                AbstractSearcher.CheckResult anotherResult = this.lookupAnotherSearcher(chr);
                if (anotherResult == null) {
                    oldSearcher.lookBack(true);
                } else {
                    oldSearcher.lookBack(false);
                    tokens.add(oldSearcher.createTokenAndReset(idx - 1));
                    if (anotherResult.isEnd()) {
                        AbstractSearcher abstractSearcher = this._currentSearcher;
                        Intrinsics.checkNotNull((Object)abstractSearcher);
                        tokens.add(abstractSearcher.createTokenAndReset(idx));
                        this._currentSearcher = null;
                    }
                }
            } else if (result.isEnd()) {
                AbstractSearcher abstractSearcher = this._currentSearcher;
                Intrinsics.checkNotNull((Object)abstractSearcher);
                tokens.add(abstractSearcher.createTokenAndReset(idx));
                this._currentSearcher = null;
            }
        }
    }

    private final AbstractSearcher.CheckResult lookupSearcher(char chr) throws ScanCharException {
        for (AbstractSearcher searcher : this._searchers) {
            AbstractSearcher.CheckResult result = searcher.check(chr);
            if (result == AbstractSearcher.CheckResult.UNKNOWN) continue;
            this._currentSearcher = searcher;
            return result;
        }
        throw new RuntimeException("Sth. must be wrong.");
    }

    private final AbstractSearcher.CheckResult lookupAnotherSearcher(char chr) throws ScanCharException {
        for (AbstractSearcher searcher : this._searchers) {
            AbstractSearcher.CheckResult result;
            if (searcher == this._currentSearcher || (result = searcher.check(chr)) == AbstractSearcher.CheckResult.UNKNOWN) continue;
            this._currentSearcher = searcher;
            return result;
        }
        return null;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Scanner.RESERVED[i] = false;
        }
        Scanner.RESERVED[35] = true;
        Scanner.RESERVED[36] = true;
        Scanner.RESERVED[46] = true;
        Scanner.RESERVED[59] = true;
        Scanner.RESERVED[64] = true;
        Scanner.RESERVED[92] = true;
        Scanner.RESERVED[94] = true;
        Scanner.RESERVED[96] = true;
        Scanner.RESERVED[123] = true;
        Scanner.RESERVED[125] = true;
        Scanner.RESERVED[126] = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H$J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0004J\u0006\u0010\u001f\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0015\u0010\u000b\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "", "()V", "_lastCheckResult", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "_text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isBeforeStart", "", "()Z", "text", "getText", "()Ljava/lang/StringBuilder;", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "append", "", "chr", "", "check", "checkImpl", "createTokenAndReset", "Lkd/bos/olapServer/grammar/Token;", "endCharIdx", "", "lookBack", "isContinueOtherwiseEnd", "removeLast", "reset", "CheckResult", "Companion", "bos-olap-dragonEngine"})
    public static abstract class AbstractSearcher {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private StringBuilder _text = new StringBuilder();
        @Nullable
        private CheckResult _lastCheckResult;
        public static final int Status_Unknown = 1;
        public static final int Status_Accept = 2;
        public static final int Status_End = 4;
        public static final int Status_Yield = 8;

        @NotNull
        public final StringBuilder getText() {
            return this._text;
        }

        public final void reset() {
            StringsKt.clear((StringBuilder)this._text);
            this._lastCheckResult = null;
        }

        protected final boolean isBeforeStart() {
            return ((CharSequence)this._text).length() == 0;
        }

        protected final void append(char chr) {
            this._text.append(chr);
        }

        protected final void removeLast() {
            if (!this.isBeforeStart()) {
                this._text.deleteCharAt(this._text.length() - 1);
            }
        }

        @NotNull
        public final Token createTokenAndReset(int endCharIdx) {
            int startCharIdx = endCharIdx - this._text.length() + 1;
            String string = this._text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Token token = new Token(string, this.getTokenType(), startCharIdx);
            this.reset();
            return token;
        }

        @NotNull
        protected abstract Token.TokenType getTokenType();

        @NotNull
        public final CheckResult check(char chr) throws ScanCharException {
            CheckResult checkResult = this.checkImpl(chr);
            if (checkResult == null) {
                throw new RuntimeException("\u5fc5\u987b\u8fd4\u56de\u4e00\u4e2a\u72b6\u6001");
            }
            CheckResult result = checkResult;
            CheckResult lastCheckResult = this._lastCheckResult;
            if (lastCheckResult == null) {
                if (result.isStatus(8)) {
                    throw new RuntimeException("\u4e0d\u80fd\u4e00\u4e0a\u6765\u5c31Yield");
                }
            } else {
                if (lastCheckResult.isStatus(4)) {
                    throw new RuntimeException("End\u540e\u4e0d\u80fd\u8df3\u8f6c\u5230\u5176\u5b83\u72b6\u6001");
                }
                if (result.isStatus(1)) {
                    throw new RuntimeException("\u4e0d\u80fd\u4ece\u5176\u5b83\u72b6\u6001\u8df3\u8f6c\u5230Unknown");
                }
            }
            if (!result.isStatus(1)) {
                this._lastCheckResult = result;
            }
            return result;
        }

        @Nullable
        protected abstract CheckResult checkImpl(char var1) throws ScanCharException;

        public void lookBack(boolean isContinueOtherwiseEnd) {
            if (isContinueOtherwiseEnd) {
                throw new RuntimeException("\u5fc5\u987b\u6709\u53d7\u8ba9\u8005\u63a5\u6536");
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "", "_status", "", "(Ljava/lang/String;II)V", "isEnd", "", "()Z", "isYield", "isStatus", "status", "UNKNOWN", "START", "INSIDE", "END", "SINGLE", "YIELD", "bos-olap-dragonEngine"})
        public static final class CheckResult
        extends Enum<CheckResult> {
            private final int _status;
            public static final /* enum */ CheckResult UNKNOWN = new CheckResult(1);
            public static final /* enum */ CheckResult START = new CheckResult(2);
            public static final /* enum */ CheckResult INSIDE = new CheckResult(2);
            public static final /* enum */ CheckResult END = new CheckResult(4);
            public static final /* enum */ CheckResult SINGLE = new CheckResult(6);
            public static final /* enum */ CheckResult YIELD = new CheckResult(8);
            private static final /* synthetic */ CheckResult[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private CheckResult(int _status) {
                this._status = _status;
            }

            public final boolean isEnd() {
                return this.isStatus(4);
            }

            public final boolean isYield() {
                return this.isStatus(8);
            }

            public final boolean isStatus(int status) {
                return (this._status & status) == status;
            }

            public static CheckResult[] values() {
                return (CheckResult[])$VALUES.clone();
            }

            public static CheckResult valueOf(String value) {
                return Enum.valueOf(CheckResult.class, value);
            }

            @NotNull
            public static EnumEntries<CheckResult> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = checkResultArray = new CheckResult[]{CheckResult.UNKNOWN, CheckResult.START, CheckResult.INSIDE, CheckResult.END, CheckResult.SINGLE, CheckResult.YIELD};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$Companion;", "", "()V", "Status_Accept", "", "Status_End", "Status_Unknown", "Status_Yield", "bos-olap-dragonEngine"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/grammar/Scanner$BlankSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "()V", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "", "bos-olap-dragonEngine"})
    private static final class BlankSearcher
    extends AbstractSearcher {
        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.BLANK;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            if (this.isBeforeStart()) {
                if (chr <= ' ') {
                    this.append(chr);
                    checkResult = AbstractSearcher.CheckResult.START;
                } else {
                    checkResult = AbstractSearcher.CheckResult.UNKNOWN;
                }
            } else if (chr <= ' ') {
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.INSIDE;
            } else {
                checkResult = AbstractSearcher.CheckResult.YIELD;
            }
            return checkResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0018\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer/grammar/Scanner$Companion;", "", "()V", "EOT", "", "RESERVED", "", "bos-olap-dragonEngine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/grammar/Scanner$LogicOperatorsSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "()V", "_first", "", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class LogicOperatorsSearcher
    extends AbstractSearcher {
        private char _first;

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.LOGIC;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            if (this.isBeforeStart()) {
                if (chr == '&' || chr == '|') {
                    this._first = chr;
                    this.append(chr);
                    checkResult = AbstractSearcher.CheckResult.START;
                } else {
                    checkResult = AbstractSearcher.CheckResult.UNKNOWN;
                }
            } else {
                if (this._first == '&' && chr == '&') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.END;
                }
                if (this._first == '|' && chr == '|') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.END;
                }
                throw new ScanCharException("" + this._first + chr, 3);
            }
            return checkResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/grammar/Scanner$NumberSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "()V", "_isDotAppeared", "", "_isEAppeared", "beforChr", "", "Ljava/lang/Character;", "isAddOrSubAppeared", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class NumberSearcher
    extends AbstractSearcher {
        private boolean _isDotAppeared;
        private boolean _isEAppeared;
        private boolean isAddOrSubAppeared;
        @Nullable
        private Character beforChr;

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.NUMBER;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            block9: {
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                var3_2 = chr;
                                v0 = '0' <= var3_2 ? var3_2 < ':' : (isNum = false);
                                if (!this.isBeforeStart()) break block8;
                                if (isNum) {
                                    this._isDotAppeared = false;
                                    this._isEAppeared = false;
                                    this.isAddOrSubAppeared = false;
                                    this.append(chr);
                                    v1 = AbstractSearcher.CheckResult.START;
                                } else {
                                    v1 = AbstractSearcher.CheckResult.UNKNOWN;
                                }
                                break block9;
                            }
                            if (!isNum) break block10;
                            this.append(chr);
                            v1 = AbstractSearcher.CheckResult.INSIDE;
                            break block9;
                        }
                        if (chr != '.') break block11;
                        if (this._isDotAppeared) {
                            throw new ScanCharException(chr, 3);
                        }
                        this._isDotAppeared = true;
                        this.append(chr);
                        v1 = AbstractSearcher.CheckResult.INSIDE;
                        break block9;
                    }
                    if (chr != 'e' && chr != 'E') break block12;
                    if (this._isEAppeared) {
                        throw new ScanCharException(chr, 3);
                    }
                    this._isEAppeared = true;
                    v2 = this.beforChr;
                    var4_5 = '.';
                    if (v2 != null && v2.charValue() == var4_5) {
                        this.removeLast();
                    }
                    this.append(chr);
                    v1 = AbstractSearcher.CheckResult.INSIDE;
                    break block9;
                }
                if (chr != '+' && chr != '-') ** GOTO lbl-1000
                v3 = this.beforChr;
                var4_5 = 'e';
                if (v3 != null && v3.charValue() == var4_5) ** GOTO lbl-1000
                v4 = this.beforChr;
                var4_5 = 'E';
                if (v4 != null && v4.charValue() == var4_5) lbl-1000:
                // 2 sources

                {
                    if (this.isAddOrSubAppeared) {
                        throw new ScanCharException(chr, 3);
                    }
                    this.isAddOrSubAppeared = true;
                    this.append(chr);
                    v1 = AbstractSearcher.CheckResult.INSIDE;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = AbstractSearcher.CheckResult.YIELD;
                }
            }
            retCheckResult = v1;
            this.beforChr = Character.valueOf(chr);
            return retCheckResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/grammar/Scanner$ReferenceSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "_startMark", "", "_endMark", "(CC)V", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class ReferenceSearcher
    extends AbstractSearcher {
        private final char _startMark;
        private final char _endMark;

        public ReferenceSearcher(char _startMark, char _endMark) {
            this._startMark = _startMark;
            this._endMark = _endMark;
        }

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.REFERENCE;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            boolean isEndMark;
            boolean isStartMark = chr == this._startMark;
            boolean bl = isEndMark = chr == this._endMark;
            if (this.isBeforeStart()) {
                if (isStartMark) {
                    this.append(chr);
                    checkResult = AbstractSearcher.CheckResult.START;
                } else {
                    checkResult = AbstractSearcher.CheckResult.UNKNOWN;
                }
            } else if (isEndMark) {
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.END;
            } else {
                if (chr == '\u0004') {
                    throw new ScanCharException('[', 2);
                }
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.INSIDE;
            }
            return checkResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/grammar/Scanner$RelationOperatorsSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "()V", "_first", "", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class RelationOperatorsSearcher
    extends AbstractSearcher {
        private char _first;

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.RELOP;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            if (this.isBeforeStart()) {
                if (chr == '<' || chr == '>' || chr == '=' || chr == '!') {
                    this._first = chr;
                    this.append(chr);
                    checkResult = AbstractSearcher.CheckResult.START;
                } else {
                    checkResult = AbstractSearcher.CheckResult.UNKNOWN;
                }
            } else {
                if (this._first == '<') {
                    if (chr == '>' || chr == '=') {
                        this.append(chr);
                        return AbstractSearcher.CheckResult.END;
                    }
                    if (chr == '<') {
                        char[] cArray = new char[]{this._first, chr};
                        throw new ScanCharException(cArray, 3);
                    }
                } else if (this._first == '>') {
                    if (chr == '=') {
                        this.append(chr);
                        return AbstractSearcher.CheckResult.END;
                    }
                    if (chr == '>' || chr == '<') {
                        char[] cArray = new char[]{this._first, chr};
                        throw new ScanCharException(cArray, 3);
                    }
                } else if (this._first == '=') {
                    if (chr == '=') {
                        this.append(chr);
                        return AbstractSearcher.CheckResult.END;
                    }
                } else if (this._first == '!' && chr == '=') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.END;
                }
                checkResult = AbstractSearcher.CheckResult.YIELD;
            }
            return checkResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/grammar/Scanner$SingleSignSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "_sign", "", "_tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "(CLkd/bos/olapServer/grammar/Token$TokenType;)V", "tokenType", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class SingleSignSearcher
    extends AbstractSearcher {
        private final char _sign;
        @NotNull
        private final Token.TokenType _tokenType;

        public SingleSignSearcher(char _sign, @NotNull Token.TokenType _tokenType) {
            Intrinsics.checkNotNullParameter((Object)((Object)_tokenType), (String)"_tokenType");
            this._sign = _sign;
            this._tokenType = _tokenType;
        }

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return this._tokenType;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            if (chr == this._sign) {
                this.append(chr);
                return AbstractSearcher.CheckResult.SINGLE;
            }
            return AbstractSearcher.CheckResult.UNKNOWN;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/grammar/Scanner$StringSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "_mark", "", "(C)V", "_isTransfered", "", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "bos-olap-dragonEngine"})
    private static final class StringSearcher
    extends AbstractSearcher {
        private final char _mark;
        private boolean _isTransfered;

        public StringSearcher(char _mark) {
            this._mark = _mark;
        }

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.STRING;
        }

        @Override
        @NotNull
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            boolean isMark;
            boolean bl = isMark = chr == this._mark;
            if (this.isBeforeStart()) {
                if (isMark) {
                    this._isTransfered = false;
                    this.append(chr);
                    checkResult = AbstractSearcher.CheckResult.START;
                } else {
                    checkResult = AbstractSearcher.CheckResult.UNKNOWN;
                }
            } else if (this._isTransfered) {
                if (chr == '\\' || chr == '\"' || chr == '\'') {
                    this.append(chr);
                } else if (chr == 'r') {
                    this.append('\r');
                } else if (chr == 'n') {
                    this.append('\n');
                } else if (chr == 't') {
                    this.append('\t');
                } else {
                    throw new ScanCharException("" + '\\' + chr, 4);
                }
                this._isTransfered = false;
                checkResult = AbstractSearcher.CheckResult.INSIDE;
            } else if (chr == '\\') {
                this._isTransfered = true;
                checkResult = AbstractSearcher.CheckResult.INSIDE;
            } else if (isMark) {
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.END;
            } else {
                if (chr == '\u0004') {
                    throw new ScanCharException('\"', 2);
                }
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.INSIDE;
            }
            return checkResult;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/grammar/Scanner$WordSearcher;", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher;", "()V", "_tempChar", "", "tokenType", "Lkd/bos/olapServer/grammar/Token$TokenType;", "getTokenType", "()Lkd/bos/olapServer/grammar/Token$TokenType;", "checkImpl", "Lkd/bos/olapServer/grammar/Scanner$AbstractSearcher$CheckResult;", "chr", "lookBack", "", "isContinueOtherwiseEnd", "", "bos-olap-dragonEngine"})
    private static class WordSearcher
    extends AbstractSearcher {
        private char _tempChar;

        @Override
        @NotNull
        protected Token.TokenType getTokenType() {
            return Token.TokenType.WORD;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            AbstractSearcher.CheckResult checkResult;
            if (chr < '\u0080' && RESERVED[chr]) {
                throw new ScanCharException(chr, 1);
            }
            if (this.isBeforeStart()) {
                this.append(chr);
                checkResult = AbstractSearcher.CheckResult.START;
                return checkResult;
            }
            char c = chr;
            if (!('A' <= c ? c < '[' : false)) {
                c = chr;
                if (!('a' <= c ? c < '{' : false)) {
                    c = chr;
                    if (!('0' <= c ? c < ':' : false)) {
                        this._tempChar = chr;
                        checkResult = AbstractSearcher.CheckResult.YIELD;
                        return checkResult;
                    }
                }
            }
            this.append(chr);
            checkResult = AbstractSearcher.CheckResult.INSIDE;
            return checkResult;
        }

        @Override
        public void lookBack(boolean isContinueOtherwiseEnd) {
            if (isContinueOtherwiseEnd) {
                this.append(this._tempChar);
            }
            this._tempChar = '\u0000';
        }
    }
}

