/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/grammar/common/NumberUtil;", "", "()V", "BIGD_DOUBLE_MAX_VALUE", "Ljava/math/BigDecimal;", "BIGI_LONG_MAX_VALUE", "Ljava/math/BigInteger;", "BIGI_LONG_MIN_VALUE", "narrow", "", "original", "parseNumber", "l", "", "toBooleanObj", "", "value", "bos-olap-dragonEngine"})
public final class NumberUtil {
    @NotNull
    public static final NumberUtil INSTANCE = new NumberUtil();
    @NotNull
    private static final BigDecimal BIGD_DOUBLE_MAX_VALUE;
    @NotNull
    private static final BigInteger BIGI_LONG_MAX_VALUE;
    @NotNull
    private static final BigInteger BIGI_LONG_MIN_VALUE;

    private NumberUtil() {
    }

    @NotNull
    public final Number narrow(@NotNull Number original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Number result = original;
        if (original instanceof BigDecimal && ((BigDecimal)original).compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
            return original;
        }
        if (original instanceof Double || original instanceof Float || original instanceof BigDecimal) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(result.floatValue());
            }
        } else {
            if (original instanceof BigInteger && (((BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || ((BigInteger)original).compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            return this.parseNumber(value);
        }
        return result;
    }

    @NotNull
    public final Number parseNumber(long l) {
        int i = (int)l;
        return (long)i == l ? (Number)i : (Number)l;
    }

    public final boolean toBooleanObj(@Nullable Object value) {
        if (value == null) {
            Boolean bl = Boolean.FALSE;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"FALSE");
            return bl;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean bl = Boolean.valueOf((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(...)");
            return bl;
        }
        Boolean bl = Boolean.FALSE;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"FALSE");
        return bl;
    }

    static {
        BigDecimal bigDecimal = BigDecimal.valueOf(Double.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        BIGD_DOUBLE_MAX_VALUE = bigDecimal;
        BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        BIGI_LONG_MAX_VALUE = bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(Long.MIN_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        BIGI_LONG_MIN_VALUE = bigInteger2;
    }
}

